/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.method;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericSignatureFormatError;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.bytebuddy.description.ByteCodeElement;
import net.bytebuddy.description.ModifierReviewable;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.enumeration.EnumerationDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.method.ParameterList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.description.type.generic.GenericTypeDescription;
import net.bytebuddy.description.type.generic.GenericTypeList;
import net.bytebuddy.description.type.generic.TypeVariableSource;
import net.bytebuddy.jar.asm.signature.SignatureWriter;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.utility.JavaInstance;
import net.bytebuddy.utility.JavaType;

public interface MethodDescription
extends TypeVariableSource,
NamedElement.WithGenericName,
ByteCodeElement.TypeDependant<InDefinedShape, Token> {
    public static final String CONSTRUCTOR_INTERNAL_NAME = "<init>";
    public static final String TYPE_INITIALIZER_INTERNAL_NAME = "<clinit>";
    public static final int TYPE_INITIALIZER_MODIFIER = 4106;
    public static final Object NO_DEFAULT_VALUE = null;
    public static final MethodDescription UNDEFINED = null;

    public GenericTypeDescription getReturnType();

    public ParameterList<?> getParameters();

    public GenericTypeList getExceptionTypes();

    public int getAdjustedModifiers(boolean var1);

    public boolean isConstructor();

    public boolean isMethod();

    public boolean isTypeInitializer();

    public boolean represents(Method var1);

    public boolean represents(Constructor<?> var1);

    public boolean isVirtual();

    public int getStackSize();

    public boolean isDefaultMethod();

    public boolean isSpecializableFor(TypeDescription var1);

    public Object getDefaultValue();

    public <T> T getDefaultValue(Class<T> var1);

    public boolean isInvokableOn(TypeDescription var1);

    public boolean isBootstrap();

    public boolean isBootstrap(List<?> var1);

    public boolean isDefaultValue();

    public boolean isDefaultValue(Object var1);

    public TypeToken asTypeToken();

    public static class TypeToken {
        private final TypeDescription returnType;
        private final List<? extends TypeDescription> parameterTypes;

        public TypeToken(TypeDescription returnType, List<? extends TypeDescription> parameterTypes) {
            this.returnType = returnType;
            this.parameterTypes = parameterTypes;
        }

        public TypeDescription getReturnType() {
            return this.returnType;
        }

        public List<TypeDescription> getParameterTypes() {
            return new ArrayList<TypeDescription>(this.parameterTypes);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            TypeToken typeToken = (TypeToken)other;
            return this.returnType.equals(typeToken.returnType) && this.parameterTypes.equals(typeToken.parameterTypes);
        }

        public int hashCode() {
            int result = this.returnType.hashCode();
            result = 31 * result + this.parameterTypes.hashCode();
            return result;
        }

        public String toString() {
            return "MethodDescription.TypeToken{returnType=" + this.returnType + ", parameterTypes=" + this.parameterTypes + '}';
        }
    }

    public static class Token
    implements ByteCodeElement.Token<Token> {
        private final String internalName;
        private final int modifiers;
        private final List<GenericTypeDescription> typeVariables;
        private final GenericTypeDescription returnType;
        private final List<? extends ParameterDescription.Token> parameterTokens;
        private final List<? extends GenericTypeDescription> exceptionTypes;
        private final List<? extends AnnotationDescription> annotations;
        private final Object defaultValue;

        public Token(String internalName, int modifiers, GenericTypeDescription returnType, List<? extends GenericTypeDescription> parameterTypes) {
            this(internalName, modifiers, Collections.emptyList(), returnType, new ParameterDescription.Token.TypeList(parameterTypes), Collections.emptyList(), Collections.emptyList(), NO_DEFAULT_VALUE);
        }

        public Token(String internalName, int modifiers, List<GenericTypeDescription> typeVariables, GenericTypeDescription returnType, List<? extends ParameterDescription.Token> parameterTokens, List<? extends GenericTypeDescription> exceptionTypes, List<? extends AnnotationDescription> annotations, Object defaultValue) {
            this.internalName = internalName;
            this.modifiers = modifiers;
            this.typeVariables = typeVariables;
            this.returnType = returnType;
            this.parameterTokens = parameterTokens;
            this.exceptionTypes = exceptionTypes;
            this.annotations = annotations;
            this.defaultValue = defaultValue;
        }

        public String getInternalName() {
            return this.internalName;
        }

        public int getModifiers() {
            return this.modifiers;
        }

        public GenericTypeList getTypeVariables() {
            return new GenericTypeList.Explicit(this.typeVariables);
        }

        public GenericTypeDescription getReturnType() {
            return this.returnType;
        }

        public ByteCodeElement.Token.TokenList<ParameterDescription.Token> getParameterTokens() {
            return new ByteCodeElement.Token.TokenList<ParameterDescription.Token>(this.parameterTokens);
        }

        public GenericTypeList getExceptionTypes() {
            return new GenericTypeList.Explicit(this.exceptionTypes);
        }

        public AnnotationList getAnnotations() {
            return new AnnotationList.Explicit(this.annotations);
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public TypeToken asTypeToken() {
            ArrayList<TypeDescription> parameterTypes = new ArrayList<TypeDescription>(this.getParameterTokens().size());
            for (ParameterDescription.Token parameterToken : this.getParameterTokens()) {
                parameterTypes.add(parameterToken.getType().asErasure());
            }
            return new TypeToken(this.getReturnType().asErasure(), parameterTypes);
        }

        @Override
        public Token accept(GenericTypeDescription.Visitor<? extends GenericTypeDescription> visitor) {
            return new Token(this.getInternalName(), this.getModifiers(), this.getTypeVariables().accept(visitor), this.getReturnType().accept(visitor), this.getParameterTokens().accept(visitor), this.getExceptionTypes().accept(visitor), this.getAnnotations(), this.getDefaultValue());
        }

        @Override
        public boolean isIdenticalTo(Token token) {
            return this.getInternalName().equals(token.getInternalName()) && this.getModifiers() == token.getModifiers() && this.getTypeVariables().equals(token.getTypeVariables()) && this.getReturnType().equals(token.getReturnType()) && this.getParameterTokens().equals(token.getParameterTokens()) && this.getExceptionTypes().equals(token.getExceptionTypes()) && this.getAnnotations().equals(token.getAnnotations()) && (this.getDefaultValue() == null && token.getDefaultValue() == null || this.getDefaultValue() != null && token.getDefaultValue() != null && this.getDefaultValue().equals(token.getDefaultValue()));
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Token)) {
                return false;
            }
            Token token = (Token)other;
            if (!this.getInternalName().equals(token.getInternalName())) {
                return false;
            }
            if (!this.getReturnType().asErasure().equals(token.getReturnType().asErasure())) {
                return false;
            }
            ByteCodeElement.Token.TokenList<ParameterDescription.Token> tokens = this.getParameterTokens();
            ByteCodeElement.Token.TokenList<ParameterDescription.Token> otherTokens = token.getParameterTokens();
            if (tokens.size() != otherTokens.size()) {
                return false;
            }
            for (int index = 0; index < tokens.size(); ++index) {
                if (((ParameterDescription.Token)tokens.get(index)).getType().asErasure().equals(((ParameterDescription.Token)otherTokens.get(index)).getType().asErasure())) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = this.getInternalName().hashCode();
            result = 31 * result + this.getReturnType().asErasure().hashCode();
            for (ParameterDescription.Token parameterToken : this.getParameterTokens()) {
                result = 31 * result + parameterToken.getType().asErasure().hashCode();
            }
            return result;
        }

        public String toString() {
            return "MethodDescription.Token{internalName='" + this.internalName + '\'' + ", modifiers=" + this.modifiers + ", typeVariables=" + this.typeVariables + ", returnType=" + this.returnType + ", parameterTokens=" + this.parameterTokens + ", exceptionTypes=" + this.exceptionTypes + ", annotations=" + this.annotations + ", defaultValue=" + this.defaultValue + '}';
        }
    }

    public static class TypeSubstituting
    extends AbstractBase {
        private final GenericTypeDescription declaringType;
        private final MethodDescription methodDescription;
        private final GenericTypeDescription.Visitor<? extends GenericTypeDescription> visitor;

        public TypeSubstituting(GenericTypeDescription declaringType, MethodDescription methodDescription, GenericTypeDescription.Visitor<? extends GenericTypeDescription> visitor) {
            this.declaringType = declaringType;
            this.methodDescription = methodDescription;
            this.visitor = visitor;
        }

        @Override
        public GenericTypeList getTypeVariables() {
            return new GenericTypeList.ForDetachedTypes(this.methodDescription.getTypeVariables(), new VariableRetainingDelegator());
        }

        @Override
        public GenericTypeDescription getReturnType() {
            return this.methodDescription.getReturnType().accept(new VariableRetainingDelegator());
        }

        @Override
        public ParameterList<?> getParameters() {
            return new ParameterList.TypeSubstituting(this, this.methodDescription.getParameters(), new VariableRetainingDelegator());
        }

        @Override
        public GenericTypeList getExceptionTypes() {
            return new GenericTypeList.ForDetachedTypes(this.methodDescription.getExceptionTypes(), new VariableRetainingDelegator());
        }

        @Override
        public Object getDefaultValue() {
            return this.methodDescription.getDefaultValue();
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return this.methodDescription.getDeclaredAnnotations();
        }

        @Override
        public GenericTypeDescription getDeclaringType() {
            return this.declaringType;
        }

        @Override
        public int getModifiers() {
            return this.methodDescription.getModifiers();
        }

        @Override
        public String getInternalName() {
            return this.methodDescription.getInternalName();
        }

        @Override
        public InDefinedShape asDefined() {
            return (InDefinedShape)this.methodDescription.asDefined();
        }

        protected class VariableRetainingDelegator
        extends GenericTypeDescription.Visitor.Substitutor {
            protected VariableRetainingDelegator() {
            }

            @Override
            public GenericTypeDescription onParameterizedType(GenericTypeDescription parameterizedType) {
                ArrayList<GenericTypeDescription> parameters = new ArrayList<GenericTypeDescription>(parameterizedType.getParameters().size());
                for (GenericTypeDescription parameter : parameterizedType.getParameters()) {
                    if (parameter.getSort().isTypeVariable() && !TypeSubstituting.this.methodDescription.getTypeVariables().contains(parameter)) {
                        return (GenericTypeDescription)TypeSubstituting.this.visitor.onParameterizedType(parameterizedType);
                    }
                    if (parameter.getSort().isWildcard()) {
                        GenericTypeList bounds = parameter.getLowerBounds();
                        GenericTypeList genericTypeList = bounds = bounds.isEmpty() ? parameter.getUpperBounds() : bounds;
                        if (((GenericTypeDescription)bounds.getOnly()).getSort().isTypeVariable() && !TypeSubstituting.this.methodDescription.getTypeVariables().contains(parameter)) {
                            return (GenericTypeDescription)TypeSubstituting.this.visitor.onParameterizedType(parameterizedType);
                        }
                    }
                    parameters.add(parameter.accept(this));
                }
                GenericTypeDescription ownerType = parameterizedType.getOwnerType();
                return new GenericTypeDescription.ForParameterizedType.Latent(parameterizedType.asErasure(), parameters, ownerType == null ? TypeDescription.UNDEFINED : ownerType.accept(this));
            }

            @Override
            public GenericTypeDescription onNonGenericType(GenericTypeDescription typeDescription) {
                return (GenericTypeDescription)TypeSubstituting.this.visitor.onNonGenericType(typeDescription);
            }

            @Override
            protected GenericTypeDescription onSimpleType(GenericTypeDescription typeDescription) {
                throw new UnsupportedOperationException();
            }

            @Override
            public GenericTypeDescription onTypeVariable(GenericTypeDescription typeVariable) {
                return TypeSubstituting.this.methodDescription.getTypeVariables().contains(typeVariable) ? new RetainedVariable(typeVariable) : (GenericTypeDescription)TypeSubstituting.this.visitor.onTypeVariable(typeVariable);
            }

            public int hashCode() {
                return TypeSubstituting.this.hashCode();
            }

            public boolean equals(Object other) {
                return other != null && other.getClass() == this.getClass() && TypeSubstituting.this.equals(((VariableRetainingDelegator)other).getOuter());
            }

            private Object getOuter() {
                return TypeSubstituting.this;
            }

            public String toString() {
                return "MethodDescription.TypeSubstituting.VariableRetainingDelegator{methodDescription=" + TypeSubstituting.this + '}';
            }

            protected class RetainedVariable
            extends GenericTypeDescription.ForTypeVariable {
                private final GenericTypeDescription typeVariable;

                protected RetainedVariable(GenericTypeDescription typeVariable) {
                    this.typeVariable = typeVariable;
                }

                @Override
                public GenericTypeList getUpperBounds() {
                    return new GenericTypeList.ForDetachedTypes(this.typeVariable.getUpperBounds(), VariableRetainingDelegator.this);
                }

                @Override
                public TypeVariableSource getVariableSource() {
                    return TypeSubstituting.this;
                }

                @Override
                public String getSymbol() {
                    return this.typeVariable.getSymbol();
                }
            }
        }
    }

    public static class Latent
    extends InDefinedShape.AbstractBase {
        private final TypeDescription declaringType;
        private final String internalName;
        private final int modifiers;
        private final List<? extends GenericTypeDescription> typeVariables;
        private final GenericTypeDescription returnType;
        private final List<? extends ParameterDescription.Token> parameterTokens;
        private final List<? extends GenericTypeDescription> exceptionTypes;
        private final List<? extends AnnotationDescription> declaredAnnotations;
        private final Object defaultValue;

        public Latent(TypeDescription declaringType, Token token) {
            this(declaringType, token.getInternalName(), token.getModifiers(), token.getTypeVariables(), token.getReturnType(), token.getParameterTokens(), token.getExceptionTypes(), token.getAnnotations(), token.getDefaultValue());
        }

        public Latent(TypeDescription declaringType, String internalName, int modifiers, List<? extends GenericTypeDescription> typeVariables, GenericTypeDescription returnType, List<? extends ParameterDescription.Token> parameterTokens, List<? extends GenericTypeDescription> exceptionTypes, List<? extends AnnotationDescription> declaredAnnotations, Object defaultValue) {
            this.declaringType = declaringType;
            this.internalName = internalName;
            this.modifiers = modifiers;
            this.typeVariables = typeVariables;
            this.returnType = returnType;
            this.parameterTokens = parameterTokens;
            this.exceptionTypes = exceptionTypes;
            this.declaredAnnotations = declaredAnnotations;
            this.defaultValue = defaultValue;
        }

        @Override
        public GenericTypeList getTypeVariables() {
            return GenericTypeList.ForDetachedTypes.OfTypeVariable.attach(this, this.typeVariables);
        }

        @Override
        public GenericTypeDescription getReturnType() {
            return this.returnType.accept(GenericTypeDescription.Visitor.Substitutor.ForAttachment.of(this));
        }

        @Override
        public ParameterList<ParameterDescription.InDefinedShape> getParameters() {
            return new ParameterList.ForTokens(this, this.parameterTokens);
        }

        @Override
        public GenericTypeList getExceptionTypes() {
            return GenericTypeList.ForDetachedTypes.attach(this, this.exceptionTypes);
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.Explicit(this.declaredAnnotations);
        }

        @Override
        public String getInternalName() {
            return this.internalName;
        }

        @Override
        public TypeDescription getDeclaringType() {
            return this.declaringType;
        }

        @Override
        public int getModifiers() {
            return this.modifiers;
        }

        @Override
        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public static class TypeInitializer
        extends InDefinedShape.AbstractBase {
            private final TypeDescription typeDescription;

            public TypeInitializer(TypeDescription typeDescription) {
                this.typeDescription = typeDescription;
            }

            @Override
            public GenericTypeDescription getReturnType() {
                return TypeDescription.VOID;
            }

            @Override
            public ParameterList<ParameterDescription.InDefinedShape> getParameters() {
                return new ParameterList.Empty();
            }

            @Override
            public GenericTypeList getExceptionTypes() {
                return new GenericTypeList.Empty();
            }

            @Override
            public Object getDefaultValue() {
                return NO_DEFAULT_VALUE;
            }

            @Override
            public GenericTypeList getTypeVariables() {
                return new GenericTypeList.Empty();
            }

            @Override
            public AnnotationList getDeclaredAnnotations() {
                return new AnnotationList.Empty();
            }

            @Override
            public TypeDescription getDeclaringType() {
                return this.typeDescription;
            }

            @Override
            public int getModifiers() {
                return 4106;
            }

            @Override
            public String getInternalName() {
                return MethodDescription.TYPE_INITIALIZER_INTERNAL_NAME;
            }
        }
    }

    public static class ForLoadedMethod
    extends InDefinedShape.AbstractBase {
        private final Method method;

        public ForLoadedMethod(Method method) {
            this.method = method;
        }

        @Override
        public TypeDescription getDeclaringType() {
            return new TypeDescription.ForLoadedType(this.method.getDeclaringClass());
        }

        @Override
        public GenericTypeDescription getReturnType() {
            return new GenericTypeDescription.LazyProjection.OfLoadedReturnType(this.method);
        }

        @Override
        public ParameterList<ParameterDescription.InDefinedShape> getParameters() {
            return ParameterList.ForLoadedExecutable.of(this.method);
        }

        @Override
        public GenericTypeList getExceptionTypes() {
            return new GenericTypeList.OfMethodExceptionTypes(this.method);
        }

        @Override
        public boolean isConstructor() {
            return false;
        }

        @Override
        public boolean isTypeInitializer() {
            return false;
        }

        @Override
        public boolean isBridge() {
            return this.method.isBridge();
        }

        @Override
        public boolean represents(Method method) {
            return this.method.equals(method) || this.equals(new ForLoadedMethod(method));
        }

        @Override
        public boolean represents(Constructor<?> constructor) {
            return false;
        }

        @Override
        public String getName() {
            return this.method.getName();
        }

        @Override
        public int getModifiers() {
            return this.method.getModifiers();
        }

        @Override
        public boolean isSynthetic() {
            return this.method.isSynthetic();
        }

        @Override
        public String getInternalName() {
            return this.method.getName();
        }

        @Override
        public String getDescriptor() {
            return net.bytebuddy.jar.asm.Type.getMethodDescriptor(this.method);
        }

        public Method getLoadedMethod() {
            return this.method;
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.ForLoadedAnnotation(this.method.getDeclaredAnnotations());
        }

        @Override
        public Object getDefaultValue() {
            Object value = this.method.getDefaultValue();
            return value == null ? NO_DEFAULT_VALUE : AnnotationDescription.ForLoadedAnnotation.describe(value, new TypeDescription.ForLoadedType(this.method.getReturnType()));
        }

        @Override
        public GenericTypeList getTypeVariables() {
            return new GenericTypeList.ForLoadedType(this.method.getTypeParameters());
        }
    }

    public static class ForLoadedConstructor
    extends InDefinedShape.AbstractBase {
        private final Constructor<?> constructor;

        public ForLoadedConstructor(Constructor<?> constructor) {
            this.constructor = constructor;
        }

        @Override
        public TypeDescription getDeclaringType() {
            return new TypeDescription.ForLoadedType(this.constructor.getDeclaringClass());
        }

        @Override
        public GenericTypeDescription getReturnType() {
            return TypeDescription.VOID;
        }

        @Override
        public ParameterList<ParameterDescription.InDefinedShape> getParameters() {
            return ParameterList.ForLoadedExecutable.of(this.constructor);
        }

        @Override
        public GenericTypeList getExceptionTypes() {
            return new GenericTypeList.OfConstructorExceptionTypes(this.constructor);
        }

        @Override
        public boolean isConstructor() {
            return true;
        }

        @Override
        public boolean isTypeInitializer() {
            return false;
        }

        @Override
        public boolean represents(Method method) {
            return false;
        }

        @Override
        public boolean represents(Constructor<?> constructor) {
            return this.constructor.equals(constructor) || this.equals(new ForLoadedConstructor(constructor));
        }

        @Override
        public String getName() {
            return this.constructor.getName();
        }

        @Override
        public int getModifiers() {
            return this.constructor.getModifiers();
        }

        @Override
        public boolean isSynthetic() {
            return this.constructor.isSynthetic();
        }

        @Override
        public String getInternalName() {
            return MethodDescription.CONSTRUCTOR_INTERNAL_NAME;
        }

        @Override
        public String getDescriptor() {
            return net.bytebuddy.jar.asm.Type.getConstructorDescriptor(this.constructor);
        }

        @Override
        public Object getDefaultValue() {
            return NO_DEFAULT_VALUE;
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.ForLoadedAnnotation(this.constructor.getDeclaredAnnotations());
        }

        @Override
        public GenericTypeList getTypeVariables() {
            return new GenericTypeList.ForLoadedType(this.constructor.getTypeParameters());
        }
    }

    public static abstract class AbstractBase
    extends ModifierReviewable.AbstractBase
    implements MethodDescription {
        private static final int SOURCE_MODIFIERS = 1343;

        @Override
        public int getStackSize() {
            return this.getParameters().asTypeList().getStackSize() + (this.isStatic() ? 0 : 1);
        }

        @Override
        public boolean isMethod() {
            return !this.isConstructor() && !this.isTypeInitializer();
        }

        @Override
        public boolean isConstructor() {
            return MethodDescription.CONSTRUCTOR_INTERNAL_NAME.equals(this.getInternalName());
        }

        @Override
        public boolean isTypeInitializer() {
            return MethodDescription.TYPE_INITIALIZER_INTERNAL_NAME.equals(this.getInternalName());
        }

        @Override
        public boolean represents(Method method) {
            return this.equals(new ForLoadedMethod(method));
        }

        @Override
        public boolean represents(Constructor<?> constructor) {
            return this.equals(new ForLoadedConstructor(constructor));
        }

        @Override
        public String getName() {
            return this.isMethod() ? this.getInternalName() : this.getDeclaringType().asErasure().getName();
        }

        @Override
        public String getSourceCodeName() {
            return this.isMethod() ? this.getName() : "";
        }

        @Override
        public String getDescriptor() {
            StringBuilder descriptor = new StringBuilder("(");
            for (TypeDescription parameterType : this.getParameters().asTypeList().asErasures()) {
                descriptor.append(parameterType.getDescriptor());
            }
            return descriptor.append(")").append(this.getReturnType().asErasure().getDescriptor()).toString();
        }

        @Override
        public String getGenericSignature() {
            try {
                SignatureWriter signatureWriter = new SignatureWriter();
                boolean generic = false;
                for (GenericTypeDescription typeVariable : this.getTypeVariables()) {
                    signatureWriter.visitFormalTypeParameter(typeVariable.getSymbol());
                    boolean classBound = true;
                    for (GenericTypeDescription upperBound : typeVariable.getUpperBounds()) {
                        upperBound.accept(new GenericTypeDescription.Visitor.ForSignatureVisitor(classBound ? signatureWriter.visitClassBound() : signatureWriter.visitInterfaceBound()));
                        classBound = false;
                    }
                    generic = true;
                }
                for (GenericTypeDescription parameterType : this.getParameters().asTypeList()) {
                    parameterType.accept(new GenericTypeDescription.Visitor.ForSignatureVisitor(signatureWriter.visitParameterType()));
                    generic = generic || !parameterType.getSort().isNonGeneric();
                }
                GenericTypeDescription returnType = this.getReturnType();
                returnType.accept(new GenericTypeDescription.Visitor.ForSignatureVisitor(signatureWriter.visitReturnType()));
                generic = generic || !returnType.getSort().isNonGeneric();
                GenericTypeList exceptionTypes = this.getExceptionTypes();
                if (!((GenericTypeList)exceptionTypes.filter(ElementMatchers.not(ElementMatchers.ofSort(GenericTypeDescription.Sort.NON_GENERIC)))).isEmpty()) {
                    for (GenericTypeDescription exceptionType : exceptionTypes) {
                        exceptionType.accept(new GenericTypeDescription.Visitor.ForSignatureVisitor(signatureWriter.visitExceptionType()));
                        generic = generic || !exceptionType.getSort().isNonGeneric();
                    }
                }
                return generic ? signatureWriter.toString() : NON_GENERIC_SIGNATURE;
            }
            catch (GenericSignatureFormatError ignored) {
                return NON_GENERIC_SIGNATURE;
            }
        }

        @Override
        public int getAdjustedModifiers(boolean nonAbstract) {
            return nonAbstract ? this.getModifiers() & 0xFFFFFAFF : this.getModifiers() & 0xFFFFFEFF | 0x400;
        }

        @Override
        public boolean isVisibleTo(TypeDescription typeDescription) {
            return (this.isVirtual() || this.getDeclaringType().asErasure().isVisibleTo(typeDescription)) && (this.isPublic() || typeDescription.equals(this.getDeclaringType()) || this.isProtected() && this.getDeclaringType().asErasure().isAssignableFrom(typeDescription) || !this.isPrivate() && typeDescription.isSamePackage(this.getDeclaringType().asErasure()));
        }

        @Override
        public boolean isVirtual() {
            return !this.isConstructor() && !this.isPrivate() && !this.isStatic() && !this.isTypeInitializer();
        }

        @Override
        public boolean isDefaultMethod() {
            return !this.isAbstract() && !this.isBridge() && this.getDeclaringType().asErasure().isInterface();
        }

        @Override
        public boolean isSpecializableFor(TypeDescription targetType) {
            if (this.isStatic()) {
                return false;
            }
            if (this.isPrivate() || this.isConstructor() || this.isDefaultMethod()) {
                return this.getDeclaringType().equals(targetType);
            }
            return !this.isAbstract() && this.getDeclaringType().asErasure().isAssignableFrom(targetType);
        }

        @Override
        public <T> T getDefaultValue(Class<T> type) {
            return type.cast(this.getDefaultValue());
        }

        @Override
        public boolean isInvokableOn(TypeDescription typeDescription) {
            return !this.isStatic() && !this.isTypeInitializer() && this.isVisibleTo(typeDescription) && (this.isVirtual() ? this.getDeclaringType().asErasure().isAssignableFrom(typeDescription) : this.getDeclaringType().asErasure().equals(typeDescription));
        }

        @Override
        public boolean isBootstrap() {
            TypeDescription returnType = this.getReturnType().asErasure();
            if (this.isMethod() && (!this.isStatic() || !JavaType.CALL_SITE.getTypeStub().isAssignableFrom(returnType) && !JavaType.CALL_SITE.getTypeStub().isAssignableTo(returnType)) || this.isConstructor() && !JavaType.CALL_SITE.getTypeStub().isAssignableFrom(this.getDeclaringType().asErasure())) {
                return false;
            }
            TypeList parameterTypes = this.getParameters().asTypeList().asErasures();
            switch (parameterTypes.size()) {
                case 0: {
                    return false;
                }
                case 1: {
                    return ((TypeDescription)parameterTypes.getOnly()).represents((Type)((Object)Object[].class));
                }
                case 2: {
                    return JavaType.METHOD_HANDLES_LOOKUP.getTypeStub().isAssignableTo((TypeDescription)parameterTypes.get(0)) && ((TypeDescription)parameterTypes.get(1)).represents((Type)((Object)Object[].class));
                }
                case 3: {
                    return !(!JavaType.METHOD_HANDLES_LOOKUP.getTypeStub().isAssignableTo((TypeDescription)parameterTypes.get(0)) || !((TypeDescription)parameterTypes.get(1)).represents((Type)((Object)Object.class)) && !((TypeDescription)parameterTypes.get(1)).represents((Type)((Object)String.class)) || !((TypeDescription)parameterTypes.get(2)).represents((Type)((Object)Object[].class)) && !JavaType.METHOD_TYPE.getTypeStub().isAssignableTo((TypeDescription)parameterTypes.get(2)));
                }
            }
            if (!JavaType.METHOD_HANDLES_LOOKUP.getTypeStub().isAssignableTo((TypeDescription)parameterTypes.get(0)) || !((TypeDescription)parameterTypes.get(1)).represents((Type)((Object)Object.class)) && !((TypeDescription)parameterTypes.get(1)).represents((Type)((Object)String.class)) || !JavaType.METHOD_TYPE.getTypeStub().isAssignableTo((TypeDescription)parameterTypes.get(2))) {
                return false;
            }
            int parameterIndex = 4;
            for (TypeDescription parameterType : (TypeList)parameterTypes.subList(3, parameterTypes.size())) {
                if (!parameterType.represents((Type)((Object)Object.class)) && !parameterType.isConstantPool()) {
                    return parameterType.represents((Type)((Object)Object[].class)) && parameterIndex == parameterTypes.size();
                }
                ++parameterIndex;
            }
            return true;
        }

        @Override
        public boolean isBootstrap(List<?> arguments) {
            if (!this.isBootstrap()) {
                return false;
            }
            for (Object argument : arguments) {
                Class<?> argumentType = argument.getClass();
                if (argumentType == String.class || argumentType == Integer.class || argumentType == Long.class || argumentType == Float.class || argumentType == Double.class || TypeDescription.class.isAssignableFrom(argumentType) || JavaInstance.MethodHandle.class.isAssignableFrom(argumentType) || JavaInstance.MethodType.class.isAssignableFrom(argumentType)) continue;
                throw new IllegalArgumentException("Not a bootstrap argument: " + argument);
            }
            TypeList parameterTypes = this.getParameters().asTypeList().asErasures();
            if (parameterTypes.size() < 4) {
                return arguments.isEmpty() || ((TypeDescription)parameterTypes.get(parameterTypes.size() - 1)).represents((Type)((Object)Object[].class));
            }
            int index = 4;
            Iterator<?> argumentIterator = arguments.iterator();
            for (TypeDescription parameterType : (TypeList)parameterTypes.subList(3, parameterTypes.size())) {
                boolean finalParameterCheck;
                boolean bl = finalParameterCheck = !argumentIterator.hasNext();
                if (!finalParameterCheck) {
                    Class<?> argumentType = argumentIterator.next().getClass();
                    boolean bl2 = finalParameterCheck = !(parameterType.represents((Type)((Object)String.class)) && argumentType == String.class || parameterType.represents(Integer.TYPE) && argumentType == Integer.class || parameterType.represents(Long.TYPE) && argumentType == Long.class || parameterType.represents(Float.TYPE) && argumentType == Float.class || parameterType.represents(Double.TYPE) && argumentType == Double.class || parameterType.represents((Type)((Object)Class.class)) && TypeDescription.class.isAssignableFrom(argumentType) || parameterType.isAssignableFrom(JavaType.METHOD_HANDLE.getTypeStub()) && JavaInstance.MethodHandle.class.isAssignableFrom(argumentType) || parameterType.equals(JavaType.METHOD_TYPE.getTypeStub()) && JavaInstance.MethodType.class.isAssignableFrom(argumentType));
                }
                if (finalParameterCheck) {
                    return index == parameterTypes.size() && parameterType.represents((Type)((Object)Object[].class));
                }
                ++index;
            }
            return true;
        }

        @Override
        public boolean isDefaultValue() {
            return !this.isConstructor() && !this.isStatic() && this.getReturnType().asErasure().isAnnotationReturnType() && this.getParameters().isEmpty();
        }

        @Override
        public boolean isDefaultValue(Object value) {
            if (!this.isDefaultValue()) {
                return false;
            }
            TypeDescription returnType = this.getReturnType().asErasure();
            return returnType.represents(Boolean.TYPE) && value instanceof Boolean || returnType.represents(Byte.TYPE) && value instanceof Byte || returnType.represents(Character.TYPE) && value instanceof Character || returnType.represents(Short.TYPE) && value instanceof Short || returnType.represents(Integer.TYPE) && value instanceof Integer || returnType.represents(Long.TYPE) && value instanceof Long || returnType.represents(Float.TYPE) && value instanceof Float || returnType.represents(Long.TYPE) && value instanceof Long || returnType.represents((Type)((Object)String.class)) && value instanceof String || returnType.isAssignableTo(Enum.class) && value instanceof EnumerationDescription || returnType.isAssignableTo(Annotation.class) && value instanceof AnnotationDescription || returnType.represents((Type)((Object)Class.class)) && value instanceof TypeDescription;
        }

        @Override
        public TypeVariableSource getEnclosingSource() {
            return this.getDeclaringType().asErasure();
        }

        @Override
        public GenericTypeDescription findVariable(String symbol) {
            GenericTypeList typeVariables = (GenericTypeList)this.getTypeVariables().filter(ElementMatchers.named(symbol));
            return typeVariables.isEmpty() ? this.getEnclosingSource().findVariable(symbol) : (GenericTypeDescription)typeVariables.getOnly();
        }

        @Override
        public <T> T accept(TypeVariableSource.Visitor<T> visitor) {
            return visitor.onMethod(this);
        }

        @Override
        public Token asToken() {
            return this.asToken((ElementMatcher)ElementMatchers.none());
        }

        @Override
        public Token asToken(ElementMatcher<? super GenericTypeDescription> targetTypeMatcher) {
            GenericTypeDescription.Visitor.Substitutor.ForDetachment visitor = new GenericTypeDescription.Visitor.Substitutor.ForDetachment(targetTypeMatcher);
            return new Token(this.getInternalName(), this.getModifiers(), this.getTypeVariables().accept(visitor), this.getReturnType().accept(visitor), this.getParameters().asTokenList(targetTypeMatcher), this.getExceptionTypes().accept(visitor), this.getDeclaredAnnotations(), this.getDefaultValue());
        }

        @Override
        public TypeToken asTypeToken() {
            return new TypeToken(this.getReturnType().asErasure(), this.getParameters().asTypeList().asErasures());
        }

        public boolean equals(Object other) {
            return other == this || other instanceof MethodDescription && this.getInternalName().equals(((MethodDescription)other).getInternalName()) && this.getDeclaringType().equals(((MethodDescription)other).getDeclaringType()) && this.getReturnType().asErasure().equals(((MethodDescription)other).getReturnType().asErasure()) && this.getParameters().asTypeList().asErasures().equals(((MethodDescription)other).getParameters().asTypeList().asErasures());
        }

        public int hashCode() {
            int hashCode = this.getDeclaringType().hashCode();
            hashCode = 31 * hashCode + this.getInternalName().hashCode();
            hashCode = 31 * hashCode + this.getReturnType().asErasure().hashCode();
            return 31 * hashCode + this.getParameters().asTypeList().asErasures().hashCode();
        }

        @Override
        public String toGenericString() {
            StringBuilder stringBuilder = new StringBuilder();
            int modifiers = this.getModifiers() & 0x53F;
            if (modifiers != 0) {
                stringBuilder.append(Modifier.toString(modifiers)).append(" ");
            }
            if (this.isMethod()) {
                stringBuilder.append(this.getReturnType().getSourceCodeName()).append(" ");
                stringBuilder.append(this.getDeclaringType().asErasure().getSourceCodeName()).append(".");
            }
            stringBuilder.append(this.getName()).append("(");
            boolean first = true;
            for (GenericTypeDescription typeDescription : this.getParameters().asTypeList()) {
                if (!first) {
                    stringBuilder.append(",");
                } else {
                    first = false;
                }
                stringBuilder.append(typeDescription.getSourceCodeName());
            }
            stringBuilder.append(")");
            GenericTypeList exceptionTypes = this.getExceptionTypes();
            if (!exceptionTypes.isEmpty()) {
                stringBuilder.append(" throws ");
                first = true;
                for (GenericTypeDescription typeDescription : exceptionTypes) {
                    if (!first) {
                        stringBuilder.append(",");
                    } else {
                        first = false;
                    }
                    stringBuilder.append(typeDescription.getSourceCodeName());
                }
            }
            return stringBuilder.toString();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            int modifiers = this.getModifiers() & 0x53F;
            if (modifiers != 0) {
                stringBuilder.append(Modifier.toString(modifiers)).append(" ");
            }
            if (this.isMethod()) {
                stringBuilder.append(this.getReturnType().asErasure().getSourceCodeName()).append(" ");
                stringBuilder.append(this.getDeclaringType().asErasure().getSourceCodeName()).append(".");
            }
            stringBuilder.append(this.getName()).append("(");
            boolean first = true;
            for (TypeDescription typeDescription : this.getParameters().asTypeList().asErasures()) {
                if (!first) {
                    stringBuilder.append(",");
                } else {
                    first = false;
                }
                stringBuilder.append(typeDescription.getSourceCodeName());
            }
            stringBuilder.append(")");
            TypeList exceptionTypes = this.getExceptionTypes().asErasures();
            if (!exceptionTypes.isEmpty()) {
                stringBuilder.append(" throws ");
                first = true;
                for (TypeDescription typeDescription : exceptionTypes) {
                    if (!first) {
                        stringBuilder.append(",");
                    } else {
                        first = false;
                    }
                    stringBuilder.append(typeDescription.getSourceCodeName());
                }
            }
            return stringBuilder.toString();
        }
    }

    public static interface InDefinedShape
    extends MethodDescription,
    ByteCodeElement.Accessible {
        @Override
        public TypeDescription getDeclaringType();

        public ParameterList<ParameterDescription.InDefinedShape> getParameters();

        public static abstract class AbstractBase
        extends net.bytebuddy.description.method.MethodDescription$AbstractBase
        implements InDefinedShape {
            @Override
            public InDefinedShape asDefined() {
                return this;
            }

            @Override
            public boolean isAccessibleTo(TypeDescription typeDescription) {
                return this.isVisibleTo(typeDescription) && this.getDeclaringType().isVisibleTo(typeDescription);
            }
        }
    }
}

