/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.asm;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.asm.ClassVisitorWrapper;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.Type;

public enum TypeConstantAdjustment implements ClassVisitorWrapper
{
    INSTANCE;


    @Override
    public int mergeWriter(int flags) {
        return flags;
    }

    @Override
    public int mergeReader(int flags) {
        return flags;
    }

    @Override
    public ClassVisitor wrap(ClassVisitor classVisitor) {
        return new TypeConstantDissolvingClassVisitor(classVisitor);
    }

    public String toString() {
        return "TypeConstantAdjustment." + this.name();
    }

    protected static class TypeConstantDissolvingClassVisitor
    extends ClassVisitor {
        private boolean supportsTypeConstants;

        protected TypeConstantDissolvingClassVisitor(ClassVisitor classVisitor) {
            super(327680, classVisitor);
        }

        @Override
        public void visit(int version, int modifiers, String name, String signature, String superTypeName, String[] interfaceName) {
            this.supportsTypeConstants = ClassFileVersion.ofMinorMajor(version).isAtLeast(ClassFileVersion.JAVA_V5);
            super.visit(version, modifiers, name, signature, superTypeName, interfaceName);
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return this.supportsTypeConstants ? super.visitMethod(access, name, desc, signature, exceptions) : new TypeConstantDissolvingMethodVisitor(super.visitMethod(access, name, desc, signature, exceptions));
        }

        public String toString() {
            return "TypeConstantAdjustment.TypeConstantDissolvingClassVisitor{classVisitor=" + this.cv + ", supportsTypeConstants=" + this.supportsTypeConstants + "}";
        }

        protected static class TypeConstantDissolvingMethodVisitor
        extends MethodVisitor {
            private static final String JAVA_LANG_CLASS = "java/lang/Class";
            private static final String FOR_NAME = "forName";
            private static final String DESCRIPTOR = "(Ljava/lang/String;)Ljava/lang/Class;";

            protected TypeConstantDissolvingMethodVisitor(MethodVisitor methodVisitor) {
                super(327680, methodVisitor);
            }

            @Override
            @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"}, justification="Fall through to default case is intentional")
            public void visitLdcInsn(Object constant) {
                if (constant instanceof Type) {
                    Type type = (Type)constant;
                    switch (type.getSort()) {
                        case 9: 
                        case 10: {
                            super.visitLdcInsn(type.getInternalName().replace('/', '.'));
                            super.visitMethodInsn(184, JAVA_LANG_CLASS, FOR_NAME, DESCRIPTOR, false);
                            return;
                        }
                    }
                }
                super.visitLdcInsn(constant);
            }

            public String toString() {
                return "TypeConstantAdjustment.TypeConstantDissolvingClassVisitor.TypeConstantDissolvingMethodVisitor{methodVisitor=" + this.mv + "}";
            }
        }
    }
}

