/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.asm;

import java.util.Arrays;
import java.util.List;
import net.bytebuddy.jar.asm.ClassVisitor;

public interface ClassVisitorWrapper {
    public int mergeWriter(int var1);

    public int mergeReader(int var1);

    public ClassVisitor wrap(ClassVisitor var1);

    public static class Compound
    implements ClassVisitorWrapper {
        private final List<? extends ClassVisitorWrapper> classVisitorWrappers;

        public Compound(ClassVisitorWrapper ... classVisitorWrapper) {
            this(Arrays.asList(classVisitorWrapper));
        }

        public Compound(List<? extends ClassVisitorWrapper> classVisitorWrappers) {
            this.classVisitorWrappers = classVisitorWrappers;
        }

        @Override
        public int mergeWriter(int flags) {
            for (ClassVisitorWrapper classVisitorWrapper : this.classVisitorWrappers) {
                flags = classVisitorWrapper.mergeWriter(flags);
            }
            return flags;
        }

        @Override
        public int mergeReader(int flags) {
            for (ClassVisitorWrapper classVisitorWrapper : this.classVisitorWrappers) {
                flags = classVisitorWrapper.mergeReader(flags);
            }
            return flags;
        }

        @Override
        public ClassVisitor wrap(ClassVisitor classVisitor) {
            for (ClassVisitorWrapper classVisitorWrapper : this.classVisitorWrappers) {
                classVisitor = classVisitorWrapper.wrap(classVisitor);
            }
            return classVisitor;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.classVisitorWrappers.equals(((Compound)other).classVisitorWrappers);
        }

        public int hashCode() {
            return this.classVisitorWrappers.hashCode();
        }

        public String toString() {
            return "ClassVisitorWrapper.Compound{classVisitorWrappers=" + this.classVisitorWrappers + '}';
        }
    }

    public static enum NoOp implements ClassVisitorWrapper
    {
        INSTANCE;


        @Override
        public int mergeWriter(int flags) {
            return flags;
        }

        @Override
        public int mergeReader(int flags) {
            return flags;
        }

        @Override
        public ClassVisitor wrap(ClassVisitor classVisitor) {
            return classVisitor;
        }

        public String toString() {
            return "ClassVisitorWrapper.NoOp." + this.name();
        }
    }
}

