/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic.scaffold;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.TypeWriter;
import net.bytebuddy.implementation.attribute.FieldAttributeAppender;

public interface FieldRegistry {
    public FieldRegistry include(LatentFieldMatcher var1, FieldAttributeAppender.Factory var2, Object var3);

    public Prepared prepare(TypeDescription var1);

    public static class Default
    implements FieldRegistry {
        private final Map<String, Entry> entries;

        public Default() {
            this.entries = Collections.emptyMap();
        }

        private Default(Map<String, Entry> entries) {
            this.entries = entries;
        }

        @Override
        public FieldRegistry include(LatentFieldMatcher latentFieldMatcher, FieldAttributeAppender.Factory attributeAppenderFactory, Object defaultValue) {
            HashMap<String, Entry> entries = new HashMap<String, Entry>(this.entries);
            if (entries.put(latentFieldMatcher.getFieldName(), new Entry(attributeAppenderFactory, defaultValue)) != null) {
                throw new IllegalArgumentException("the field name " + latentFieldMatcher.getFieldName() + " is already registered");
            }
            return new Default(entries);
        }

        @Override
        public net.bytebuddy.dynamic.scaffold.FieldRegistry$Prepared prepare(TypeDescription instrumentedType) {
            HashMap<String, TypeWriter.FieldPool.Entry> entries = new HashMap<String, TypeWriter.FieldPool.Entry>(this.entries.size());
            HashMap<FieldAttributeAppender.Factory, FieldAttributeAppender> attributeAppenders = new HashMap<FieldAttributeAppender.Factory, FieldAttributeAppender>(this.entries.size());
            for (Map.Entry<String, Entry> entry : this.entries.entrySet()) {
                FieldAttributeAppender attributeAppender = (FieldAttributeAppender)attributeAppenders.get(entry.getValue().getAttributeAppenderFactory());
                if (attributeAppender == null) {
                    attributeAppender = entry.getValue().getAttributeAppenderFactory().make(instrumentedType);
                    attributeAppenders.put(entry.getValue().getAttributeAppenderFactory(), attributeAppender);
                }
                entries.put(entry.getKey(), new TypeWriter.FieldPool.Entry.Simple(attributeAppender, entry.getValue().getDefaultValue()));
            }
            return new Prepared(entries);
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.entries.equals(((Default)other).entries);
        }

        public int hashCode() {
            return this.entries.hashCode();
        }

        public String toString() {
            return "FieldRegistry.Default{entries=" + this.entries + '}';
        }

        protected static class Compiled
        implements net.bytebuddy.dynamic.scaffold.FieldRegistry$Compiled {
            private final Map<String, TypeWriter.FieldPool.Entry> entries;
            private final TypeWriter.FieldPool.Entry fallback;

            public Compiled(Map<String, TypeWriter.FieldPool.Entry> entries, TypeWriter.FieldPool.Entry fallback) {
                this.entries = entries;
                this.fallback = fallback;
            }

            @Override
            public TypeWriter.FieldPool.Entry target(FieldDescription fieldDescription) {
                TypeWriter.FieldPool.Entry entry = this.entries.get(fieldDescription.getInternalName());
                return entry == null ? this.fallback : entry;
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.entries.equals(((Compiled)other).entries) && this.fallback.equals(((Compiled)other).fallback);
            }

            public int hashCode() {
                return 31 * this.entries.hashCode() + this.fallback.hashCode();
            }

            public String toString() {
                return "FieldRegistry.Default.Compiled{entries=" + this.entries + ", fallback=" + this.fallback + '}';
            }
        }

        protected static class Prepared
        implements net.bytebuddy.dynamic.scaffold.FieldRegistry$Prepared {
            private final Map<String, TypeWriter.FieldPool.Entry> entries;

            public Prepared(Map<String, TypeWriter.FieldPool.Entry> entries) {
                this.entries = entries;
            }

            @Override
            public net.bytebuddy.dynamic.scaffold.FieldRegistry$Compiled compile(TypeWriter.FieldPool.Entry fallback) {
                return new Compiled(this.entries, fallback);
            }

            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && this.entries.equals(((Prepared)other).entries);
            }

            public int hashCode() {
                return this.entries.hashCode();
            }

            public String toString() {
                return "FieldRegistry.Default.Prepared{entries=" + this.entries + '}';
            }
        }

        protected static class Entry {
            private final FieldAttributeAppender.Factory attributeAppenderFactory;
            private final Object defaultValue;

            private Entry(FieldAttributeAppender.Factory attributeAppenderFactory, Object defaultValue) {
                this.attributeAppenderFactory = attributeAppenderFactory;
                this.defaultValue = defaultValue;
            }

            public FieldAttributeAppender.Factory getAttributeAppenderFactory() {
                return this.attributeAppenderFactory;
            }

            public Object getDefaultValue() {
                return this.defaultValue;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                Entry entry = (Entry)other;
                return this.attributeAppenderFactory.equals(entry.attributeAppenderFactory) && !(this.defaultValue == null ? entry.defaultValue != null : !this.defaultValue.equals(entry.defaultValue));
            }

            public int hashCode() {
                return 31 * this.attributeAppenderFactory.hashCode() + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
            }

            public String toString() {
                return "FieldRegistry.Default.Entry{attributeAppenderFactory=" + this.attributeAppenderFactory + ", defaultValue=" + this.defaultValue + '}';
            }
        }
    }

    public static interface LatentFieldMatcher {
        public String getFieldName();
    }

    public static interface Compiled
    extends TypeWriter.FieldPool {

        public static enum NoOp implements Compiled
        {
            INSTANCE;


            @Override
            public TypeWriter.FieldPool.Entry target(FieldDescription fieldDescription) {
                return TypeWriter.FieldPool.Entry.NoOp.INSTANCE;
            }

            public String toString() {
                return "FieldRegistry.Compiled.NoOp." + this.name();
            }
        }
    }

    public static interface Prepared {
        public Compiled compile(TypeWriter.FieldPool.Entry var1);
    }
}

