/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.dynamic;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Logger;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.NamingStrategy;
import net.bytebuddy.asm.ClassVisitorWrapper;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.dynamic.TargetType;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.dynamic.scaffold.BridgeMethodResolver;
import net.bytebuddy.dynamic.scaffold.FieldRegistry;
import net.bytebuddy.dynamic.scaffold.InstrumentedType;
import net.bytebuddy.dynamic.scaffold.MethodLookupEngine;
import net.bytebuddy.dynamic.scaffold.MethodRegistry;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.LoadedTypeInitializer;
import net.bytebuddy.implementation.attribute.FieldAttributeAppender;
import net.bytebuddy.implementation.attribute.MethodAttributeAppender;
import net.bytebuddy.implementation.attribute.TypeAttributeAppender;
import net.bytebuddy.implementation.auxiliary.AuxiliaryType;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import net.bytebuddy.matcher.LatentMethodMatcher;
import net.bytebuddy.utility.ByteBuddyCommons;

public interface DynamicType {
    public TypeDescription getTypeDescription();

    public byte[] getBytes();

    public Map<TypeDescription, byte[]> getRawAuxiliaryTypes();

    public Map<TypeDescription, byte[]> getAllTypes();

    public Map<TypeDescription, LoadedTypeInitializer> getLoadedTypeInitializers();

    public boolean hasAliveLoadedTypeInitializers();

    public Map<TypeDescription, File> saveIn(File var1) throws IOException;

    public File inject(File var1, File var2) throws IOException;

    public File inject(File var1) throws IOException;

    public File toJar(File var1, Manifest var2) throws IOException;

    public static class Default
    implements DynamicType {
        private static final String CLASS_FILE_EXTENSION = ".class";
        private static final int BUFFER_SIZE = 1024;
        private static final int FROM_BEGINNING = 0;
        private static final int END_OF_FILE = -1;
        private static final String TEMP_SUFFIX = "tmp";
        protected final TypeDescription typeDescription;
        protected final byte[] binaryRepresentation;
        protected final LoadedTypeInitializer loadedTypeInitializer;
        protected final List<? extends DynamicType> auxiliaryTypes;

        public Default(TypeDescription typeDescription, byte[] binaryRepresentation, LoadedTypeInitializer loadedTypeInitializer, List<? extends DynamicType> auxiliaryTypes) {
            this.typeDescription = typeDescription;
            this.binaryRepresentation = binaryRepresentation;
            this.loadedTypeInitializer = loadedTypeInitializer;
            this.auxiliaryTypes = auxiliaryTypes;
        }

        @Override
        public TypeDescription getTypeDescription() {
            return this.typeDescription;
        }

        @Override
        public Map<TypeDescription, byte[]> getAllTypes() {
            HashMap<TypeDescription, byte[]> allTypes = new HashMap<TypeDescription, byte[]>(this.auxiliaryTypes.size() + 1);
            for (DynamicType dynamicType : this.auxiliaryTypes) {
                allTypes.putAll(dynamicType.getAllTypes());
            }
            allTypes.put(this.typeDescription, this.binaryRepresentation);
            return allTypes;
        }

        @Override
        public Map<TypeDescription, LoadedTypeInitializer> getLoadedTypeInitializers() {
            HashMap<TypeDescription, LoadedTypeInitializer> classLoadingCallbacks = new HashMap<TypeDescription, LoadedTypeInitializer>(this.auxiliaryTypes.size() + 1);
            for (DynamicType dynamicType : this.auxiliaryTypes) {
                classLoadingCallbacks.putAll(dynamicType.getLoadedTypeInitializers());
            }
            classLoadingCallbacks.put(this.typeDescription, this.loadedTypeInitializer);
            return classLoadingCallbacks;
        }

        @Override
        public boolean hasAliveLoadedTypeInitializers() {
            for (LoadedTypeInitializer loadedTypeInitializer : this.getLoadedTypeInitializers().values()) {
                if (!loadedTypeInitializer.isAlive()) continue;
                return true;
            }
            return false;
        }

        @Override
        public byte[] getBytes() {
            return this.binaryRepresentation;
        }

        @Override
        public Map<TypeDescription, byte[]> getRawAuxiliaryTypes() {
            HashMap<TypeDescription, byte[]> auxiliaryTypes = new HashMap<TypeDescription, byte[]>();
            for (DynamicType dynamicType : this.auxiliaryTypes) {
                auxiliaryTypes.put(dynamicType.getTypeDescription(), dynamicType.getBytes());
                auxiliaryTypes.putAll(dynamicType.getRawAuxiliaryTypes());
            }
            return auxiliaryTypes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map<TypeDescription, File> saveIn(File folder) throws IOException {
            HashMap<TypeDescription, File> savedFiles = new HashMap<TypeDescription, File>();
            File target = new File(folder, this.typeDescription.getName().replace('.', File.separatorChar) + CLASS_FILE_EXTENSION);
            if (target.getParentFile() != null) {
                target.getParentFile().mkdirs();
            }
            FileOutputStream outputStream = new FileOutputStream(target);
            try {
                ((OutputStream)outputStream).write(this.binaryRepresentation);
            }
            finally {
                ((OutputStream)outputStream).close();
            }
            savedFiles.put(this.typeDescription, target);
            for (DynamicType dynamicType : this.auxiliaryTypes) {
                savedFiles.putAll(dynamicType.saveIn(folder));
            }
            return savedFiles;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public File inject(File sourceJar, File targetJar) throws IOException {
            JarInputStream jarInputStream = new JarInputStream(new BufferedInputStream(new FileInputStream(sourceJar)));
            try {
                targetJar.createNewFile();
                JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(targetJar)), jarInputStream.getManifest());
                try {
                    JarEntry jarEntry;
                    Map<TypeDescription, byte[]> rawAuxiliaryTypes = this.getRawAuxiliaryTypes();
                    HashMap<String, byte[]> files = new HashMap<String, byte[]>(rawAuxiliaryTypes.size() + 1);
                    for (Map.Entry<TypeDescription, byte[]> entry : rawAuxiliaryTypes.entrySet()) {
                        files.put(entry.getKey().getInternalName() + CLASS_FILE_EXTENSION, entry.getValue());
                    }
                    files.put(this.typeDescription.getInternalName() + CLASS_FILE_EXTENSION, this.binaryRepresentation);
                    while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                        jarOutputStream.putNextEntry(jarEntry);
                        byte[] replacement = (byte[])files.remove(jarEntry.getName());
                        if (replacement == null) {
                            int index;
                            byte[] buffer = new byte[1024];
                            while ((index = jarInputStream.read(buffer)) != -1) {
                                jarOutputStream.write(buffer, 0, index);
                            }
                        } else {
                            jarOutputStream.write(replacement);
                        }
                        jarInputStream.closeEntry();
                        jarOutputStream.closeEntry();
                    }
                    for (Map.Entry entry : files.entrySet()) {
                        jarOutputStream.putNextEntry(new JarEntry((String)entry.getKey()));
                        jarOutputStream.write((byte[])entry.getValue());
                        jarOutputStream.closeEntry();
                    }
                }
                finally {
                    jarOutputStream.close();
                }
            }
            finally {
                jarInputStream.close();
            }
            return targetJar;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public File inject(File jar) throws IOException {
            File temporary = this.inject(jar, File.createTempFile(jar.getName(), TEMP_SUFFIX));
            try {
                BufferedInputStream jarInputStream = new BufferedInputStream(new FileInputStream(temporary));
                try {
                    BufferedOutputStream jarOutputStream = new BufferedOutputStream(new FileOutputStream(jar));
                    try {
                        int index;
                        byte[] buffer = new byte[1024];
                        while ((index = ((InputStream)jarInputStream).read(buffer)) != -1) {
                            ((OutputStream)jarOutputStream).write(buffer, 0, index);
                        }
                    }
                    finally {
                        ((OutputStream)jarOutputStream).close();
                    }
                }
                finally {
                    ((InputStream)jarInputStream).close();
                }
            }
            finally {
                if (!temporary.delete()) {
                    Logger.getAnonymousLogger().warning("Cannot delete " + temporary);
                }
            }
            return jar;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public File toJar(File file, Manifest manifest) throws IOException {
            file.createNewFile();
            JarOutputStream outputStream = new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(file)), manifest);
            try {
                for (Map.Entry<TypeDescription, byte[]> entry : this.getRawAuxiliaryTypes().entrySet()) {
                    outputStream.putNextEntry(new JarEntry(entry.getKey().getInternalName() + CLASS_FILE_EXTENSION));
                    outputStream.write(entry.getValue());
                    outputStream.closeEntry();
                }
                outputStream.putNextEntry(new JarEntry(this.typeDescription.getInternalName() + CLASS_FILE_EXTENSION));
                outputStream.write(this.binaryRepresentation);
                outputStream.closeEntry();
            }
            finally {
                outputStream.close();
            }
            return file;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Default aDefault = (Default)other;
            return this.auxiliaryTypes.equals(aDefault.auxiliaryTypes) && Arrays.equals(this.binaryRepresentation, aDefault.binaryRepresentation) && this.typeDescription.equals(aDefault.typeDescription) && this.loadedTypeInitializer.equals(aDefault.loadedTypeInitializer);
        }

        public int hashCode() {
            int result = this.typeDescription.hashCode();
            result = 31 * result + Arrays.hashCode(this.binaryRepresentation);
            result = 31 * result + this.loadedTypeInitializer.hashCode();
            result = 31 * result + this.auxiliaryTypes.hashCode();
            return result;
        }

        public String toString() {
            return "DynamicType.Default{typeDescription='" + this.typeDescription + '\'' + ", binaryRepresentation=<" + this.binaryRepresentation.length + " bytes>" + ", loadedTypeInitializer=" + this.loadedTypeInitializer + ", auxiliaryTypes=" + this.auxiliaryTypes + '}';
        }

        protected static class Loaded<T>
        extends Default
        implements net.bytebuddy.dynamic.DynamicType$Loaded<T> {
            private final Map<TypeDescription, Class<?>> loadedTypes;

            protected Loaded(TypeDescription typeDescription, byte[] typeByte, LoadedTypeInitializer loadedTypeInitializer, List<? extends DynamicType> auxiliaryTypes, Map<TypeDescription, Class<?>> loadedTypes) {
                super(typeDescription, typeByte, loadedTypeInitializer, auxiliaryTypes);
                this.loadedTypes = loadedTypes;
            }

            @Override
            public Class<? extends T> getLoaded() {
                return this.loadedTypes.get(this.typeDescription);
            }

            @Override
            public Map<TypeDescription, Class<?>> getLoadedAuxiliaryTypes() {
                HashMap loadedAuxiliaryTypes = new HashMap(this.loadedTypes);
                loadedAuxiliaryTypes.remove(this.typeDescription);
                return loadedAuxiliaryTypes;
            }

            @Override
            public boolean equals(Object other) {
                return this == other || other != null && this.getClass() == other.getClass() && super.equals(other) && this.loadedTypes.equals(((Loaded)other).loadedTypes);
            }

            @Override
            public int hashCode() {
                return 31 * super.hashCode() + this.loadedTypes.hashCode();
            }

            @Override
            public String toString() {
                return "DynamicType.Default.Loaded{typeDescription='" + this.typeDescription + '\'' + ", binaryRepresentation=<" + this.binaryRepresentation.length + " bytes>" + ", typeInitializer=" + this.loadedTypeInitializer + ", auxiliaryTypes=" + this.auxiliaryTypes + ", loadedTypes=" + this.loadedTypes + '}';
            }
        }

        public static class Unloaded<T>
        extends Default
        implements net.bytebuddy.dynamic.DynamicType$Unloaded<T> {
            public Unloaded(TypeDescription typeDescription, byte[] typeByte, LoadedTypeInitializer loadedTypeInitializer, List<? extends DynamicType> auxiliaryTypes) {
                super(typeDescription, typeByte, loadedTypeInitializer, auxiliaryTypes);
            }

            @Override
            public net.bytebuddy.dynamic.DynamicType$Loaded<T> load(ClassLoader classLoader, ClassLoadingStrategy classLoadingStrategy) {
                LinkedHashMap<TypeDescription, byte[]> types = new LinkedHashMap<TypeDescription, byte[]>(this.getRawAuxiliaryTypes());
                types.put(this.typeDescription, this.binaryRepresentation);
                return new Loaded(this.typeDescription, this.binaryRepresentation, this.loadedTypeInitializer, this.auxiliaryTypes, this.initialize(classLoadingStrategy.load(classLoader, types)));
            }

            private Map<TypeDescription, Class<?>> initialize(Map<TypeDescription, Class<?>> uninitialized) {
                Map<TypeDescription, LoadedTypeInitializer> typeInitializers = this.getLoadedTypeInitializers();
                for (Map.Entry<TypeDescription, Class<?>> entry : uninitialized.entrySet()) {
                    typeInitializers.get(entry.getKey()).onLoad(entry.getValue());
                }
                return new HashMap(uninitialized);
            }

            @Override
            public String toString() {
                return "DynamicType.Default.Unloaded{typeDescription='" + this.typeDescription + '\'' + ", binaryRepresentation=<" + this.binaryRepresentation.length + " bytes>" + ", typeInitializer=" + this.loadedTypeInitializer + ", auxiliaryTypes=" + this.auxiliaryTypes + '}';
            }
        }
    }

    public static interface Unloaded<T>
    extends DynamicType {
        public Loaded<T> load(ClassLoader var1, ClassLoadingStrategy var2);
    }

    public static interface Loaded<T>
    extends DynamicType {
        public Class<? extends T> getLoaded();

        public Map<TypeDescription, Class<?>> getLoadedAuxiliaryTypes();
    }

    public static interface Builder<T> {
        public Builder<T> classFileVersion(ClassFileVersion var1);

        public OptionalMatchedMethodInterception<T> implement(Class<?> ... var1);

        public OptionalMatchedMethodInterception<T> implement(Iterable<? extends Class<?>> var1);

        public OptionalMatchedMethodInterception<T> implement(TypeDescription ... var1);

        public OptionalMatchedMethodInterception<T> implement(Collection<? extends TypeDescription> var1);

        public Builder<T> name(String var1);

        public Builder<T> name(NamingStrategy var1);

        public Builder<T> name(AuxiliaryType.NamingStrategy var1);

        public Builder<T> modifiers(ModifierContributor.ForType ... var1);

        public Builder<T> modifiers(int var1);

        public Builder<T> ignoreMethods(ElementMatcher<? super MethodDescription> var1);

        public Builder<T> attribute(TypeAttributeAppender var1);

        public Builder<T> annotateType(Annotation ... var1);

        public Builder<T> annotateType(Iterable<? extends Annotation> var1);

        public Builder<T> annotateType(AnnotationDescription ... var1);

        public Builder<T> annotateType(Collection<? extends AnnotationDescription> var1);

        public Builder<T> classVisitor(ClassVisitorWrapper var1);

        public Builder<T> bridgeMethodResolverFactory(BridgeMethodResolver.Factory var1);

        public Builder<T> methodLookupEngine(MethodLookupEngine.Factory var1);

        public FieldValueTarget<T> defineField(String var1, Class<?> var2, ModifierContributor.ForField ... var3);

        public FieldValueTarget<T> defineField(String var1, TypeDescription var2, ModifierContributor.ForField ... var3);

        public FieldValueTarget<T> defineField(String var1, Class<?> var2, int var3);

        public FieldValueTarget<T> defineField(String var1, TypeDescription var2, int var3);

        public FieldValueTarget<T> defineField(Field var1);

        public FieldValueTarget<T> defineField(FieldDescription var1);

        public ExceptionDeclarableMethodInterception<T> defineMethod(String var1, Class<?> var2, List<? extends Class<?>> var3, ModifierContributor.ForMethod ... var4);

        public ExceptionDeclarableMethodInterception<T> defineMethod(String var1, TypeDescription var2, List<? extends TypeDescription> var3, ModifierContributor.ForMethod ... var4);

        public ExceptionDeclarableMethodInterception<T> defineMethod(String var1, Class<?> var2, List<? extends Class<?>> var3, int var4);

        public ExceptionDeclarableMethodInterception<T> defineMethod(String var1, TypeDescription var2, List<? extends TypeDescription> var3, int var4);

        public ExceptionDeclarableMethodInterception<T> defineMethod(Method var1);

        public ExceptionDeclarableMethodInterception<T> defineMethod(MethodDescription var1);

        public ExceptionDeclarableMethodInterception<T> defineConstructor(Iterable<? extends Class<?>> var1, ModifierContributor.ForMethod ... var2);

        public ExceptionDeclarableMethodInterception<T> defineConstructor(List<? extends TypeDescription> var1, ModifierContributor.ForMethod ... var2);

        public ExceptionDeclarableMethodInterception<T> defineConstructor(Iterable<? extends Class<?>> var1, int var2);

        public ExceptionDeclarableMethodInterception<T> defineConstructor(List<? extends TypeDescription> var1, int var2);

        public ExceptionDeclarableMethodInterception<T> defineConstructor(Constructor<?> var1);

        public ExceptionDeclarableMethodInterception<T> defineConstructor(MethodDescription var1);

        public ExceptionDeclarableMethodInterception<T> define(MethodDescription var1);

        public MatchedMethodInterception<T> method(ElementMatcher<? super MethodDescription> var1);

        public MatchedMethodInterception<T> constructor(ElementMatcher<? super MethodDescription> var1);

        public MatchedMethodInterception<T> invokable(ElementMatcher<? super MethodDescription> var1);

        public MatchedMethodInterception<T> invokable(LatentMethodMatcher var1);

        public Unloaded<T> make();

        public static abstract class AbstractBase<S>
        implements Builder<S> {
            protected final ClassFileVersion classFileVersion;
            protected final NamingStrategy namingStrategy;
            protected final AuxiliaryType.NamingStrategy auxiliaryTypeNamingStrategy;
            protected final TypeDescription targetType;
            protected final List<TypeDescription> interfaceTypes;
            protected final int modifiers;
            protected final TypeAttributeAppender attributeAppender;
            protected final ElementMatcher<? super MethodDescription> ignoredMethods;
            protected final BridgeMethodResolver.Factory bridgeMethodResolverFactory;
            protected final ClassVisitorWrapper.Chain classVisitorWrapperChain;
            protected final FieldRegistry fieldRegistry;
            protected final MethodRegistry methodRegistry;
            protected final MethodLookupEngine.Factory methodLookupEngineFactory;
            protected final FieldAttributeAppender.Factory defaultFieldAttributeAppenderFactory;
            protected final MethodAttributeAppender.Factory defaultMethodAttributeAppenderFactory;
            protected final List<FieldToken> fieldTokens;
            protected final List<MethodToken> methodTokens;

            protected AbstractBase(ClassFileVersion classFileVersion, NamingStrategy namingStrategy, AuxiliaryType.NamingStrategy auxiliaryTypeNamingStrategy, TypeDescription targetType, List<TypeDescription> interfaceTypes, int modifiers, TypeAttributeAppender attributeAppender, ElementMatcher<? super MethodDescription> ignoredMethods, BridgeMethodResolver.Factory bridgeMethodResolverFactory, ClassVisitorWrapper.Chain classVisitorWrapperChain, FieldRegistry fieldRegistry, MethodRegistry methodRegistry, MethodLookupEngine.Factory methodLookupEngineFactory, FieldAttributeAppender.Factory defaultFieldAttributeAppenderFactory, MethodAttributeAppender.Factory defaultMethodAttributeAppenderFactory, List<FieldToken> fieldTokens, List<MethodToken> methodTokens) {
                this.classFileVersion = classFileVersion;
                this.namingStrategy = namingStrategy;
                this.auxiliaryTypeNamingStrategy = auxiliaryTypeNamingStrategy;
                this.targetType = targetType;
                this.interfaceTypes = interfaceTypes;
                this.modifiers = modifiers;
                this.attributeAppender = attributeAppender;
                this.ignoredMethods = ignoredMethods;
                this.bridgeMethodResolverFactory = bridgeMethodResolverFactory;
                this.classVisitorWrapperChain = classVisitorWrapperChain;
                this.fieldRegistry = fieldRegistry;
                this.methodRegistry = methodRegistry;
                this.methodLookupEngineFactory = methodLookupEngineFactory;
                this.defaultFieldAttributeAppenderFactory = defaultFieldAttributeAppenderFactory;
                this.defaultMethodAttributeAppenderFactory = defaultMethodAttributeAppenderFactory;
                this.fieldTokens = fieldTokens;
                this.methodTokens = methodTokens;
            }

            protected InstrumentedType applyRecordedMembersTo(InstrumentedType instrumentedType) {
                for (FieldToken fieldToken : this.fieldTokens) {
                    instrumentedType = instrumentedType.withField(fieldToken.name, fieldToken.resolveFieldType(instrumentedType), fieldToken.modifiers);
                }
                for (MethodToken methodToken : this.methodTokens) {
                    instrumentedType = instrumentedType.withMethod(methodToken.internalName, methodToken.resolveReturnType(instrumentedType), methodToken.resolveParameterTypes(instrumentedType), methodToken.resolveExceptionTypes(instrumentedType), methodToken.modifiers);
                }
                return instrumentedType;
            }

            @Override
            public OptionalMatchedMethodInterception<S> implement(Class<?> ... interfaceType) {
                return this.implement(new TypeList.ForLoadedType(ByteBuddyCommons.nonNull(interfaceType)));
            }

            @Override
            public OptionalMatchedMethodInterception<S> implement(Iterable<? extends Class<?>> interfaceTypes) {
                return this.implement(new TypeList.ForLoadedType(ByteBuddyCommons.toList(interfaceTypes)));
            }

            @Override
            public OptionalMatchedMethodInterception<S> implement(TypeDescription ... interfaceType) {
                return this.implement((Collection<? extends TypeDescription>)Arrays.asList(interfaceType));
            }

            @Override
            public OptionalMatchedMethodInterception<S> implement(Collection<? extends TypeDescription> interfaceTypes) {
                return new DefaultOptionalMatchedMethodInterception(new ArrayList<TypeDescription>(ByteBuddyCommons.isInterface(interfaceTypes)));
            }

            @Override
            public FieldValueTarget<S> defineField(String name, Class<?> fieldType, ModifierContributor.ForField ... modifier) {
                return this.defineField(name, (TypeDescription)new TypeDescription.ForLoadedType(fieldType), modifier);
            }

            @Override
            public ExceptionDeclarableMethodInterception<S> defineMethod(String name, Class<?> returnType, List<? extends Class<?>> parameterTypes, ModifierContributor.ForMethod ... modifier) {
                return this.defineMethod(name, (TypeDescription)new TypeDescription.ForLoadedType(returnType), (List<TypeDescription>)new TypeList.ForLoadedType(new ArrayList(ByteBuddyCommons.nonNull(parameterTypes))), modifier);
            }

            @Override
            public ExceptionDeclarableMethodInterception<S> defineConstructor(Iterable<? extends Class<?>> parameterTypes, ModifierContributor.ForMethod ... modifier) {
                return this.defineConstructor((List<TypeDescription>)new TypeList.ForLoadedType(ByteBuddyCommons.toList(parameterTypes)), modifier);
            }

            @Override
            public Builder<S> classFileVersion(ClassFileVersion classFileVersion) {
                return this.materialize(ByteBuddyCommons.nonNull(classFileVersion), this.namingStrategy, this.auxiliaryTypeNamingStrategy, this.targetType, this.interfaceTypes, this.modifiers, this.attributeAppender, this.ignoredMethods, this.bridgeMethodResolverFactory, this.classVisitorWrapperChain, this.fieldRegistry, this.methodRegistry, this.methodLookupEngineFactory, this.defaultFieldAttributeAppenderFactory, this.defaultMethodAttributeAppenderFactory, this.fieldTokens, this.methodTokens);
            }

            @Override
            public Builder<S> name(String name) {
                return this.materialize(this.classFileVersion, new NamingStrategy.Fixed(ByteBuddyCommons.isValidTypeName(name)), this.auxiliaryTypeNamingStrategy, this.targetType, this.interfaceTypes, this.modifiers, this.attributeAppender, this.ignoredMethods, this.bridgeMethodResolverFactory, this.classVisitorWrapperChain, this.fieldRegistry, this.methodRegistry, this.methodLookupEngineFactory, this.defaultFieldAttributeAppenderFactory, this.defaultMethodAttributeAppenderFactory, this.fieldTokens, this.methodTokens);
            }

            @Override
            public Builder<S> name(NamingStrategy namingStrategy) {
                return this.materialize(this.classFileVersion, ByteBuddyCommons.nonNull(namingStrategy), this.auxiliaryTypeNamingStrategy, this.targetType, this.interfaceTypes, this.modifiers, this.attributeAppender, this.ignoredMethods, this.bridgeMethodResolverFactory, this.classVisitorWrapperChain, this.fieldRegistry, this.methodRegistry, this.methodLookupEngineFactory, this.defaultFieldAttributeAppenderFactory, this.defaultMethodAttributeAppenderFactory, this.fieldTokens, this.methodTokens);
            }

            @Override
            public Builder<S> name(AuxiliaryType.NamingStrategy auxiliaryTypeNamingStrategy) {
                return this.materialize(this.classFileVersion, this.namingStrategy, ByteBuddyCommons.nonNull(auxiliaryTypeNamingStrategy), this.targetType, this.interfaceTypes, this.modifiers, this.attributeAppender, this.ignoredMethods, this.bridgeMethodResolverFactory, this.classVisitorWrapperChain, this.fieldRegistry, this.methodRegistry, this.methodLookupEngineFactory, this.defaultFieldAttributeAppenderFactory, this.defaultMethodAttributeAppenderFactory, this.fieldTokens, this.methodTokens);
            }

            @Override
            public Builder<S> modifiers(ModifierContributor.ForType ... modifier) {
                return this.materialize(this.classFileVersion, this.namingStrategy, this.auxiliaryTypeNamingStrategy, this.targetType, this.interfaceTypes, ByteBuddyCommons.resolveModifierContributors(163383, ByteBuddyCommons.nonNull(modifier)), this.attributeAppender, this.ignoredMethods, this.bridgeMethodResolverFactory, this.classVisitorWrapperChain, this.fieldRegistry, this.methodRegistry, this.methodLookupEngineFactory, this.defaultFieldAttributeAppenderFactory, this.defaultMethodAttributeAppenderFactory, this.fieldTokens, this.methodTokens);
            }

            @Override
            public Builder<S> modifiers(int modifiers) {
                return this.materialize(this.classFileVersion, this.namingStrategy, this.auxiliaryTypeNamingStrategy, this.targetType, this.interfaceTypes, modifiers, this.attributeAppender, this.ignoredMethods, this.bridgeMethodResolverFactory, this.classVisitorWrapperChain, this.fieldRegistry, this.methodRegistry, this.methodLookupEngineFactory, this.defaultFieldAttributeAppenderFactory, this.defaultMethodAttributeAppenderFactory, this.fieldTokens, this.methodTokens);
            }

            @Override
            public Builder<S> ignoreMethods(ElementMatcher<? super MethodDescription> ignoredMethods) {
                return this.materialize(this.classFileVersion, this.namingStrategy, this.auxiliaryTypeNamingStrategy, this.targetType, this.interfaceTypes, this.modifiers, this.attributeAppender, new ElementMatcher.Junction.Conjunction<MethodDescription>(this.ignoredMethods, ByteBuddyCommons.nonNull(ignoredMethods)), this.bridgeMethodResolverFactory, this.classVisitorWrapperChain, this.fieldRegistry, this.methodRegistry, this.methodLookupEngineFactory, this.defaultFieldAttributeAppenderFactory, this.defaultMethodAttributeAppenderFactory, this.fieldTokens, this.methodTokens);
            }

            @Override
            public Builder<S> attribute(TypeAttributeAppender attributeAppender) {
                return this.materialize(this.classFileVersion, this.namingStrategy, this.auxiliaryTypeNamingStrategy, this.targetType, this.interfaceTypes, this.modifiers, new TypeAttributeAppender.Compound(this.attributeAppender, ByteBuddyCommons.nonNull(attributeAppender)), this.ignoredMethods, this.bridgeMethodResolverFactory, this.classVisitorWrapperChain, this.fieldRegistry, this.methodRegistry, this.methodLookupEngineFactory, this.defaultFieldAttributeAppenderFactory, this.defaultMethodAttributeAppenderFactory, this.fieldTokens, this.methodTokens);
            }

            @Override
            public Builder<S> annotateType(Annotation ... annotation) {
                return this.annotateType(new AnnotationList.ForLoadedAnnotation(ByteBuddyCommons.nonNull(annotation)));
            }

            @Override
            public Builder<S> annotateType(Iterable<? extends Annotation> annotations) {
                return this.annotateType(new AnnotationList.ForLoadedAnnotation(ByteBuddyCommons.toList(annotations)));
            }

            @Override
            public Builder<S> annotateType(AnnotationDescription ... annotation) {
                return this.annotateType(new AnnotationList.Explicit(Arrays.asList(ByteBuddyCommons.nonNull(annotation))));
            }

            @Override
            public Builder<S> annotateType(Collection<? extends AnnotationDescription> annotations) {
                return this.attribute(new TypeAttributeAppender.ForAnnotation(new ArrayList<AnnotationDescription>(ByteBuddyCommons.nonNull(annotations))));
            }

            @Override
            public Builder<S> classVisitor(ClassVisitorWrapper classVisitorWrapper) {
                return this.materialize(this.classFileVersion, this.namingStrategy, this.auxiliaryTypeNamingStrategy, this.targetType, this.interfaceTypes, this.modifiers, this.attributeAppender, this.ignoredMethods, this.bridgeMethodResolverFactory, this.classVisitorWrapperChain.append(ByteBuddyCommons.nonNull(classVisitorWrapper)), this.fieldRegistry, this.methodRegistry, this.methodLookupEngineFactory, this.defaultFieldAttributeAppenderFactory, this.defaultMethodAttributeAppenderFactory, this.fieldTokens, this.methodTokens);
            }

            @Override
            public Builder<S> methodLookupEngine(MethodLookupEngine.Factory methodLookupEngineFactory) {
                return this.materialize(this.classFileVersion, this.namingStrategy, this.auxiliaryTypeNamingStrategy, this.targetType, this.interfaceTypes, this.modifiers, this.attributeAppender, this.ignoredMethods, this.bridgeMethodResolverFactory, this.classVisitorWrapperChain, this.fieldRegistry, this.methodRegistry, ByteBuddyCommons.nonNull(methodLookupEngineFactory), this.defaultFieldAttributeAppenderFactory, this.defaultMethodAttributeAppenderFactory, this.fieldTokens, this.methodTokens);
            }

            @Override
            public Builder<S> bridgeMethodResolverFactory(BridgeMethodResolver.Factory bridgeMethodResolverFactory) {
                return this.materialize(this.classFileVersion, this.namingStrategy, this.auxiliaryTypeNamingStrategy, this.targetType, this.interfaceTypes, this.modifiers, this.attributeAppender, this.ignoredMethods, ByteBuddyCommons.nonNull(bridgeMethodResolverFactory), this.classVisitorWrapperChain, this.fieldRegistry, this.methodRegistry, this.methodLookupEngineFactory, this.defaultFieldAttributeAppenderFactory, this.defaultMethodAttributeAppenderFactory, this.fieldTokens, this.methodTokens);
            }

            @Override
            public FieldValueTarget<S> defineField(String name, TypeDescription fieldType, ModifierContributor.ForField ... modifier) {
                return this.defineField(name, fieldType, ByteBuddyCommons.resolveModifierContributors(163583, ByteBuddyCommons.nonNull(modifier)));
            }

            @Override
            public FieldValueTarget<S> defineField(String name, Class<?> fieldType, int modifiers) {
                return this.defineField(name, (TypeDescription)new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(fieldType)), modifiers);
            }

            @Override
            public FieldValueTarget<S> defineField(String name, TypeDescription fieldTypeDescription, int modifiers) {
                return new DefaultFieldValueTarget(new FieldToken(ByteBuddyCommons.isValidIdentifier(name), ByteBuddyCommons.nonVoid(fieldTypeDescription), modifiers), this.defaultFieldAttributeAppenderFactory);
            }

            @Override
            public FieldValueTarget<S> defineField(Field field) {
                return this.defineField(field.getName(), field.getType(), field.getModifiers());
            }

            @Override
            public FieldValueTarget<S> defineField(FieldDescription fieldDescription) {
                return this.defineField(fieldDescription.getName(), fieldDescription.getFieldType(), fieldDescription.getModifiers());
            }

            @Override
            public ExceptionDeclarableMethodInterception<S> defineMethod(String name, TypeDescription returnType, List<? extends TypeDescription> parameterTypes, ModifierContributor.ForMethod ... modifier) {
                return new DefaultExceptionDeclarableMethodInterception(new MethodToken(ByteBuddyCommons.isValidIdentifier(name), ByteBuddyCommons.nonNull(returnType), ByteBuddyCommons.nonVoid(parameterTypes), Collections.emptyList(), ByteBuddyCommons.resolveModifierContributors(163839, ByteBuddyCommons.nonNull(modifier))));
            }

            @Override
            public ExceptionDeclarableMethodInterception<S> defineMethod(Method method) {
                return this.defineMethod(method.getName(), method.getReturnType(), Arrays.asList(method.getParameterTypes()), method.getModifiers());
            }

            @Override
            public ExceptionDeclarableMethodInterception<S> defineMethod(MethodDescription methodDescription) {
                if (!methodDescription.isMethod()) {
                    throw new IllegalArgumentException("Not a method: " + methodDescription);
                }
                return this.defineMethod(methodDescription.getName(), methodDescription.getReturnType(), (List<TypeDescription>)methodDescription.getParameters().asTypeList(), methodDescription.getModifiers());
            }

            @Override
            public ExceptionDeclarableMethodInterception<S> defineMethod(String name, Class<?> returnType, List<? extends Class<?>> parameterTypes, int modifiers) {
                return this.defineMethod(name, (TypeDescription)new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(returnType)), (List<TypeDescription>)new TypeList.ForLoadedType(ByteBuddyCommons.nonNull(parameterTypes)), modifiers);
            }

            @Override
            public ExceptionDeclarableMethodInterception<S> defineMethod(String name, TypeDescription returnType, List<? extends TypeDescription> parameterTypes, int modifiers) {
                return new DefaultExceptionDeclarableMethodInterception(new MethodToken(ByteBuddyCommons.isValidIdentifier(name), ByteBuddyCommons.nonNull(returnType), ByteBuddyCommons.nonVoid(parameterTypes), Collections.emptyList(), modifiers));
            }

            @Override
            public ExceptionDeclarableMethodInterception<S> defineConstructor(List<? extends TypeDescription> parameterTypes, ModifierContributor.ForMethod ... modifier) {
                return this.defineConstructor(parameterTypes, ByteBuddyCommons.resolveModifierContributors(163831, ByteBuddyCommons.nonNull(modifier)));
            }

            @Override
            public ExceptionDeclarableMethodInterception<S> defineConstructor(Constructor<?> constructor) {
                return this.defineConstructor((Iterable<? extends Class<?>>)Arrays.asList(constructor.getParameterTypes()), constructor.getModifiers());
            }

            @Override
            public ExceptionDeclarableMethodInterception<S> defineConstructor(MethodDescription methodDescription) {
                if (!methodDescription.isConstructor()) {
                    throw new IllegalArgumentException("Not a constructor: " + methodDescription);
                }
                return this.defineConstructor((List<TypeDescription>)methodDescription.getParameters().asTypeList(), methodDescription.getModifiers());
            }

            @Override
            public ExceptionDeclarableMethodInterception<S> defineConstructor(Iterable<? extends Class<?>> parameterTypes, int modifiers) {
                return this.defineConstructor((List<TypeDescription>)new TypeList.ForLoadedType(ByteBuddyCommons.toList(parameterTypes)), modifiers);
            }

            @Override
            public ExceptionDeclarableMethodInterception<S> defineConstructor(List<? extends TypeDescription> parameterTypes, int modifiers) {
                return new DefaultExceptionDeclarableMethodInterception(new MethodToken(ByteBuddyCommons.nonVoid(parameterTypes), Collections.emptyList(), modifiers));
            }

            @Override
            public ExceptionDeclarableMethodInterception<S> define(MethodDescription methodDescription) {
                return methodDescription.isMethod() ? this.defineMethod(methodDescription) : this.defineConstructor(methodDescription);
            }

            @Override
            public MatchedMethodInterception<S> method(ElementMatcher<? super MethodDescription> methodMatcher) {
                return this.invokable(ElementMatchers.isMethod().and(ByteBuddyCommons.nonNull(methodMatcher)));
            }

            @Override
            public MatchedMethodInterception<S> constructor(ElementMatcher<? super MethodDescription> methodMatcher) {
                return this.invokable(ElementMatchers.isConstructor().and(ByteBuddyCommons.nonNull(methodMatcher)));
            }

            @Override
            public MatchedMethodInterception<S> invokable(ElementMatcher<? super MethodDescription> methodMatcher) {
                return this.invokable(new LatentMethodMatcher.Resolved(ByteBuddyCommons.nonNull(methodMatcher)));
            }

            @Override
            public MatchedMethodInterception<S> invokable(LatentMethodMatcher methodMatcher) {
                return new DefaultMatchedMethodInterception(ByteBuddyCommons.nonNull(methodMatcher), this.methodTokens);
            }

            protected abstract Builder<S> materialize(ClassFileVersion var1, NamingStrategy var2, AuxiliaryType.NamingStrategy var3, TypeDescription var4, List<TypeDescription> var5, int var6, TypeAttributeAppender var7, ElementMatcher<? super MethodDescription> var8, BridgeMethodResolver.Factory var9, ClassVisitorWrapper.Chain var10, FieldRegistry var11, MethodRegistry var12, MethodLookupEngine.Factory var13, FieldAttributeAppender.Factory var14, MethodAttributeAppender.Factory var15, List<FieldToken> var16, List<MethodToken> var17);

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (other == null || this.getClass() != other.getClass()) {
                    return false;
                }
                AbstractBase that = (AbstractBase)other;
                return this.modifiers == that.modifiers && this.attributeAppender.equals(that.attributeAppender) && this.bridgeMethodResolverFactory.equals(that.bridgeMethodResolverFactory) && this.classFileVersion.equals(that.classFileVersion) && this.classVisitorWrapperChain.equals(that.classVisitorWrapperChain) && this.defaultFieldAttributeAppenderFactory.equals(that.defaultFieldAttributeAppenderFactory) && this.defaultMethodAttributeAppenderFactory.equals(that.defaultMethodAttributeAppenderFactory) && this.fieldRegistry.equals(that.fieldRegistry) && this.fieldTokens.equals(that.fieldTokens) && this.ignoredMethods.equals(that.ignoredMethods) && this.interfaceTypes.equals(that.interfaceTypes) && this.targetType.equals(that.targetType) && this.methodLookupEngineFactory.equals(that.methodLookupEngineFactory) && this.methodRegistry.equals(that.methodRegistry) && this.methodTokens.equals(that.methodTokens) && this.namingStrategy.equals(that.namingStrategy) && this.auxiliaryTypeNamingStrategy.equals(that.auxiliaryTypeNamingStrategy);
            }

            public int hashCode() {
                int result = this.classFileVersion.hashCode();
                result = 31 * result + this.namingStrategy.hashCode();
                result = 31 * result + this.auxiliaryTypeNamingStrategy.hashCode();
                result = 31 * result + this.targetType.hashCode();
                result = 31 * result + this.interfaceTypes.hashCode();
                result = 31 * result + this.modifiers;
                result = 31 * result + this.attributeAppender.hashCode();
                result = 31 * result + this.ignoredMethods.hashCode();
                result = 31 * result + this.bridgeMethodResolverFactory.hashCode();
                result = 31 * result + this.classVisitorWrapperChain.hashCode();
                result = 31 * result + this.fieldRegistry.hashCode();
                result = 31 * result + this.methodRegistry.hashCode();
                result = 31 * result + this.methodLookupEngineFactory.hashCode();
                result = 31 * result + this.defaultFieldAttributeAppenderFactory.hashCode();
                result = 31 * result + this.defaultMethodAttributeAppenderFactory.hashCode();
                result = 31 * result + this.fieldTokens.hashCode();
                result = 31 * result + this.methodTokens.hashCode();
                return result;
            }

            protected class DefaultOptionalMatchedMethodInterception
            extends AbstractDelegatingBuilder<S>
            implements OptionalMatchedMethodInterception<S> {
                private List<TypeDescription> additionalInterfaceTypes;

                protected DefaultOptionalMatchedMethodInterception(List<TypeDescription> interfaceTypes) {
                    this.additionalInterfaceTypes = interfaceTypes;
                }

                @Override
                public MethodAnnotationTarget<S> intercept(Implementation implementation) {
                    return this.materialize().method(ElementMatchers.isDeclaredBy(ElementMatchers.anyOf(this.additionalInterfaceTypes))).intercept(ByteBuddyCommons.nonNull(implementation));
                }

                @Override
                public MethodAnnotationTarget<S> withoutCode() {
                    return this.materialize().method(ElementMatchers.isDeclaredBy(ElementMatchers.anyOf(this.additionalInterfaceTypes))).withoutCode();
                }

                @Override
                public MethodAnnotationTarget<S> withDefaultValue(Object value, Class<?> type) {
                    return this.materialize().method(ElementMatchers.isDeclaredBy(ElementMatchers.anyOf(this.additionalInterfaceTypes))).withDefaultValue(value, type);
                }

                @Override
                public MethodAnnotationTarget<S> withDefaultValue(Object value) {
                    return this.materialize().method(ElementMatchers.isDeclaredBy(ElementMatchers.anyOf(this.additionalInterfaceTypes))).withDefaultValue(value);
                }

                @Override
                protected Builder<S> materialize() {
                    return AbstractBase.this.materialize(AbstractBase.this.classFileVersion, AbstractBase.this.namingStrategy, AbstractBase.this.auxiliaryTypeNamingStrategy, AbstractBase.this.targetType, ByteBuddyCommons.joinUnique(AbstractBase.this.interfaceTypes, this.additionalInterfaceTypes), AbstractBase.this.modifiers, AbstractBase.this.attributeAppender, AbstractBase.this.ignoredMethods, AbstractBase.this.bridgeMethodResolverFactory, AbstractBase.this.classVisitorWrapperChain, AbstractBase.this.fieldRegistry, AbstractBase.this.methodRegistry, AbstractBase.this.methodLookupEngineFactory, AbstractBase.this.defaultFieldAttributeAppenderFactory, AbstractBase.this.defaultMethodAttributeAppenderFactory, AbstractBase.this.fieldTokens, AbstractBase.this.methodTokens);
                }

                private Builder<?> getDynamicTypeBuilder() {
                    return AbstractBase.this;
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    DefaultOptionalMatchedMethodInterception that = (DefaultOptionalMatchedMethodInterception)other;
                    return this.additionalInterfaceTypes.equals(that.additionalInterfaceTypes) && AbstractBase.this.equals(that.getDynamicTypeBuilder());
                }

                public int hashCode() {
                    return 31 * AbstractBase.this.hashCode() + this.additionalInterfaceTypes.hashCode();
                }

                public String toString() {
                    return "DynamicType.Builder.AbstractBase.DefaultOptionalMatchedMethodInterception{base=" + AbstractBase.this + "additionalInterfaceTypes=" + this.additionalInterfaceTypes + '}';
                }
            }

            protected class DefaultMethodAnnotationTarget
            extends AbstractDelegatingBuilder<S>
            implements MethodAnnotationTarget<S> {
                private final List<MethodToken> methodTokens;
                private final LatentMethodMatcher methodMatcher;
                private final MethodRegistry.Handler handler;
                private final MethodAttributeAppender.Factory attributeAppenderFactory;

                protected DefaultMethodAnnotationTarget(List<MethodToken> methodTokens, LatentMethodMatcher methodMatcher, MethodRegistry.Handler handler, MethodAttributeAppender.Factory attributeAppenderFactory) {
                    this.methodMatcher = methodMatcher;
                    this.methodTokens = methodTokens;
                    this.handler = handler;
                    this.attributeAppenderFactory = attributeAppenderFactory;
                }

                @Override
                protected Builder<S> materialize() {
                    return AbstractBase.this.materialize(AbstractBase.this.classFileVersion, AbstractBase.this.namingStrategy, AbstractBase.this.auxiliaryTypeNamingStrategy, AbstractBase.this.targetType, AbstractBase.this.interfaceTypes, AbstractBase.this.modifiers, AbstractBase.this.attributeAppender, AbstractBase.this.ignoredMethods, AbstractBase.this.bridgeMethodResolverFactory, AbstractBase.this.classVisitorWrapperChain, AbstractBase.this.fieldRegistry, AbstractBase.this.methodRegistry.prepend(this.methodMatcher, this.handler, this.attributeAppenderFactory), AbstractBase.this.methodLookupEngineFactory, AbstractBase.this.defaultFieldAttributeAppenderFactory, AbstractBase.this.defaultMethodAttributeAppenderFactory, AbstractBase.this.fieldTokens, this.methodTokens);
                }

                @Override
                public MethodAnnotationTarget<S> attribute(MethodAttributeAppender.Factory attributeAppenderFactory) {
                    return new DefaultMethodAnnotationTarget(this.methodTokens, this.methodMatcher, this.handler, new MethodAttributeAppender.Factory.Compound(this.attributeAppenderFactory, ByteBuddyCommons.nonNull(attributeAppenderFactory)));
                }

                @Override
                public MethodAnnotationTarget<S> annotateMethod(Annotation ... annotation) {
                    return this.annotateMethod(new AnnotationList.ForLoadedAnnotation(ByteBuddyCommons.nonNull(annotation)));
                }

                @Override
                public MethodAnnotationTarget<S> annotateMethod(Iterable<? extends Annotation> annotations) {
                    return this.annotateMethod(new AnnotationList.ForLoadedAnnotation(ByteBuddyCommons.toList(annotations)));
                }

                @Override
                public MethodAnnotationTarget<S> annotateMethod(AnnotationDescription ... annotation) {
                    return this.annotateMethod((Collection<? extends AnnotationDescription>)Arrays.asList(ByteBuddyCommons.nonNull(annotation)));
                }

                @Override
                public MethodAnnotationTarget<S> annotateMethod(Collection<? extends AnnotationDescription> annotations) {
                    return this.attribute(new MethodAttributeAppender.ForAnnotation((List<? extends AnnotationDescription>)ByteBuddyCommons.nonNull(new ArrayList<AnnotationDescription>(annotations))));
                }

                @Override
                public MethodAnnotationTarget<S> annotateParameter(int parameterIndex, Annotation ... annotation) {
                    return this.annotateParameter(parameterIndex, new AnnotationList.ForLoadedAnnotation(ByteBuddyCommons.nonNull(annotation)));
                }

                @Override
                public MethodAnnotationTarget<S> annotateParameter(int parameterIndex, Iterable<? extends Annotation> annotations) {
                    return this.annotateParameter(parameterIndex, new AnnotationList.ForLoadedAnnotation(ByteBuddyCommons.toList(annotations)));
                }

                @Override
                public MethodAnnotationTarget<S> annotateParameter(int parameterIndex, AnnotationDescription ... annotation) {
                    return this.annotateParameter(parameterIndex, (Collection<? extends AnnotationDescription>)Arrays.asList(ByteBuddyCommons.nonNull(annotation)));
                }

                @Override
                public MethodAnnotationTarget<S> annotateParameter(int parameterIndex, Collection<? extends AnnotationDescription> annotations) {
                    return this.attribute(new MethodAttributeAppender.ForAnnotation(parameterIndex, (List<? extends AnnotationDescription>)ByteBuddyCommons.nonNull(new ArrayList<AnnotationDescription>(annotations))));
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    DefaultMethodAnnotationTarget that = (DefaultMethodAnnotationTarget)other;
                    return this.attributeAppenderFactory.equals(that.attributeAppenderFactory) && this.handler.equals(that.handler) && this.methodMatcher.equals(that.methodMatcher) && this.methodTokens.equals(that.methodTokens) && AbstractBase.this.equals(that.getDynamicTypeBuilder());
                }

                public int hashCode() {
                    int result = this.methodTokens.hashCode();
                    result = 31 * result + this.methodMatcher.hashCode();
                    result = 31 * result + this.handler.hashCode();
                    result = 31 * result + this.attributeAppenderFactory.hashCode();
                    result = 31 * result + AbstractBase.this.hashCode();
                    return result;
                }

                public String toString() {
                    return "DynamicType.Builder.AbstractBase.DefaultMethodAnnotationTarget{base=" + AbstractBase.this + ", methodTokens=" + this.methodTokens + ", methodMatcher=" + this.methodMatcher + ", handler=" + this.handler + ", attributeAppenderFactory=" + this.attributeAppenderFactory + '}';
                }

                private Builder<?> getDynamicTypeBuilder() {
                    return AbstractBase.this;
                }
            }

            protected class DefaultExceptionDeclarableMethodInterception
            implements ExceptionDeclarableMethodInterception<S> {
                private final MethodToken methodToken;

                private DefaultExceptionDeclarableMethodInterception(MethodToken methodToken) {
                    this.methodToken = methodToken;
                }

                @Override
                public MatchedMethodInterception<S> throwing(Class<?> ... exceptionType) {
                    return this.throwing(new TypeList.ForLoadedType(ByteBuddyCommons.nonNull(exceptionType)));
                }

                @Override
                public MatchedMethodInterception<S> throwing(Iterable<? extends Class<?>> exceptionTypes) {
                    return this.throwing(new TypeList.ForLoadedType(ByteBuddyCommons.toList(exceptionTypes)));
                }

                @Override
                public MatchedMethodInterception<S> throwing(TypeDescription ... exceptionType) {
                    return this.throwing((Collection<? extends TypeDescription>)Arrays.asList(ByteBuddyCommons.nonNull(exceptionType)));
                }

                @Override
                public MatchedMethodInterception<S> throwing(Collection<? extends TypeDescription> exceptionTypes) {
                    return this.materialize(new MethodToken(this.methodToken.getInternalName(), this.methodToken.getReturnType(), this.methodToken.getParameterTypes(), (List)ByteBuddyCommons.unique((Collection)ByteBuddyCommons.isThrowable(new ArrayList<TypeDescription>(exceptionTypes))), this.methodToken.getModifiers()));
                }

                @Override
                public MethodAnnotationTarget<S> intercept(Implementation implementation) {
                    return this.materialize(this.methodToken).intercept(implementation);
                }

                @Override
                public MethodAnnotationTarget<S> withoutCode() {
                    return this.materialize(this.methodToken).withoutCode();
                }

                @Override
                public MethodAnnotationTarget<S> withDefaultValue(Object value, Class<?> type) {
                    return this.materialize(this.methodToken).withDefaultValue(value, type);
                }

                @Override
                public MethodAnnotationTarget<S> withDefaultValue(Object value) {
                    return this.materialize(this.methodToken).withDefaultValue(value);
                }

                private DefaultMatchedMethodInterception materialize(MethodToken methodToken) {
                    return new DefaultMatchedMethodInterception(methodToken, ByteBuddyCommons.join(AbstractBase.this.methodTokens, methodToken));
                }

                public boolean equals(Object other) {
                    return this == other || other != null && this.getClass() == other.getClass() && this.methodToken.equals(((DefaultExceptionDeclarableMethodInterception)other).methodToken) && AbstractBase.this.equals(((DefaultExceptionDeclarableMethodInterception)other).getDynamicTypeBuilder());
                }

                public int hashCode() {
                    return 31 * AbstractBase.this.hashCode() + this.methodToken.hashCode();
                }

                public String toString() {
                    return "DynamicType.Builder.AbstractBase.DefaultExceptionDeclarableMethodInterception{base=" + AbstractBase.this + ", methodToken=" + this.methodToken + '}';
                }

                private Builder<?> getDynamicTypeBuilder() {
                    return AbstractBase.this;
                }
            }

            protected class DefaultMatchedMethodInterception
            implements MatchedMethodInterception<S> {
                private final LatentMethodMatcher methodMatcher;
                private final List<MethodToken> methodTokens;

                protected DefaultMatchedMethodInterception(LatentMethodMatcher methodMatcher, List<MethodToken> methodTokens) {
                    this.methodMatcher = methodMatcher;
                    this.methodTokens = methodTokens;
                }

                @Override
                public MethodAnnotationTarget<S> intercept(Implementation implementation) {
                    return new DefaultMethodAnnotationTarget(this.methodTokens, this.methodMatcher, new MethodRegistry.Handler.ForImplementation(ByteBuddyCommons.nonNull(implementation)), AbstractBase.this.defaultMethodAttributeAppenderFactory);
                }

                @Override
                public MethodAnnotationTarget<S> withoutCode() {
                    return new DefaultMethodAnnotationTarget(this.methodTokens, this.methodMatcher, MethodRegistry.Handler.ForAbstractMethod.INSTANCE, AbstractBase.this.defaultMethodAttributeAppenderFactory);
                }

                @Override
                public MethodAnnotationTarget<S> withDefaultValue(Object value, Class<?> type) {
                    return this.withDefaultValue(AnnotationDescription.ForLoadedAnnotation.describe(ByteBuddyCommons.nonNull(value), new TypeDescription.ForLoadedType(ByteBuddyCommons.nonNull(type))));
                }

                @Override
                public MethodAnnotationTarget<S> withDefaultValue(Object value) {
                    return new DefaultMethodAnnotationTarget(this.methodTokens, this.methodMatcher, MethodRegistry.Handler.ForAnnotationValue.of(value), MethodAttributeAppender.NoOp.INSTANCE);
                }

                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null || this.getClass() != other.getClass()) {
                        return false;
                    }
                    DefaultMatchedMethodInterception that = (DefaultMatchedMethodInterception)other;
                    return this.methodMatcher.equals(that.methodMatcher) && this.methodTokens.equals(that.methodTokens) && AbstractBase.this.equals(that.getDynamicTypeBuilder());
                }

                public int hashCode() {
                    int result = this.methodMatcher.hashCode();
                    result = 31 * result + this.methodTokens.hashCode();
                    result = 31 * result + AbstractBase.this.hashCode();
                    return result;
                }

                public String toString() {
                    return "DynamicType.Builder.AbstractBase.DefaultMatchedMethodInterception{base=" + AbstractBase.this + ", methodMatcher=" + this.methodMatcher + ", methodTokens=" + this.methodTokens + '}';
                }

                private Builder<?> getDynamicTypeBuilder() {
                    return AbstractBase.this;
                }
            }

            protected class DefaultFieldValueTarget
            extends AbstractDelegatingBuilder<S>
            implements FieldValueTarget<S> {
                private static final int NUMERIC_BOOLEAN_TRUE = 1;
                private static final int NUMERIC_BOOLEAN_FALSE = 0;
                private final FieldToken fieldToken;
                private final FieldAttributeAppender.Factory attributeAppenderFactory;
                private final Object defaultValue;

                private DefaultFieldValueTarget(FieldToken fieldToken, FieldAttributeAppender.Factory attributeAppenderFactory) {
                    this(fieldToken, attributeAppenderFactory, (Object)null);
                }

                private DefaultFieldValueTarget(FieldToken fieldToken, FieldAttributeAppender.Factory attributeAppenderFactory, Object defaultValue) {
                    this.fieldToken = fieldToken;
                    this.attributeAppenderFactory = attributeAppenderFactory;
                    this.defaultValue = defaultValue;
                }

                @Override
                protected Builder<S> materialize() {
                    return AbstractBase.this.materialize(AbstractBase.this.classFileVersion, AbstractBase.this.namingStrategy, AbstractBase.this.auxiliaryTypeNamingStrategy, AbstractBase.this.targetType, AbstractBase.this.interfaceTypes, AbstractBase.this.modifiers, AbstractBase.this.attributeAppender, AbstractBase.this.ignoredMethods, AbstractBase.this.bridgeMethodResolverFactory, AbstractBase.this.classVisitorWrapperChain, AbstractBase.this.fieldRegistry.include(this.fieldToken, this.attributeAppenderFactory, this.defaultValue), AbstractBase.this.methodRegistry, AbstractBase.this.methodLookupEngineFactory, AbstractBase.this.defaultFieldAttributeAppenderFactory, AbstractBase.this.defaultMethodAttributeAppenderFactory, ByteBuddyCommons.join(AbstractBase.this.fieldTokens, this.fieldToken), AbstractBase.this.methodTokens);
                }

                @Override
                public FieldAnnotationTarget<S> value(boolean value) {
                    return this.value(value ? 1 : 0);
                }

                @Override
                public FieldAnnotationTarget<S> value(int value) {
                    return this.makeFieldAnnotationTarget(FieldValueTarget.NumericRangeValidator.of(this.fieldToken.getFieldType()).validate(value));
                }

                @Override
                public FieldAnnotationTarget<S> value(long value) {
                    return this.makeFieldAnnotationTarget(this.isValid(value, Long.TYPE));
                }

                @Override
                public FieldAnnotationTarget<S> value(float value) {
                    return this.makeFieldAnnotationTarget(this.isValid(Float.valueOf(value), Float.TYPE));
                }

                @Override
                public FieldAnnotationTarget<S> value(double value) {
                    return this.makeFieldAnnotationTarget(this.isValid(value, Double.TYPE));
                }

                @Override
                public FieldAnnotationTarget<S> value(String value) {
                    return this.makeFieldAnnotationTarget(this.isValid(value, String.class));
                }

                private Object isValid(Object defaultValue, Class<?> legalType) {
                    if (this.fieldToken.getFieldType().represents(legalType)) {
                        return defaultValue;
                    }
                    throw new IllegalStateException(String.format("The given value %s was not of the required type %s", defaultValue, legalType));
                }

                private FieldAnnotationTarget<S> makeFieldAnnotationTarget(Object defaultValue) {
                    if ((this.fieldToken.getModifiers() & 8) == 0) {
                        throw new IllegalStateException("Default field values can only be set for static fields");
                    }
                    return new DefaultFieldValueTarget(this.fieldToken, this.attributeAppenderFactory, defaultValue);
                }

                @Override
                public FieldAnnotationTarget<S> attribute(FieldAttributeAppender.Factory attributeAppenderFactory) {
                    return new DefaultFieldValueTarget(this.fieldToken, new FieldAttributeAppender.Factory.Compound(this.attributeAppenderFactory, ByteBuddyCommons.nonNull(attributeAppenderFactory)));
                }

                @Override
                public FieldAnnotationTarget<S> annotateField(Annotation ... annotation) {
                    return this.annotateField(new AnnotationList.ForLoadedAnnotation(ByteBuddyCommons.nonNull(annotation)));
                }

                @Override
                public FieldAnnotationTarget<S> annotateField(Iterable<? extends Annotation> annotations) {
                    return this.annotateField(new AnnotationList.ForLoadedAnnotation(ByteBuddyCommons.toList(annotations)));
                }

                @Override
                public FieldAnnotationTarget<S> annotateField(AnnotationDescription ... annotation) {
                    return this.annotateField((Collection<? extends AnnotationDescription>)Arrays.asList(ByteBuddyCommons.nonNull(annotation)));
                }

                @Override
                public FieldAnnotationTarget<S> annotateField(Collection<? extends AnnotationDescription> annotations) {
                    return this.attribute(new FieldAttributeAppender.ForAnnotation(new ArrayList<AnnotationDescription>(ByteBuddyCommons.nonNull(annotations))));
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean equals(Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (other == null) return false;
                    if (this.getClass() != other.getClass()) {
                        return false;
                    }
                    DefaultFieldValueTarget that = (DefaultFieldValueTarget)other;
                    if (!this.attributeAppenderFactory.equals(that.attributeAppenderFactory)) return false;
                    if (this.defaultValue != null) {
                        if (!this.defaultValue.equals(that.defaultValue)) {
                            return false;
                        }
                    } else if (that.defaultValue != null) return false;
                    if (!this.fieldToken.equals(that.fieldToken)) return false;
                    if (!AbstractBase.this.equals(that.getDynamicTypeBuilder())) return false;
                    return true;
                }

                public int hashCode() {
                    int result = this.fieldToken.hashCode();
                    result = 31 * result + this.attributeAppenderFactory.hashCode();
                    result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
                    result = 31 * result + AbstractBase.this.hashCode();
                    return result;
                }

                public String toString() {
                    return "DynamicType.Builder.AbstractBase.DefaultFieldValueTarget{base=" + AbstractBase.this + ", fieldToken=" + this.fieldToken + ", attributeAppenderFactory=" + this.attributeAppenderFactory + ", defaultValue=" + this.defaultValue + '}';
                }

                private Builder<?> getDynamicTypeBuilder() {
                    return AbstractBase.this;
                }
            }

            protected abstract class AbstractDelegatingBuilder<U>
            implements Builder<U> {
                protected AbstractDelegatingBuilder() {
                }

                @Override
                public Builder<U> classFileVersion(ClassFileVersion classFileVersion) {
                    return this.materialize().classFileVersion(classFileVersion);
                }

                @Override
                public OptionalMatchedMethodInterception<U> implement(Class<?> ... interfaceType) {
                    return this.materialize().implement(interfaceType);
                }

                @Override
                public OptionalMatchedMethodInterception<U> implement(Iterable<? extends Class<?>> interfaceTypes) {
                    return this.materialize().implement(interfaceTypes);
                }

                @Override
                public OptionalMatchedMethodInterception<U> implement(TypeDescription ... interfaceType) {
                    return this.materialize().implement(interfaceType);
                }

                @Override
                public OptionalMatchedMethodInterception<U> implement(Collection<? extends TypeDescription> typeDescriptions) {
                    return this.materialize().implement(typeDescriptions);
                }

                @Override
                public Builder<U> name(String name) {
                    return this.materialize().name(name);
                }

                @Override
                public Builder<U> name(NamingStrategy namingStrategy) {
                    return this.materialize().name(namingStrategy);
                }

                @Override
                public Builder<U> name(AuxiliaryType.NamingStrategy namingStrategy) {
                    return this.materialize().name(namingStrategy);
                }

                @Override
                public Builder<U> modifiers(ModifierContributor.ForType ... modifier) {
                    return this.materialize().modifiers(modifier);
                }

                @Override
                public Builder<U> modifiers(int modifiers) {
                    return this.materialize().modifiers(modifiers);
                }

                @Override
                public Builder<U> ignoreMethods(ElementMatcher<? super MethodDescription> ignoredMethods) {
                    return this.materialize().ignoreMethods(ignoredMethods);
                }

                @Override
                public Builder<U> attribute(TypeAttributeAppender attributeAppender) {
                    return this.materialize().attribute(attributeAppender);
                }

                @Override
                public Builder<U> annotateType(Annotation ... annotation) {
                    return this.materialize().annotateType(annotation);
                }

                @Override
                public Builder<U> annotateType(Iterable<? extends Annotation> annotations) {
                    return this.materialize().annotateType(annotations);
                }

                @Override
                public Builder<U> annotateType(AnnotationDescription ... annotation) {
                    return this.materialize().annotateType(annotation);
                }

                @Override
                public Builder<U> annotateType(Collection<? extends AnnotationDescription> annotations) {
                    return this.materialize().annotateType(annotations);
                }

                @Override
                public Builder<U> classVisitor(ClassVisitorWrapper classVisitorWrapper) {
                    return this.materialize().classVisitor(classVisitorWrapper);
                }

                @Override
                public Builder<U> methodLookupEngine(MethodLookupEngine.Factory methodLookupEngineFactory) {
                    return this.materialize().methodLookupEngine(methodLookupEngineFactory);
                }

                @Override
                public Builder<U> bridgeMethodResolverFactory(BridgeMethodResolver.Factory bridgeMethodResolverFactory) {
                    return this.materialize().bridgeMethodResolverFactory(bridgeMethodResolverFactory);
                }

                @Override
                public FieldValueTarget<U> defineField(String name, Class<?> fieldType, ModifierContributor.ForField ... modifier) {
                    return this.materialize().defineField(name, fieldType, modifier);
                }

                @Override
                public FieldValueTarget<U> defineField(String name, TypeDescription fieldTypeDescription, ModifierContributor.ForField ... modifier) {
                    return this.materialize().defineField(name, fieldTypeDescription, modifier);
                }

                @Override
                public FieldValueTarget<U> defineField(String name, Class<?> fieldType, int modifiers) {
                    return this.materialize().defineField(name, fieldType, modifiers);
                }

                @Override
                public FieldValueTarget<U> defineField(String name, TypeDescription fieldTypeDescription, int modifiers) {
                    return this.materialize().defineField(name, fieldTypeDescription, modifiers);
                }

                @Override
                public FieldValueTarget<U> defineField(Field field) {
                    return this.materialize().defineField(field);
                }

                @Override
                public FieldValueTarget<U> defineField(FieldDescription fieldDescription) {
                    return this.materialize().defineField(fieldDescription);
                }

                @Override
                public ExceptionDeclarableMethodInterception<U> defineMethod(String name, Class<?> returnType, List<? extends Class<?>> parameterTypes, ModifierContributor.ForMethod ... modifier) {
                    return this.materialize().defineMethod(name, returnType, parameterTypes, modifier);
                }

                @Override
                public ExceptionDeclarableMethodInterception<U> defineMethod(String name, TypeDescription returnType, List<? extends TypeDescription> parameterTypes, ModifierContributor.ForMethod ... modifier) {
                    return this.materialize().defineMethod(name, returnType, parameterTypes, modifier);
                }

                @Override
                public ExceptionDeclarableMethodInterception<U> defineMethod(String name, Class<?> returnType, List<? extends Class<?>> parameterTypes, int modifiers) {
                    return this.materialize().defineMethod(name, returnType, parameterTypes, modifiers);
                }

                @Override
                public ExceptionDeclarableMethodInterception<U> defineMethod(String name, TypeDescription returnType, List<? extends TypeDescription> parameterTypes, int modifiers) {
                    return this.materialize().defineMethod(name, returnType, parameterTypes, modifiers);
                }

                @Override
                public ExceptionDeclarableMethodInterception<U> defineMethod(Method method) {
                    return this.materialize().defineMethod(method);
                }

                @Override
                public ExceptionDeclarableMethodInterception<U> defineMethod(MethodDescription methodDescription) {
                    return this.materialize().defineMethod(methodDescription);
                }

                @Override
                public ExceptionDeclarableMethodInterception<U> defineConstructor(Iterable<? extends Class<?>> parameterTypes, ModifierContributor.ForMethod ... modifier) {
                    return this.materialize().defineConstructor(parameterTypes, modifier);
                }

                @Override
                public ExceptionDeclarableMethodInterception<U> defineConstructor(List<? extends TypeDescription> parameterTypes, ModifierContributor.ForMethod ... modifier) {
                    return this.materialize().defineConstructor(parameterTypes, modifier);
                }

                @Override
                public ExceptionDeclarableMethodInterception<U> defineConstructor(Iterable<? extends Class<?>> parameterTypes, int modifiers) {
                    return this.materialize().defineConstructor(parameterTypes, modifiers);
                }

                @Override
                public ExceptionDeclarableMethodInterception<U> defineConstructor(List<? extends TypeDescription> parameterTypes, int modifiers) {
                    return this.materialize().defineConstructor(parameterTypes, modifiers);
                }

                @Override
                public ExceptionDeclarableMethodInterception<U> defineConstructor(Constructor<?> constructor) {
                    return this.materialize().defineConstructor(constructor);
                }

                @Override
                public ExceptionDeclarableMethodInterception<U> defineConstructor(MethodDescription methodDescription) {
                    return this.materialize().defineConstructor(methodDescription);
                }

                @Override
                public ExceptionDeclarableMethodInterception<U> define(MethodDescription methodDescription) {
                    return this.materialize().define(methodDescription);
                }

                @Override
                public MatchedMethodInterception<U> method(ElementMatcher<? super MethodDescription> methodMatcher) {
                    return this.materialize().method(methodMatcher);
                }

                @Override
                public MatchedMethodInterception<U> constructor(ElementMatcher<? super MethodDescription> methodMatcher) {
                    return this.materialize().constructor(methodMatcher);
                }

                @Override
                public MatchedMethodInterception<U> invokable(ElementMatcher<? super MethodDescription> methodMatcher) {
                    return this.materialize().invokable(methodMatcher);
                }

                @Override
                public MatchedMethodInterception<U> invokable(LatentMethodMatcher methodMatcher) {
                    return this.materialize().invokable(methodMatcher);
                }

                @Override
                public Unloaded<U> make() {
                    return this.materialize().make();
                }

                protected abstract Builder<U> materialize();
            }

            protected static class FieldToken
            implements FieldRegistry.LatentFieldMatcher {
                protected final String name;
                protected final TypeDescription fieldType;
                protected final int modifiers;

                public FieldToken(String name, TypeDescription fieldType, int modifiers) {
                    this.name = name;
                    this.fieldType = fieldType;
                    this.modifiers = modifiers;
                }

                protected TypeDescription resolveFieldType(TypeDescription instrumentedType) {
                    return TargetType.resolve(this.fieldType, instrumentedType);
                }

                public String getName() {
                    return this.name;
                }

                public TypeDescription getFieldType() {
                    return this.fieldType;
                }

                public int getModifiers() {
                    return this.modifiers;
                }

                @Override
                public String getFieldName() {
                    return this.name;
                }

                public boolean equals(Object other) {
                    return (this == other || other instanceof FieldToken) && this.name.equals(((FieldToken)other).getFieldName());
                }

                public int hashCode() {
                    return this.name.hashCode();
                }

                public String toString() {
                    return "DynamicType.Builder.AbstractBase.FieldToken{name='" + this.name + '\'' + ", fieldType=" + this.fieldType + ", modifiers=" + this.modifiers + '}';
                }
            }

            protected static class MethodToken
            implements LatentMethodMatcher {
                protected final String internalName;
                protected final TypeDescription returnType;
                protected final List<TypeDescription> parameterTypes;
                protected final List<TypeDescription> exceptionTypes;
                protected final int modifiers;

                public MethodToken(List<? extends TypeDescription> parameterTypes, List<? extends TypeDescription> exceptionTypes, int modifiers) {
                    this("<init>", TypeDescription.VOID, parameterTypes, exceptionTypes, modifiers);
                }

                public MethodToken(String internalName, TypeDescription returnType, List<? extends TypeDescription> parameterTypes, List<? extends TypeDescription> exceptionTypes, int modifiers) {
                    this.internalName = internalName;
                    this.returnType = returnType;
                    this.parameterTypes = Collections.unmodifiableList(new ArrayList<TypeDescription>(parameterTypes));
                    this.exceptionTypes = Collections.unmodifiableList(new ArrayList<TypeDescription>(exceptionTypes));
                    this.modifiers = modifiers;
                }

                @Override
                public ElementMatcher<? super MethodDescription> resolve(TypeDescription instrumentedType) {
                    return ("<init>".equals(this.internalName) ? ElementMatchers.isConstructor() : ElementMatchers.named(this.internalName)).and(ElementMatchers.returns(this.resolveReturnType(instrumentedType))).and(ElementMatchers.takesArguments(this.resolveParameterTypes(instrumentedType)));
                }

                protected TypeDescription resolveReturnType(TypeDescription instrumentedType) {
                    return TargetType.resolve(this.returnType, instrumentedType);
                }

                protected List<TypeDescription> resolveParameterTypes(TypeDescription instrumentedType) {
                    return TargetType.resolve(this.parameterTypes, instrumentedType);
                }

                protected List<TypeDescription> resolveExceptionTypes(TypeDescription instrumentedType) {
                    ArrayList<TypeDescription> exceptionTypes = new ArrayList<TypeDescription>(this.exceptionTypes.size());
                    for (TypeDescription exceptionType : this.exceptionTypes) {
                        exceptionTypes.add(TargetType.resolve(exceptionType, instrumentedType));
                    }
                    return exceptionTypes;
                }

                public String getInternalName() {
                    return this.internalName;
                }

                public TypeDescription getReturnType() {
                    return this.returnType;
                }

                public List<TypeDescription> getParameterTypes() {
                    return this.parameterTypes;
                }

                public List<TypeDescription> getExceptionTypes() {
                    return this.exceptionTypes;
                }

                public int getModifiers() {
                    return this.modifiers;
                }

                public boolean equals(Object other) {
                    return (this == other || other instanceof MethodToken) && this.internalName.equals(((MethodToken)other).getInternalName()) && this.parameterTypes.equals(((MethodToken)other).getParameterTypes()) && this.returnType.equals(((MethodToken)other).getReturnType());
                }

                public int hashCode() {
                    int result = this.internalName.hashCode();
                    result = 31 * result + this.returnType.hashCode();
                    result = 31 * result + this.parameterTypes.hashCode();
                    return result;
                }

                public String toString() {
                    return "DynamicType.Builder.AbstractBase.MethodToken{internalName='" + this.internalName + '\'' + ", returnType=" + this.returnType + ", parameterTypes=" + this.parameterTypes + ", exceptionTypes=" + this.exceptionTypes + ", modifiers=" + this.modifiers + '}';
                }
            }
        }

        public static interface FieldAnnotationTarget<S>
        extends Builder<S> {
            public FieldAnnotationTarget<S> attribute(FieldAttributeAppender.Factory var1);

            public FieldAnnotationTarget<S> annotateField(Annotation ... var1);

            public FieldAnnotationTarget<S> annotateField(Iterable<? extends Annotation> var1);

            public FieldAnnotationTarget<S> annotateField(AnnotationDescription ... var1);

            public FieldAnnotationTarget<S> annotateField(Collection<? extends AnnotationDescription> var1);
        }

        public static interface FieldValueTarget<S>
        extends FieldAnnotationTarget<S> {
            public FieldAnnotationTarget<S> value(boolean var1);

            public FieldAnnotationTarget<S> value(int var1);

            public FieldAnnotationTarget<S> value(long var1);

            public FieldAnnotationTarget<S> value(float var1);

            public FieldAnnotationTarget<S> value(double var1);

            public FieldAnnotationTarget<S> value(String var1);

            public static enum NumericRangeValidator {
                BOOLEAN(0, 1),
                BYTE(-128, 127),
                SHORT(Short.MIN_VALUE, Short.MAX_VALUE),
                CHARACTER(0, 65535),
                INTEGER(Integer.MIN_VALUE, Integer.MAX_VALUE),
                LONG(Integer.MIN_VALUE, Integer.MAX_VALUE){

                    @Override
                    public Object validate(int value) {
                        return (long)value;
                    }
                };

                private final int minimum;
                private final int maximum;

                private NumericRangeValidator(int minimum, int maximum) {
                    this.minimum = minimum;
                    this.maximum = maximum;
                }

                public static NumericRangeValidator of(TypeDescription typeDescription) {
                    if (typeDescription.represents(Boolean.TYPE)) {
                        return BOOLEAN;
                    }
                    if (typeDescription.represents(Byte.TYPE)) {
                        return BYTE;
                    }
                    if (typeDescription.represents(Short.TYPE)) {
                        return SHORT;
                    }
                    if (typeDescription.represents(Character.TYPE)) {
                        return CHARACTER;
                    }
                    if (typeDescription.represents(Integer.TYPE)) {
                        return INTEGER;
                    }
                    if (typeDescription.represents(Long.TYPE)) {
                        return LONG;
                    }
                    throw new IllegalStateException(String.format("A field of type %s does not permit an integer-typed default value", typeDescription));
                }

                public Object validate(int value) {
                    if (value < this.minimum || value > this.maximum) {
                        throw new IllegalArgumentException(String.format("The value %d overflows for %s", new Object[]{value, this}));
                    }
                    return value;
                }

                public String toString() {
                    return "DynamicType.Builder.FieldValueTarget.NumericRangeValidator." + this.name();
                }
            }
        }

        public static interface MethodAnnotationTarget<S>
        extends Builder<S> {
            public MethodAnnotationTarget<S> attribute(MethodAttributeAppender.Factory var1);

            public MethodAnnotationTarget<S> annotateMethod(Annotation ... var1);

            public MethodAnnotationTarget<S> annotateMethod(Iterable<? extends Annotation> var1);

            public MethodAnnotationTarget<S> annotateMethod(AnnotationDescription ... var1);

            public MethodAnnotationTarget<S> annotateMethod(Collection<? extends AnnotationDescription> var1);

            public MethodAnnotationTarget<S> annotateParameter(int var1, Annotation ... var2);

            public MethodAnnotationTarget<S> annotateParameter(int var1, Iterable<? extends Annotation> var2);

            public MethodAnnotationTarget<S> annotateParameter(int var1, AnnotationDescription ... var2);

            public MethodAnnotationTarget<S> annotateParameter(int var1, Collection<? extends AnnotationDescription> var2);
        }

        public static interface OptionalMatchedMethodInterception<S>
        extends MatchedMethodInterception<S>,
        Builder<S> {
        }

        public static interface ExceptionDeclarableMethodInterception<S>
        extends MatchedMethodInterception<S> {
            public MatchedMethodInterception<S> throwing(Class<?> ... var1);

            public MatchedMethodInterception<S> throwing(Iterable<? extends Class<?>> var1);

            public MatchedMethodInterception<S> throwing(TypeDescription ... var1);

            public MatchedMethodInterception<S> throwing(Collection<? extends TypeDescription> var1);
        }

        public static interface MatchedMethodInterception<S> {
            public MethodAnnotationTarget<S> intercept(Implementation var1);

            public MethodAnnotationTarget<S> withoutCode();

            public MethodAnnotationTarget<S> withDefaultValue(Object var1, Class<?> var2);

            public MethodAnnotationTarget<S> withDefaultValue(Object var1);
        }
    }
}

