/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.type;

import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.annotation.AnnotatedCodeElement;
import net.bytebuddy.description.annotation.AnnotationList;

public interface PackageDescription
extends NamedElement,
AnnotatedCodeElement {
    public boolean isSealed();

    public static class ForLoadedPackage
    extends AbstractPackageDescription {
        private final Package aPackage;

        protected ForLoadedPackage(Package aPackage) {
            this.aPackage = aPackage;
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.ForLoadedAnnotation(this.aPackage.getDeclaredAnnotations());
        }

        @Override
        public String getName() {
            return this.aPackage.getName();
        }

        @Override
        public boolean isSealed() {
            return this.aPackage.isSealed();
        }
    }

    public static class Simple
    extends AbstractPackageDescription {
        private final String name;

        public Simple(String name) {
            this.name = name;
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.Empty();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isSealed() {
            return false;
        }
    }

    public static abstract class AbstractPackageDescription
    implements PackageDescription {
        @Override
        public String getInternalName() {
            return this.getName().replace('.', '/');
        }

        @Override
        public String getSourceCodeName() {
            return this.getName();
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof PackageDescription && this.getName().equals(((PackageDescription)other).getName());
        }

        public String toString() {
            return "package " + this.getName();
        }
    }
}

