/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.method;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.bytebuddy.description.ByteCodeElement;
import net.bytebuddy.description.ModifierReviewable;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.annotation.AnnotationList;
import net.bytebuddy.description.enumeration.EnumerationDescription;
import net.bytebuddy.description.method.ParameterList;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.utility.JavaInstance;
import net.bytebuddy.utility.JavaType;

public interface MethodDescription
extends ByteCodeElement {
    public static final String CONSTRUCTOR_INTERNAL_NAME = "<init>";
    public static final String TYPE_INITIALIZER_INTERNAL_NAME = "<clinit>";
    public static final int TYPE_INITIALIZER_MODIFIER = 4106;

    public TypeDescription getReturnType();

    public ParameterList getParameters();

    public TypeList getExceptionTypes();

    public int getAdjustedModifiers(boolean var1);

    public boolean isConstructor();

    public boolean isMethod();

    public boolean isTypeInitializer();

    public boolean represents(Method var1);

    public boolean represents(Constructor<?> var1);

    public boolean isOverridable();

    public int getStackSize();

    public boolean isDefaultMethod();

    public boolean isSpecializableFor(TypeDescription var1);

    public String getUniqueSignature();

    public Object getDefaultValue();

    public <T> T getDefaultValue(Class<T> var1);

    public boolean isInvokableOn(TypeDescription var1);

    public boolean isBootstrap();

    public boolean isBootstrap(List<?> var1);

    public boolean isDefaultValue();

    public boolean isDefaultValue(Object var1);

    public static class Latent
    extends AbstractMethodDescription {
        private final String internalName;
        private final TypeDescription declaringType;
        private final TypeDescription returnType;
        private final List<? extends TypeDescription> parameterTypes;
        private final int modifiers;
        private final List<? extends TypeDescription> exceptionTypes;

        public Latent(String internalName, TypeDescription declaringType, TypeDescription returnType, List<? extends TypeDescription> parameterTypes, int modifiers, List<? extends TypeDescription> exceptionTypes) {
            this.internalName = internalName;
            this.declaringType = declaringType;
            this.returnType = returnType;
            this.parameterTypes = parameterTypes;
            this.modifiers = modifiers;
            this.exceptionTypes = exceptionTypes;
        }

        public static MethodDescription typeInitializerOf(TypeDescription declaringType) {
            return new Latent(MethodDescription.TYPE_INITIALIZER_INTERNAL_NAME, declaringType, TypeDescription.VOID, new TypeList.Empty(), 4106, Collections.emptyList());
        }

        @Override
        public TypeDescription getReturnType() {
            return this.returnType;
        }

        @Override
        public ParameterList getParameters() {
            return ParameterList.Explicit.latent(this, this.parameterTypes);
        }

        @Override
        public TypeList getExceptionTypes() {
            return new TypeList.Explicit(this.exceptionTypes);
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.Empty();
        }

        @Override
        public String getInternalName() {
            return this.internalName;
        }

        @Override
        public TypeDescription getDeclaringType() {
            return this.declaringType;
        }

        @Override
        public int getModifiers() {
            return this.modifiers;
        }

        @Override
        public Object getDefaultValue() {
            return null;
        }
    }

    public static class ForLoadedMethod
    extends AbstractMethodDescription {
        private final Method method;

        public ForLoadedMethod(Method method) {
            this.method = method;
        }

        @Override
        public TypeDescription getDeclaringType() {
            return new TypeDescription.ForLoadedType(this.method.getDeclaringClass());
        }

        @Override
        public TypeDescription getReturnType() {
            return new TypeDescription.ForLoadedType(this.method.getReturnType());
        }

        @Override
        public ParameterList getParameters() {
            return ParameterList.ForLoadedExecutable.of(this.method);
        }

        @Override
        public TypeList getExceptionTypes() {
            return new TypeList.ForLoadedType(this.method.getExceptionTypes());
        }

        @Override
        public boolean isConstructor() {
            return false;
        }

        @Override
        public boolean isTypeInitializer() {
            return false;
        }

        @Override
        public boolean isBridge() {
            return this.method.isBridge();
        }

        @Override
        public boolean represents(Method method) {
            return this.method.equals(method) || this.equals(new ForLoadedMethod(method));
        }

        @Override
        public boolean represents(Constructor<?> constructor) {
            return false;
        }

        @Override
        public String getName() {
            return this.method.getName();
        }

        @Override
        public int getModifiers() {
            return this.method.getModifiers();
        }

        @Override
        public boolean isSynthetic() {
            return this.method.isSynthetic();
        }

        @Override
        public String getInternalName() {
            return this.method.getName();
        }

        @Override
        public String getDescriptor() {
            return Type.getMethodDescriptor(this.method);
        }

        public Method getLoadedMethod() {
            return this.method;
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.ForLoadedAnnotation(this.method.getDeclaredAnnotations());
        }

        @Override
        public Object getDefaultValue() {
            Object value = this.method.getDefaultValue();
            return value == null ? null : AnnotationDescription.ForLoadedAnnotation.describe(value, new TypeDescription.ForLoadedType(this.method.getReturnType()));
        }
    }

    public static class ForLoadedConstructor
    extends AbstractMethodDescription {
        private final Constructor<?> constructor;

        public ForLoadedConstructor(Constructor<?> constructor) {
            this.constructor = constructor;
        }

        @Override
        public TypeDescription getDeclaringType() {
            return new TypeDescription.ForLoadedType(this.constructor.getDeclaringClass());
        }

        @Override
        public TypeDescription getReturnType() {
            return TypeDescription.VOID;
        }

        @Override
        public ParameterList getParameters() {
            return ParameterList.ForLoadedExecutable.of(this.constructor);
        }

        @Override
        public TypeList getExceptionTypes() {
            return new TypeList.ForLoadedType(this.constructor.getExceptionTypes());
        }

        @Override
        public boolean isConstructor() {
            return true;
        }

        @Override
        public boolean isTypeInitializer() {
            return false;
        }

        @Override
        public boolean represents(Method method) {
            return false;
        }

        @Override
        public boolean represents(Constructor<?> constructor) {
            return this.constructor.equals(constructor) || this.equals(new ForLoadedConstructor(constructor));
        }

        @Override
        public String getName() {
            return this.constructor.getName();
        }

        @Override
        public int getModifiers() {
            return this.constructor.getModifiers();
        }

        @Override
        public boolean isSynthetic() {
            return this.constructor.isSynthetic();
        }

        @Override
        public String getInternalName() {
            return MethodDescription.CONSTRUCTOR_INTERNAL_NAME;
        }

        @Override
        public String getDescriptor() {
            return Type.getConstructorDescriptor(this.constructor);
        }

        @Override
        public Object getDefaultValue() {
            return null;
        }

        @Override
        public AnnotationList getDeclaredAnnotations() {
            return new AnnotationList.ForLoadedAnnotation(this.constructor.getDeclaredAnnotations());
        }
    }

    public static abstract class AbstractMethodDescription
    extends ModifierReviewable.AbstractModifierReviewable
    implements MethodDescription {
        private static final int SOURCE_MODIFIERS = 1343;

        @Override
        public String getUniqueSignature() {
            return this.getInternalName() + this.getDescriptor();
        }

        @Override
        public int getStackSize() {
            return this.getParameters().asTypeList().getStackSize() + (this.isStatic() ? 0 : 1);
        }

        @Override
        public boolean isMethod() {
            return !this.isConstructor() && !this.isTypeInitializer();
        }

        @Override
        public boolean isConstructor() {
            return MethodDescription.CONSTRUCTOR_INTERNAL_NAME.equals(this.getInternalName());
        }

        @Override
        public boolean isTypeInitializer() {
            return MethodDescription.TYPE_INITIALIZER_INTERNAL_NAME.equals(this.getInternalName());
        }

        @Override
        public boolean represents(Method method) {
            return this.equals(new ForLoadedMethod(method));
        }

        @Override
        public boolean represents(Constructor<?> constructor) {
            return this.equals(new ForLoadedConstructor(constructor));
        }

        @Override
        public String getName() {
            return this.isMethod() ? this.getInternalName() : this.getDeclaringType().getName();
        }

        @Override
        public String getSourceCodeName() {
            return this.isMethod() ? this.getName() : "";
        }

        @Override
        public String getDescriptor() {
            StringBuilder descriptor = new StringBuilder("(");
            for (TypeDescription parameterType : this.getParameters().asTypeList()) {
                descriptor.append(parameterType.getDescriptor());
            }
            return descriptor.append(")").append(this.getReturnType().getDescriptor()).toString();
        }

        @Override
        public String getGenericSignature() {
            return null;
        }

        @Override
        public int getAdjustedModifiers(boolean nonAbstract) {
            return nonAbstract ? this.getModifiers() & 0xFFFFFAFF : this.getModifiers() & 0xFFFFFEFF | 0x400;
        }

        @Override
        public boolean isVisibleTo(TypeDescription typeDescription) {
            return this.getDeclaringType().isVisibleTo(typeDescription) && (this.isPublic() || typeDescription.equals(this.getDeclaringType()) || this.isProtected() && this.getDeclaringType().isAssignableFrom(typeDescription) || !this.isPrivate() && typeDescription.isSamePackage(this.getDeclaringType()));
        }

        @Override
        public boolean isOverridable() {
            return !this.isConstructor() && !this.isFinal() && !this.isPrivate() && !this.isStatic();
        }

        @Override
        public boolean isDefaultMethod() {
            return !this.isAbstract() && !this.isBridge() && this.getDeclaringType().isInterface();
        }

        @Override
        public boolean isSpecializableFor(TypeDescription targetType) {
            if (this.isStatic()) {
                return false;
            }
            if (this.isPrivate() || this.isConstructor()) {
                return this.getDeclaringType().equals(targetType);
            }
            return !this.isAbstract() && this.getDeclaringType().isAssignableFrom(targetType);
        }

        @Override
        public <T> T getDefaultValue(Class<T> type) {
            return type.cast(this.getDefaultValue());
        }

        @Override
        public boolean isInvokableOn(TypeDescription typeDescription) {
            return !this.isStatic() && !this.isTypeInitializer() && this.isVisibleTo(typeDescription) && this.getDeclaringType().isAssignableFrom(typeDescription);
        }

        @Override
        public boolean isBootstrap() {
            if (this.isMethod() && (!this.isStatic() || !JavaType.CALL_SITE.getTypeStub().isAssignableFrom(this.getReturnType()) && !JavaType.CALL_SITE.getTypeStub().isAssignableTo(this.getReturnType())) || this.isConstructor() && !JavaType.CALL_SITE.getTypeStub().isAssignableFrom(this.getDeclaringType())) {
                return false;
            }
            TypeList parameterTypes = this.getParameters().asTypeList();
            switch (parameterTypes.size()) {
                case 0: {
                    return false;
                }
                case 1: {
                    return ((TypeDescription)parameterTypes.getOnly()).represents(Object[].class);
                }
                case 2: {
                    return JavaType.METHOD_HANDLES_LOOKUP.getTypeStub().isAssignableTo((TypeDescription)parameterTypes.get(0)) && ((TypeDescription)parameterTypes.get(1)).represents(Object[].class);
                }
                case 3: {
                    return !(!JavaType.METHOD_HANDLES_LOOKUP.getTypeStub().isAssignableTo((TypeDescription)parameterTypes.get(0)) || !((TypeDescription)parameterTypes.get(1)).represents(Object.class) && !((TypeDescription)parameterTypes.get(1)).represents(String.class) || !((TypeDescription)parameterTypes.get(2)).represents(Object[].class) && !JavaType.METHOD_TYPE.getTypeStub().isAssignableTo((TypeDescription)parameterTypes.get(2)));
                }
            }
            if (!JavaType.METHOD_HANDLES_LOOKUP.getTypeStub().isAssignableTo((TypeDescription)parameterTypes.get(0)) || !((TypeDescription)parameterTypes.get(1)).represents(Object.class) && !((TypeDescription)parameterTypes.get(1)).represents(String.class) || !JavaType.METHOD_TYPE.getTypeStub().isAssignableTo((TypeDescription)parameterTypes.get(2))) {
                return false;
            }
            int parameterIndex = 4;
            for (TypeDescription parameterType : (TypeList)parameterTypes.subList(3, parameterTypes.size())) {
                if (!parameterType.represents(Object.class) && !parameterType.isConstantPool()) {
                    return parameterType.represents(Object[].class) && parameterIndex == parameterTypes.size();
                }
                ++parameterIndex;
            }
            return true;
        }

        @Override
        public boolean isBootstrap(List<?> arguments) {
            if (!this.isBootstrap()) {
                return false;
            }
            for (Object argument : arguments) {
                Class<?> argumentType = argument.getClass();
                if (argumentType == String.class || argumentType == Integer.class || argumentType == Long.class || argumentType == Float.class || argumentType == Double.class || TypeDescription.class.isAssignableFrom(argumentType) || JavaInstance.MethodHandle.class.isAssignableFrom(argumentType) || JavaInstance.MethodType.class.isAssignableFrom(argumentType)) continue;
                throw new IllegalArgumentException("Not a bootstrap argument: " + argument);
            }
            TypeList parameterTypes = this.getParameters().asTypeList();
            if (parameterTypes.size() < 4) {
                return arguments.size() == 0 || ((TypeDescription)parameterTypes.get(parameterTypes.size() - 1)).represents(Object[].class);
            }
            int index = 4;
            Iterator<?> argumentIterator = arguments.iterator();
            for (TypeDescription parameterType : parameterTypes.subList(3, parameterTypes.size())) {
                boolean finalParameterCheck;
                boolean bl = finalParameterCheck = !argumentIterator.hasNext();
                if (!finalParameterCheck) {
                    Class<?> argumentType = argumentIterator.next().getClass();
                    boolean bl2 = finalParameterCheck = !(parameterType.represents(String.class) && argumentType == String.class || parameterType.represents(Integer.TYPE) && argumentType == Integer.class || parameterType.represents(Long.TYPE) && argumentType == Long.class || parameterType.represents(Float.TYPE) && argumentType == Float.class || parameterType.represents(Double.TYPE) && argumentType == Double.class || parameterType.represents(Class.class) && TypeDescription.class.isAssignableFrom(argumentType) || parameterType.isAssignableFrom(JavaType.METHOD_HANDLE.getTypeStub()) && JavaInstance.MethodHandle.class.isAssignableFrom(argumentType) || parameterType.equals(JavaType.METHOD_TYPE.getTypeStub()) && JavaInstance.MethodType.class.isAssignableFrom(argumentType));
                }
                if (finalParameterCheck) {
                    return index == parameterTypes.size() && parameterType.represents(Object[].class);
                }
                ++index;
            }
            return true;
        }

        @Override
        public boolean isDefaultValue() {
            return !this.isConstructor() && !this.isStatic() && this.getReturnType().isAnnotationReturnType() && this.getParameters().isEmpty();
        }

        @Override
        public boolean isDefaultValue(Object value) {
            if (!this.isDefaultValue()) {
                return false;
            }
            TypeDescription returnType = this.getReturnType();
            return returnType.represents(Boolean.TYPE) && value instanceof Boolean || returnType.represents(Boolean.TYPE) && value instanceof Boolean || returnType.represents(Byte.TYPE) && value instanceof Byte || returnType.represents(Character.TYPE) && value instanceof Character || returnType.represents(Short.TYPE) && value instanceof Short || returnType.represents(Integer.TYPE) && value instanceof Integer || returnType.represents(Long.TYPE) && value instanceof Long || returnType.represents(Float.TYPE) && value instanceof Float || returnType.represents(Long.TYPE) && value instanceof Long || returnType.represents(String.class) && value instanceof String || returnType.isAssignableTo(Enum.class) && value instanceof EnumerationDescription || returnType.isAssignableTo(Annotation.class) && value instanceof AnnotationDescription || returnType.represents(Class.class) && value instanceof TypeDescription;
        }

        public boolean equals(Object other) {
            return other == this || other instanceof MethodDescription && this.getInternalName().equals(((MethodDescription)other).getInternalName()) && this.getDeclaringType().equals(((MethodDescription)other).getDeclaringType()) && this.getReturnType().equals(((MethodDescription)other).getReturnType()) && this.getParameters().asTypeList().equals(((MethodDescription)other).getParameters().asTypeList());
        }

        public int hashCode() {
            int hashCode = this.getDeclaringType().hashCode();
            hashCode = 31 * hashCode + this.getInternalName().hashCode();
            hashCode = 31 * hashCode + this.getReturnType().hashCode();
            return 31 * hashCode + this.getParameters().asTypeList().hashCode();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            int modifiers = this.getModifiers() & 0x53F;
            if (modifiers != 0) {
                stringBuilder.append(Modifier.toString(modifiers)).append(" ");
            }
            if (this.isMethod()) {
                stringBuilder.append(this.getReturnType().getSourceCodeName()).append(" ");
                stringBuilder.append(this.getDeclaringType().getSourceCodeName()).append(".");
            }
            stringBuilder.append(this.getName()).append("(");
            boolean first = true;
            for (TypeDescription typeDescription : this.getParameters().asTypeList()) {
                if (!first) {
                    stringBuilder.append(",");
                } else {
                    first = false;
                }
                stringBuilder.append(typeDescription.getSourceCodeName());
            }
            stringBuilder.append(")");
            TypeList exceptionTypes = this.getExceptionTypes();
            if (exceptionTypes.size() > 0) {
                stringBuilder.append(" throws ");
                first = true;
                for (TypeDescription typeDescription : exceptionTypes) {
                    if (!first) {
                        stringBuilder.append(",");
                    } else {
                        first = false;
                    }
                    stringBuilder.append(typeDescription.getName());
                }
            }
            return stringBuilder.toString();
        }
    }
}

