/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.matcher;

import net.bytebuddy.matcher.ElementMatcher;

public class StringMatcher
extends ElementMatcher.Junction.AbstractBase<String> {
    private final String value;
    private final Mode mode;

    public StringMatcher(String value, Mode mode) {
        this.value = value;
        this.mode = mode;
    }

    @Override
    public boolean matches(String target) {
        return this.mode.matches(this.value, target);
    }

    public boolean equals(Object other) {
        return this == other || other != null && this.getClass() == other.getClass() && this.mode == ((StringMatcher)other).mode && this.value.equals(((StringMatcher)other).value);
    }

    public int hashCode() {
        return 31 * this.value.hashCode() + this.mode.hashCode();
    }

    public String toString() {
        return this.mode.getDescription() + '(' + this.value + ')';
    }

    public static enum Mode {
        EQUALS_FULLY("equals"){

            @Override
            protected boolean matches(String expected, String actual) {
                return actual.equals(expected);
            }
        }
        ,
        EQUALS_FULLY_IGNORE_CASE("equalsIgnoreCase"){

            @Override
            protected boolean matches(String expected, String actual) {
                return actual.equalsIgnoreCase(expected);
            }
        }
        ,
        STARTS_WITH("startsWith"){

            @Override
            protected boolean matches(String expected, String actual) {
                return actual.startsWith(expected);
            }
        }
        ,
        STARTS_WITH_IGNORE_CASE("startsWithIgnoreCase"){

            @Override
            protected boolean matches(String expected, String actual) {
                return actual.toLowerCase().startsWith(expected.toLowerCase());
            }
        }
        ,
        ENDS_WITH("endsWith"){

            @Override
            protected boolean matches(String expected, String actual) {
                return actual.endsWith(expected);
            }
        }
        ,
        ENDS_WITH_IGNORE_CASE("endsWithIgnoreCase"){

            @Override
            protected boolean matches(String expected, String actual) {
                return actual.toLowerCase().endsWith(expected.toLowerCase());
            }
        }
        ,
        CONTAINS("contains"){

            @Override
            protected boolean matches(String expected, String actual) {
                return actual.contains(expected);
            }
        }
        ,
        CONTAINS_IGNORE_CASE("containsIgnoreCase"){

            @Override
            protected boolean matches(String expected, String actual) {
                return actual.toLowerCase().contains(expected.toLowerCase());
            }
        }
        ,
        MATCHES("matches"){

            @Override
            protected boolean matches(String expected, String actual) {
                return actual.matches(expected);
            }
        };

        private final String description;

        private Mode(String description) {
            this.description = description;
        }

        protected String getDescription() {
            return this.description;
        }

        protected abstract boolean matches(String var1, String var2);

        public String toString() {
            return "StringMatcher.Mode." + this.name();
        }
    }
}

