/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bytecode.constant;

import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.jar.asm.MethodVisitor;

public enum IntegerConstant implements StackManipulation
{
    MINUS_ONE(2),
    ZERO(3),
    ONE(4),
    TWO(5),
    THREE(6),
    FOUR(7),
    FIVE(8);

    private static final StackManipulation.Size SIZE;
    private final int opcode;

    private IntegerConstant(int opcode) {
        this.opcode = opcode;
    }

    public static StackManipulation forValue(boolean value) {
        return value ? ONE : ZERO;
    }

    public static StackManipulation forValue(int value) {
        switch (value) {
            case -1: {
                return MINUS_ONE;
            }
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
            case 3: {
                return THREE;
            }
            case 4: {
                return FOUR;
            }
            case 5: {
                return FIVE;
            }
        }
        if (value >= -128 && value <= 127) {
            return new SingleBytePush((byte)value);
        }
        if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            return new TwoBytePush((short)value);
        }
        return new ConstantPool(value);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        methodVisitor.visitInsn(this.opcode);
        return SIZE;
    }

    public String toString() {
        return "IntegerConstant." + this.name();
    }

    static {
        SIZE = StackSize.SINGLE.toIncreasingSize();
    }

    protected static class ConstantPool
    implements StackManipulation {
        private final int value;

        protected ConstantPool(int value) {
            this.value = value;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitLdcInsn(this.value);
            return SIZE;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.value == ((ConstantPool)other).value;
        }

        public int hashCode() {
            return this.value;
        }

        public String toString() {
            return "IntegerConstant.ConstantPool{value=" + this.value + '}';
        }
    }

    protected static class TwoBytePush
    implements StackManipulation {
        private final short value;

        protected TwoBytePush(short value) {
            this.value = value;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitIntInsn(17, this.value);
            return SIZE;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.value == ((TwoBytePush)other).value;
        }

        public int hashCode() {
            return this.value;
        }

        public String toString() {
            return "IntegerConstant.TwoBytePush{value=" + this.value + '}';
        }
    }

    protected static class SingleBytePush
    implements StackManipulation {
        private final byte value;

        protected SingleBytePush(byte value) {
            this.value = value;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            methodVisitor.visitIntInsn(16, this.value);
            return SIZE;
        }

        public boolean equals(Object other) {
            return this == other || other != null && this.getClass() == other.getClass() && this.value == ((SingleBytePush)other).value;
        }

        public int hashCode() {
            return this.value;
        }

        public String toString() {
            return "IntegerConstant.SingleBytePush{value=" + this.value + '}';
        }
    }
}

