/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.implementation.bind.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bind.MethodDelegationBinder;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.TargetMethodAnnotationDrivenBinder;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.constant.NullConstant;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.PARAMETER})
public @interface This {
    public boolean optional() default false;

    public static enum Binder implements TargetMethodAnnotationDrivenBinder.ParameterBinder<This>
    {
        INSTANCE;

        private static final int THIS_REFERENCE_INDEX = 0;

        @Override
        public Class<This> getHandledType() {
            return This.class;
        }

        @Override
        public MethodDelegationBinder.ParameterBinding<?> bind(AnnotationDescription.Loadable<This> annotation, MethodDescription source, ParameterDescription target, Implementation.Target implementationTarget, Assigner assigner) {
            if (target.getTypeDescription().isPrimitive()) {
                throw new IllegalStateException(String.format("The %d. argument virtual %s is a primitive type and can never be bound to an instance", target.getIndex(), target));
            }
            if (target.getTypeDescription().isArray()) {
                throw new IllegalStateException(String.format("The %d. argument virtual %s is an array type and can never be bound to an instance", target.getIndex(), target));
            }
            if (source.isStatic() && !annotation.loadSilent().optional()) {
                return MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
            }
            StackManipulation assignment = source.isStatic() ? NullConstant.INSTANCE : new StackManipulation.Compound(MethodVariableAccess.REFERENCE.loadOffset(0), assigner.assign(implementationTarget.getTypeDescription(), target.getTypeDescription(), RuntimeType.Verifier.check(target)));
            return assignment.isValid() ? new MethodDelegationBinder.ParameterBinding.Anonymous(assignment) : MethodDelegationBinder.ParameterBinding.Illegal.INSTANCE;
        }

        public String toString() {
            return "This.Binder." + this.name();
        }
    }
}

