/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.description.method;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.description.type.TypeList;
import net.bytebuddy.implementation.bytecode.StackSize;
import net.bytebuddy.matcher.FilterableList;
import net.bytebuddy.utility.JavaMethod;

public interface ParameterList
extends FilterableList<ParameterDescription, ParameterList> {
    public TypeList asTypeList();

    public boolean hasExplicitMetaData();

    public static class Empty
    extends FilterableList.Empty<ParameterDescription, ParameterList>
    implements ParameterList {
        @Override
        public boolean hasExplicitMetaData() {
            return true;
        }

        @Override
        public TypeList asTypeList() {
            return new TypeList.Empty();
        }
    }

    public static class Explicit
    extends AbstractBase {
        private final List<? extends ParameterDescription> parameterDescriptions;

        public Explicit(List<? extends ParameterDescription> parameterDescriptions) {
            this.parameterDescriptions = Collections.unmodifiableList(parameterDescriptions);
        }

        public static ParameterList latent(MethodDescription declaringMethod, List<? extends TypeDescription> parameterTypes) {
            ArrayList<ParameterDescription.Latent> parameterDescriptions = new ArrayList<ParameterDescription.Latent>(parameterTypes.size());
            int index = 0;
            int offset = declaringMethod.isStatic() ? StackSize.ZERO.getSize() : StackSize.SINGLE.getSize();
            for (TypeDescription typeDescription : parameterTypes) {
                parameterDescriptions.add(new ParameterDescription.Latent(declaringMethod, typeDescription, index++, offset));
                offset += typeDescription.getStackSize().getSize();
            }
            return new Explicit(parameterDescriptions);
        }

        @Override
        public ParameterDescription get(int index) {
            return this.parameterDescriptions.get(index);
        }

        @Override
        public int size() {
            return this.parameterDescriptions.size();
        }

        @Override
        public TypeList asTypeList() {
            ArrayList<TypeDescription> typeDescriptions = new ArrayList<TypeDescription>(this.parameterDescriptions.size());
            for (ParameterDescription parameterDescription : this.parameterDescriptions) {
                typeDescriptions.add(parameterDescription.getTypeDescription());
            }
            return new TypeList.Explicit(typeDescriptions);
        }

        @Override
        protected ParameterList wrap(List<ParameterDescription> values) {
            return new Explicit(values);
        }
    }

    public static class ForLoadedExecutable
    extends AbstractBase {
        private static final JavaMethod GET_PARAMETERS;
        private final Object[] parameter;

        protected ForLoadedExecutable(Object[] parameter) {
            this.parameter = parameter;
        }

        public static ParameterList of(Method method) {
            return GET_PARAMETERS.isInvokable() ? new ForLoadedExecutable((Object[])GET_PARAMETERS.invoke(method, new Object[0])) : new OfLegacyVmMethod(method);
        }

        public static ParameterList of(Constructor<?> constructor) {
            return GET_PARAMETERS.isInvokable() ? new ForLoadedExecutable((Object[])GET_PARAMETERS.invoke(constructor, new Object[0])) : new OfLegacyVmConstructor(constructor);
        }

        @Override
        public ParameterDescription get(int index) {
            return new ParameterDescription.ForLoadedParameter(this.parameter[index], index);
        }

        @Override
        public int size() {
            return this.parameter.length;
        }

        @Override
        public TypeList asTypeList() {
            ArrayList<TypeDescription.ForLoadedType> typeDescriptions = new ArrayList<TypeDescription.ForLoadedType>(this.parameter.length);
            for (Object aParameter : this.parameter) {
                Class type = (Class)ParameterDescription.ForLoadedParameter.GET_TYPE.invoke(aParameter, new Object[0]);
                typeDescriptions.add(new TypeDescription.ForLoadedType(type));
            }
            return new TypeList.Explicit(typeDescriptions);
        }

        @Override
        protected ParameterList wrap(List<ParameterDescription> values) {
            return new Explicit(values);
        }

        static {
            JavaMethod getParameters;
            try {
                Class<?> executableType = Class.forName("java.lang.reflect.Executable");
                getParameters = new JavaMethod.ForLoadedMethod(executableType.getDeclaredMethod("getParameters", new Class[0]));
            }
            catch (Exception ignored) {
                getParameters = JavaMethod.ForUnavailableMethod.INSTANCE;
            }
            GET_PARAMETERS = getParameters;
        }

        protected static class OfLegacyVmConstructor
        extends AbstractBase {
            private final Constructor<?> constructor;
            private final Class<?>[] parameterType;
            private final Annotation[][] parameterAnnotation;

            public OfLegacyVmConstructor(Constructor<?> constructor) {
                this.constructor = constructor;
                this.parameterType = constructor.getParameterTypes();
                this.parameterAnnotation = constructor.getParameterAnnotations();
            }

            @Override
            protected ParameterList wrap(List<ParameterDescription> values) {
                return new Explicit(values);
            }

            @Override
            public ParameterDescription get(int index) {
                return new ParameterDescription.ForLoadedParameter.OfLegacyVmConstructor(this.constructor, index, this.parameterType[index], this.parameterAnnotation[index]);
            }

            @Override
            public int size() {
                return this.parameterType.length;
            }

            @Override
            public TypeList asTypeList() {
                return new TypeList.ForLoadedType(this.parameterType);
            }
        }

        protected static class OfLegacyVmMethod
        extends AbstractBase {
            private final Method method;
            private final Class<?>[] parameterType;
            private final Annotation[][] parameterAnnotation;

            protected OfLegacyVmMethod(Method method) {
                this.method = method;
                this.parameterType = method.getParameterTypes();
                this.parameterAnnotation = method.getParameterAnnotations();
            }

            @Override
            protected ParameterList wrap(List<ParameterDescription> values) {
                return new Explicit(values);
            }

            @Override
            public ParameterDescription get(int index) {
                return new ParameterDescription.ForLoadedParameter.OfLegacyVmMethod(this.method, index, this.parameterType[index], this.parameterAnnotation[index]);
            }

            @Override
            public int size() {
                return this.parameterType.length;
            }

            @Override
            public TypeList asTypeList() {
                return new TypeList.ForLoadedType(this.parameterType);
            }
        }
    }

    public static abstract class AbstractBase
    extends FilterableList.AbstractBase<ParameterDescription, ParameterList>
    implements ParameterList {
        @Override
        public boolean hasExplicitMetaData() {
            for (ParameterDescription parameterDescription : this) {
                if (parameterDescription.isNamed() && parameterDescription.hasModifiers()) continue;
                return false;
            }
            return true;
        }
    }
}

