/*
 * Decompiled with CFR 0.152.
 */
package net.butterflytv.rtmp_client;

import java.io.IOException;

public class RtmpClient {
    public static final int OPEN_SUCCESS = 1;

    public void open(String url, boolean isPublishMode) throws RtmpIOException {
        int result = this.nativeOpen(url, isPublishMode);
        if (result != 1) {
            throw new RtmpIOException(result);
        }
    }

    private native int nativeOpen(String var1, boolean var2);

    public native int read(byte[] var1, int var2, int var3) throws IOException;

    public native int write(byte[] var1) throws IOException;

    public native boolean pause(boolean var1);

    public native boolean isConnected();

    public native void close();

    static {
        System.loadLibrary("rtmp-jni");
    }

    public static class RtmpIOException
    extends IOException {
        public static final int OPEN_ALLOC = -1;
        public static final int OPEN_SETUP_URL = -2;
        public static final int OPEN_CONNECT = -3;
        public static final int OPEN_CONNECT_STREAM = -4;
        public final int errorCode;

        public RtmpIOException(int errorCode) {
            this.errorCode = errorCode;
        }
    }
}

