/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.util.schema;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import net.bpelunit.toolsupport.util.schema.SchemaParser;
import net.bpelunit.toolsupport.util.schema.nodes.Attribute;
import net.bpelunit.toolsupport.util.schema.nodes.ComplexType;
import net.bpelunit.toolsupport.util.schema.nodes.Element;
import net.bpelunit.toolsupport.util.schema.nodes.SimpleType;
import net.bpelunit.toolsupport.util.schema.nodes.Type;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SchemaParserTest {
    private final String schemaFileFolder = "testSchemata";
    private static final String targetNs = "http://schematest.bpelunit.org";
    private static final String schemaNs = "http://www.w3.org/2001/XMLSchema";
    private static final String XSD_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    private SchemaParser parser;
    private HashMap<QName, Element> elements;
    private HashMap<QName, ComplexType> complexTypes;
    private HashMap<QName, SimpleType> simpleTypes;

    @Before
    public void setUp() throws Exception {
        this.parser = new SchemaParser();
        this.elements = this.parser.getElements();
        this.complexTypes = this.parser.getComplexTypes();
        this.simpleTypes = this.parser.getSimpleTypes();
    }

    @Test
    public void testSimpleElement() throws Exception {
        this.parser.parse(this.getFile("simpleElement.xsd"));
        Assert.assertEquals((long)3L, (long)this.simpleTypes.size());
        this.checkSimpleTypesFor(new String[]{"string", "integer", "date"});
        Assert.assertEquals((long)4L, (long)this.elements.size());
        Assert.assertTrue((boolean)this.complexTypes.isEmpty());
        Element element = this.elements.get(new QName(targetNs, "name"));
        Assert.assertNotNull((Object)element);
        Assert.assertEquals((Object)"name", (Object)element.getLocalPart());
        Assert.assertEquals((Object)targetNs, (Object)element.getNamespace());
        Assert.assertEquals((Object)"string", (Object)element.getType().getLocalPart());
        Assert.assertEquals((Object)"http://www.w3.org/2001/XMLSchema", (Object)element.getType().getNamespace());
        element = this.elements.get(new QName(targetNs, "lastname"));
        Assert.assertNotNull((Object)element);
        Assert.assertEquals((Object)"lastname", (Object)element.getLocalPart());
        Assert.assertEquals((Object)targetNs, (Object)element.getNamespace());
        Assert.assertEquals((Object)"string", (Object)element.getType().getLocalPart());
        Assert.assertEquals((Object)"http://www.w3.org/2001/XMLSchema", (Object)element.getType().getNamespace());
        element = this.elements.get(new QName(targetNs, "age"));
        Assert.assertNotNull((Object)element);
        Assert.assertEquals((Object)"age", (Object)element.getLocalPart());
        Assert.assertEquals((Object)targetNs, (Object)element.getNamespace());
        Assert.assertEquals((Object)"integer", (Object)element.getType().getLocalPart());
        Assert.assertEquals((Object)"http://www.w3.org/2001/XMLSchema", (Object)element.getType().getNamespace());
        element = this.elements.get(new QName(targetNs, "dateborn"));
        Assert.assertNotNull((Object)element);
        Assert.assertEquals((Object)"dateborn", (Object)element.getLocalPart());
        Assert.assertEquals((Object)targetNs, (Object)element.getNamespace());
        Assert.assertEquals((Object)"date", (Object)element.getType().getLocalPart());
        Assert.assertEquals((Object)"http://www.w3.org/2001/XMLSchema", (Object)element.getType().getNamespace());
    }

    @Test
    public void testComplexEmptyElements() throws Exception {
        this.parser.parse(this.getFile("complexEmptyElements.xsd"));
        Assert.assertEquals((long)1L, (long)this.simpleTypes.size());
        this.checkSimpleTypesFor(new String[]{"positiveInteger"});
        Assert.assertEquals((long)1L, (long)this.elements.size());
        Assert.assertEquals((long)1L, (long)this.complexTypes.size());
        Element element = this.elements.get(new QName(targetNs, "product"));
        Assert.assertNotNull((Object)element);
        ComplexType complex = (ComplexType)element.getType();
        Assert.assertEquals((Object)"ProductType", (Object)complex.getLocalPart());
        Assert.assertEquals((Object)targetNs, (Object)complex.getNamespace());
        Assert.assertSame((Object)this.complexTypes.get(complex.getQName()), (Object)complex);
        List<Attribute> attributes = complex.getAttributes();
        Assert.assertEquals((long)1L, (long)attributes.size());
        Attribute attribute = attributes.get(0);
        Assert.assertEquals((Object)"productId", (Object)attribute.getLocalPart());
        Assert.assertEquals((Object)targetNs, (Object)attribute.getNamespace());
        Assert.assertEquals((Object)"positiveInteger", (Object)attribute.getType().getLocalPart());
        Assert.assertEquals((Object)"http://www.w3.org/2001/XMLSchema", (Object)attribute.getType().getNamespace());
    }

    @Test
    public void testDefineComplexElements1() throws Exception {
        this.parser.parse(this.getFile("defineComplexElements1.xsd"));
        Assert.assertEquals((long)1L, (long)this.simpleTypes.size());
        this.checkSimpleTypesFor(new String[]{"string"});
        Assert.assertEquals((long)1L, (long)this.elements.size());
        Assert.assertEquals((long)1L, (long)this.complexTypes.size());
        Element element = this.elements.get(new QName(targetNs, "employee"));
        Assert.assertNotNull((Object)element);
        ComplexType complex = (ComplexType)element.getType();
        Assert.assertNull((Object)complex.getLocalPart());
        Assert.assertEquals((Object)targetNs, (Object)complex.getNamespace());
        List<Element> nestedElements = complex.getElements();
        Assert.assertEquals((long)3L, (long)nestedElements.size());
        element = nestedElements.get(0);
        Assert.assertNotNull((Object)element);
        Assert.assertEquals((Object)"string", (Object)element.getType().getLocalPart());
        Assert.assertEquals((Object)"http://www.w3.org/2001/XMLSchema", (Object)element.getType().getNamespace());
        element = nestedElements.get(1);
        Assert.assertNotNull((Object)element);
        Assert.assertEquals((Object)"string", (Object)element.getType().getLocalPart());
        Assert.assertEquals((Object)"http://www.w3.org/2001/XMLSchema", (Object)element.getType().getNamespace());
        element = nestedElements.get(2);
        Assert.assertNotNull((Object)element);
        Assert.assertEquals((Object)"AddressType", (Object)element.getType().getLocalPart());
        Assert.assertEquals((Object)targetNs, (Object)element.getType().getNamespace());
        complex = this.complexTypes.get(new QName(targetNs, "AddressType"));
        Assert.assertSame((Object)complex, (Object)element.getType());
        Assert.assertEquals((Object)targetNs, (Object)complex.getNamespace());
        Assert.assertEquals((Object)"AddressType", (Object)complex.getLocalPart());
        Assert.assertEquals((long)0L, (long)complex.getAttributes().size());
        Assert.assertEquals((long)2L, (long)complex.getElements().size());
        element = complex.getElements().get(0);
        Assert.assertNotNull((Object)element);
        Assert.assertEquals((Object)targetNs, (Object)element.getNamespace());
        Assert.assertEquals((Object)"zip", (Object)element.getLocalPart());
        Assert.assertEquals((Object)"string", (Object)element.getType().getLocalPart());
        Assert.assertEquals((Object)"http://www.w3.org/2001/XMLSchema", (Object)element.getType().getNamespace());
        element = complex.getElements().get(1);
        Assert.assertNotNull((Object)element);
        Assert.assertEquals((Object)targetNs, (Object)element.getNamespace());
        Assert.assertEquals((Object)"city", (Object)element.getLocalPart());
        Assert.assertEquals((Object)"string", (Object)element.getType().getLocalPart());
        Assert.assertEquals((Object)"http://www.w3.org/2001/XMLSchema", (Object)element.getType().getNamespace());
    }

    @Test
    public void testDefineComplexElements2() throws Exception {
        this.parser.parse(this.getFile("defineComplexElements2.xsd"));
        Assert.assertEquals((long)1L, (long)this.simpleTypes.size());
        this.checkSimpleTypesFor(new String[]{"string"});
        Assert.assertEquals((long)1L, (long)this.elements.size());
        Assert.assertTrue((boolean)this.complexTypes.isEmpty());
        Element element = this.elements.get(new QName(targetNs, "employee"));
        Assert.assertNotNull((Object)element);
        ComplexType complex = (ComplexType)element.getType();
        Assert.assertNull((Object)complex.getLocalPart());
        Assert.assertEquals((Object)targetNs, (Object)complex.getNamespace());
        List<Element> nestedElements = complex.getElements();
        Assert.assertEquals((long)3L, (long)nestedElements.size());
        element = nestedElements.get(0);
        Assert.assertNotNull((Object)element);
        Assert.assertEquals((Object)"string", (Object)element.getType().getLocalPart());
        Assert.assertEquals((Object)"http://www.w3.org/2001/XMLSchema", (Object)element.getType().getNamespace());
        element = nestedElements.get(1);
        Assert.assertNotNull((Object)element);
        Assert.assertEquals((Object)"string", (Object)element.getType().getLocalPart());
        Assert.assertEquals((Object)"http://www.w3.org/2001/XMLSchema", (Object)element.getType().getNamespace());
        element = nestedElements.get(2);
        Assert.assertNotNull((Object)element);
        complex = (ComplexType)element.getType();
        Assert.assertEquals((Object)targetNs, (Object)complex.getNamespace());
        Assert.assertEquals((long)0L, (long)complex.getAttributes().size());
        Assert.assertEquals((long)2L, (long)complex.getElements().size());
        element = complex.getElements().get(0);
        Assert.assertNotNull((Object)element);
        Assert.assertEquals((Object)targetNs, (Object)element.getNamespace());
        Assert.assertEquals((Object)"zip", (Object)element.getLocalPart());
        Assert.assertEquals((Object)"string", (Object)element.getType().getLocalPart());
        Assert.assertEquals((Object)"http://www.w3.org/2001/XMLSchema", (Object)element.getType().getNamespace());
        element = complex.getElements().get(1);
        Assert.assertNotNull((Object)element);
        Assert.assertEquals((Object)targetNs, (Object)element.getNamespace());
        Assert.assertEquals((Object)"city", (Object)element.getLocalPart());
        Assert.assertEquals((Object)"string", (Object)element.getType().getLocalPart());
        Assert.assertEquals((Object)"http://www.w3.org/2001/XMLSchema", (Object)element.getType().getNamespace());
    }

    @Test
    public void testDefineComplexElements3() throws Exception {
        this.parser.parse(this.getFile("defineComplexElements3.xsd"));
        Assert.assertEquals((long)1L, (long)this.simpleTypes.size());
        SimpleType stringType = this.simpleTypes.get(new QName("http://www.w3.org/2001/XMLSchema", "string"));
        Assert.assertEquals((Object)"string", (Object)stringType.getLocalPart());
        Assert.assertEquals((Object)"http://www.w3.org/2001/XMLSchema", (Object)stringType.getNamespace());
        Assert.assertEquals((long)2L, (long)this.complexTypes.size());
        ComplexType locationType = this.complexTypes.get(new QName(targetNs, "LocationType"));
        Assert.assertEquals((Object)"LocationType", (Object)locationType.getLocalPart());
        Assert.assertEquals((Object)targetNs, (Object)locationType.getNamespace());
        Assert.assertEquals((long)0L, (long)locationType.getAttributes().size());
        Assert.assertEquals((long)2L, (long)locationType.getElements().size());
        Element nested = locationType.getElements().get(0);
        Assert.assertSame((Object)stringType, (Object)nested.getType());
        Assert.assertEquals((Object)targetNs, (Object)nested.getNamespace());
        Assert.assertEquals((Object)"city", (Object)nested.getLocalPart());
        nested = locationType.getElements().get(1);
        Assert.assertSame((Object)stringType, (Object)nested.getType());
        Assert.assertEquals((Object)targetNs, (Object)nested.getNamespace());
        Assert.assertEquals((Object)"zip", (Object)nested.getLocalPart());
        ComplexType personType = this.complexTypes.get(new QName(targetNs, "PersonType"));
        Assert.assertEquals((Object)"PersonType", (Object)personType.getLocalPart());
        Assert.assertEquals((Object)targetNs, (Object)locationType.getNamespace());
        Assert.assertEquals((long)2L, (long)personType.getAttributes().size());
        Attribute attribute = this.findAttribute(personType.getAttributes(), targetNs, "personId");
        Assert.assertSame((Object)stringType, (Object)attribute.getType());
        Assert.assertEquals((Object)"personId", (Object)attribute.getLocalPart());
        Assert.assertEquals((Object)targetNs, (Object)attribute.getNamespace());
        Assert.assertNull((Object)attribute.getFixedValue());
        Assert.assertEquals((Object)"-1", (Object)attribute.getDefaultValue());
        attribute = this.findAttribute(personType.getAttributes(), targetNs, "lang");
        Assert.assertSame((Object)stringType, (Object)attribute.getType());
        Assert.assertEquals((Object)"lang", (Object)attribute.getLocalPart());
        Assert.assertEquals((Object)targetNs, (Object)attribute.getNamespace());
        Assert.assertEquals((Object)"DE", (Object)attribute.getFixedValue());
        nested = personType.getElements().get(0);
        Assert.assertSame((Object)stringType, (Object)nested.getType());
        Assert.assertEquals((Object)targetNs, (Object)nested.getNamespace());
        Assert.assertEquals((Object)"firstname", (Object)nested.getLocalPart());
        Assert.assertEquals((long)1L, (long)nested.getMinOccurs());
        Assert.assertEquals((long)2L, (long)nested.getMaxOccurs());
        Assert.assertFalse((boolean)nested.isNillable());
        nested = personType.getElements().get(1);
        Assert.assertSame((Object)stringType, (Object)nested.getType());
        Assert.assertEquals((Object)targetNs, (Object)nested.getNamespace());
        Assert.assertEquals((Object)"lastname", (Object)nested.getLocalPart());
        Assert.assertEquals((long)1L, (long)nested.getMinOccurs());
        Assert.assertEquals((long)1L, (long)nested.getMaxOccurs());
        Assert.assertTrue((boolean)nested.isNillable());
        nested = personType.getElements().get(2);
        Assert.assertSame((Object)locationType, (Object)nested.getType());
        Assert.assertEquals((Object)targetNs, (Object)nested.getNamespace());
        Assert.assertEquals((Object)"location", (Object)nested.getLocalPart());
        Assert.assertEquals((long)2L, (long)nested.getMinOccurs());
        Assert.assertEquals((long)0L, (long)nested.getMaxOccurs());
        Assert.assertFalse((boolean)nested.isNillable());
        Assert.assertEquals((long)3L, (long)this.elements.size());
        Element element = this.elements.get(new QName(targetNs, "employee"));
        Assert.assertSame((Object)personType, (Object)element.getType());
        Assert.assertEquals((Object)targetNs, (Object)element.getNamespace());
        Assert.assertEquals((Object)"employee", (Object)element.getLocalPart());
        element = this.elements.get(new QName(targetNs, "student"));
        Assert.assertSame((Object)personType, (Object)element.getType());
        Assert.assertEquals((Object)targetNs, (Object)element.getNamespace());
        Assert.assertEquals((Object)"student", (Object)element.getLocalPart());
        element = this.elements.get(new QName(targetNs, "member"));
        Assert.assertSame((Object)personType, (Object)element.getType());
        Assert.assertEquals((Object)targetNs, (Object)element.getNamespace());
        Assert.assertEquals((Object)"member", (Object)element.getLocalPart());
    }

    @Test
    public void testDefineComplexElements4_NestedSimpleTypes() throws Exception {
        this.parser.parse(this.getFile("defineComplexElements4.xsd"));
        Assert.assertEquals((long)2L, (long)this.simpleTypes.size());
        Assert.assertEquals((long)1L, (long)this.complexTypes.size());
        Assert.assertEquals((long)2L, (long)this.elements.size());
        Element element = this.elements.get(new QName(targetNs, "itinerary"));
        ComplexType type = element.getType().getAsComplexType();
        Assert.assertNull((Object)type.getLocalPart());
        List<Attribute> attrs = type.getAttributes();
        Assert.assertEquals((long)1L, (long)attrs.size());
        Attribute colorAttr = attrs.get(0);
        Assert.assertEquals((Object)"color", (Object)colorAttr.getLocalPart());
        SimpleType attrType = colorAttr.getType();
        Assert.assertNull((Object)attrType.getLocalPart());
    }

    @Test
    public void testDefineComplexElements4_NestedModelGroups() throws Exception {
        this.parser.parse(this.getFile("defineComplexElements4.xsd"));
        Element element = this.elements.get(new QName(targetNs, "results"));
        ComplexType type = element.getType().getAsComplexType();
        Assert.assertNull((Object)type.getLocalPart());
        List<Element> elements = type.getElements();
        String[] localParts = new String[]{"result", "count", "empty"};
        QName[] nestedTypeName = new QName[]{new QName("http://www.w3.org/2001/XMLSchema", "string"), new QName("http://www.w3.org/2001/XMLSchema", "nonNegativeInteger"), new QName("http://www.w3.org/2001/XMLSchema", "anyType")};
        Assert.assertEquals((long)localParts.length, (long)elements.size());
        int i = 0;
        while (i < elements.size()) {
            Element nestedElement = elements.get(i);
            Assert.assertEquals((Object)localParts[i], (Object)nestedElement.getLocalPart());
            Type nestedType = nestedElement.getType();
            Assert.assertEquals((Object)nestedTypeName[i], (Object)nestedType.getQName());
            ++i;
        }
    }

    private Attribute findAttribute(List<Attribute> e, String namespace, String name) {
        for (Attribute attribute : e) {
            if (!namespace.equals(attribute.getNamespace()) || !name.equals(attribute.getLocalPart())) continue;
            return attribute;
        }
        return null;
    }

    private File getFile(String filename) {
        return new File(String.valueOf("testSchemata") + File.separator + filename);
    }

    private void checkSimpleTypesFor(String[] types) {
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            Assert.assertNotNull((Object)this.simpleTypes.get(new QName("http://www.w3.org/2001/XMLSchema", type)));
            ++n2;
        }
    }
}

