/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.editors.wizards.pages;

import net.bpelunit.framework.xml.suite.XMLWaitActivity;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class WaitWizardPage
extends WizardPage {
    private Text durationText;
    private XMLWaitActivity xmlWait;

    public WaitWizardPage(String pageName, XMLWaitActivity xmlWait) {
        super(pageName, "Edit a Wait Activity", null);
        this.setDescription("Configure the duration for waiting");
        this.xmlWait = xmlWait;
    }

    public void createControl(Composite parent) {
        Composite topLevel = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        topLevel.setLayout((Layout)layout);
        Label textLabel = new Label(topLevel, 0);
        textLabel.setText("Wait Duration (ms): ");
        this.durationText = new Text(topLevel, 2052);
        this.durationText.setText("" + this.xmlWait.getWaitForMilliseconds());
        this.durationText.addListener(25, new Listener(){

            public void handleEvent(Event e) {
                char[] chars;
                String string = e.text;
                char[] cArray = chars = string.toCharArray();
                int n = chars.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    if ('0' > c || c > '9') {
                        e.doit = false;
                        return;
                    }
                    ++n2;
                }
            }
        });
        this.durationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WaitWizardPage.this.validateInput();
            }
        });
        GC gc = new GC((Drawable)this.durationText);
        FontMetrics fm = gc.getFontMetrics();
        int charWidth = fm.getAverageCharWidth();
        int width = this.durationText.computeSize((int)(charWidth * 8), (int)-1).x;
        gc.dispose();
        FormData data = new FormData(width, -1);
        this.durationText.setLayoutData((Object)data);
        data.left = new FormAttachment((Control)textLabel, 5);
        data.top = new FormAttachment((Control)textLabel, 0, 0x1000000);
        this.setControl((Control)topLevel);
        this.validateInput();
    }

    public void validateInput() {
        String duration = this.durationText.getText();
        if (duration == null || duration.equals("")) {
            this.setPageComplete(false);
            return;
        }
        try {
            Long.parseLong(duration);
        }
        catch (NumberFormatException numberFormatException) {
            this.setPageComplete(false);
        }
        this.setPageComplete(true);
    }

    public long getDuration() {
        try {
            return Long.parseLong(this.durationText.getText());
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }
}

