/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.editors.wizards.pages;

import net.bpelunit.toolsupport.ToolSupportActivator;
import net.bpelunit.toolsupport.editors.wizards.ActivityEditMode;
import net.bpelunit.toolsupport.editors.wizards.WizardPageCode;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class ActivityWizardPage
extends WizardPage {
    private FontMetrics fontMetrics;

    protected ActivityWizardPage(String pageName, ActivityEditMode mode) {
        super(pageName);
        this.setImageDescriptor(ToolSupportActivator.getImageDescriptor("icons/new_wiz.png"));
        this.setTitle(String.valueOf(mode == ActivityEditMode.ADD ? "Add" : "Edit") + " a " + pageName + " activity");
    }

    protected void initializeDialogUnits(Control testControl) {
        super.initializeDialogUnits(testControl);
        GC gc = new GC((Drawable)testControl);
        gc.setFont(JFaceResources.getDialogFont());
        this.fontMetrics = gc.getFontMetrics();
        gc.dispose();
    }

    protected FontMetrics getFontMetrics() {
        return this.fontMetrics;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createFieldControls(composite, nColumns);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    protected abstract void createFieldControls(Composite var1, int var2);

    public abstract WizardPageCode getCode();
}

