/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.editors.wizards.fields;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.bpelunit.framework.xml.suite.XMLTestSuite;
import net.bpelunit.toolsupport.ToolSupportActivator;
import net.bpelunit.toolsupport.editors.wizards.components.StringValueListener;
import net.bpelunit.toolsupport.editors.wizards.fields.TreeItemToolTip;
import net.bpelunit.toolsupport.util.NamespaceEditor;
import net.bpelunit.toolsupport.util.schema.nodes.Attribute;
import net.bpelunit.toolsupport.util.schema.nodes.ComplexType;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MessageEditor
extends Composite {
    protected static final int IMAGE_MARGIN = 4;
    private static final String ATTRIBUTE_VALUE_KEY_PREFIX = "@";
    private static final String ELEMENT_VALUE_KEY = "elementContent";
    private static final String TREE_ITEM_FOR_START_TAG = "startTag";
    private static final String TREE_ITEM_FOR_END_TAG = "endTag";
    private static final String TREE_ITEM_FOR_ELEMENT_CONTENT = "inner";
    private static final String TREE_ITEM_IS_DISABLED = "null";
    private static final String TREE_ITEM_CHILDREN = "children";
    private static final String TREE_ITEM_IMAGE_POSITION = "imagePosition";
    private Tree tree;
    private NamespaceEditor namespaceEditor;
    protected boolean isEditable = true;
    private XMLTreeSelectionListener selectionListener;
    private List<StringValueListener> listeners = new ArrayList<StringValueListener>();
    private Color disabledColor;
    private Color normalColor;
    private net.bpelunit.toolsupport.util.schema.nodes.Element displayedElement;
    protected Point mouseDownPosition;
    protected TreeItemToolTip treeItemToolTip;
    private String xml;

    public MessageEditor(Composite parent, int style, XMLTestSuite suite) {
        super(parent, style);
        this.namespaceEditor = new NamespaceEditor(suite);
        this.setLayoutData(new GridData(4, 4, true, true));
        this.setEnabled(true);
        this.setLayout((Layout)new FillLayout());
        this.disabledColor = new Color(this.getForeground().getDevice(), 180, 180, 180);
        this.normalColor = new Color(this.getForeground().getDevice(), 0, 0, 0);
        this.tree = new Tree((Composite)this, 4);
        this.tree.setBackground(this.getBackground());
        TreeEditor editor = new TreeEditor(this.tree);
        editor.horizontalAlignment = 16384;
        editor.grabHorizontal = true;
        this.selectionListener = new XMLTreeSelectionListener(editor);
        this.tree.addSelectionListener((SelectionListener)this.selectionListener);
        this.tree.addListener(3, new Listener(){

            public void handleEvent(Event arg0) {
                MessageEditor.this.mouseDownPosition = new Point(arg0.x, arg0.y);
            }
        });
        this.tree.addListener(5, new Listener(){

            public void handleEvent(Event arg0) {
                Point mousePosition = new Point(arg0.x, arg0.y);
                TreeItem item = MessageEditor.this.getTree().getItem(mousePosition);
                if (item != null) {
                    Object data = item.getData(MessageEditor.TREE_ITEM_IMAGE_POSITION);
                    Integer imagePosition = data == null ? 0 : (Integer)data;
                    if (MessageEditor.this.isInAddButton(imagePosition, mousePosition)) {
                        if (MessageEditor.this.isCloneable(item)) {
                            MessageEditor.this.setCursor(21);
                            MessageEditor.this.treeItemToolTip.setText("Add another kind of this tag.");
                        } else {
                            MessageEditor.this.setCursor(0);
                            MessageEditor.this.treeItemToolTip.setText("");
                        }
                    } else if (MessageEditor.this.isInDeleteButton(imagePosition, mousePosition)) {
                        MessageEditor.this.setCursor(21);
                        MessageEditor.this.treeItemToolTip.setText("Remove this tag.");
                    } else {
                        MessageEditor.this.setCursor(0);
                        MessageEditor.this.treeItemToolTip.setText("");
                    }
                } else {
                    MessageEditor.this.setCursor(0);
                    MessageEditor.this.treeItemToolTip.setText("");
                }
            }
        });
        this.tree.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                if (event.index == 0) {
                    Image trailingImage = MessageEditor.this.getImage((TreeItem)event.item);
                    if (trailingImage != null) {
                        event.width += trailingImage.getBounds().width + 4;
                    }
                    event.height = 18;
                }
            }
        });
        this.tree.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                if (event.index == 0) {
                    TreeItem item = (TreeItem)event.item;
                    Image trailingImage = MessageEditor.this.getImage(item);
                    if (trailingImage != null) {
                        int x = event.x + event.width + 4;
                        int itemHeight = MessageEditor.this.getTree().getItemHeight();
                        int imageHeight = trailingImage.getBounds().height;
                        int y = event.y + (itemHeight - imageHeight) / 2;
                        event.gc.drawImage(trailingImage, x, y);
                        item.setData(MessageEditor.TREE_ITEM_IMAGE_POSITION, (Object)x);
                    } else {
                        item.setData(MessageEditor.TREE_ITEM_IMAGE_POSITION, (Object)-1);
                    }
                }
            }
        });
        this.treeItemToolTip = new TreeItemToolTip(this.tree);
        this.tree.addListener(12, (Listener)this.treeItemToolTip);
        this.tree.addListener(1, (Listener)this.treeItemToolTip);
        this.tree.addListener(5, (Listener)this.treeItemToolTip);
        this.tree.addListener(32, (Listener)this.treeItemToolTip);
    }

    protected void removeItem(TreeItem item) {
        net.bpelunit.toolsupport.util.schema.nodes.Element element = (net.bpelunit.toolsupport.util.schema.nodes.Element)item.getData(TREE_ITEM_FOR_START_TAG);
        TreeItem parent = item.getParentItem();
        TreeItem closingItem = parent.getItem(this.getItemIndex(item) + 1);
        if (this.isLastElementOfType(item, element)) {
            item.setData(TREE_ITEM_IS_DISABLED, (Object)"true");
            closingItem.setData(TREE_ITEM_IS_DISABLED, (Object)"true");
            item.setData(TREE_ITEM_CHILDREN, (Object)item.getItems());
            this.setDisabled(item, true);
            closingItem.setForeground(this.disabledColor);
            this.setCursor(0);
        } else {
            item.dispose();
            closingItem.dispose();
        }
        this.notifyStringValueListeners();
    }

    private boolean isLastElementOfType(TreeItem item, net.bpelunit.toolsupport.util.schema.nodes.Element element) {
        TreeItem parent = item.getParentItem();
        if (parent != null) {
            TreeItem[] treeItemArray = parent.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem child = treeItemArray[n2];
                if (item != child && element == child.getData(TREE_ITEM_FOR_START_TAG)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    private void setDisabled(TreeItem item, boolean disabled) {
        Color color = this.getColor(disabled);
        item.setForeground(color);
        TreeItem[] treeItemArray = item.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem i = treeItemArray[n2];
            this.setDisabled(i, disabled);
            ++n2;
        }
        item.setExpanded(!disabled);
        item.setData(TREE_ITEM_IS_DISABLED, (Object)("" + disabled));
    }

    protected Color getColor(boolean disabled) {
        Color color = disabled ? this.disabledColor : this.normalColor;
        return color;
    }

    protected void copyItem(TreeItem item) {
        TreeItem parent = item.getParentItem();
        int index = this.getItemIndex(item);
        if (this.isItemDisabled(item)) {
            TreeItem closingItem = parent.getItem(index + 1);
            item.setData(TREE_ITEM_IS_DISABLED, (Object)"false");
            closingItem.setData(TREE_ITEM_IS_DISABLED, (Object)"false");
            Color color = new Color(this.getForeground().getDevice(), 0, 0, 0);
            this.setDisabled(item, false);
            closingItem.setForeground(color);
        } else {
            net.bpelunit.toolsupport.util.schema.nodes.Element element = (net.bpelunit.toolsupport.util.schema.nodes.Element)item.getData(TREE_ITEM_FOR_START_TAG);
            this.displayElement(element, parent, index + 2);
            this.expandTreeItem(parent);
        }
        this.selectionListener.disposeEditor();
        this.notifyStringValueListeners();
    }

    protected boolean isItemDisabled(TreeItem item) {
        if (item == null) {
            return false;
        }
        Object data = item.getData(TREE_ITEM_IS_DISABLED);
        return Boolean.parseBoolean((String)data);
    }

    private int getItemIndex(TreeItem item) {
        int index = 0;
        TreeItem parent = item.getParentItem();
        TreeItem[] treeItemArray = parent.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem i = treeItemArray[n2];
            if (i == item) break;
            ++index;
            ++n2;
        }
        return index;
    }

    protected boolean selectNext(TreeItem selected) {
        return this.select(this.getNext(selected, true));
    }

    protected boolean selectPrevious(TreeItem selected) {
        return this.select(this.getPrevious(selected));
    }

    private boolean select(TreeItem newSelection) {
        if (newSelection != null) {
            this.tree.setSelection(newSelection);
            Event event = new Event();
            event.item = newSelection;
            event.widget = this.tree;
            this.selectionListener.widgetSelected(new SelectionEvent(event));
            return true;
        }
        return false;
    }

    private TreeItem getNext(TreeItem selected, boolean selectChildren) {
        if (selected.getItemCount() > 0 && selectChildren) {
            return selected.getItem(0);
        }
        TreeItem parent = selected.getParentItem();
        TreeItem next = null;
        if (parent != null) {
            if (parent.getItemCount() == 1) {
                this.getNext(parent, false);
            }
            if ((next = this.findNext(selected, parent.getItems())) == null) {
                next = this.getNext(parent, false);
            }
        } else {
            next = this.findNext(selected, this.tree.getItems());
        }
        return next;
    }

    private TreeItem findNext(TreeItem selected, TreeItem[] siblings) {
        int i = 0;
        while (i < siblings.length - 1) {
            if (siblings[i] == selected) {
                return siblings[i + 1];
            }
            ++i;
        }
        return null;
    }

    private TreeItem getPrevious(TreeItem selected) {
        TreeItem parent = selected.getParentItem();
        TreeItem previous = null;
        if (parent != null) {
            previous = this.findPrevious(selected, parent.getItems());
            if (previous == null) {
                previous = parent;
            }
        } else {
            previous = this.findPrevious(selected, this.tree.getItems());
        }
        return previous;
    }

    private TreeItem findPrevious(TreeItem selected, TreeItem[] siblings) {
        if (siblings.length == 1) {
            return selected.getParentItem();
        }
        int i = 1;
        while (i < siblings.length) {
            if (siblings[i] == selected) {
                return siblings[i - 1];
            }
            ++i;
        }
        return null;
    }

    protected Tree getTree() {
        return this.tree;
    }

    public void displayElement(net.bpelunit.toolsupport.util.schema.nodes.Element inputElement, boolean notifyListener) {
        this.displayedElement = inputElement;
        if (this.isEditable) {
            this.selectionListener.disposeEditor();
            this.tree.removeAll();
            if (this.displayedElement == null) {
                this.displayError("No element definition available for this message.");
                if (this.isEditable) {
                    for (StringValueListener listener : this.listeners) {
                        listener.valueChanged("");
                    }
                }
            } else {
                this.displayElement(inputElement, null);
                this.expandTreeItem(this.tree.getTopItem());
                this.layout();
                if (notifyListener) {
                    this.notifyStringValueListeners();
                }
            }
        } else {
            this.setXML();
        }
    }

    public void updateItems() {
        if (this.tree.getItemCount() > 0) {
            this.updateItems(this.tree.getItems());
            this.notifyStringValueListeners();
        }
    }

    private void updateItems(TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            this.setItemText(item);
            if (item.getItemCount() > 0) {
                this.updateItems(item.getItems());
            }
            ++n2;
        }
    }

    private void expandTreeItem(TreeItem item) {
        if (item != null && !this.isItemDisabled(item)) {
            item.setExpanded(true);
            TreeItem[] treeItemArray = item.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem child = treeItemArray[n2];
                this.expandTreeItem(child);
                ++n2;
            }
        }
    }

    private void displayElement(net.bpelunit.toolsupport.util.schema.nodes.Element element, TreeItem parent) {
        int index = parent == null ? 0 : parent.getItemCount();
        this.displayElement(element, parent, index);
    }

    private void displayElement(net.bpelunit.toolsupport.util.schema.nodes.Element element, TreeItem parent, Element domElement) {
        int index = parent == null ? 0 : parent.getItemCount();
        this.displayElement(element, parent, index, domElement);
    }

    private TreeItem displayElement(net.bpelunit.toolsupport.util.schema.nodes.Element element, TreeItem parent, int index) {
        TreeItem startTag = this.createTreeItem(parent, index);
        startTag.setData(TREE_ITEM_FOR_START_TAG, (Object)element);
        if (element.getType().isComplexType()) {
            ComplexType complex = element.getType().getAsComplexType();
            for (Attribute attribute : complex.getAttributes()) {
                startTag.setData(ATTRIBUTE_VALUE_KEY_PREFIX + attribute.getLocalPart(), (Object)attribute.getDefaultOrFixedValue());
            }
            for (net.bpelunit.toolsupport.util.schema.nodes.Element child : complex.getElements()) {
                this.displayElement(child, startTag, startTag.getItemCount());
            }
        } else {
            TreeItem inner = this.createTreeItem(startTag, startTag.getItemCount());
            inner.setData(TREE_ITEM_FOR_ELEMENT_CONTENT, (Object)element);
            this.setItemText(inner);
        }
        this.setItemText(startTag);
        TreeItem endTag = this.createTreeItem(parent, index + 1);
        endTag.setData(TREE_ITEM_FOR_END_TAG, (Object)element);
        this.setItemText(endTag);
        return startTag;
    }

    private void displayElement(net.bpelunit.toolsupport.util.schema.nodes.Element element, TreeItem parent, int index, Element domElement) {
        TreeItem startTag = this.createTreeItem(parent, index);
        startTag.setData(TREE_ITEM_FOR_START_TAG, (Object)element);
        if (element.getType().isComplexType()) {
            ComplexType complex = element.getType().getAsComplexType();
            for (Attribute attribute : complex.getAttributes()) {
                String name = attribute.getLocalPart();
                startTag.setData(ATTRIBUTE_VALUE_KEY_PREFIX + name, (Object)domElement.getAttribute(name));
            }
            List<Element> children = this.getDomChildrenElements(domElement.getChildNodes());
            int i = 0;
            Element domChild = null;
            if (!children.isEmpty()) {
                domChild = children.get(0);
            }
            for (net.bpelunit.toolsupport.util.schema.nodes.Element schemaChild : complex.getElements()) {
                boolean added = false;
                while (this.areNamesEqual(domChild, schemaChild)) {
                    this.displayElement(schemaChild, startTag, startTag.getItemCount(), domChild);
                    added = true;
                    if (++i >= children.size()) break;
                    domChild = children.get(i);
                }
                if (added) continue;
                TreeItem item = this.displayElement(schemaChild, startTag, startTag.getItemCount());
                this.removeItem(item);
            }
        } else {
            TreeItem inner = this.createTreeItem(startTag, startTag.getItemCount());
            inner.setData(TREE_ITEM_FOR_ELEMENT_CONTENT, (Object)element);
            String value = "";
            if (domElement.getFirstChild() != null) {
                value = domElement.getFirstChild().getNodeValue().trim();
            }
            inner.setData(ELEMENT_VALUE_KEY, (Object)value);
            this.setItemText(inner);
        }
        this.setItemText(startTag);
        TreeItem endTag = this.createTreeItem(parent, index + 1);
        endTag.setData(TREE_ITEM_FOR_END_TAG, (Object)element);
        this.setItemText(endTag);
    }

    private List<Element> getDomChildrenElements(NodeList childNodes) {
        ArrayList<Element> elements = new ArrayList<Element>();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = childNodes.item(i);
            if (node instanceof Element) {
                elements.add((Element)node);
            }
            ++i;
        }
        return elements;
    }

    private TreeItem createTreeItem(TreeItem parent, int index) {
        TreeItem treeItem = parent == null ? new TreeItem(this.tree, 0, index) : new TreeItem(parent, 0, index);
        treeItem.setData(TREE_ITEM_IS_DISABLED, (Object)"false");
        treeItem.setExpanded(true);
        return treeItem;
    }

    protected String getTagName(net.bpelunit.toolsupport.util.schema.nodes.Element element) {
        String prefix = this.namespaceEditor.getPrefix(element.getNamespace());
        if (prefix.isEmpty()) {
            return element.getLocalPart();
        }
        return String.valueOf(prefix) + ":" + element.getLocalPart();
    }

    private boolean isEditable(TreeItem item) {
        net.bpelunit.toolsupport.util.schema.nodes.Element element;
        if (item == null || item.getData(TREE_ITEM_FOR_END_TAG) != null || this.isItemDisabled(item)) {
            return false;
        }
        if (this.tree.getSelection().length > 0 && this.tree.getSelection()[0] == item) {
            return false;
        }
        if (item.getData(TREE_ITEM_FOR_ELEMENT_CONTENT) != null) {
            return true;
        }
        if (item.getData(TREE_ITEM_FOR_START_TAG) != null && (element = (net.bpelunit.toolsupport.util.schema.nodes.Element)item.getData(TREE_ITEM_FOR_START_TAG)).getType().isComplexType()) {
            return !element.getType().getAsComplexType().getAttributes().isEmpty();
        }
        return false;
    }

    protected boolean isCloneable(TreeItem item) {
        if (item == null || item.getData(TREE_ITEM_FOR_END_TAG) != null || item.getData(TREE_ITEM_FOR_ELEMENT_CONTENT) != null) {
            return false;
        }
        return this.tree.getItem(0) != item;
    }

    protected Image getImage(TreeItem item) {
        String imageName = null;
        if (this.isItemDisabled(item.getParentItem())) {
            return null;
        }
        boolean itemDisabled = this.isItemDisabled(item);
        boolean cloneable = this.isCloneable(item);
        boolean editable = this.isEditable(item);
        if (itemDisabled && cloneable) {
            imageName = "img_add";
        } else if (editable && cloneable) {
            imageName = "img_editable_cloneable";
        } else if (editable) {
            imageName = "img_editable";
        } else if (cloneable) {
            imageName = "img_cloneable";
        }
        if (imageName != null) {
            return ToolSupportActivator.getImage(imageName);
        }
        return null;
    }

    protected void setItemText(TreeItem item) {
        String text = "";
        if (item.getData(TREE_ITEM_FOR_START_TAG) != null) {
            text = this.setStartTagText(item, (net.bpelunit.toolsupport.util.schema.nodes.Element)item.getData(TREE_ITEM_FOR_START_TAG));
        } else if (item.getData(TREE_ITEM_FOR_END_TAG) != null) {
            net.bpelunit.toolsupport.util.schema.nodes.Element element = (net.bpelunit.toolsupport.util.schema.nodes.Element)item.getData(TREE_ITEM_FOR_END_TAG);
            text = "</" + this.getTagName(element) + ">";
        } else if (item.getData(TREE_ITEM_FOR_ELEMENT_CONTENT) != null) {
            text = (String)item.getData(ELEMENT_VALUE_KEY);
        }
        item.setText(0, text == null ? "" : text);
    }

    private String setStartTagText(TreeItem item, net.bpelunit.toolsupport.util.schema.nodes.Element element) {
        String text = "<" + this.getTagName(element);
        if (element.getType().isComplexType()) {
            ComplexType complex = element.getType().getAsComplexType();
            for (Attribute attribute : complex.getAttributes()) {
                text = String.valueOf(text) + " " + attribute.getLocalPart() + "=\"";
                String attributeValue = (String)item.getData(ATTRIBUTE_VALUE_KEY_PREFIX + attribute.getLocalPart());
                text = String.valueOf(text) + (attributeValue == null ? "" : attributeValue);
                text = String.valueOf(text) + "\"";
            }
        }
        text = String.valueOf(text) + ">";
        return text;
    }

    public void addStringValueListener(StringValueListener listener) {
        for (StringValueListener l : this.listeners) {
            if (l != listener) continue;
            return;
        }
        this.listeners.add(listener);
    }

    public void removeStringValueListener(StringValueListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyStringValueListeners() {
        if (this.isEditable) {
            String newValue = this.treeToXml(this.tree.getItems(), 0);
            for (StringValueListener listener : this.listeners) {
                listener.valueChanged(newValue);
            }
        }
    }

    public String getMessageAsXML() {
        return this.treeToXml(this.tree.getItems(), 0);
    }

    private String treeToXml(TreeItem[] treeItems, int indent) {
        String retval = "";
        String indentString = "";
        int i = 0;
        while (i < indent) {
            indentString = String.valueOf(indentString) + "\t";
            ++i;
        }
        TreeItem[] treeItemArray = treeItems;
        int n = treeItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (!this.isItemDisabled(item)) {
                String text = item.getText();
                if (!text.isEmpty()) {
                    retval = String.valueOf(retval) + indentString + text + "\n";
                }
                if (item.getItemCount() > 0) {
                    retval = String.valueOf(retval) + this.treeToXml(item.getItems(), indent + 1);
                }
            }
            ++n2;
        }
        return retval;
    }

    public void setEditable(boolean b) {
        this.isEditable = b;
        if (this.isEditable && !this.isXMLValid()) {
            this.displayElement(this.displayedElement, true);
        }
    }

    public boolean isXMLValid() {
        return this.tree.getItemCount() >= 2;
    }

    public void setXML(String xml) {
        this.xml = xml;
        this.setXML();
    }

    private void setXML() {
        if (this.displayedElement == null) {
            this.displayError("No element definition available in the WSDL.");
            return;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(new StringReader(this.xml)));
            Element root = document.getDocumentElement();
            if (this.areNamesEqual(root, this.displayedElement)) {
                if (this.compareElements(root, this.displayedElement)) {
                    this.selectionListener.disposeEditor();
                    this.tree.removeAll();
                    this.displayElement(this.displayedElement, null, root);
                    this.expandTreeItem(this.tree.getTopItem());
                    this.layout();
                }
            } else {
                String errorMsg = "Root element from literal XML does not fit the selected Operation.";
                this.displayError(errorMsg);
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            if ("Premature end of file.".equals(e.getMessage())) {
                this.displayError("Please choose operation.");
            } else {
                this.displayError(e.getMessage());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void displayError(String errorMsg) {
        this.selectionListener.disposeEditor();
        this.tree.removeAll();
        TreeItem item = this.createTreeItem(null, 0);
        item.setText(errorMsg);
    }

    private boolean compareElements(Element domElement, net.bpelunit.toolsupport.util.schema.nodes.Element schemaElement) {
        ComplexType type = schemaElement.getType().getAsComplexType();
        if (type != null) {
            if (type.getAttributes().size() != domElement.getAttributes().getLength()) {
                this.displayError("Attributes of " + domElement.getNodeName() + " do not match the Schema.");
                return false;
            }
            for (Attribute attribute : type.getAttributes()) {
                if (domElement.getAttributeNode(attribute.getLocalPart()) != null) continue;
                this.displayError("Attributes of " + domElement.getNodeName() + " do not match the Schema.");
                return false;
            }
            NodeList domChildren = domElement.getChildNodes();
            List<net.bpelunit.toolsupport.util.schema.nodes.Element> schemaChildren = type.getElements();
            if (schemaChildren.size() == 0 && domChildren.getLength() > 0) {
                this.displayError("Element " + domElement.getNodeName() + " can not have any children, but has.");
                return false;
            }
            int j = 0;
            int i = 0;
            while (i < domChildren.getLength()) {
                block9: {
                    Node node = domChildren.item(i);
                    if (node instanceof Element) {
                        Element domChild = (Element)node;
                        do {
                            net.bpelunit.toolsupport.util.schema.nodes.Element schemaChild;
                            if (!this.areNamesEqual(domChild, schemaChild = schemaChildren.get(j))) continue;
                            if (!this.compareElements(domChild, schemaChild)) {
                                return false;
                            }
                            break block9;
                        } while (++j < schemaChildren.size());
                        this.displayError("unexpected " + domChild.getNodeName() + ".");
                        return false;
                    }
                    if (node.getNodeValue() != null && !node.getNodeValue().trim().equals("")) {
                        this.displayError("Mixed data is not allowed: " + node.getNodeValue().trim());
                        return false;
                    }
                }
                ++i;
            }
        }
        return true;
    }

    private boolean areNamesEqual(Element domElement, net.bpelunit.toolsupport.util.schema.nodes.Element schemaElement) {
        if (domElement == null || schemaElement == null) {
            return false;
        }
        String namespace = schemaElement.getNamespace();
        String prefix = this.namespaceEditor.getPrefix(namespace);
        String tagName = schemaElement.getLocalPart();
        if (!prefix.isEmpty()) {
            tagName = String.valueOf(prefix) + ":" + tagName;
        }
        return tagName.equals(domElement.getNodeName());
    }

    protected boolean isInAddButton(int imagePosition, Point mousePosition) {
        if (this.isInButton(mousePosition)) {
            return imagePosition < mousePosition.x && mousePosition.x < imagePosition + 13;
        }
        return false;
    }

    protected boolean isInDeleteButton(int imagePosition, Point mousePosition) {
        if (this.isInButton(mousePosition)) {
            return imagePosition + 16 <= mousePosition.x && mousePosition.x < imagePosition + 13 + 16;
        }
        return false;
    }

    private boolean isInButton(Point mousePosition) {
        int itemHeight = this.tree.getItemHeight();
        return 2 < mousePosition.y % itemHeight && mousePosition.y % itemHeight < 14;
    }

    protected void setCursor(int cursor) {
        this.setCursor(new Cursor((Device)this.getDisplay(), cursor));
    }

    private class ChangeListener
    implements ModifyListener {
        private Attribute attribute = null;
        private TreeItem item;

        protected ChangeListener(Attribute attribute, TreeItem item) {
            this.attribute = attribute;
            this.item = item;
        }

        protected ChangeListener(TreeItem item) {
            this.item = item;
        }

        public void modifyText(ModifyEvent e) {
            Text text = (Text)e.getSource();
            String key = "";
            key = this.attribute == null ? MessageEditor.ELEMENT_VALUE_KEY : MessageEditor.ATTRIBUTE_VALUE_KEY_PREFIX + this.attribute.getLocalPart();
            this.item.setData(key, (Object)text.getText());
            text.pack();
            text.getParent().pack();
            int position = text.getSelection().x;
            text.setSelection(0);
            text.setSelection(Math.min(position, text.getText().length()));
            MessageEditor.this.setItemText(this.item);
            MessageEditor.this.notifyStringValueListeners();
        }
    }

    protected class TextFocusListener
    implements FocusListener {
        protected TextFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            Text text = (Text)e.widget;
            text.setSelection(text.getText().length());
        }

        public void focusLost(FocusEvent e) {
            ((Text)e.widget).setSelection(0);
        }
    }

    private final class XMLTreeSelectionListener
    extends SelectionAdapter {
        private final TreeEditor editor;

        XMLTreeSelectionListener(TreeEditor editor) {
            this.editor = editor;
        }

        protected void disposeEditor() {
            Control oldEditor = this.editor.getEditor();
            if (oldEditor != null) {
                oldEditor.dispose();
            }
        }

        public void widgetSelected(SelectionEvent e) {
            this.disposeEditor();
            if (!MessageEditor.this.isEditable) {
                return;
            }
            TreeItem item = (TreeItem)e.item;
            if (item == null) {
                return;
            }
            if (item.getParentItem() != null && MessageEditor.this.isItemDisabled(item.getParentItem())) {
                return;
            }
            net.bpelunit.toolsupport.util.schema.nodes.Element element = (net.bpelunit.toolsupport.util.schema.nodes.Element)item.getData(MessageEditor.TREE_ITEM_FOR_ELEMENT_CONTENT);
            if (element != null && !MessageEditor.this.isItemDisabled(item)) {
                this.createInnerTextEditor(item);
            } else {
                element = (net.bpelunit.toolsupport.util.schema.nodes.Element)item.getData(MessageEditor.TREE_ITEM_FOR_START_TAG);
                if (element != null) {
                    int imagePosition = (Integer)item.getData(MessageEditor.TREE_ITEM_IMAGE_POSITION);
                    if (imagePosition > 0) {
                        Point mousePosition = MessageEditor.this.mouseDownPosition;
                        MessageEditor.this.mouseDownPosition = new Point(0, 0);
                        if (MessageEditor.this.isInAddButton(imagePosition, mousePosition)) {
                            MessageEditor.this.copyItem(item);
                            return;
                        }
                        if (MessageEditor.this.isInDeleteButton(imagePosition, mousePosition)) {
                            MessageEditor.this.removeItem(item);
                            return;
                        }
                    }
                    this.createStartTagEditor(item, element);
                }
            }
        }

        private void createStartTagEditor(TreeItem item, net.bpelunit.toolsupport.util.schema.nodes.Element element) {
            ComplexType complex = element.getType().getAsComplexType();
            if (complex == null || complex.getAttributes().isEmpty()) {
                return;
            }
            boolean itemDisabled = MessageEditor.this.isItemDisabled(item);
            Color color = MessageEditor.this.getColor(itemDisabled);
            Composite composite = new Composite((Composite)MessageEditor.this.getTree(), 4);
            ArrayList<Text> tabList = new ArrayList<Text>();
            composite.setLayout((Layout)this.createRowLayout());
            this.addLabel(composite, color, "<" + MessageEditor.this.getTagName(element));
            int i = 0;
            while (i < complex.getAttributes().size()) {
                Attribute attribute = complex.getAttributes().get(i);
                Text text = this.createAttributeInput(item, composite, attribute, color, !itemDisabled);
                if (text != null) {
                    tabList.add(text);
                }
                ++i;
            }
            this.addLabel(composite, color, ">");
            if (item.getData(MessageEditor.TREE_ITEM_FOR_START_TAG) != null && item.getParentItem() != null) {
                this.addButtons(item, composite);
            }
            if (!tabList.isEmpty()) {
                Control[] tmpTabList = new Control[tabList.size()];
                tabList.toArray(tmpTabList);
                composite.setTabList(tmpTabList);
                ((Control)tabList.get(0)).setFocus();
            }
            this.editor.setEditor((Control)composite, item);
        }

        private Label addLabel(Composite composite, String text) {
            Label label = new Label(composite, 0);
            label.setText(text);
            return label;
        }

        private Label addLabel(Composite composite, Color color, String text) {
            Label label = this.addLabel(composite, text);
            label.setForeground(color);
            return label;
        }

        private void addButtons(final TreeItem item, Composite composite) {
            this.addLabel(composite, "   ");
            Label label = new Label(composite, 0);
            label.setImage(ToolSupportActivator.getImage("img_add"));
            label.setCursor(new Cursor((Device)MessageEditor.this.getDisplay(), 21));
            label.setToolTipText("Add another tag of this kind.");
            label.addListener(4, new Listener(){

                public void handleEvent(Event arg0) {
                    MessageEditor.this.copyItem(item);
                }
            });
            label = this.addLabel(composite, " ");
            Font oldFont = label.getFont();
            FontData fontData = oldFont.getFontData()[0];
            fontData.height = (float)((double)fontData.height * 0.75);
            label.setFont(new Font(oldFont.getDevice(), fontData));
            label = new Label(composite, 0);
            label.setImage(ToolSupportActivator.getImage("img_delete"));
            label.setCursor(new Cursor((Device)MessageEditor.this.getDisplay(), 21));
            label.setToolTipText("Remove this tag.");
            label.addListener(4, new Listener(){

                public void handleEvent(Event arg0) {
                    MessageEditor.this.removeItem(item);
                    XMLTreeSelectionListener.this.disposeEditor();
                }
            });
        }

        private Text createAttributeInput(final TreeItem item, final Composite composite, Attribute attribute, Color color, boolean isAttributeEditable) {
            this.addLabel(composite, color, " " + attribute.getLocalPart() + "=\"");
            String attributeValue = (String)item.getData(MessageEditor.ATTRIBUTE_VALUE_KEY_PREFIX + attribute.getLocalPart());
            String string = attributeValue = attributeValue == null ? "" : attributeValue;
            if (isAttributeEditable) {
                Text text = new Text(composite, 4);
                text.setText(attributeValue);
                text.addModifyListener((ModifyListener)new ChangeListener(attribute, item));
                text.addFocusListener((FocusListener)new TextFocusListener());
                text.addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyPressed(KeyEvent event) {
                        switch (event.keyCode) {
                            case 0x1000002: {
                                if (!MessageEditor.this.selectNext(item)) break;
                                composite.dispose();
                                break;
                            }
                            case 0x1000001: {
                                if (!MessageEditor.this.selectPrevious(item)) break;
                                composite.dispose();
                                break;
                            }
                            case 13: 
                            case 0x1000050: {
                                composite.dispose();
                                break;
                            }
                            case 9: {
                                Control[] tabList = composite.getTabList();
                                int j = 0;
                                while (j < tabList.length) {
                                    if (tabList[j] == event.getSource()) {
                                        int nextIndex = j + 1 >= tabList.length ? 0 : j + 1;
                                        tabList[nextIndex].setFocus();
                                    }
                                    ++j;
                                }
                                event.doit = false;
                            }
                        }
                    }
                });
                this.addLabel(composite, color, "\"");
                return text;
            }
            this.addLabel(composite, color, String.valueOf(attributeValue) + "\"");
            return null;
        }

        private RowLayout createRowLayout() {
            RowLayout layout = new RowLayout(256);
            layout.fill = false;
            layout.spacing = 0;
            layout.marginLeft = 2;
            layout.marginTop = 2;
            layout.wrap = false;
            return layout;
        }

        private void createInnerTextEditor(final TreeItem item) {
            final Composite composite = new Composite((Composite)MessageEditor.this.getTree(), 0);
            composite.setLayout((Layout)this.createRowLayout());
            final Text text = new Text(composite, 4);
            text.setText(item.getText());
            text.setVisible(true);
            text.addModifyListener((ModifyListener)new ChangeListener(item));
            text.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent event) {
                    composite.dispose();
                }
            });
            text.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    switch (event.keyCode) {
                        case 0x1000002: {
                            text.dispose();
                            MessageEditor.this.selectNext(item);
                            break;
                        }
                        case 0x1000001: {
                            text.dispose();
                            MessageEditor.this.selectPrevious(item);
                            break;
                        }
                        case 9: {
                            event.doit = false;
                        }
                        case 13: 
                        case 0x1000050: {
                            text.dispose();
                        }
                    }
                }
            });
            this.editor.setEditor((Control)composite, item);
            text.pack();
            composite.pack();
            text.setSelection(text.getText().length());
            text.setFocus();
        }
    }
}

