/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.editors.wizards.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import net.bpelunit.framework.control.util.ActivityUtil;
import net.bpelunit.framework.xml.suite.XMLActivity;
import net.bpelunit.framework.xml.suite.XMLSoapActivity;
import net.bpelunit.framework.xml.suite.XMLTrack;
import net.bpelunit.toolsupport.ToolSupportActivator;
import net.bpelunit.toolsupport.editors.wizards.components.DataComponent;
import net.bpelunit.toolsupport.editors.wizards.components.MessageChangeListener;
import net.bpelunit.toolsupport.editors.wizards.components.SendComponent;
import net.bpelunit.toolsupport.editors.wizards.fields.DialogField;
import net.bpelunit.toolsupport.editors.wizards.fields.IDialogFieldListener;
import net.bpelunit.toolsupport.editors.wizards.fields.IStringButtonAdapter;
import net.bpelunit.toolsupport.editors.wizards.fields.LayoutUtil;
import net.bpelunit.toolsupport.editors.wizards.fields.SelectionButtonDialogField;
import net.bpelunit.toolsupport.editors.wizards.fields.StringButtonDialogField;
import net.bpelunit.toolsupport.editors.wizards.pages.OperationWizardPage;
import net.bpelunit.toolsupport.util.AggregatedWSDLDefinitionFacade;
import net.bpelunit.toolsupport.util.WSDLReadingException;
import net.bpelunit.toolsupport.util.schema.WSDLParser;
import net.bpelunit.toolsupport.util.schema.nodes.Element;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class OperationDataComponent
extends DataComponent {
    private static final String REGLAR_MESSAGE_SELITEM = "regular message";
    private static final String CUSTOM_FAULT_SELITEM = "custom fault";
    private static final String RECEIVE_NAME = "receive";
    private StringButtonDialogField fServiceDialogField;
    private StringButtonDialogField fPortDialogField;
    private StringButtonDialogField fOperationDialogField;
    private XMLActivity fActivity;
    private QName fService;
    private String fPort;
    private String fOperation;
    private String fErrorMessage;
    private boolean fPageComplete;
    private SelectionButtonDialogField fReceiveFaultField;
    private List<MessageChangeListener> messageChangeListener = new ArrayList<MessageChangeListener>();
    private StringButtonDialogField fOutputDialogField;
    private boolean fSendFault;
    private String fSendFaultName;

    public OperationDataComponent(IWizardPage wizard, FontMetrics metrics) {
        super(wizard, metrics);
    }

    public void handleOutputFieldChanged(DialogField field) {
        this.setFaultByMenuSelection(this.fOutputDialogField.getText());
        this.fireMessageChanged();
    }

    public void handleServiceFieldChanged(DialogField field) {
        AggregatedWSDLDefinitionFacade def = this.getDefinition();
        String fieldText = this.fServiceDialogField.getText();
        if (!(def == null || this.fService != null && this.fService.getLocalPart().equals(fieldText))) {
            Collection services = def.getServices().values();
            for (Service s : services) {
                QName sName = s.getQName();
                if (!sName.getLocalPart().equals(fieldText)) continue;
                this.fService = sName;
            }
        }
        this.validateOperation(Verify.ALL);
    }

    public void handlePortFieldChanged(DialogField field) {
        this.fPort = this.fPortDialogField.getText();
        this.validateOperation(Verify.ALL);
    }

    public void handleOperationFieldChanged(DialogField field) {
        this.fOperation = this.fOperationDialogField.getText();
        this.fireMessageChanged();
    }

    public void addMessageListener(MessageChangeListener listener) {
        for (MessageChangeListener ol : this.messageChangeListener) {
            if (ol != listener) continue;
            return;
        }
        this.messageChangeListener.add(listener);
        if (this.getWizardPage() instanceof OperationWizardPage) {
            try {
                Element element = ((OperationWizardPage)this.getWizardPage()).getElementForOperation();
                if (this.validateOperation(Verify.ALL) && listener instanceof SendComponent && element != null) {
                    ((SendComponent)listener).setOperationMessage(element, false);
                }
            }
            catch (Exception e1) {
                ToolSupportActivator.log(e1);
            }
        }
    }

    public void removeOperationListener(MessageChangeListener listener) {
        this.messageChangeListener.remove(listener);
    }

    private boolean validateOperation(Verify v) {
        Operation op;
        AggregatedWSDLDefinitionFacade def;
        XMLTrack track = ActivityUtil.getEnclosingTrack((XMLActivity)this.fActivity);
        if (track == null) {
            this.setProblem("Partner Track not found.");
            return false;
        }
        try {
            def = this.getDefinition();
        }
        catch (Exception e) {
            String msg = String.valueOf(e.getMessage()) + e.getCause() != null ? e.getCause().getMessage() : "";
            this.setProblem(msg);
            return false;
        }
        if (def == null) {
            this.setProblem("WSDL definition was not found for this partner track.");
            return false;
        }
        if (v.equals((Object)Verify.DEF)) {
            this.setNoProblem();
            return true;
        }
        if (this.isEmpty(this.fService)) {
            this.setProblem("Enter a service name.");
            return false;
        }
        Service service = def.getService(this.fService);
        if (service == null) {
            this.setProblem("Could not locate Service with name " + this.fService.toString());
            return false;
        }
        if (v.equals((Object)Verify.SERVICE)) {
            this.setNoProblem();
            return true;
        }
        if (this.isEmpty(this.fPort)) {
            this.setProblem("Enter a port name.");
            return false;
        }
        Port port = this.getDefinition().getService(this.fService).getPort(this.fPort);
        if (port == null) {
            this.setProblem("Could not locate port with name " + this.fPort);
            return false;
        }
        if (v.equals((Object)Verify.PORT)) {
            this.setNoProblem();
            return true;
        }
        if (this.isEmpty(this.fOperation)) {
            this.setProblem("Enter an operation name");
            return false;
        }
        Binding binding = this.getDefinition().getService(this.fService).getPort(this.fPort).getBinding();
        if (binding == null || binding.getBindingOperation(this.fOperation, null, null) == null) {
            this.setProblem("Could not locate operation with name " + this.fOperation);
            return false;
        }
        if (v.equals((Object)Verify.OPERATION)) {
            this.setNoProblem();
            return true;
        }
        if (!(ActivityUtil.isReceiveFirstActivity((XMLActivity)this.fActivity) && !ActivityUtil.isTwoWayActivity((Object)this.fActivity) || this.isEmpty(this.fSendFaultName) || (op = this.getOperationByName(this.fOperation)) == null || op.getFault(this.fSendFaultName) != null)) {
            this.setProblem("Could not locate fault with name " + this.fSendFaultName);
            return false;
        }
        this.setNoProblem();
        return true;
    }

    public void openServiceChooser(DialogField field) {
        AggregatedWSDLDefinitionFacade def = this.getDefinition();
        if (def == null) {
            this.showErrorDialog("Partner Definition is incorrect; Problem loading WSDL.");
            return;
        }
        Map services = def.getServices();
        if (services != null) {
            Object[] res;
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new SimpleLabelProvider());
            dialog.setElements(services.keySet().toArray());
            dialog.setTitle("Services for this partner");
            dialog.setMessage("Select one of the services to set it.");
            dialog.setMultipleSelection(false);
            int code = dialog.open();
            if (code == 0 && (res = dialog.getResult()) != null && res.length > 0) {
                QName serviceName;
                this.fService = serviceName = (QName)res[0];
                this.updateFields();
                this.validateOperation(Verify.ALL);
            }
        }
    }

    private void openPortChooser(DialogField field) {
        if (this.validateOperation(Verify.SERVICE)) {
            Map ports = this.getDefinition().getService(this.fService).getPorts();
            String str = this.openStringChooser(ports.keySet().toArray());
            if (str != null) {
                this.fPort = str;
            }
            this.updateFields();
            this.validateOperation(Verify.ALL);
        } else {
            this.showErrorDialog("Please select a valid service first.");
        }
    }

    public void openOperationChooser(DialogField field) {
        if (this.validateOperation(Verify.PORT)) {
            List operations = this.getDefinition().getService(this.fService).getPort(this.fPort).getBinding().getBindingOperations();
            Object[] options = new String[operations.size()];
            int i = 0;
            for (BindingOperation operation : operations) {
                options[i] = operation.getName();
                ++i;
            }
            String str = this.openStringChooser(options);
            if (str != null) {
                this.fOperation = str;
            }
            this.updateFields();
            this.validateOperation(Verify.ALL);
        } else {
            this.showErrorDialog("Please select a valid service and port first.");
        }
    }

    private void showErrorDialog(String msg) {
        MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)msg);
    }

    private void openOutputChooser(DialogField field) {
        if (this.validateOperation(Verify.OPERATION)) {
            Operation op = this.getOperationByName(this.fOperation);
            if (op == null) {
                this.showErrorDialog("Couldn't find information about the selected Operation " + this.fOperation);
                return;
            }
            int iOption = 0;
            Collection faults = op.getFaults().values();
            Object[] options = new String[2 + faults.size()];
            options[iOption++] = REGLAR_MESSAGE_SELITEM;
            options[iOption++] = CUSTOM_FAULT_SELITEM;
            for (Fault fault : faults) {
                options[iOption++] = fault.getName();
            }
            this.setFaultByMenuSelection(this.openStringChooser(options));
            this.updateFields();
            this.validateOperation(Verify.ALL);
        } else {
            this.showErrorDialog("Please select a valid service, port and operation first.");
        }
    }

    private void setFaultByMenuSelection(String str) {
        if (this.isEmpty(str) || REGLAR_MESSAGE_SELITEM.equals(str)) {
            this.fSendFault = false;
            this.fSendFaultName = null;
        } else if (CUSTOM_FAULT_SELITEM.equals(str)) {
            this.fSendFault = true;
            this.fSendFaultName = null;
        } else {
            this.fSendFault = true;
            this.fSendFaultName = str;
        }
    }

    private boolean isEmpty(String something) {
        return something == null || "".equals(something);
    }

    private boolean isEmpty(QName something) {
        return something == null || "".equals(something.getLocalPart());
    }

    private String openStringChooser(Object[] values) {
        Object[] res;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new SimpleLabelProvider());
        dialog.setElements(values);
        dialog.setTitle("Services for this partner");
        dialog.setMessage("Select one of the services to set it.");
        dialog.setMultipleSelection(false);
        int code = dialog.open();
        if (code == 0 && (res = dialog.getResult()) != null && res.length > 0) {
            return (String)res[0];
        }
        return null;
    }

    private void updateFields() {
        if (this.fService != null) {
            this.fServiceDialogField.setText(this.fService.getLocalPart());
        }
        if (this.fPort != null) {
            this.fPortDialogField.setText(this.fPort);
        }
        if (this.fOperation != null) {
            this.fOperationDialogField.setText(this.fOperation);
        }
        if (this.fSendFault) {
            this.fOutputDialogField.setText(!this.isEmpty(this.fSendFaultName) ? this.fSendFaultName : CUSTOM_FAULT_SELITEM);
        } else {
            this.fOutputDialogField.setText(REGLAR_MESSAGE_SELITEM);
        }
    }

    public AggregatedWSDLDefinitionFacade getDefinition() {
        Definition wsdlForPartner;
        XMLTrack track = ActivityUtil.getEnclosingTrack((XMLActivity)this.fActivity);
        if (track == null) {
            this.setProblem("Partner Track not found - cannot continue.");
            return null;
        }
        try {
            wsdlForPartner = this.getEditor().getWsdlForPartner(track);
        }
        catch (WSDLReadingException e) {
            String msg = String.valueOf(e.getMessage()) + e.getCause() != null ? e.getCause().getMessage() : "";
            this.setProblem(msg);
            return null;
        }
        Definition partnerWSDLForPartner = null;
        try {
            partnerWSDLForPartner = this.getEditor().getPartnerWsdlForPartner(track);
        }
        catch (WSDLReadingException wSDLReadingException) {}
        if (partnerWSDLForPartner == null) {
            return new AggregatedWSDLDefinitionFacade(wsdlForPartner);
        }
        return new AggregatedWSDLDefinitionFacade(wsdlForPartner, partnerWSDLForPartner);
    }

    public WSDLParser getWSDLParser() {
        AggregatedWSDLDefinitionFacade facade = this.getDefinition();
        try {
            Definition definition = facade.getDefinition(this.fService.getNamespaceURI());
            return this.getEditor().getWSDLParserForDefinition(definition);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void init(XMLSoapActivity activity) {
        this.fActivity = activity;
        try {
            this.fService = activity.getService();
            this.fPort = activity.getPort();
            this.fOperation = activity.getOperation();
        }
        catch (Exception exception) {}
        if (this.fService == null) {
            this.fPort = null;
            this.fOperation = null;
        }
        ServiceListener serviceAdapter = new ServiceListener();
        this.fServiceDialogField = new StringButtonDialogField(serviceAdapter);
        this.fServiceDialogField.setDialogFieldListener(serviceAdapter);
        this.fServiceDialogField.setLabelText("Service");
        this.fServiceDialogField.setButtonLabel("Choose...");
        PortListener portListener = new PortListener();
        this.fPortDialogField = new StringButtonDialogField(portListener);
        this.fPortDialogField.setDialogFieldListener(portListener);
        this.fPortDialogField.setLabelText("Port");
        this.fPortDialogField.setButtonLabel("Choose...");
        OperationListener operationListener = new OperationListener();
        this.fOperationDialogField = new StringButtonDialogField(operationListener);
        this.fOperationDialogField.setDialogFieldListener(operationListener);
        this.fOperationDialogField.setLabelText("Operation");
        this.fOperationDialogField.setButtonLabel("Choose...");
        OutputListener outputListener = new OutputListener();
        this.fOutputDialogField = new StringButtonDialogField(outputListener);
        this.fOutputDialogField.setDialogFieldListener(outputListener);
        this.fOutputDialogField.setLabelText("Send");
        this.fOutputDialogField.setButtonLabel("Choose...");
        this.fSendFault = ActivityUtil.getSendFault((XMLActivity)this.fActivity);
        this.fSendFaultName = ActivityUtil.getSendFaultString((XMLActivity)this.fActivity);
        this.fReceiveFaultField = new SelectionButtonDialogField(32);
        this.fReceiveFaultField.setLabelText("Use fault element for receive operation");
        this.fReceiveFaultField.setSelection(ActivityUtil.getReceiveFault((XMLActivity)this.fActivity));
        this.updateFields();
        this.validateOperation(Verify.ALL);
    }

    @Override
    public Composite createControls(Composite composite, int nColumns) {
        String niceName = String.valueOf(ActivityUtil.getNiceName((Object)this.fActivity)) + " operation";
        Group operationGroup = this.createGroup(composite, niceName, nColumns, new GridData(4, 1, true, false));
        this.fServiceDialogField.doFillIntoGrid((Composite)operationGroup, nColumns);
        Text text0 = this.fServiceDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text0, this.getMaxFieldWidth());
        LayoutUtil.setHorizontalGrabbing((Control)text0);
        this.fPortDialogField.doFillIntoGrid((Composite)operationGroup, nColumns);
        Text text1 = this.fPortDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text1, Dialog.convertWidthInCharsToPixels((FontMetrics)this.getFontMetrics(), (int)30));
        this.fOperationDialogField.doFillIntoGrid((Composite)operationGroup, nColumns);
        Text text2 = this.fOperationDialogField.getTextControl(null);
        LayoutUtil.setWidthHint((Control)text2, Dialog.convertWidthInCharsToPixels((FontMetrics)this.getFontMetrics(), (int)30));
        if (ActivityUtil.isReceiveFirstActivity((XMLActivity)this.fActivity)) {
            this.fReceiveFaultField.doFillIntoGrid((Composite)operationGroup, nColumns);
        } else {
            this.fOutputDialogField.doFillIntoGrid((Composite)operationGroup, nColumns);
        }
        if (ActivityUtil.isTwoWayActivity((Object)this.fActivity)) {
            if (ActivityUtil.isReceiveFirstActivity((XMLActivity)this.fActivity)) {
                this.fOutputDialogField.doFillIntoGrid((Composite)operationGroup, nColumns);
            } else {
                this.fReceiveFaultField.doFillIntoGrid((Composite)operationGroup, nColumns);
            }
        }
        return operationGroup;
    }

    public QName getService() {
        return this.fService;
    }

    public String getPort() {
        return this.fPort;
    }

    public String getOperation() {
        return this.fOperation;
    }

    public boolean getSendFault() {
        return this.fSendFault;
    }

    public String getSendFaultName() {
        return this.fSendFaultName;
    }

    public boolean getReceiveFault() {
        return this.fReceiveFaultField.isSelected();
    }

    private void setProblem(String string) {
        this.setErrorMessage(string);
        this.setPageComplete(false);
        this.fireValueChanged(null);
    }

    private void setNoProblem() {
        this.setErrorMessage(null);
        this.setPageComplete(true);
        this.fireValueChanged(null);
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public boolean isPageComplete() {
        return this.fPageComplete;
    }

    private void setPageComplete(boolean isComplete) {
        this.fPageComplete = isComplete;
    }

    private void setErrorMessage(String string) {
        this.fErrorMessage = string;
    }

    private Operation getOperationByName(String opName) {
        List bindingOps = this.getDefinition().getService(this.fService).getPort(this.fPort).getBinding().getBindingOperations();
        for (BindingOperation bindingOp : bindingOps) {
            if (!opName.equals(bindingOp.getOperation().getName())) continue;
            return bindingOp.getOperation();
        }
        return null;
    }

    private void fireMessageChanged() {
        if (this.validateOperation(Verify.ALL) && this.getWizardPage() instanceof OperationWizardPage) {
            try {
                Element element = ((OperationWizardPage)this.getWizardPage()).getElementForOperation();
                for (MessageChangeListener listener : this.messageChangeListener) {
                    listener.messageChanged(element);
                }
            }
            catch (Exception e1) {
                ToolSupportActivator.log(e1);
            }
        }
    }

    private class OperationListener
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private OperationListener() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
            OperationDataComponent.this.openOperationChooser(field);
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            OperationDataComponent.this.handleOperationFieldChanged(field);
        }
    }

    private class OutputListener
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private OutputListener() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
            OperationDataComponent.this.openOutputChooser(field);
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            OperationDataComponent.this.handleOutputFieldChanged(field);
        }
    }

    private class PortListener
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private PortListener() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
            OperationDataComponent.this.openPortChooser(field);
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            OperationDataComponent.this.handlePortFieldChanged(field);
        }
    }

    private class ServiceListener
    implements IStringButtonAdapter,
    IDialogFieldListener {
        private ServiceListener() {
        }

        @Override
        public void changeControlPressed(DialogField field) {
            OperationDataComponent.this.openServiceChooser(field);
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            OperationDataComponent.this.handleServiceFieldChanged(field);
        }
    }

    class SimpleLabelProvider
    implements ILabelProvider {
        SimpleLabelProvider() {
        }

        public Image getImage(Object element) {
            return ToolSupportActivator.getImage("img_deployer");
        }

        public String getText(Object element) {
            if (element instanceof QName) {
                return ((QName)element).getLocalPart();
            }
            if (element instanceof String) {
                return (String)element;
            }
            return "Unknown Type";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private static enum Verify {
        DEF,
        SERVICE,
        PORT,
        OPERATION,
        ALL;

    }
}

