/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.editors.wizards.pages;

import net.bpelunit.toolsupport.editors.wizards.ActivityEditMode;
import net.bpelunit.toolsupport.editors.wizards.fields.DialogField;
import net.bpelunit.toolsupport.editors.wizards.fields.IDialogFieldListener;
import net.bpelunit.toolsupport.editors.wizards.fields.IListAdapter;
import net.bpelunit.toolsupport.editors.wizards.fields.ListDialogField;
import net.bpelunit.toolsupport.editors.wizards.pages.ActivityWizardPage;

public abstract class StructuredActivityWizardPage
extends ActivityWizardPage {
    private final int BUTTON_ADD = 0;
    private final int BUTTON_EDIT = 1;
    private final int BUTTON_REMOVE = 2;
    protected String[] fButtons = new String[]{"&Add", "&Edit", "&Remove"};

    protected StructuredActivityWizardPage(String pageName) {
        super(pageName, ActivityEditMode.ADD);
    }

    protected abstract void handleAddPressed();

    protected abstract void handleRemovePressed();

    protected abstract void handleEditPressed();

    protected void enableButtonsForSelection(ListDialogField listField, boolean enable) {
        listField.enableButton(1, enable);
        listField.enableButton(2, enable);
    }

    protected ListFieldListener createListFieldListener() {
        return new ListFieldListener();
    }

    protected class ListFieldListener
    implements IListAdapter,
    IDialogFieldListener {
        protected ListFieldListener() {
        }

        @Override
        public void customButtonPressed(ListDialogField field, int index) {
            switch (index) {
                case 0: {
                    StructuredActivityWizardPage.this.handleAddPressed();
                    break;
                }
                case 1: {
                    StructuredActivityWizardPage.this.handleEditPressed();
                    break;
                }
                case 2: {
                    StructuredActivityWizardPage.this.handleRemovePressed();
                }
            }
        }

        @Override
        public void doubleClicked(ListDialogField field) {
            StructuredActivityWizardPage.this.handleEditPressed();
        }

        @Override
        public void selectionChanged(ListDialogField field) {
            StructuredActivityWizardPage.this.enableButtonsForSelection(field, true);
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
        }
    }
}

