/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.editors.wizards.pages;

import net.bpelunit.framework.xml.suite.XMLSendActivity;
import net.bpelunit.framework.xml.suite.XMLSoapActivity;
import net.bpelunit.framework.xml.suite.XMLTestSuite;
import net.bpelunit.toolsupport.editors.wizards.ActivityEditMode;
import net.bpelunit.toolsupport.editors.wizards.ActivityWizard;
import net.bpelunit.toolsupport.editors.wizards.WizardPageCode;
import net.bpelunit.toolsupport.editors.wizards.components.SendComponent;
import net.bpelunit.toolsupport.editors.wizards.fields.DialogField;
import net.bpelunit.toolsupport.editors.wizards.pages.OperationWizardPage;
import net.bpelunit.toolsupport.util.ToolUtil;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;

public class SendCompleteWizardPage
extends OperationWizardPage {
    private SendComponent fSendComponent;
    private XMLSendActivity fSendActivity;

    public SendCompleteWizardPage(XMLSoapActivity operationActivity, XMLSendActivity sendActivity, ActivityEditMode mode, String pageName) {
        super(operationActivity, mode, pageName);
        this.fSendActivity = sendActivity;
    }

    @Override
    protected void createFieldControls(Composite composite, int nColumns) {
        super.createFieldControls(composite, nColumns);
        this.fSendComponent = new SendComponent((IWizardPage)this, this.getFontMetrics());
        this.fSendComponent.init(this.getSendActivity());
        this.fSendComponent.createControls(composite, nColumns);
        this.fSendComponent.addComponentListener(this);
        this.valueChanged(null);
    }

    private XMLSendActivity getSendActivity() {
        return this.fSendActivity;
    }

    @Override
    public void valueChanged(DialogField field) {
        super.valueChanged(field);
        if (this.isPageComplete()) {
            if (this.fSendComponent != null) {
                String xmlText = this.fSendComponent.getXmlText();
                try {
                    ToolUtil.parseSendBlockWithException(this.getTestSuite(), xmlText);
                }
                catch (Exception e) {
                    this.fail("Not valid XML: " + e.getMessage());
                    return;
                }
                String delaySequence = this.fSendComponent.getDelaySequence().trim();
                if (!"".equals(delaySequence)) {
                    String[] sequence;
                    String[] stringArray = sequence = delaySequence.split(",");
                    int n = sequence.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String element = stringArray[n2];
                        try {
                            Integer.parseInt(element.trim());
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.fail("Delay Sequence must be a comma-separate integer list.");
                            return;
                        }
                        ++n2;
                    }
                }
            }
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    private XMLTestSuite getTestSuite() {
        return ((ActivityWizard)this.getWizard()).getEditor().getTestSuite();
    }

    private void fail(String string) {
        this.setErrorMessage(string);
        this.setPageComplete(false);
    }

    public String getSendXML() {
        return this.fSendComponent.getXmlText();
    }

    public void setSendXML(String xml) {
        this.fSendComponent.setXmlText(xml);
    }

    public String getDelaySequence() {
        return this.fSendComponent.getDelaySequence();
    }

    @Override
    public WizardPageCode getCode() {
        return WizardPageCode.SEND;
    }
}

