/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.editors.sections;

import java.util.ArrayList;
import java.util.List;
import net.bpelunit.framework.client.eclipse.dialog.DialogFieldValidator;
import net.bpelunit.framework.client.eclipse.dialog.Field;
import net.bpelunit.framework.client.eclipse.dialog.FieldBasedInputDialog;
import net.bpelunit.framework.client.eclipse.dialog.field.CheckBoxField;
import net.bpelunit.framework.client.eclipse.dialog.field.ComboField;
import net.bpelunit.framework.client.eclipse.dialog.field.TextField;
import net.bpelunit.framework.client.eclipse.dialog.validate.NotEmptyValidator;
import net.bpelunit.framework.client.eclipse.dialog.validate.NullValidator;
import net.bpelunit.framework.control.util.ActivityUtil;
import net.bpelunit.framework.xml.suite.XMLHumanPartnerDeploymentInformation;
import net.bpelunit.framework.xml.suite.XMLHumanPartnerTrack;
import net.bpelunit.framework.xml.suite.XMLPartnerDeploymentInformation;
import net.bpelunit.framework.xml.suite.XMLPartnerTrack;
import net.bpelunit.framework.xml.suite.XMLTestCase;
import net.bpelunit.framework.xml.suite.XMLTestCasesSection;
import net.bpelunit.framework.xml.suite.XMLTestSuite;
import net.bpelunit.framework.xml.suite.XMLTrack;
import net.bpelunit.toolsupport.ToolSupportActivator;
import net.bpelunit.toolsupport.editors.TestSuitePage;
import net.bpelunit.toolsupport.editors.sections.TreeSection;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.w3c.dom.Node;

public class TestCaseAndTrackSection
extends TreeSection {
    public TestCaseAndTrackSection(Composite parent, TestSuitePage page, FormToolkit toolkit) {
        super(parent, toolkit, page, true, true, null);
        this.init();
    }

    private void init() {
        this.getViewer().setLabelProvider((IBaseLabelProvider)new TestCaseLabelProvider());
        this.getViewer().setContentProvider((IContentProvider)new TestCaseContentProvider());
    }

    @Override
    protected String getDescription() {
        return "Manage test cases and partner tracks.";
    }

    @Override
    protected String getName() {
        return "Test Cases and Tracks";
    }

    public void refresh() {
        this.setViewerInput(this.getTestCasesXMLPart());
        this.getTreeViewer().expandAll();
        super.refresh();
    }

    private XMLTestCasesSection getTestCasesXMLPart() {
        XMLTestSuite model = this.getEditor().getTestSuite();
        return model.getTestCases();
    }

    @Override
    protected void addPressed() {
        this.addTestCase();
    }

    protected void addPartnerTrack(XMLTestCase to) {
        String name = this.editPartnerTrack("Add a new partner track", null);
        if (name != null && name.length() > 0) {
            XMLPartnerTrack track = to.addNewPartnerTrack();
            track.setName(name);
            this.adjust();
        }
    }

    protected void addHumanPartnerTrack(XMLTestCase to) {
        String name = this.editHumanPartnerTrack("Add a new WS-HT Track", null);
        if (name != null && name.length() > 0) {
            XMLHumanPartnerTrack track = to.addNewHumanPartnerTrack();
            track.setName(name);
            this.adjust();
        }
    }

    protected void addClientTrack(XMLTestCase to) {
        to.addNewClientTrack();
        this.adjust();
    }

    private void addTestCase() {
        String[] results = this.editTestCase("Add a new test case", null, null, false, false);
        if (results != null) {
            XMLTestCase testCase = this.getTestCasesXMLPart().addNewTestCase();
            testCase.setName(results[0]);
            testCase.setBasedOn(results[1]);
            testCase.setAbstract(Boolean.parseBoolean(results[2]));
            testCase.setVary(Boolean.parseBoolean(results[3]));
            testCase.addNewClientTrack();
            List<XMLPartnerDeploymentInformation> allDeployers = this.getAllDeployers();
            for (XMLPartnerDeploymentInformation information : allDeployers) {
                XMLPartnerTrack track = testCase.addNewPartnerTrack();
                track.setName(information.getName());
            }
            this.adjust();
            this.getTreeViewer().expandToLevel((Object)testCase, -1);
            this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)testCase));
        }
    }

    private List<XMLPartnerDeploymentInformation> getAllDeployers() {
        XMLTestSuite model = this.getEditor().getTestSuite();
        List partnerList = model.getDeployment().getPartnerList();
        return partnerList;
    }

    @Override
    protected void editPressed() {
        Object current = this.getViewerSelection();
        if (current instanceof XMLTestCase) {
            XMLTestCase testCase = (XMLTestCase)current;
            String[] results = this.editTestCase("Edit a test case", testCase.getName(), testCase.getBasedOn(), testCase.getAbstract(), testCase.getVary());
            if (results != null) {
                testCase.setName(results[0]);
                testCase.setBasedOn(results[1]);
                testCase.setAbstract(Boolean.parseBoolean(results[2]));
                testCase.setVary(Boolean.parseBoolean(results[3]));
                this.setEditRemoveDuplicateEnabled(true);
                this.adjust();
            }
        } else if (current instanceof XMLPartnerTrack) {
            this.editPartnerTrack((XMLPartnerTrack)current);
        } else if (current instanceof XMLPartnerTrack) {
            this.editHumanPartnerTrack((XMLHumanPartnerTrack)current);
        }
    }

    private void editPartnerTrack(XMLPartnerTrack track) {
        String name = this.editPartnerTrack("Edit a partner track", track.getName());
        if (name != null) {
            track.setName(name);
            this.setEditRemoveDuplicateEnabled(true);
            this.adjust();
        }
    }

    private void editHumanPartnerTrack(XMLHumanPartnerTrack track) {
        String name = this.editPartnerTrack("Edit a WS-HT Track", track.getName());
        if (name != null) {
            track.setName(name);
            this.setEditRemoveDuplicateEnabled(true);
            this.adjust();
        }
    }

    @Override
    protected void removePressed() {
        Object current = this.getViewerSelection();
        if (current instanceof XMLTestCase) {
            this.removeTestCase(current);
        } else if (current instanceof XMLTrack) {
            this.removeTrack((XMLTrack)current);
        } else if (current instanceof XMLHumanPartnerTrack) {
            this.removeTrack((XMLHumanPartnerTrack)current);
        }
    }

    private void removeTrack(XMLHumanPartnerTrack track) {
        XMLTestCase current = this.getTestCase((XmlObject)track);
        List partnerTrackList = current.getHumanPartnerTrackList();
        int index = partnerTrackList.indexOf(track);
        if (index >= 0) {
            current.removeHumanPartnerTrack(index);
            this.getPage().postTrackSelected((XMLHumanPartnerTrack)null);
        }
        this.getViewer().refresh();
        this.setEditRemoveDuplicateEnabled(false);
        this.markDirty();
    }

    private void removeTestCase(Object current) {
        XMLTestCasesSection testCaseSection = this.getTestCasesXMLPart();
        List testCaseList = testCaseSection.getTestCaseList();
        int i = 0;
        for (XMLTestCase testCase : testCaseList) {
            if (testCase.equals(current)) {
                testCaseSection.removeTestCase(i);
                break;
            }
            ++i;
        }
        this.getViewer().refresh();
        this.setEditRemoveDuplicateEnabled(false);
        this.markDirty();
    }

    private XMLTestCase getTestCase(XmlObject o) {
        XmlCursor c = o.newCursor();
        if (!c.toParent()) {
            return null;
        }
        XmlObject object = c.getObject();
        if (object instanceof XMLTestCase) {
            return (XMLTestCase)object;
        }
        return null;
    }

    private void removeTrack(XMLTrack track) {
        XMLTestCase current = this.getTestCase((XmlObject)track);
        List partnerTrackList = current.getPartnerTrackList();
        int index = partnerTrackList.indexOf(track);
        if (index >= 0) {
            current.removePartnerTrack(index);
            this.getPage().postTrackSelected((XMLTrack)null);
        }
        this.getViewer().refresh();
        this.setEditRemoveDuplicateEnabled(false);
        this.markDirty();
    }

    @Override
    protected void upPressed() {
        XMLTestCase xmlTestCase;
        XmlCursor currentCursor;
        Object viewerSelection = this.getViewerSelection();
        if (viewerSelection instanceof XMLTestCase && (currentCursor = (xmlTestCase = (XMLTestCase)viewerSelection).newCursor()).toPrevSibling()) {
            xmlTestCase.newCursor().moveXml(currentCursor);
            this.adjust();
        }
    }

    @Override
    protected void downPressed() {
        XMLTestCase xmlTestCase;
        XmlCursor currentCursor;
        Object viewerSelection = this.getViewerSelection();
        if (viewerSelection instanceof XMLTestCase && (currentCursor = (xmlTestCase = (XMLTestCase)viewerSelection).newCursor()).toNextSibling()) {
            currentCursor.moveXml(xmlTestCase.newCursor());
            this.adjust();
        }
    }

    @Override
    protected void duplicatePressed() {
        Object viewerSelection = this.getViewerSelection();
        if (viewerSelection instanceof XMLTestCase) {
            XMLTestCase testCase = (XMLTestCase)viewerSelection;
            Node node = testCase.getDomNode();
            node.getParentNode().appendChild(node.cloneNode(true));
            this.adjust();
        }
    }

    private void adjust() {
        this.getViewer().refresh();
        this.markDirty();
    }

    private String editPartnerTrack(String title, String current) {
        List partnerList = this.getEditor().getTestSuite().getDeployment().getPartnerList();
        String[] partnerNames = new String[partnerList.size()];
        int i = 0;
        boolean found = false;
        for (XMLPartnerDeploymentInformation information : partnerList) {
            partnerNames[i] = information.getName();
            if (partnerNames[i].equals(current)) {
                found = true;
            }
            ++i;
        }
        if (!found) {
            current = null;
        }
        FieldBasedInputDialog dialog = new FieldBasedInputDialog(this.getShell(), title);
        ComboField combo = new ComboField(dialog, "Name:", current, partnerNames);
        combo.setValidator((DialogFieldValidator)new NotEmptyValidator("Name"));
        dialog.addField((Field)combo);
        if (dialog.open() != 0) {
            return null;
        }
        return combo.getSelection();
    }

    private String editHumanPartnerTrack(String title, String current) {
        List partnerList = this.getEditor().getTestSuite().getDeployment().getHumanPartnerList();
        String[] partnerNames = new String[partnerList.size()];
        int i = 0;
        boolean found = false;
        for (XMLHumanPartnerDeploymentInformation information : partnerList) {
            partnerNames[i] = information.getName();
            if (partnerNames[i].equals(current)) {
                found = true;
            }
            ++i;
        }
        if (!found) {
            current = null;
        }
        FieldBasedInputDialog dialog = new FieldBasedInputDialog(this.getShell(), title);
        ComboField combo = new ComboField(dialog, "Name:", current, partnerNames);
        combo.setValidator((DialogFieldValidator)new NotEmptyValidator("Name"));
        dialog.addField((Field)combo);
        if (dialog.open() != 0) {
            return null;
        }
        return combo.getSelection();
    }

    private String[] editTestCase(String title, String currentName, String currentBasedOn, boolean currentAbstractSetting, boolean currentVarySetting) {
        FieldBasedInputDialog dialog = new FieldBasedInputDialog(this.getShell(), title);
        TextField nameField = new TextField(dialog, "Name:", currentName, TextField.Style.SINGLE);
        nameField.setValidator((DialogFieldValidator)new NotEmptyValidator("Name"));
        dialog.addField((Field)nameField);
        TextField basedOnField = new TextField(dialog, "Based On:", currentBasedOn, TextField.Style.SINGLE);
        basedOnField.setValidator((DialogFieldValidator)new NullValidator());
        dialog.addField((Field)basedOnField);
        CheckBoxField abstractField = new CheckBoxField(dialog, "Abstract", currentAbstractSetting);
        abstractField.setValidator((DialogFieldValidator)new NotEmptyValidator("Abstract"));
        dialog.addField((Field)abstractField);
        CheckBoxField varyField = new CheckBoxField(dialog, "Vary send delay times", currentVarySetting);
        varyField.setValidator((DialogFieldValidator)new NotEmptyValidator("Vary"));
        dialog.addField((Field)varyField);
        if (dialog.open() != 0) {
            return null;
        }
        return new String[]{nameField.getSelection(), basedOnField.getSelection(), abstractField.getSelection(), varyField.getSelection()};
    }

    @Override
    protected void itemSelected(Object firstElement) {
        if (firstElement instanceof XMLTrack) {
            XMLTrack selection = (XMLTrack)firstElement;
            this.getPage().postTrackSelected(selection);
        } else if (firstElement instanceof XMLHumanPartnerTrack) {
            XMLHumanPartnerTrack selection = (XMLHumanPartnerTrack)firstElement;
            this.getPage().postTrackSelected(selection);
        }
        this.setEnabled(BUTTON_REMOVE, this.getIsDeleteEnabled(firstElement));
        this.setEnabled(BUTTON_EDIT, this.getIsEditEnabled(firstElement));
        this.setEnabled(BUTTON_DUPLICATE, this.getIsDuplicateEnabled(firstElement));
        this.setEnabled("UP", this.getIsMoveEnabled(firstElement) && ActivityUtil.hasPrevious((XmlObject)((XmlObject)firstElement)));
        this.setEnabled("DOWN", this.getIsMoveEnabled(firstElement) && ActivityUtil.hasNext((XmlObject)((XmlObject)firstElement)));
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        ISelection selection = this.getViewer().getSelection();
        IStructuredSelection ssel = (IStructuredSelection)selection;
        MenuManager newMenu = new MenuManager("&New");
        if (ssel.size() == 0 || ssel.size() == 1 && ssel.getFirstElement() instanceof XMLTestCase) {
            this.createAction((IMenuManager)newMenu, "Test Case", new Action(){

                public void run() {
                    TestCaseAndTrackSection.this.addPressed();
                }
            });
        }
        if (ssel.size() == 1) {
            Object object = ssel.getFirstElement();
            if (object instanceof XMLTestCase) {
                final XMLTestCase testCase = (XMLTestCase)object;
                this.createAction((IMenuManager)newMenu, "Partner Track", new Action(){

                    public void run() {
                        TestCaseAndTrackSection.this.addPartnerTrack(testCase);
                    }
                });
                this.createAction((IMenuManager)newMenu, "WS-HT Track", new Action(){

                    public void run() {
                        TestCaseAndTrackSection.this.addHumanPartnerTrack(testCase);
                    }
                });
                Action newClientTrackAction = this.createAction((IMenuManager)newMenu, "Client Track", new Action(){

                    public void run() {
                        TestCaseAndTrackSection.this.addClientTrack(testCase);
                    }
                });
                newClientTrackAction.setEnabled(testCase.getClientTrack() == null);
            }
            manager.add((IContributionItem)newMenu);
            manager.add((IContributionItem)new Separator());
            Action editAction = this.createAction(manager, "&Edit", new Action(){

                public void run() {
                    TestCaseAndTrackSection.this.editPressed();
                }
            });
            editAction.setEnabled(this.getIsEditEnabled(object));
            manager.add((IContributionItem)new Separator());
            Action removeAction = this.createAction(manager, "&Delete", new Action(){

                public void run() {
                    TestCaseAndTrackSection.this.removePressed();
                }
            });
            removeAction.setEnabled(this.getIsDeleteEnabled(object));
            manager.add((IContributionItem)new Separator());
            Action duplicateAction = this.createAction(manager, "D&uplicate", new Action(){

                public void run() {
                    TestCaseAndTrackSection.this.removePressed();
                }
            });
            duplicateAction.setEnabled(this.getIsDeleteEnabled(object));
        }
    }

    private boolean getIsMoveEnabled(Object object) {
        return object instanceof XMLTestCase;
    }

    private boolean getIsEditEnabled(Object object) {
        return object instanceof XMLPartnerTrack || object instanceof XMLTestCase || object instanceof XMLHumanPartnerTrack;
    }

    private boolean getIsDuplicateEnabled(Object object) {
        return object instanceof XMLTestCase;
    }

    private boolean getIsDeleteEnabled(Object object) {
        return object != null;
    }

    private class TestCaseContentProvider
    implements ITreeContentProvider {
        private final Object[] EMPTY_LIST = new Object[0];
        private XMLTestCasesSection fSection;

        private TestCaseContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof XMLTestCasesSection) {
                XMLTestCasesSection element = (XMLTestCasesSection)inputElement;
                return element.getTestCaseList().toArray();
            }
            return this.EMPTY_LIST;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof XMLTestCasesSection) {
                this.fSection = (XMLTestCasesSection)newInput;
            }
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof XMLTestCase) {
                XMLTestCase testCase = (XMLTestCase)parentElement;
                ArrayList<XMLTrack> tracks = new ArrayList<XMLTrack>();
                tracks.addAll(testCase.getPartnerTrackList());
                tracks.addAll(testCase.getHumanPartnerTrackList());
                if (testCase.getClientTrack() != null) {
                    tracks.add(testCase.getClientTrack());
                }
                return tracks.toArray();
            }
            return this.EMPTY_LIST;
        }

        public Object getParent(Object element) {
            List partnerTrackList;
            List testCaseList;
            XMLTrack track;
            if (element instanceof XMLTrack) {
                track = (XMLTrack)element;
                testCaseList = this.fSection.getTestCaseList();
                for (XMLTestCase case1 : testCaseList) {
                    partnerTrackList = case1.getPartnerTrackList();
                    for (XMLPartnerTrack track2 : partnerTrackList) {
                        if (!track2.equals(track)) continue;
                        return case1;
                    }
                    if (!element.equals(case1.getClientTrack())) continue;
                    return case1;
                }
            }
            if (element instanceof XMLHumanPartnerTrack) {
                track = (XMLHumanPartnerTrack)element;
                testCaseList = this.fSection.getTestCaseList();
                for (XMLTestCase case1 : testCaseList) {
                    partnerTrackList = case1.getHumanPartnerTrackList();
                    for (XMLPartnerTrack track2 : partnerTrackList) {
                        if (!track2.equals(track)) continue;
                        return case1;
                    }
                }
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof XMLTestCase) {
                XMLTestCase testCase = (XMLTestCase)element;
                return testCase.getPartnerTrackList().size() > 0 || testCase.getHumanPartnerTrackList().size() > 0 || testCase.getClientTrack() != null;
            }
            return false;
        }
    }

    private class TestCaseLabelProvider
    implements ILabelProvider {
        private TestCaseLabelProvider() {
        }

        public Image getImage(Object element) {
            return ToolSupportActivator.getImage("img_testcase");
        }

        public String getText(Object element) {
            if (element instanceof XMLTestCase) {
                return ((XMLTestCase)element).getName();
            }
            if (element instanceof XMLPartnerTrack) {
                return ((XMLPartnerTrack)element).getName();
            }
            if (element instanceof XMLHumanPartnerTrack) {
                return ((XMLHumanPartnerTrack)element).getName();
            }
            return "client";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

