/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.editors.sections;

import javax.wsdl.Definition;
import net.bpelunit.framework.xml.suite.XMLTestSuite;
import net.bpelunit.toolsupport.editors.BPELUnitEditor;
import net.bpelunit.toolsupport.editors.IModelChangedListener;
import net.bpelunit.toolsupport.editors.TestSuitePage;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;

public abstract class BPELUnitSection
extends SectionPart
implements IModelChangedListener {
    private TestSuitePage fSuitePage;

    public BPELUnitSection(TestSuitePage page, Composite parent, FormToolkit toolkit, int style) {
        super(parent, toolkit, style);
        this.fSuitePage = page;
        this.getEditor().addModelChangedListener(this);
    }

    public TestSuitePage getPage() {
        return this.fSuitePage;
    }

    public void dispose() {
        super.dispose();
        this.getEditor().removeModelChangedListener(this);
    }

    @Override
    public void modelChanged() {
        this.refresh();
    }

    protected Shell getShell() {
        return this.fSuitePage.getSite().getShell();
    }

    protected XMLTestSuite getTestSuite() {
        XMLTestSuite model = this.getEditor().getTestSuite();
        return model;
    }

    protected void manageTargetNamespace(String file) {
        try {
            Definition wsdlForFile = this.getEditor().getWsdlForFile(file);
            String targetNamespace = wsdlForFile.getTargetNamespace();
            this.getTestSuite().newCursor().prefixForNamespace(targetNamespace);
        }
        catch (Exception exception) {}
    }

    protected FormText createText(Composite section, String content, FormToolkit toolkit, IHyperlinkListener listener) {
        FormText text = toolkit.createFormText(section, true);
        try {
            text.setText(content, true, false);
        }
        catch (SWTException e) {
            text.setText(e.getMessage(), false, false);
        }
        TableWrapData tableWrapData = new TableWrapData(256);
        tableWrapData.colspan = 2;
        text.setLayoutData((Object)tableWrapData);
        text.addHyperlinkListener(listener);
        return text;
    }

    protected BPELUnitEditor getEditor() {
        return this.getPage().getSuiteEditor();
    }
}

