/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.editors.formwidgets;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class HyperlinkField {
    private String fText;
    private IHyperLinkFieldListener fListener;

    public HyperlinkField(String text) {
        this.fText = text;
    }

    public void setHyperLinkFieldListener(IHyperLinkFieldListener listener) {
        this.fListener = listener;
    }

    public void removeHyperLinkFieldListener() {
        this.fListener = null;
    }

    public Control createControl(Composite parent, int nColumns, int horizontalAlign) {
        Hyperlink link = new Hyperlink(parent, 0);
        link.setText(this.fText);
        link.setUnderlined(true);
        link.setForeground(HyperlinkField.getHyperlinkText(link.getDisplay()));
        link.addMouseListener((MouseListener)new MouseAdapter(){
            private boolean down = false;

            public void mouseUp(MouseEvent e) {
                if (this.down) {
                    if (HyperlinkField.this.fListener != null) {
                        HyperlinkField.this.fListener.hyperLinkActivated();
                    }
                    this.down = false;
                }
            }

            public void mouseDown(MouseEvent e) {
                this.down = true;
            }
        });
        GridData d = new GridData(horizontalAlign, 1, true, false);
        d.horizontalSpan = nColumns;
        link.setLayoutData((Object)d);
        return link;
    }

    private static Color getHyperlinkText(Display display) {
        return JFaceResources.getColorRegistry().get("HYPERLINK_COLOR");
    }

    public static interface IHyperLinkFieldListener {
        public void hyperLinkActivated();
    }
}

