/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.editors.wizards.components;

import java.util.ArrayList;
import java.util.List;
import net.bpelunit.framework.client.eclipse.ExtensionControl;
import net.bpelunit.framework.client.eclipse.dialog.DialogFieldValidator;
import net.bpelunit.framework.client.eclipse.dialog.Field;
import net.bpelunit.framework.client.eclipse.dialog.FieldBasedInputDialog;
import net.bpelunit.framework.client.eclipse.dialog.field.SelectionField;
import net.bpelunit.framework.client.eclipse.dialog.field.TextField;
import net.bpelunit.framework.client.eclipse.dialog.validate.NotEmptyValidator;
import net.bpelunit.framework.control.util.ActivityUtil;
import net.bpelunit.framework.xml.suite.XMLProperty;
import net.bpelunit.framework.xml.suite.XMLTwoWayActivity;
import net.bpelunit.toolsupport.editors.wizards.components.StructuredDataComponent;
import net.bpelunit.toolsupport.editors.wizards.fields.ComboDialogField;
import net.bpelunit.toolsupport.editors.wizards.fields.DialogField;
import net.bpelunit.toolsupport.editors.wizards.fields.IDialogFieldListener;
import net.bpelunit.toolsupport.editors.wizards.fields.ListDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public class HeaderProcessorComponent
extends StructuredDataComponent {
    private static final String HEADER_PROCESSOR_NULL_NAME = "(none)";
    private static final int HEADER_PROCESSOR_NULL_INDEX = 0;
    private ComboDialogField fHeaderProcessorField;
    private XMLTwoWayActivity fParentActivity;
    private ListDialogField fPropertiesField;
    private String fCurrentlySelectedHeaderProcessor;
    private String[][] fDeployerMetaInformations;

    public HeaderProcessorComponent(IWizardPage wizard, FontMetrics metrics) {
        super(wizard, metrics);
    }

    @Override
    public void handleAddPressed() {
        String[] edit = this.editProperty(null);
        if (edit != null) {
            XMLProperty xmlCondition = this.fParentActivity.getHeaderProcessor().addNewProperty();
            xmlCondition.setName(edit[0]);
            xmlCondition.setStringValue(edit[1]);
            this.recreateInput();
            this.enableButtonsForSelection(this.fPropertiesField, false);
        }
    }

    @Override
    public void handleEditPressed() {
        XMLProperty current = this.getSelectedProperty();
        if (current == null) {
            return;
        }
        String[] edit = this.editProperty(current);
        if (edit != null) {
            current.setName(edit[0]);
            current.setStringValue(edit[1]);
            this.recreateInput();
            this.enableButtonsForSelection(this.fPropertiesField, false);
        }
    }

    @Override
    public void handleRemovePressed() {
        int index;
        XMLProperty prop = this.getSelectedProperty();
        if (prop != null && (index = ActivityUtil.getIndexFor((Object[])this.fParentActivity.getHeaderProcessor().getPropertyArray(), (Object)prop)) != -1) {
            this.fParentActivity.getHeaderProcessor().removeProperty(index);
            this.recreateInput();
            this.enableButtonsForSelection(this.fPropertiesField, false);
        }
    }

    private XMLProperty getSelectedProperty() {
        List<Object> selectedElements = this.fPropertiesField.getSelectedElements();
        if (selectedElements.size() > 0) {
            return (XMLProperty)selectedElements.get(0);
        }
        return null;
    }

    public void recreateInput() {
        ArrayList<Object> l = new ArrayList<Object>();
        XMLProperty[] xMLPropertyArray = this.fParentActivity.getHeaderProcessor().getPropertyArray();
        int n = xMLPropertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            XMLProperty o = xMLPropertyArray[n2];
            l.add(o);
            ++n2;
        }
        this.fPropertiesField.setElements(l);
    }

    private String[] editProperty(XMLProperty currentProperty) {
        FieldBasedInputDialog dialog = new FieldBasedInputDialog(this.getWizard().getShell(), "Add a property");
        String initialKey = currentProperty != null ? currentProperty.getName() : null;
        String initialValue = currentProperty != null ? currentProperty.getStringValue() : null;
        SelectionField field = new SelectionField(dialog, "Key", initialKey, "Keys...", new String[0]);
        field.setValidator((DialogFieldValidator)new NotEmptyValidator("Key"));
        dialog.addField((Field)field);
        TextField field2 = new TextField(dialog, "Value", initialValue, TextField.Style.SINGLE);
        field2.setValidator((DialogFieldValidator)new NotEmptyValidator("Value"));
        dialog.addField((Field)field2);
        if (dialog.open() != 0) {
            return null;
        }
        String[] s = new String[]{field.getSelection(), field2.getSelection()};
        return s;
    }

    public void headerProcessorChanged() {
        if (this.fPropertiesField != null && this.fHeaderProcessorField != null) {
            int selectionIndex = this.fHeaderProcessorField.getSelectionIndex();
            if (selectionIndex > 0) {
                this.fPropertiesField.setEnabled(true);
                String currentName = this.fHeaderProcessorField.getItems()[this.fHeaderProcessorField.getSelectionIndex()];
                this.fCurrentlySelectedHeaderProcessor = this.name2code(currentName);
                this.fParentActivity.getHeaderProcessor().setName(this.fCurrentlySelectedHeaderProcessor);
                this.enableButtonsForSelection(this.fPropertiesField, false);
            } else {
                this.fPropertiesField.setEnabled(false);
                this.fParentActivity.getHeaderProcessor().setName("removeme");
                this.fCurrentlySelectedHeaderProcessor = null;
            }
        }
    }

    public void init(XMLTwoWayActivity twoWayActivity) {
        this.fParentActivity = twoWayActivity;
        HeaderListener headerListener = new HeaderListener();
        this.fHeaderProcessorField = new ComboDialogField(8);
        this.fHeaderProcessorField.setDialogFieldListener(headerListener);
        this.fHeaderProcessorField.setLabelText("Processor");
        this.fDeployerMetaInformations = ExtensionControl.getHeaderProcessorMetaInformation();
        String[] items = new String[this.fDeployerMetaInformations.length + 1];
        items[0] = HEADER_PROCESSOR_NULL_NAME;
        int i = 0;
        while (i < this.fDeployerMetaInformations.length) {
            items[i + 1] = this.fDeployerMetaInformations[i][0];
            ++i;
        }
        this.fHeaderProcessorField.setItems(items);
        StructuredDataComponent.ListFieldListener conditionListener = this.createListFieldListener();
        this.fPropertiesField = new ListDialogField(conditionListener, fButtons, (IBaseLabelProvider)new ConditionsListLabelProvider());
        this.fPropertiesField.setDialogFieldListener(conditionListener);
        this.fPropertiesField.setTableColumns(new ListDialogField.ColumnsDescription(new String[]{"Key", "Value"}, true));
        this.fPropertiesField.setLabelText("Properties");
        boolean initialized = false;
        this.fCurrentlySelectedHeaderProcessor = null;
        if (this.hasHeaderProcessor()) {
            String code = this.fParentActivity.getHeaderProcessor().getName();
            String readableName = this.code2name(code);
            int index = this.getItemIndex(items, readableName);
            if (readableName != null && index != -1) {
                this.fPropertiesField.setEnabled(true);
                ArrayList<Object> l = new ArrayList<Object>();
                XMLProperty[] xMLPropertyArray = this.fParentActivity.getHeaderProcessor().getPropertyArray();
                int n = xMLPropertyArray.length;
                int n2 = 0;
                while (n2 < n) {
                    XMLProperty o = xMLPropertyArray[n2];
                    l.add(o);
                    ++n2;
                }
                this.fPropertiesField.setElements(l);
                this.fHeaderProcessorField.selectItem(index);
                this.fCurrentlySelectedHeaderProcessor = code;
                initialized = true;
            }
        } else {
            this.fParentActivity.addNewHeaderProcessor();
        }
        if (!initialized) {
            this.fPropertiesField.setEnabled(false);
            this.fHeaderProcessorField.selectItem(0);
        }
        this.enableButtonsForSelection(this.fPropertiesField, false);
    }

    private String code2name(String code) {
        if (code == null) {
            return null;
        }
        int i = 0;
        while (i < this.fDeployerMetaInformations.length) {
            if (this.fDeployerMetaInformations[i][1].equals(code)) {
                return this.fDeployerMetaInformations[i][0];
            }
            ++i;
        }
        return null;
    }

    private String name2code(String name) {
        if (name == null) {
            return null;
        }
        int i = 0;
        while (i < this.fDeployerMetaInformations.length) {
            if (this.fDeployerMetaInformations[i][0].equals(name)) {
                return this.fDeployerMetaInformations[i][1];
            }
            ++i;
        }
        return null;
    }

    private int getItemIndex(String[] items, String name) {
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean hasHeaderProcessor() {
        return this.fParentActivity.getHeaderProcessor() != null;
    }

    @Override
    public Composite createControls(Composite composite, int nColumns) {
        Group group = this.createGroup(composite, "Header Processor", nColumns, new GridData(4, 4, true, true));
        this.fHeaderProcessorField.doFillIntoGrid((Composite)group, nColumns);
        GridData gd = (GridData)this.fHeaderProcessorField.getComboControl(null).getLayoutData();
        gd.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)this.getFontMetrics(), (int)6);
        gd.grabExcessVerticalSpace = false;
        gd.widthHint = this.getMaxFieldWidth();
        gd.grabExcessHorizontalSpace = true;
        this.fPropertiesField.doFillIntoGrid((Composite)group, nColumns);
        TableViewer tableViewer = this.fPropertiesField.getTableViewer();
        tableViewer.getTable().setHeaderVisible(true);
        gd = (GridData)this.fPropertiesField.getListControl(null).getLayoutData();
        gd.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)this.getFontMetrics(), (int)6);
        gd.grabExcessVerticalSpace = false;
        gd.widthHint = this.getMaxFieldWidth();
        gd.grabExcessHorizontalSpace = true;
        this.headerProcessorChanged();
        return group;
    }

    public boolean hasHeaderProcessorSelected() {
        return this.fCurrentlySelectedHeaderProcessor != null;
    }

    private static class ConditionsListLabelProvider
    implements ITableLabelProvider {
        private ConditionsListLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof XMLProperty) {
                XMLProperty property = (XMLProperty)element;
                switch (columnIndex) {
                    case 0: {
                        return property.getName();
                    }
                    case 1: {
                        return property.getStringValue();
                    }
                }
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class HeaderListener
    implements IDialogFieldListener {
        private HeaderListener() {
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            HeaderProcessorComponent.this.headerProcessorChanged();
        }
    }
}

