/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.editors.sections;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import net.bpelunit.framework.client.eclipse.dialog.DialogFieldValidator;
import net.bpelunit.framework.client.eclipse.dialog.Field;
import net.bpelunit.framework.client.eclipse.dialog.FieldBasedInputDialog;
import net.bpelunit.framework.client.eclipse.dialog.field.ListField;
import net.bpelunit.framework.control.util.ActivityUtil;
import net.bpelunit.framework.control.util.BPELUnitUtil;
import net.bpelunit.framework.xml.suite.XMLActivity;
import net.bpelunit.framework.xml.suite.XMLCondition;
import net.bpelunit.framework.xml.suite.XMLHeaderProcessor;
import net.bpelunit.framework.xml.suite.XMLMapping;
import net.bpelunit.framework.xml.suite.XMLReceiveActivity;
import net.bpelunit.framework.xml.suite.XMLSendActivity;
import net.bpelunit.framework.xml.suite.XMLSoapActivity;
import net.bpelunit.framework.xml.suite.XMLTrack;
import net.bpelunit.framework.xml.suite.XMLTwoWayActivity;
import net.bpelunit.framework.xml.suite.XMLWaitActivity;
import net.bpelunit.toolsupport.ToolSupportActivator;
import net.bpelunit.toolsupport.editors.TestSuitePage;
import net.bpelunit.toolsupport.editors.sections.TreeSection;
import net.bpelunit.toolsupport.editors.wizards.ActivityEditMode;
import net.bpelunit.toolsupport.editors.wizards.ActivityWizard;
import net.bpelunit.toolsupport.editors.wizards.ReceiveOnlyWizard;
import net.bpelunit.toolsupport.editors.wizards.ReceiveSendAsyncActivityWizard;
import net.bpelunit.toolsupport.editors.wizards.ReceiveSendSyncActivityWizard;
import net.bpelunit.toolsupport.editors.wizards.SendOnlyWizard;
import net.bpelunit.toolsupport.editors.wizards.SendReceiveAsyncActivityWizard;
import net.bpelunit.toolsupport.editors.wizards.SendReceiveSyncActivityWizard;
import net.bpelunit.toolsupport.editors.wizards.WaitActivityWizard;
import net.bpelunit.toolsupport.editors.wizards.WizardPageCode;
import net.bpelunit.toolsupport.util.WSDLReadingException;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ActivitySection
extends TreeSection {
    private XMLTrack fCurrentPartnerTrack;
    private boolean fCtrlDown;

    public ActivitySection(Composite parent, TestSuitePage page, FormToolkit toolkit) {
        super(parent, toolkit, page, true);
        this.init();
        this.fCtrlDown = false;
    }

    private void init() {
        this.getViewer().setLabelProvider((IBaseLabelProvider)new ActivityLabelProvider());
        this.getViewer().setContentProvider((IContentProvider)new ActivityContentProvider());
    }

    @Override
    protected String getDescription() {
        return "Manage the activities of the selected partner track.";
    }

    @Override
    protected String getName() {
        return "Activities";
    }

    @Override
    protected void editPressed() {
        Object viewerSelection = this.getViewerSelection();
        XMLActivity currentActivity = null;
        WizardPageCode code = null;
        if (viewerSelection instanceof XMLMapping) {
            currentActivity = ActivityUtil.getParentActivityFor((Object)viewerSelection);
            code = WizardPageCode.DATACOPY;
        }
        if (viewerSelection instanceof XMLCondition) {
            currentActivity = ActivityUtil.getParentActivityFor((Object)viewerSelection);
            code = WizardPageCode.RECEIVE;
        }
        if (viewerSelection instanceof XMLHeaderProcessor) {
            currentActivity = ActivityUtil.getParentActivityFor((Object)viewerSelection);
            code = WizardPageCode.HEADERPROCESSOR;
        }
        if (ActivityUtil.isActivity((Object)viewerSelection)) {
            currentActivity = (XMLActivity)viewerSelection;
        }
        if (ActivityUtil.isChildActivity((Object)currentActivity)) {
            currentActivity = ActivityUtil.getParentActivityFor((Object)currentActivity);
            if (code == null) {
                if (ActivityUtil.isActivity((Object)viewerSelection, (ActivityUtil.ActivityConstant)ActivityUtil.ActivityConstant.SEND)) {
                    code = WizardPageCode.SEND;
                }
                if (ActivityUtil.isActivity((Object)viewerSelection, (ActivityUtil.ActivityConstant)ActivityUtil.ActivityConstant.RECEIVE)) {
                    code = WizardPageCode.RECEIVE;
                }
            }
        }
        if (currentActivity != null) {
            ActivityUtil.ActivityConstant activityConstant = ActivityUtil.getActivityConstant((Object)currentActivity);
            int currentActivityIndex = this.getActivityIndex(this.fCurrentPartnerTrack, currentActivity);
            XMLActivity copiedActivity = (XMLActivity)currentActivity.copy();
            Wizard wizard = null;
            switch (activityConstant) {
                case SEND_ONLY: {
                    wizard = new SendOnlyWizard(this.getPage(), ActivityEditMode.EDIT, (XMLSendActivity)currentActivity);
                    break;
                }
                case RECEIVE_ONLY: {
                    wizard = new ReceiveOnlyWizard(this.getPage(), ActivityEditMode.EDIT, (XMLReceiveActivity)currentActivity);
                    break;
                }
                case SEND_RECEIVE_SYNC: {
                    wizard = new SendReceiveSyncActivityWizard(this.getPage(), ActivityEditMode.EDIT, (XMLTwoWayActivity)currentActivity);
                    break;
                }
                case RECEIVE_SEND_SYNC: {
                    wizard = new ReceiveSendSyncActivityWizard(this.getPage(), ActivityEditMode.EDIT, (XMLTwoWayActivity)currentActivity);
                    break;
                }
                case SEND_RECEIVE_ASYNC: {
                    wizard = new SendReceiveAsyncActivityWizard(this.getPage(), ActivityEditMode.EDIT, (XMLTwoWayActivity)currentActivity);
                    break;
                }
                case RECEIVE_SEND_ASYNC: {
                    wizard = new ReceiveSendAsyncActivityWizard(this.getPage(), ActivityEditMode.EDIT, (XMLTwoWayActivity)currentActivity);
                    break;
                }
                case WAIT: {
                    wizard = new WaitActivityWizard((XMLWaitActivity)currentActivity);
                }
            }
            if (wizard != null) {
                if (code != null) {
                    ((ActivityWizard)wizard).setStart(code);
                }
                if (this.openWizard((IWizard)wizard)) {
                    this.adjust(true);
                } else {
                    this.replaceActivity(this.fCurrentPartnerTrack, currentActivityIndex, activityConstant, copiedActivity);
                    this.getViewer().refresh();
                    this.getTreeViewer().expandAll();
                }
            }
        }
    }

    @Override
    protected void removePressed() {
        XMLReceiveActivity rcvOp;
        int index;
        XmlObject parent;
        XMLCondition cond;
        XmlCursor cursor;
        Object viewerSelection = this.getViewerSelection();
        if (ActivityUtil.isActivity((Object)viewerSelection)) {
            this.removeActivity(this.fCurrentPartnerTrack, viewerSelection);
        } else if (viewerSelection instanceof XMLMapping) {
            XMLActivity activity = ActivityUtil.getParentActivityFor((Object)viewerSelection);
            if (ActivityUtil.isTwoWayActivity((Object)activity)) {
                XMLTwoWayActivity op = (XMLTwoWayActivity)activity;
                op.unsetMapping();
            }
        } else if (viewerSelection instanceof XMLHeaderProcessor) {
            XMLActivity activity = ActivityUtil.getParentActivityFor((Object)viewerSelection);
            if (ActivityUtil.isTwoWayActivity((Object)activity)) {
                XMLTwoWayActivity op = (XMLTwoWayActivity)activity;
                op.unsetHeaderProcessor();
            }
        } else if (viewerSelection instanceof XMLCondition && (cursor = (cond = (XMLCondition)viewerSelection).newCursor()).toParent() && (parent = cursor.getObject()) instanceof XMLReceiveActivity && (index = ActivityUtil.getIndexFor((Object[])(rcvOp = (XMLReceiveActivity)parent).getConditionArray(), (Object)viewerSelection)) != -1) {
            rcvOp.removeCondition(index);
        }
        this.adjust(false);
    }

    @Override
    protected void upPressed() {
        XMLActivity activity;
        XmlCursor currentCursor;
        Object viewerSelection = this.getViewerSelection();
        if (ActivityUtil.isActivity((Object)viewerSelection) && (currentCursor = (activity = (XMLActivity)viewerSelection).newCursor()).toPrevSibling()) {
            activity.newCursor().moveXml(currentCursor);
            this.adjust(true);
        }
    }

    @Override
    protected void downPressed() {
        XMLActivity activity;
        XmlCursor currentCursor;
        Object viewerSelection = this.getViewerSelection();
        if (ActivityUtil.isActivity((Object)viewerSelection) && (currentCursor = (activity = (XMLActivity)viewerSelection).newCursor()).toNextSibling()) {
            currentCursor.moveXml(activity.newCursor());
            this.adjust(true);
        }
    }

    private void removeActivity(XMLTrack track, Object activity) {
        System.out.println("Removing activity " + activity);
        int index = this.getActivityIndex(track, activity);
        if (index != -1) {
            switch (ActivityUtil.getActivityConstant((Object)activity)) {
                case SEND_ONLY: {
                    this.fCurrentPartnerTrack.removeSendOnly(index);
                    break;
                }
                case RECEIVE_ONLY: {
                    this.fCurrentPartnerTrack.removeReceiveOnly(index);
                    break;
                }
                case SEND_RECEIVE_SYNC: {
                    this.fCurrentPartnerTrack.removeSendReceive(index);
                    break;
                }
                case RECEIVE_SEND_SYNC: {
                    this.fCurrentPartnerTrack.removeReceiveSend(index);
                    break;
                }
                case SEND_RECEIVE_ASYNC: {
                    this.fCurrentPartnerTrack.removeSendReceiveAsynchronous(index);
                    break;
                }
                case RECEIVE_SEND_ASYNC: {
                    this.fCurrentPartnerTrack.removeReceiveSendAsynchronous(index);
                    break;
                }
                case WAIT: {
                    System.out.println("Removing WAIT[" + index + "]");
                    this.fCurrentPartnerTrack.removeWait(index);
                }
            }
        }
    }

    private void replaceActivity(XMLTrack track, int index, ActivityUtil.ActivityConstant type, XMLActivity theReplacement) {
        if (index != -1) {
            switch (type) {
                case SEND_ONLY: {
                    this.fCurrentPartnerTrack.setSendOnlyArray(index, (XMLSendActivity)theReplacement);
                    break;
                }
                case RECEIVE_ONLY: {
                    this.fCurrentPartnerTrack.setReceiveOnlyArray(index, (XMLReceiveActivity)theReplacement);
                    break;
                }
                case SEND_RECEIVE_SYNC: {
                    this.fCurrentPartnerTrack.setSendReceiveArray(index, (XMLTwoWayActivity)theReplacement);
                    break;
                }
                case RECEIVE_SEND_SYNC: {
                    this.fCurrentPartnerTrack.setReceiveSendArray(index, (XMLTwoWayActivity)theReplacement);
                    break;
                }
                case SEND_RECEIVE_ASYNC: {
                    this.fCurrentPartnerTrack.setSendReceiveAsynchronousArray(index, (XMLTwoWayActivity)theReplacement);
                    break;
                }
                case RECEIVE_SEND_ASYNC: {
                    this.fCurrentPartnerTrack.setReceiveSendAsynchronousArray(index, (XMLTwoWayActivity)theReplacement);
                }
            }
        }
    }

    private int getActivityIndex(XMLTrack track, Object activity) {
        Object[] activities = null;
        switch (ActivityUtil.getActivityConstant((Object)activity)) {
            case SEND_ONLY: {
                activities = track.getSendOnlyArray();
                break;
            }
            case RECEIVE_ONLY: {
                activities = this.fCurrentPartnerTrack.getReceiveOnlyArray();
                break;
            }
            case SEND_RECEIVE_SYNC: {
                activities = this.fCurrentPartnerTrack.getSendReceiveArray();
                break;
            }
            case RECEIVE_SEND_SYNC: {
                activities = this.fCurrentPartnerTrack.getReceiveSendArray();
                break;
            }
            case SEND_RECEIVE_ASYNC: {
                activities = this.fCurrentPartnerTrack.getSendReceiveAsynchronousArray();
                break;
            }
            case RECEIVE_SEND_ASYNC: {
                activities = this.fCurrentPartnerTrack.getReceiveSendAsynchronousArray();
                break;
            }
            case WAIT: {
                activities = this.fCurrentPartnerTrack.getWaitArray();
                break;
            }
            default: {
                return -1;
            }
        }
        return ActivityUtil.getIndexFor((Object[])activities, (Object)activity);
    }

    @Override
    protected void addPressed() {
        FieldBasedInputDialog dialog = new FieldBasedInputDialog(this.getShell(), "Create a new activity");
        List topLevelActivities = ActivityUtil.getTopLevelActivities();
        String[] names = new String[topLevelActivities.size()];
        int i = 0;
        for (ActivityUtil.ActivityConstant constant : topLevelActivities) {
            names[i] = constant.getNiceName();
            ++i;
        }
        ListField nameField = new ListField(dialog, "Activity", null, names);
        nameField.setValidator(new DialogFieldValidator(){

            public String validate(String value) {
                if ("".equals(value)) {
                    return "Select an activity.";
                }
                return null;
            }
        });
        nameField.setLabelProvider(new ILabelProvider(){

            public Image getImage(Object element) {
                return ToolSupportActivator.getImage("img_activity");
            }

            public String getText(Object element) {
                return (String)element;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return true;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        dialog.addField((Field)nameField);
        if (dialog.open() != 0) {
            return;
        }
        String name = nameField.getSelection();
        if (name != null) {
            this.addActivity(ActivityUtil.ActivityConstant.getForNiceName((String)name));
        }
    }

    public void handleTrackSelection(XMLTrack selection) {
        this.fCurrentPartnerTrack = selection;
        this.setEnabled(BUTTON_ADD, true);
        this.setEnabled(BUTTON_EDIT, false);
        this.setEnabled(BUTTON_REMOVE, false);
        this.setEnabled("UP", false);
        this.setEnabled("DOWN", false);
        this.getViewer().setInput((Object)selection);
        this.getTreeViewer().expandToLevel(-1);
    }

    @Override
    protected void itemSelected(Object item) {
        if (item != null) {
            this.setEnabled(BUTTON_ADD, true);
            this.setEnabled(BUTTON_EDIT, true);
            this.setEnabled(BUTTON_REMOVE, this.getIsRemoveEnabled(item));
            if (ActivityUtil.isActivity((Object)item) && !ActivityUtil.isChildActivity((Object)item)) {
                this.setEnabled("UP", ActivityUtil.hasPrevious((XmlObject)((XMLActivity)item)));
                this.setEnabled("DOWN", ActivityUtil.hasNext((XmlObject)((XMLActivity)item)));
            } else {
                this.setEnabled("UP", false);
                this.setEnabled("DOWN", false);
            }
        }
    }

    public void refresh() {
        this.fCurrentPartnerTrack = null;
        this.getViewer().setInput(null);
        this.setEnabled(BUTTON_ADD, false);
        this.setEnabled(BUTTON_EDIT, false);
        this.setEnabled(BUTTON_REMOVE, false);
        this.setEnabled("UP", false);
        this.setEnabled("DOWN", false);
        super.refresh();
    }

    private void copyPressed() {
        Object viewerSelection = this.getViewerSelection();
        if (ActivityUtil.isActivity((Object)viewerSelection) && !ActivityUtil.isChildActivity((Object)viewerSelection)) {
            XMLActivity activity = (XMLActivity)viewerSelection;
            Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
            XmlOptions options = new XmlOptions();
            options.setSavePrettyPrint();
            options.setSaveOuter();
            Object[] o = new Object[]{activity.xmlText(options)};
            Transfer[] t = new Transfer[]{TextTransfer.getInstance()};
            clipboard.setContents(o, t);
            clipboard.dispose();
        }
    }

    private void pastePressed() {
        TextTransfer textTransfer;
        Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
        String textData = (String)clipboard.getContents((Transfer)(textTransfer = TextTransfer.getInstance()));
        if (textData != null) {
            try {
                XmlObject activity = XmlObject.Factory.parse((String)textData);
                activity.validate();
                XmlCursor cursor = activity.newCursor();
                if (cursor.toFirstChild()) {
                    XmlObject obj = cursor.getObject();
                    ActivityUtil.ActivityConstant type = ActivityUtil.getActivityConstant((Object)obj);
                    XMLActivity newOne = ActivityUtil.createNewTopLevelActivity((XMLTrack)this.fCurrentPartnerTrack, (ActivityUtil.ActivityConstant)type);
                    newOne.set(obj);
                    this.adjust(true);
                }
            }
            catch (XmlException xmlException) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"No activity in clipboard.");
            }
        }
        clipboard.dispose();
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        if (this.fCurrentPartnerTrack == null) {
            return;
        }
        ISelection selection = this.getViewer().getSelection();
        IStructuredSelection ssel = (IStructuredSelection)selection;
        boolean hasPaste = false;
        MenuManager newMenu = new MenuManager("&New Activity");
        if (ssel.size() == 0 || ssel.size() == 1 && ActivityUtil.isActivity((Object)ssel.getFirstElement()) && !ActivityUtil.isChildActivity((Object)ssel.getFirstElement())) {
            List topLevelActivities = ActivityUtil.getTopLevelActivities();
            for (final ActivityUtil.ActivityConstant constant : topLevelActivities) {
                this.createAction((IMenuManager)newMenu, constant.getNiceName(), new Action(){

                    public void run() {
                        ActivitySection.this.addActivity(constant);
                    }
                });
            }
        }
        manager.add((IContributionItem)newMenu);
        if (ssel.size() == 1) {
            Object object = ssel.getFirstElement();
            manager.add((IContributionItem)new Separator());
            if (ActivityUtil.isActivity((Object)ssel.getFirstElement()) && !ActivityUtil.isChildActivity((Object)ssel.getFirstElement())) {
                Action copyAction = new Action(){

                    public void run() {
                        ActivitySection.this.copyPressed();
                    }
                };
                copyAction.setText("&Copy");
                manager.add((IAction)copyAction);
                Action pasteAction = new Action(){

                    public void run() {
                        ActivitySection.this.pastePressed();
                    }
                };
                pasteAction.setText("&Paste");
                manager.add((IAction)pasteAction);
                hasPaste = true;
                manager.add((IContributionItem)new Separator());
            }
            Action editAction = new Action(){

                public void run() {
                    ActivitySection.this.editPressed();
                }
            };
            editAction.setText("&Edit");
            manager.add((IAction)editAction);
            editAction.setEnabled(true);
            manager.add((IContributionItem)new Separator());
            Action delAction = new Action(){

                public void run() {
                    ActivitySection.this.removePressed();
                }
            };
            delAction.setText("&Delete");
            manager.add((IAction)delAction);
            manager.add((IContributionItem)new Separator());
            delAction.setEnabled(this.getIsRemoveEnabled(object));
        }
        if (!hasPaste) {
            Action pasteAction = new Action(){

                public void run() {
                    ActivitySection.this.pastePressed();
                }
            };
            pasteAction.setText("&Paste");
            manager.add((IAction)pasteAction);
        }
    }

    private boolean getIsRemoveEnabled(Object object) {
        return !ActivityUtil.isChildActivity((Object)object);
    }

    private boolean openWizard(IWizard wizard) {
        WizardDialog dialog = new WizardDialog(this.getShell(), wizard);
        return dialog.open() == 0;
    }

    protected void addActivity(ActivityUtil.ActivityConstant constant) {
        XMLWaitActivity added = null;
        switch (constant) {
            case SEND_ONLY: {
                XMLSendActivity sendOp = this.fCurrentPartnerTrack.addNewSendOnly();
                sendOp.setService(new QName(""));
                sendOp.setPort("");
                sendOp.setOperation("");
                sendOp.addNewData();
                this.prefillDataIfOnlyOneChoiceExists((XMLSoapActivity)sendOp);
                SendOnlyWizard wiz = new SendOnlyWizard(this.getPage(), ActivityEditMode.ADD, sendOp);
                if (!this.openWizard((IWizard)wiz)) {
                    this.removeActivity(this.fCurrentPartnerTrack, sendOp);
                    break;
                }
                added = sendOp;
                break;
            }
            case RECEIVE_ONLY: {
                XMLReceiveActivity receiveOp = this.fCurrentPartnerTrack.addNewReceiveOnly();
                receiveOp.setService(new QName(""));
                receiveOp.setPort("");
                receiveOp.setOperation("");
                this.prefillDataIfOnlyOneChoiceExists((XMLSoapActivity)receiveOp);
                ReceiveOnlyWizard wiz = new ReceiveOnlyWizard(this.getPage(), ActivityEditMode.ADD, receiveOp);
                if (!this.openWizard((IWizard)wiz)) {
                    this.removeActivity(this.fCurrentPartnerTrack, receiveOp);
                    break;
                }
                added = receiveOp;
                break;
            }
            case SEND_RECEIVE_SYNC: {
                XMLTwoWayActivity sendRcvOp = this.fCurrentPartnerTrack.addNewSendReceive();
                this.initializeTwoWay(sendRcvOp);
                SendReceiveSyncActivityWizard wiz = new SendReceiveSyncActivityWizard(this.getPage(), ActivityEditMode.ADD, sendRcvOp);
                if (!this.openWizard((IWizard)wiz)) {
                    this.removeActivity(this.fCurrentPartnerTrack, sendRcvOp);
                    break;
                }
                added = sendRcvOp;
                break;
            }
            case RECEIVE_SEND_SYNC: {
                XMLTwoWayActivity rcvSendOp = this.fCurrentPartnerTrack.addNewReceiveSend();
                this.initializeTwoWay(rcvSendOp);
                ReceiveSendSyncActivityWizard wiz = new ReceiveSendSyncActivityWizard(this.getPage(), ActivityEditMode.ADD, rcvSendOp);
                if (!this.openWizard((IWizard)wiz)) {
                    this.removeActivity(this.fCurrentPartnerTrack, rcvSendOp);
                    break;
                }
                added = rcvSendOp;
                break;
            }
            case SEND_RECEIVE_ASYNC: {
                XMLTwoWayActivity sendRcvOp = this.fCurrentPartnerTrack.addNewSendReceiveAsynchronous();
                this.initializeTwoWay(sendRcvOp);
                SendReceiveAsyncActivityWizard wiz = new SendReceiveAsyncActivityWizard(this.getPage(), ActivityEditMode.ADD, sendRcvOp);
                if (!this.openWizard((IWizard)wiz)) {
                    this.removeActivity(this.fCurrentPartnerTrack, sendRcvOp);
                    break;
                }
                added = sendRcvOp;
                break;
            }
            case RECEIVE_SEND_ASYNC: {
                XMLTwoWayActivity sendRcvOp = this.fCurrentPartnerTrack.addNewReceiveSendAsynchronous();
                this.initializeTwoWay(sendRcvOp);
                ReceiveSendAsyncActivityWizard wiz = new ReceiveSendAsyncActivityWizard(this.getPage(), ActivityEditMode.ADD, sendRcvOp);
                if (!this.openWizard((IWizard)wiz)) {
                    this.removeActivity(this.fCurrentPartnerTrack, sendRcvOp);
                    break;
                }
                added = sendRcvOp;
                break;
            }
            case WAIT: {
                XMLWaitActivity waitAct = this.fCurrentPartnerTrack.addNewWait();
                this.initializeWait(waitAct);
                WaitActivityWizard wiz = new WaitActivityWizard(waitAct);
                if (!this.openWizard((IWizard)wiz)) {
                    this.removeActivity(this.fCurrentPartnerTrack, waitAct);
                    break;
                }
                added = waitAct;
            }
        }
        if (added != null) {
            this.adjust(false);
            this.getTreeViewer().expandToLevel(added, -1);
            this.getTreeViewer().setSelection((ISelection)new StructuredSelection(added));
        }
    }

    private void initializeWait(XMLWaitActivity waitAct) {
        waitAct.setWaitForMilliseconds(1000L);
    }

    private void prefillDataIfOnlyOneChoiceExists(XMLSoapActivity operation) {
        XMLTrack track = ActivityUtil.getEnclosingTrack((XMLActivity)operation);
        if (track == null) {
            return;
        }
        try {
            Definition wsdlForPartner = this.getEditor().getWsdlForPartner(track);
            if (wsdlForPartner == null) {
                return;
            }
            Map services = wsdlForPartner.getServices();
            if (services.size() == 1) {
                Service service = (Service)services.values().iterator().next();
                operation.setService(service.getQName());
                Map ports = service.getPorts();
                if (ports.size() == 1) {
                    Port port = (Port)ports.values().iterator().next();
                    operation.setPort(port.getName());
                    List operations = port.getBinding().getPortType().getOperations();
                    if (operations.size() == 1) {
                        operation.setOperation(((Operation)operations.get(0)).getName());
                    }
                }
            }
        }
        catch (WSDLReadingException wSDLReadingException) {}
    }

    private void initializeTwoWay(XMLTwoWayActivity sendRcvOp) {
        if (sendRcvOp == null) {
            return;
        }
        sendRcvOp.setService(new QName(""));
        sendRcvOp.setPort("");
        sendRcvOp.setOperation("");
        XMLSendActivity sendOp = sendRcvOp.addNewSend();
        sendOp.addNewData();
        XMLReceiveActivity recvOp = sendRcvOp.addNewReceive();
        this.prefillDataIfOnlyOneChoiceExists((XMLSoapActivity)sendRcvOp);
        this.prefillDataIfOnlyOneChoiceExists((XMLSoapActivity)sendOp);
        this.prefillDataIfOnlyOneChoiceExists((XMLSoapActivity)recvOp);
    }

    @Override
    protected void handleKeyPressed(KeyEvent event) {
        super.handleKeyPressed(event);
        if (event.keyCode == 262144) {
            this.fCtrlDown = true;
        }
        if (event.keyCode == 99 && this.fCtrlDown) {
            this.copyPressed();
        }
        if (event.keyCode == 118 && this.fCtrlDown) {
            this.pastePressed();
        }
    }

    @Override
    protected void handleKeyReleased(KeyEvent event) {
        super.handleKeyReleased(event);
        if (event.keyCode == 262144) {
            this.fCtrlDown = false;
        }
    }

    private void adjust(boolean expand) {
        this.getViewer().refresh();
        if (expand) {
            this.getTreeViewer().expandAll();
        }
        this.markDirty();
    }

    private class ActivityContentProvider
    implements ITreeContentProvider {
        private ActivityContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof XMLTrack) {
                return ActivityUtil.getActivities((XMLTrack)((XMLTrack)inputElement)).toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof XMLActivity) {
                XMLActivity activity = (XMLActivity)parentElement;
                if (activity instanceof XMLReceiveActivity) {
                    XMLReceiveActivity rcvOp = (XMLReceiveActivity)activity;
                    return rcvOp.getConditionArray();
                }
                if (activity instanceof XMLWaitActivity) {
                    XMLWaitActivity waitAct = (XMLWaitActivity)activity;
                    return new Object[]{"Duration: " + waitAct.getWaitForMilliseconds() + "ms"};
                }
                if (ActivityUtil.isTwoWayActivity((Object)activity)) {
                    XMLTwoWayActivity twoWayActivity = (XMLTwoWayActivity)activity;
                    ArrayList<Object> moreActivities = new ArrayList<Object>();
                    if (ActivityUtil.isReceiveFirstActivity((XMLActivity)activity)) {
                        moreActivities.add(twoWayActivity.getReceive());
                        moreActivities.add(twoWayActivity.getSend());
                    } else {
                        moreActivities.add(twoWayActivity.getSend());
                        moreActivities.add(twoWayActivity.getReceive());
                    }
                    if (twoWayActivity.getMapping() != null) {
                        moreActivities.add(twoWayActivity.getMapping());
                    }
                    if (twoWayActivity.getHeaderProcessor() != null) {
                        moreActivities.add(twoWayActivity.getHeaderProcessor());
                    }
                    return moreActivities.toArray();
                }
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof XMLTwoWayActivity || element instanceof XMLWaitActivity) {
                return true;
            }
            if (element instanceof XMLReceiveActivity) {
                return ((XMLReceiveActivity)element).getConditionArray().length > 0;
            }
            return false;
        }
    }

    private class ActivityLabelProvider
    implements ILabelProvider {
        private ActivityLabelProvider() {
        }

        public Image getImage(Object element) {
            return ToolSupportActivator.getImage("img_activity");
        }

        public String getText(Object element) {
            if (ActivityUtil.isActivity((Object)element)) {
                return ActivityUtil.getNiceName((Object)element);
            }
            if (element instanceof XMLMapping) {
                return "Data Copy";
            }
            if (element instanceof XMLHeaderProcessor) {
                return "Header Processor (" + ((XMLHeaderProcessor)element).getName() + ")";
            }
            if (element instanceof XMLCondition) {
                return "Condition (" + StringUtils.abbreviate((String)BPELUnitUtil.removeSpaceLineBreaks((String)((XMLCondition)element).getExpression()), (int)100) + ")";
            }
            if (element != null) {
                return element.toString();
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

