/*
 * Decompiled with CFR 0.152.
 */
package net.bpelunit.toolsupport.editors;

import net.bpelunit.framework.xml.suite.XMLTrack;
import net.bpelunit.toolsupport.editors.BPELUnitEditor;
import net.bpelunit.toolsupport.editors.sections.ActivitySection;
import net.bpelunit.toolsupport.editors.sections.PUTSection;
import net.bpelunit.toolsupport.editors.sections.PartnerSection;
import net.bpelunit.toolsupport.editors.sections.TestCaseAndTrackSection;
import net.bpelunit.toolsupport.editors.sections.TestSuiteSection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class TestSuitePage
extends FormPage {
    private TestSuiteSection fGeneralSection;
    private PUTSection fPUTSection;
    private PartnerSection fPartnerSection;
    private ActivitySection fTrackSection;
    private TestCaseAndTrackSection fTestCaseAndTrackSection;

    public TestSuitePage(BPELUnitEditor editor, String id, String title) {
        super((FormEditor)editor, id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.setText("Test Suite");
        this.fillBody(managedForm, toolkit);
        managedForm.refresh();
    }

    private void fillBody(IManagedForm managedForm, FormToolkit toolkit) {
        GridLayout layout = new GridLayout();
        Composite body = managedForm.getForm().getBody();
        layout.numColumns = 2;
        layout.marginWidth = 10;
        layout.horizontalSpacing = 15;
        layout.verticalSpacing = 10;
        layout.makeColumnsEqualWidth = true;
        body.setLayout((Layout)layout);
        this.createTestSuiteSection(managedForm, toolkit, body);
        this.createPartnerSection(managedForm, toolkit, body);
        this.createPUTSection(managedForm, toolkit, body);
        this.createTestCaseSection(managedForm, toolkit, body);
        this.createActivitySection(managedForm, toolkit, body);
    }

    private void createTestSuiteSection(IManagedForm managedForm, FormToolkit toolkit, Composite body) {
        this.fGeneralSection = new TestSuiteSection(body, this, toolkit, 384);
        managedForm.addPart((IFormPart)this.fGeneralSection);
    }

    private void createPUTSection(IManagedForm managedForm, FormToolkit toolkit, Composite body) {
        this.fPUTSection = new PUTSection(body, this, toolkit, 384);
        managedForm.addPart((IFormPart)this.fPUTSection);
    }

    private void createPartnerSection(IManagedForm managedForm, FormToolkit toolkit, Composite body) {
        this.fPartnerSection = new PartnerSection(body, this, toolkit);
        managedForm.addPart((IFormPart)this.fPartnerSection);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.verticalSpan = 2;
        this.fPartnerSection.getSection().setLayoutData((Object)gridData);
    }

    private void createTestCaseSection(IManagedForm managedForm, FormToolkit toolkit, Composite parent) {
        this.fTestCaseAndTrackSection = new TestCaseAndTrackSection(parent, this, toolkit);
        managedForm.addPart((IFormPart)this.fTestCaseAndTrackSection);
    }

    private void createActivitySection(IManagedForm managedForm, FormToolkit toolkit, Composite parent) {
        this.fTrackSection = new ActivitySection(parent, this, toolkit);
        managedForm.addPart((IFormPart)this.fTrackSection);
    }

    public BPELUnitEditor getSuiteEditor() {
        return (BPELUnitEditor)this.getEditor();
    }

    public void postTrackSelected(XMLTrack selection) {
        this.fTrackSection.handleTrackSelection(selection);
    }

    public void markDirty() {
        this.fGeneralSection.markDirty();
    }
}

