/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.service;

import net.blugrid.core.model.Token;
import net.blugrid.service.WebscaperConnector;
import org.apache.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

@Service
public class WebscaperConnectorImpl
implements WebscaperConnector {
    private static final Logger logger = Logger.getLogger(WebscaperConnectorImpl.class);
    private static final String BASE_URL = "http://localhost:8080/v2.0/";

    @Override
    public String getEmailDocument(Token token, String baseuri, String staticbaseuri, String emailurl) {
        String response = new String();
        RestTemplate template = new RestTemplate();
        String url = "http://localhost:8080/v2.0/web-scraper/email";
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)url).queryParam("baseuri", new Object[]{baseuri}).queryParam("staticbaseuri", new Object[]{staticbaseuri}).queryParam("url", new Object[]{emailurl});
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", token.getJwttoken());
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        try {
            logger.info((Object)("Web scraper url:  " + url));
            ResponseEntity restResponse = template.exchange(uriBuilder.build().encode().toUri(), HttpMethod.GET, requestEntity, String.class);
            logger.info((Object)("web-scraper response: " + restResponse.getStatusCode()));
            response = (String)restResponse.getBody();
        }
        catch (HttpClientErrorException e) {
            logger.error((Object)(e.getStatusCode().toString() + ": " + e.getResponseBodyAsString()));
        }
        catch (RestClientException e) {
            logger.error((Object)e.toString());
        }
        catch (Exception e) {
            logger.error((Object)e.toString());
        }
        return response;
    }

    @Override
    public String getWebPageDocument(Token token, String baseuri, String staticbaseuri, String webpageurl) {
        String response = new String();
        RestTemplate template = new RestTemplate();
        String url = "http://localhost:8080/v2.0/web-scraper/webpage";
        UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromHttpUrl((String)url).queryParam("baseuri", new Object[]{baseuri}).queryParam("staticbaseuri", new Object[]{staticbaseuri}).queryParam("url", new Object[]{webpageurl});
        HttpHeaders headers = new HttpHeaders();
        headers.add("Authorization", token.getJwttoken());
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        try {
            logger.info((Object)("Web scaper request:  " + uriBuilder.build().encode().toUri()));
            ResponseEntity restResponse = template.exchange(uriBuilder.build().encode().toUri(), HttpMethod.GET, requestEntity, String.class);
            logger.info((Object)("web-scraper response: " + restResponse.getStatusCode()));
            response = (String)restResponse.getBody();
        }
        catch (HttpClientErrorException e) {
            logger.error((Object)(e.getStatusCode().toString() + ": " + e.getResponseBodyAsString()));
        }
        catch (RestClientException e) {
            logger.error((Object)e.toString());
        }
        catch (Exception e) {
            logger.error((Object)e.toString());
        }
        return response;
    }
}

