/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.service;

import java.util.ArrayList;
import java.util.UUID;
import net.blugrid.core.model.Item;
import net.blugrid.core.model.MessageInstance;
import net.blugrid.core.model.Party;
import net.blugrid.core.model.RetailTransaction;
import net.blugrid.core.model.SaleReturnLineItem;
import net.blugrid.core.model.Token;
import net.blugrid.service.EventService;
import net.blugrid.service.TransactionService;
import net.blugrid.service.WebMailerConnector;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TransactionServiceImpl
implements TransactionService {
    private static final Logger logger = Logger.getLogger(TransactionServiceImpl.class);
    @Autowired
    private EventService Eventservice;
    @Autowired
    private WebMailerConnector WebMailerconnector;

    @Override
    public void afterCloseRetailTransaction(Token token, RetailTransaction transaction) {
        for (int i = 0; i < transaction.getSalereturnlineitems().size(); ++i) {
            Item item;
            if (((SaleReturnLineItem)transaction.getSalereturnlineitems().get(i)).getItem() == null || !(item = ((SaleReturnLineItem)transaction.getSalereturnlineitems().get(i)).getItem()).getTypecode().equalsIgnoreCase("EventTicket") || item.getEventticket() == null) continue;
            UUID eventuuid = item.getEventticket().getEventuuid();
            this.Eventservice.sendSignUpMessage(token, eventuuid, transaction.getCustomer());
        }
        this.sendRetailTransactionInvoice(token, transaction);
    }

    @Override
    public void sendRetailTransactionInvoice(Token token, RetailTransaction transaction) {
        if (transaction.getSession().getDevice().getInvoiceemail() != null) {
            Party party = transaction.getCustomer();
            MessageInstance messageisntance = new MessageInstance();
            messageisntance.setRecipient(party);
            messageisntance.setMessageuuid(transaction.getSession().getDevice().getInvoiceemail().getMessageuuid());
            messageisntance.setTransactionuuid(transaction.getTransactionuuid());
            ArrayList<MessageInstance> messageinstances = new ArrayList<MessageInstance>();
            messageinstances.add(messageisntance);
            this.WebMailerconnector.sendEmail(token, transaction.getSession().getDevice().getInvoiceemail().getMessageuuid());
        }
    }
}

