/*
 * Decompiled with CFR 0.152.
 */
package net.blugrid.service;

import com.stripe.Stripe;
import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Account;
import com.stripe.model.Charge;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import net.blugrid.core.model.PaymentAuthorization;
import net.blugrid.core.model.PaymentAuthorizationResponse;
import net.blugrid.core.model.StripeAccount;
import net.blugrid.core.model.StripeAccountResponse;
import net.blugrid.service.StripeApi;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Repository;

@Repository
public class StripeApiImpl
implements StripeApi {
    private static final Logger logger = Logger.getLogger(StripeApiImpl.class);
    private static String apikey = "sk_live_Nw0feIiV5NIIsTZBpzsUMIlm";

    @Override
    public Account getAccountDetails(String account_id) {
        Stripe.apiKey = apikey;
        Account account = null;
        try {
            account = Account.retrieve((String)account_id);
        }
        catch (AuthenticationException ex) {
            logger.error((Object)ex);
        }
        catch (InvalidRequestException ex) {
            logger.error((Object)ex);
        }
        catch (APIConnectionException ex) {
            logger.error((Object)ex);
        }
        catch (CardException ex) {
            logger.error((Object)ex);
        }
        catch (APIException ex) {
            logger.error((Object)ex);
        }
        return account;
    }

    @Override
    public StripeAccountResponse createAccount(StripeAccount stripeaccount) {
        Stripe.apiKey = apikey;
        Map<String, Object> accountParams = this.setAccountParams(stripeaccount.getAccount());
        StripeAccountResponse response = new StripeAccountResponse();
        response.setStripeaccount(stripeaccount);
        try {
            response.getStripeaccount().setAccount(Account.create(accountParams));
            response.setStatus("OK");
        }
        catch (AuthenticationException ex) {
            logger.error((Object)ex);
            response.setStatus("Error");
            response.setSource("Stripe Api");
            response.setMessage("Authentication Error - " + ex.getMessage());
        }
        catch (InvalidRequestException ex) {
            logger.error((Object)ex);
            response.setStatus("Error");
            response.setSource("Stripe Api");
            response.setMessage("Invalid Request - " + ex.getMessage());
        }
        catch (APIConnectionException ex) {
            logger.error((Object)ex);
            response.setStatus("Error");
            response.setSource("Stripe Api");
            response.setMessage(ex.getMessage());
        }
        catch (CardException ex) {
            logger.error((Object)ex);
            response.setStatus("Error");
            response.setSource("Stripe Api");
            response.setMessage("Card " + ex.getCode() + " - " + ex.getMessage());
        }
        catch (APIException ex) {
            logger.error((Object)ex);
            response.setStatus("Error");
            response.setSource("Stripe Api");
            response.setMessage("API exception - " + ex.getMessage());
        }
        return response;
    }

    @Override
    public StripeAccountResponse udpateAccount(StripeAccount stripeaccount) {
        Stripe.apiKey = stripeaccount.getAccount().getKeys().getSecret();
        Map<String, Object> accountParams = this.setAccountParams(stripeaccount.getAccount());
        StripeAccountResponse response = new StripeAccountResponse();
        response.setStripeaccount(stripeaccount);
        try {
            Account oldaccount = Account.retrieve((String)stripeaccount.getAccount().getId());
            response.getStripeaccount().setAccount(oldaccount.update(accountParams));
            response.setStatus("OK");
        }
        catch (AuthenticationException ex) {
            logger.error((Object)ex);
            response.setStatus("Error");
            response.setSource("Stripe Api");
            response.setMessage("Authentication Error - " + ex.getMessage());
        }
        catch (InvalidRequestException ex) {
            logger.error((Object)ex);
            response.setStatus("Error");
            response.setSource("Stripe Api");
            response.setMessage("Invalid Request - " + ex.getMessage());
        }
        catch (APIConnectionException ex) {
            logger.error((Object)ex);
            response.setStatus("Error");
            response.setSource("Stripe Api");
            response.setMessage(ex.getMessage());
        }
        catch (CardException ex) {
            logger.error((Object)ex);
            response.setStatus("Error");
            response.setSource("Stripe Api");
            response.setMessage("Card " + ex.getCode() + " - " + ex.getMessage());
        }
        catch (APIException ex) {
            logger.error((Object)ex);
            response.setStatus("Error");
            response.setSource("Stripe Api");
            response.setMessage("API exception - " + ex.getMessage());
        }
        return response;
    }

    private Map<String, Object> setAccountParams(Account account) {
        HashMap<String, Object> accountParams = new HashMap<String, Object>();
        accountParams.put("managed", false);
        accountParams.put("business_name", account.getBusinessName());
        accountParams.put("business_url", account.getBusinessUrl());
        accountParams.put("email", account.getEmail());
        accountParams.put("default_currency", account.getDefaultCurrency());
        accountParams.put("country", account.getCountry());
        accountParams.put("statement_descriptor", account.getStatementDescriptor());
        return accountParams;
    }

    @Override
    public PaymentAuthorizationResponse createCharge(PaymentAuthorization paymentauth) {
        Stripe.apiKey = paymentauth.getPaymentprocessoraccount().getAccount().getKeys().getSecret();
        HashMap<String, Object> chargeParams = new HashMap<String, Object>();
        BigInteger amountrequest = paymentauth.getRequestedamount().multiply(new BigDecimal(100)).toBigInteger();
        chargeParams.put("amount", amountrequest);
        chargeParams.put("currency", "aud");
        chargeParams.put("source", paymentauth.getToken());
        PaymentAuthorizationResponse response = new PaymentAuthorizationResponse();
        response.setPaymentauthorization(paymentauth);
        try {
            Charge charge = Charge.create(chargeParams);
            logger.info((Object)("Stripe Charge successful. Chrage ID: " + charge.getId()));
            response.setStatus("OK");
            if (charge.getStatus().contentEquals("succeeded")) {
                response.getPaymentauthorization().setSuccessflag(Boolean.valueOf(true));
            } else {
                response.getPaymentauthorization().setSuccessflag(Boolean.valueOf(false));
            }
            BigDecimal amountcharged = new BigDecimal(charge.getAmount().toString());
            amountcharged.divide(new BigDecimal(100));
            BigDecimal amountrefunded = new BigDecimal(charge.getAmountRefunded().toString());
            amountrefunded.divide(new BigDecimal(100));
            response.getPaymentauthorization().setAmountcharged(amountcharged);
            response.getPaymentauthorization().setAmountrefunded(amountrefunded);
            response.getPaymentauthorization().setCaptured(charge.getCaptured());
            response.getPaymentauthorization().setResponsedata((Object)charge);
        }
        catch (AuthenticationException ex) {
            logger.error((Object)ex);
            response.setStatus("Error");
            response.setSource("Stripe Api");
            response.setMessage("Authentication Error - " + ex.getMessage());
        }
        catch (InvalidRequestException ex) {
            logger.error((Object)ex);
            response.setStatus("Error");
            response.setSource("Stripe Api");
            response.setMessage("Invalid Request - " + ex.getMessage());
        }
        catch (APIConnectionException ex) {
            logger.error((Object)ex);
            response.setStatus("Error");
            response.setSource("Stripe Api");
            response.setMessage(ex.getMessage());
        }
        catch (CardException ex) {
            logger.error((Object)ex);
            response.setStatus("Error");
            response.setSource("Stripe Api");
            response.setMessage("Card " + ex.getCode() + " - " + ex.getMessage());
            response.getPaymentauthorization().setSuccessflag(Boolean.valueOf(false));
            if (ex.getCharge() != null) {
                response.getPaymentauthorization().setAmountcharged(BigDecimal.ZERO);
                response.getPaymentauthorization().setAmountrefunded(BigDecimal.ZERO);
                response.getPaymentauthorization().setCaptured(Boolean.valueOf(false));
                response.getPaymentauthorization().setResponsedata((Object)ex);
            }
        }
        catch (APIException ex) {
            logger.error((Object)ex);
            response.setStatus("Error");
            response.setSource("Stripe Api");
            response.setMessage("API exception - " + ex.getMessage());
        }
        return response;
    }
}

