/*
 * Decompiled with CFR 0.152.
 */
package net.bican.wordpress;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import net.bican.wordpress.Author;
import net.bican.wordpress.Comment;
import net.bican.wordpress.CommentCount;
import net.bican.wordpress.CommentStatusList;
import net.bican.wordpress.FilterPost;
import net.bican.wordpress.FilterUser;
import net.bican.wordpress.MediaItemUploadResult;
import net.bican.wordpress.Post;
import net.bican.wordpress.Term;
import net.bican.wordpress.User;
import net.bican.wordpress.Wordpress;
import net.bican.wordpress.XmlRpcMapped;
import net.bican.wordpress.configuration.WpCliConfiguration;
import net.bican.wordpress.exceptions.FileUploadException;
import net.bican.wordpress.exceptions.InsufficientRightsException;
import net.bican.wordpress.exceptions.InvalidArgumentsException;
import net.bican.wordpress.exceptions.InvalidPostFormatException;
import net.bican.wordpress.exceptions.ObjectNotFoundException;
import net.bican.wordpress.util.StringHeader;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import redstone.xmlrpc.XmlRpcFault;

public class Main {
    private static void delete(Options options, WpCliConfiguration config, Wordpress wp, String opt, boolean deletePage) throws XmlRpcFault, InsufficientRightsException, ObjectNotFoundException {
        Integer post_ID = Main.getInteger(opt, config);
        if (post_ID != null) {
            System.out.println(wp.deletePost(post_ID));
        } else {
            Main.showHelp(options);
        }
    }

    private static void deleteComment(Wordpress wp, int commentID) throws XmlRpcFault, InsufficientRightsException, ObjectNotFoundException {
        boolean result = wp.deleteComment(commentID);
        if (result) {
            System.out.println("Comment deleted.");
        } else {
            System.out.println("Comment not deleted");
        }
    }

    private static void edit(Options options, WpCliConfiguration config, Wordpress wp, String opt, boolean isPage) throws IOException, InvalidPostFormatException, XmlRpcFault, InsufficientRightsException, InvalidArgumentsException, ObjectNotFoundException {
        Integer post_ID = Main.getInteger("postid", config);
        Post post = Post.fromFile(new File(config.getOptionValue(opt)));
        if (post_ID != null) {
            System.out.println(wp.editPost(post_ID, post));
        } else {
            Main.showHelp(options);
        }
    }

    private static void editComment(Wordpress wp, String fileName, String operation) throws XmlRpcFault, FileNotFoundException, IOException, InvalidPostFormatException, InsufficientRightsException, ObjectNotFoundException, InvalidArgumentsException {
        Comment comment = Comment.fromFile(new File(fileName));
        System.err.println(comment.getPost_id());
        System.err.println(comment.getContent());
        if (operation.equals("newcomment")) {
            Integer r = wp.newComment(comment.getPost_id(), comment.getParent(), comment.getContent(), comment.getAuthor(), comment.getAuthor_url(), comment.getAuthor_email());
            System.err.println("Comment ID: " + r);
        } else if (operation.equals("editcomment")) {
            Boolean r = wp.editComment(comment);
            if (r.booleanValue()) {
                System.err.println("Comment edited.");
            } else {
                System.err.println("Comment not edited.");
            }
        }
    }

    private static Integer getInteger(String c, WpCliConfiguration config) {
        Integer post_ID = null;
        try {
            post_ID = Integer.valueOf(config.getOptionValue(c));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return post_ID;
    }

    public static void main(String[] args) throws ParseException, InsufficientRightsException, InvalidArgumentsException, ObjectNotFoundException, FileUploadException {
        block50: {
            try {
                Options options = new Options();
                options.addOption("?", "help", false, "Print usage information");
                options.addOption("h", "url", true, "Specify the url to xmlrpc.php");
                options.addOption("u", "user", true, "User name");
                options.addOption("p", "pass", true, "Password");
                options.addOption("a", "authors", false, "Get author list");
                options.addOption("s", "slug", true, "Slug for categories");
                options.addOption("pi", "parentid", true, "Parent id for categories");
                options.addOption("oi", "postid", true, "Post id for posts");
                options.addOption("c", "categories", false, "Get category list");
                options.addOption("cn", "newcategory", true, "New category (uses --slug and --parentid)");
                options.addOption("cr", "deletecategory", true, "Delete category <category_id>");
                options.addOption("us", "userinfo", false, "Get user information");
                options.addOption("or", "recentposts", true, "Get recent posts");
                options.addOption("os", "getpost", true, "Get post");
                options.addOption("on", "newpost", true, "New post from file <arg>");
                options.addOption("oe", "editpost", true, "Edit post (needs --postid)");
                options.addOption("od", "deletepost", true, "Delete post");
                options.addOption("mn", "newmedia", true, "New media file (uses --overwrite)");
                options.addOption("ov", "overwrite", false, "Allow overwrite in uploading new media");
                options.addOption("so", "supportedstatus", false, "Print supported post status values");
                options.addOption("cs", "commentstatus", false, "Print comment status names for the blog");
                options.addOption("cc", "commentcount", true, "Get comment count for a post (-1 for all posts)");
                options.addOption("ca", "newcomment", true, "New comment from file");
                options.addOption("cd", "deletecomment", true, "Delete comment");
                options.addOption("ce", "editcomment", true, "Edit comment from file");
                options.addOption("cg", "getcomment", true, "Get comment");
                options.addOption("ct", "getcomments", true, "Get comments for the post");
                options.addOption("cs", "commentstatus", true, "Comment status (for --getcomments)");
                options.addOption("co", "commentoffset", true, "Comment offset # (for --getcomments)");
                options.addOption("cm", "commentnumber", true, "Comment # (for --getcomments)");
                try {
                    WpCliConfiguration config = new WpCliConfiguration(args, options, Main.class);
                    if (config.hasOption("help")) {
                        Main.showHelp(options);
                        break block50;
                    }
                    if (!(config.hasOption("url") && config.hasOption("user") && config.hasOption("pass"))) {
                        System.err.println("Specify --user, --pass and --url");
                        break block50;
                    }
                    try {
                        Wordpress wp = new Wordpress(config.getOptionValue("user"), config.getOptionValue("pass"), config.getOptionValue("url"));
                        if (config.hasOption("authors")) {
                            Main.printList(wp.getAuthors(), Author.class, true);
                            break block50;
                        }
                        if (config.hasOption("categories")) {
                            Main.printList(wp.getTerms("category"), Term.class, true);
                            break block50;
                        }
                        if (config.hasOption("deletecategory")) {
                            Integer category_id = Integer.valueOf(config.getOptionValue("deletecategory"));
                            boolean r = wp.deleteTerm("category", category_id);
                            System.out.println(r);
                            break block50;
                        }
                        if (config.hasOption("newcategory")) {
                            String slug = config.getOptionValue("slug");
                            Integer parentId = Main.getInteger("parentid", config);
                            if (slug == null) {
                                slug = "";
                            }
                            if (parentId == null) {
                                parentId = 0;
                            }
                            Term term = Term.builder().slug(slug).parent(parentId).name(config.getOptionValue("newcategory")).build();
                            System.out.println(wp.newTerm(term));
                            break block50;
                        }
                        if (config.hasOption("userinfo")) {
                            FilterUser filter = new FilterUser();
                            filter.setWho(config.getOptionValue("user"));
                            Main.printItem(wp.getUsers(filter).get(0), User.class);
                            break block50;
                        }
                        if (config.hasOption("recentposts")) {
                            FilterPost filter = new FilterPost();
                            filter.setNumber(Main.getInteger("recentposts", config));
                            Main.printList(wp.getPosts(filter), Post.class, false);
                            break block50;
                        }
                        if (config.hasOption("getpost")) {
                            Main.printItem(wp.getPost(Main.getInteger("getpost", config)), Post.class);
                            break block50;
                        }
                        if (config.hasOption("editpost")) {
                            Main.edit(options, config, wp, "editpost", false);
                            break block50;
                        }
                        if (config.hasOption("deletepost")) {
                            Main.delete(options, config, wp, "deletepost", false);
                            break block50;
                        }
                        if (config.hasOption("newpost")) {
                            System.out.println(wp.newPost(Post.fromFile(new File(config.getOptionValue("newpost")))));
                            break block50;
                        }
                        if (config.hasOption("newmedia")) {
                            String fileName = config.getOptionValue("newmedia");
                            File file = new File(fileName);
                            Boolean overwrite = Boolean.FALSE;
                            if (config.hasOption("overwrite")) {
                                overwrite = Boolean.TRUE;
                            }
                            try (FileInputStream fis = new FileInputStream(file);){
                                MediaItemUploadResult result = wp.uploadFile(fis, fileName, overwrite);
                                if (result != null) {
                                    System.out.println(result);
                                }
                                break block50;
                            }
                        }
                        if (config.hasOption("supportedstatus")) {
                            System.out.println("Recognized status values for posts:");
                            Map<String, String> psl = wp.getPostStatusList();
                            for (String k : psl.keySet()) {
                                System.out.println(k + " : " + psl.get(k));
                            }
                            break block50;
                        }
                        if (config.hasOption("commentstatus")) {
                            Main.showCommentStatus(wp);
                            break block50;
                        }
                        if (config.hasOption("commentcount")) {
                            Main.showCommentCount(config, wp);
                            break block50;
                        }
                        if (config.hasOption("newcomment")) {
                            Main.editComment(wp, config.getOptionValue("newcomment"), "newcomment");
                            break block50;
                        }
                        if (config.hasOption("editcomment")) {
                            Main.editComment(wp, config.getOptionValue("editcomment"), "editcomment");
                            break block50;
                        }
                        if (config.hasOption("deletecomment")) {
                            System.err.println(Integer.valueOf(config.getOptionValue("deletecomment")));
                            Main.deleteComment(wp, Integer.valueOf(config.getOptionValue("deletecomment")));
                            break block50;
                        }
                        if (config.hasOption("getcomment")) {
                            Main.printComment(wp, Integer.valueOf(config.getOptionValue("getcomment")));
                            break block50;
                        }
                        if (config.hasOption("getcomments")) {
                            Integer commentNumber;
                            Integer commentOffset;
                            Integer postID = Integer.valueOf(config.getOptionValue("getcomments"));
                            String commentStatus = config.getOptionValue("commentstatus");
                            try {
                                commentOffset = Integer.valueOf(config.getOptionValue("commentoffset"));
                            }
                            catch (NumberFormatException e) {
                                commentOffset = null;
                            }
                            try {
                                commentNumber = Integer.valueOf(config.getOptionValue("commentnumber"));
                            }
                            catch (Exception e) {
                                commentNumber = null;
                            }
                            Main.printComments(wp, postID, commentStatus, commentOffset, commentNumber);
                            break block50;
                        }
                        Main.showHelp(options);
                    }
                    catch (MalformedURLException e) {
                        System.err.println("URL \"" + config.getOptionValue("url") + "\" is invalid, reason is: " + e.getLocalizedMessage());
                    }
                    catch (IOException e) {
                        System.err.println("Can't read from file, reason is: " + e.getLocalizedMessage());
                    }
                    catch (InvalidPostFormatException e) {
                        System.err.println("Input format is invalid.");
                    }
                }
                catch (ParseException e) {
                    System.err.println("Can't process command line arguments, reason is: " + e.getLocalizedMessage());
                }
            }
            catch (XmlRpcFault e) {
                String reason = e.getLocalizedMessage();
                System.err.println("Operation failed, reason is: " + reason);
            }
        }
    }

    private static void printComment(Wordpress wp, Integer commentID) throws XmlRpcFault, InsufficientRightsException, ObjectNotFoundException {
        Comment r = wp.getComment(commentID);
        System.out.println(r);
    }

    private static void printComments(Wordpress wp, Integer postID, String commentStatus, Integer commentOffset, Integer commentNumber) throws XmlRpcFault, InsufficientRightsException {
        List<Comment> r = wp.getComments(commentStatus, postID, commentNumber, commentOffset);
        for (Comment comment : r) {
            System.out.println("--- BEGIN COMMENT");
            System.out.println(comment);
            System.out.println("--- END COMMENT");
        }
    }

    private static void printItem(Object o, Class<?> cl) {
        cl.cast(o);
        System.out.println(((StringHeader)o).getStringHeader());
        System.out.println(o);
    }

    private static void printList(List<?> r, Class<?> cl, boolean oneLiner) {
        boolean headerPrinted = false;
        for (Object o : r) {
            cl.cast(o);
            if (!headerPrinted) {
                if (!(o instanceof String) && oneLiner) {
                    System.out.println(((StringHeader)o).getStringHeader());
                }
                headerPrinted = true;
            }
            if (oneLiner) {
                System.out.println(((XmlRpcMapped)o).toOneLinerString());
                continue;
            }
            System.out.println(o);
        }
    }

    private static void showCommentCount(WpCliConfiguration config, Wordpress wp) throws InsufficientRightsException {
        Integer post_ID = Main.getInteger("commentcount", config);
        try {
            CommentCount result = wp.getCommentsCount(post_ID);
            System.out.println(result);
        }
        catch (XmlRpcFault e) {
            String reason = e.getLocalizedMessage();
            System.err.println("Operation failed, reason is: " + reason);
        }
    }

    private static void showCommentStatus(Wordpress wp) throws XmlRpcFault {
        Main.printItem(wp.getCommentStatusList(), CommentStatusList.class);
    }

    private static void showHelp(Options options) {
        HelpFormatter help = new HelpFormatter();
        help.printHelp(" ", options);
    }
}

