/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.xml.bind.JAXBException;
import net.authorize.Environment;
import net.authorize.api.contract.v1.ANetApiRequest;
import net.authorize.api.contract.v1.ANetApiResponse;
import net.authorize.util.BOMStripperInputStream;
import net.authorize.util.HttpCallTask;
import net.authorize.util.LogHelper;
import net.authorize.util.XmlUtility;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class HttpUtility {
    private static Logger logger = LogManager.getLogger(HttpUtility.class);

    private HttpUtility() {
    }

    static HttpPost createPostRequest(Environment env, ANetApiRequest request) throws URISyntaxException, UnsupportedEncodingException, IOException, JAXBException {
        URI postUrl = null;
        HttpPost httpPost = null;
        if (null != request) {
            postUrl = new URI(env.getXmlBaseUrl() + "/xml/v1/request.api");
            logger.debug(String.format("Posting request to Url: '%s'", postUrl));
            httpPost = new HttpPost(postUrl);
            httpPost.setHeader("Content-Type", (Object)"text/xml; charset=utf-8");
            String xmlRequest = XmlUtility.getXml(request);
            logger.debug(String.format("Request: '%s%s%s'", LogHelper.LineSeparator, xmlRequest, LogHelper.LineSeparator));
            httpPost.setEntity((HttpEntity)new StringEntity(xmlRequest, StandardCharsets.UTF_8));
        }
        return httpPost;
    }

    public static <T> ANetApiResponse postData(Environment env, ANetApiRequest request, Class<T> classType) {
        ANetApiResponse response = null;
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<ANetApiResponse> future = null;
        try {
            HttpCallTask task = new HttpCallTask(env, request, classType);
            future = executor.submit(task);
        }
        catch (Exception err) {
            logger.error((Object)err.getStackTrace());
        }
        executor.shutdown();
        try {
            response = future.get();
            logger.debug(String.format("Response: '%s'", response));
        }
        catch (InterruptedException ie) {
            logger.error(String.format("Http call interrupted Message: '%s'", ie.getMessage()));
        }
        catch (ExecutionException ee) {
            logger.error(String.format("Execution error for http post Message: '%s'", ee.getMessage()));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertStreamToString(InputStream is) {
        BOMStripperInputStream bomStripperStream = null;
        try {
            bomStripperStream = new BOMStripperInputStream(is);
        }
        catch (NullPointerException e) {
            logger.warn(String.format("Exception creating BOMStripperInputStream: '%s'", e.getMessage()));
        }
        catch (IOException e) {
            logger.warn(String.format("Exception creating BOMStripperInputStream: '%s'", e.getMessage()));
        }
        if (null == bomStripperStream) {
            throw new NullPointerException("Unable to create BomStriper from the input stream");
        }
        try {
            bomStripperStream.skipBOM();
        }
        catch (IOException e) {
            logger.warn(String.format("Exception setting skip for BOMStripperInputStream: '%s'", e.getMessage()));
        }
        String line = null;
        InputStreamReader isr = null;
        BufferedReader reader = null;
        StringBuilder sb = null;
        try {
            isr = new InputStreamReader(bomStripperStream);
            reader = new BufferedReader(isr);
            sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line).append(LogHelper.LineSeparator);
            }
        }
        catch (IOException e) {
            logger.warn(String.format("Exception reading data from Stream: '%s'", e.getMessage()));
        }
        finally {
            HttpUtility.tryClose(reader);
            HttpUtility.tryClose(isr);
            HttpUtility.tryClose(bomStripperStream);
            HttpUtility.tryClose(is);
        }
        return sb.toString();
    }

    private static <T extends Closeable> void tryClose(T closableObject) {
        if (null != closableObject) {
            try {
                closableObject.close();
            }
            catch (Exception e) {
                logger.warn(String.format("Exception closing '%s': '%s'", closableObject.getClass(), e.getMessage()));
            }
        }
    }
}

