/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.Callable;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import net.authorize.Environment;
import net.authorize.api.contract.v1.ANetApiRequest;
import net.authorize.api.contract.v1.ANetApiResponse;
import net.authorize.api.contract.v1.ErrorResponse;
import net.authorize.api.contract.v1.MessageTypeEnum;
import net.authorize.api.contract.v1.MessagesType;
import net.authorize.util.HttpClient;
import net.authorize.util.HttpUtility;
import net.authorize.util.LogHelper;
import net.authorize.util.XmlUtility;
import org.apache.hc.client5.http.ClientProtocolException;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HttpCallTask
implements Callable<ANetApiResponse> {
    private static Logger logger = LogManager.getLogger(HttpCallTask.class);
    Environment env = null;
    ANetApiRequest request = null;
    Class classType = null;
    private MessagesType.Message errorMessage = null;

    public <T> HttpCallTask(Environment env, ANetApiRequest request, Class<T> classType) {
        this.env = env;
        this.request = request;
        this.classType = classType;
        this.errorMessage = new MessagesType.Message();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ANetApiResponse call() throws Exception {
        ANetApiResponse response;
        block21: {
            response = null;
            StringBuilder buffer = new StringBuilder();
            CloseableHttpClient httpCaller = null;
            try {
                HttpPost httppost = HttpUtility.createPostRequest(this.env, this.request);
                httpCaller = HttpClient.getHttpsClient();
                ClassicHttpResponse httpResponse = httpCaller.executeOpen(null, (ClassicHttpRequest)httppost, null);
                if (null != httpResponse && 200 == httpResponse.getCode()) {
                    HttpEntity entity = httpResponse.getEntity();
                    InputStream instream = entity.getContent();
                    buffer.append(HttpUtility.convertStreamToString(instream));
                    EntityUtils.consume((HttpEntity)entity);
                }
                LogHelper.debug(logger, "Raw Response: '%s'", buffer.toString());
                if (0 == buffer.length()) {
                    response = this.createErrorResponse((HttpResponse)httpResponse, null);
                    break block21;
                }
                ErrorResponse localResponse = null;
                try {
                    localResponse = (ErrorResponse)XmlUtility.create(buffer.toString(), this.classType);
                }
                catch (UnmarshalException ume) {
                    try {
                        localResponse = XmlUtility.create(buffer.toString(), ErrorResponse.class);
                    }
                    catch (JAXBException jabex) {
                        response = this.createErrorResponse((HttpResponse)httpResponse, (Exception)((Object)jabex));
                    }
                }
                catch (JAXBException jabex) {
                    response = this.createErrorResponse((HttpResponse)httpResponse, (Exception)((Object)jabex));
                }
                if (null == localResponse) {
                    try {
                        response = XmlUtility.create(buffer.toString(), ANetApiResponse.class);
                    }
                    catch (JAXBException jabex) {
                        response = this.createErrorResponse((HttpResponse)httpResponse, (Exception)((Object)jabex));
                    }
                } else if (localResponse instanceof ANetApiResponse) {
                    response = localResponse;
                } else {
                    LogHelper.warn(logger, "Unknown ResponseType: '%s'", localResponse);
                }
            }
            catch (ClientProtocolException cpe) {
                response = this.createErrorResponse(null, (Exception)((Object)cpe));
            }
            catch (IOException ioe) {
                response = this.createErrorResponse(null, ioe);
            }
            finally {
                if (null != httpCaller) {
                    httpCaller.close();
                }
            }
        }
        return response;
    }

    private ANetApiResponse createErrorResponse(HttpResponse httpResponse, Exception exception) {
        ANetApiResponse response = new ANetApiResponse();
        MessagesType aMessage = new MessagesType();
        aMessage.setResultCode(MessageTypeEnum.ERROR);
        response.setMessages(aMessage);
        List<MessagesType.Message> messages = response.getMessages().getMessage();
        messages.clear();
        this.setErrorResponse(messages, httpResponse);
        this.setErrorResponse(messages, exception);
        return response;
    }

    private void setErrorResponse(List<MessagesType.Message> messages, HttpResponse httpResponse) {
        if (null != httpResponse) {
            messages.add(this.errorMessage);
            String code = "Error";
            String text = "Unknown Error";
            LogHelper.warn(logger, "Error deserializing response to '%s'", this.classType);
            code = String.format("%d", httpResponse.getCode());
            if (null != httpResponse.getReasonPhrase()) {
                text = httpResponse.getReasonPhrase();
            }
            this.setErrorMessageValues(code, text);
        }
    }

    private void setErrorResponse(List<MessagesType.Message> messages, Exception exception) {
        if (null != exception) {
            messages.add(this.errorMessage);
            String code = "Error";
            String text = "Unknown Error";
            LogHelper.error(logger, "Http request execute failed: '%s'", exception.getMessage());
            code = exception.getClass().getCanonicalName();
            text = exception.getMessage();
            this.setErrorMessageValues(code, text);
        }
    }

    private void setErrorMessageValues(String code, String text) {
        this.errorMessage.setCode(code);
        this.errorMessage.setText(text);
        LogHelper.warn(logger, "Adding ErrorMessage: Code: '%s', Text: '%s'", code, text);
    }
}

