/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import net.authorize.util.SensitiveDataConfigType;
import net.authorize.util.SensitiveTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SensitiveTagsDeserializer
implements JsonDeserializer<SensitiveDataConfigType> {
    public SensitiveDataConfigType deserialize(JsonElement arg0, Type arg1, JsonDeserializationContext arg2) throws JsonParseException {
        JsonObject jsonObject = arg0.getAsJsonObject();
        JsonArray jsonSensitiveRegexesArray = jsonObject.get("sensitiveStringRegexes").getAsJsonArray();
        String[] stringRegexes = new String[jsonSensitiveRegexesArray.size()];
        for (int j = 0; j < stringRegexes.length; ++j) {
            JsonElement jsonStringRegex = jsonSensitiveRegexesArray.get(j);
            stringRegexes[j] = jsonStringRegex.getAsString();
        }
        SensitiveTag[] sensitiveTags = (SensitiveTag[])arg2.deserialize(jsonObject.get("sensitiveTags"), SensitiveTag[].class);
        SensitiveDataConfigType configType = new SensitiveDataConfigType();
        configType.setSensitiveTags(sensitiveTags);
        configType.setSensitiveStringRegexes(stringRegexes);
        return configType;
    }
}

