/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.api.controller;

import net.authorize.api.contract.v1.CreateTransactionRequest;
import net.authorize.api.contract.v1.CreateTransactionResponse;
import net.authorize.api.contract.v1.TransactionTypeEnum;
import net.authorize.api.controller.base.ApiOperationBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateTransactionController
extends ApiOperationBase<CreateTransactionRequest, CreateTransactionResponse> {
    public CreateTransactionController(CreateTransactionRequest apiRequest) {
        super(apiRequest);
    }

    @Override
    protected void validateRequest() {
        CreateTransactionRequest request = (CreateTransactionRequest)this.getApiRequest();
        if (null == request.getTransactionRequest()) {
            throw new NullPointerException("TransactionRequest cannot be null");
        }
        String transactionType = request.getTransactionRequest().getTransactionType();
        TransactionTypeEnum newtransactionType = TransactionTypeEnum.fromValue(transactionType);
        if (!newtransactionType.value().equals(transactionType)) {
            throw new IllegalArgumentException("Pass a valid 'value' of 'TransactionTypeEnum' (using .value() as string)");
        }
    }

    @Override
    protected Class<CreateTransactionResponse> getResponseType() {
        return CreateTransactionResponse.class;
    }
}

