/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.aim;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import net.authorize.AuthNetField;
import net.authorize.Environment;
import net.authorize.Merchant;
import net.authorize.PaymentMethod;
import net.authorize.ResponseField;
import net.authorize.TransactionType;
import net.authorize.data.Customer;
import net.authorize.data.EmailReceipt;
import net.authorize.data.Order;
import net.authorize.data.OrderItem;
import net.authorize.data.ShippingAddress;
import net.authorize.data.ShippingCharges;
import net.authorize.data.creditcard.AVSCode;
import net.authorize.data.creditcard.CardType;
import net.authorize.data.creditcard.CreditCard;
import net.authorize.data.echeck.ECheck;
import net.authorize.data.echeck.ECheckType;
import net.authorize.data.reporting.Solution;
import net.authorize.util.BasicXmlDocument;
import net.authorize.util.DeepCopy;
import net.authorize.util.LogHelper;
import net.authorize.util.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transaction
extends net.authorize.Transaction
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Log logger = LogFactory.getLog(Transaction.class);
    protected Map<String, String> requestMap = Collections.synchronizedMap(new HashMap());
    private Map<ResponseField, String> responseMap = Collections.synchronizedMap(new HashMap());
    private BasicXmlDocument currentResponse = null;
    protected Map<String, String> merchantDefinedMap = Collections.synchronizedMap(new HashMap());
    private CreditCard creditCard;
    private ECheck eCheck;
    private Customer customer;
    private EmailReceipt emailReceipt;
    private Order order;
    private ShippingAddress shippingAddress;
    private ShippingCharges shippingCharges;
    private Solution solution;
    protected TransactionType transactionType;
    private boolean cardPresent = false;
    protected String MD5Value = null;

    protected Transaction(Merchant merchant, TransactionType transactionType, BigDecimal amount) {
        this.requestMap.put(AuthNetField.X_VERSION_FIELD.getFieldName(), "3.1");
        this.requestMap.put(AuthNetField.X_DELIM_CHAR_FIELD.getFieldName(), TRANSACTION_FIELD_DELIMITER);
        this.requestMap.put(AuthNetField.X_DELIM_DATA_FIELD.getFieldName(), "TRUE");
        this.requestMap.put(AuthNetField.X_ENCAP_CHAR.getFieldName(), ENCAP_CHAR_DELIMITER);
        if (Environment.PRODUCTION.equals((Object)merchant.getEnvironment()) || Environment.SANDBOX.equals((Object)merchant.getEnvironment())) {
            this.requestMap.put(AuthNetField.X_TEST_REQUEST.getFieldName(), "FALSE");
        } else {
            this.requestMap.put(AuthNetField.X_TEST_REQUEST.getFieldName(), "TRUE");
        }
        if (merchant != null) {
            this.requestMap.put(AuthNetField.X_LOGIN.getFieldName(), merchant.getLogin());
            this.requestMap.put(AuthNetField.X_TRAN_KEY.getFieldName(), merchant.getTransactionKey());
            this.requestMap.put(AuthNetField.X_ALLOW_PARTIAL_AUTH.getFieldName(), merchant.isAllowPartialAuth() ? "TRUE" : "FALSE");
            if (merchant.getDeviceType() != null && merchant.getMarketType() != null) {
                this.cardPresent = true;
                this.MD5Value = merchant.getMD5Value();
                this.requestMap.put(AuthNetField.X_MARKET_TYPE.getFieldName(), merchant.getMarketType().getValue());
                this.requestMap.put(AuthNetField.X_DEVICE_TYPE.getFieldName(), merchant.getDeviceType().getValue());
                this.requestMap.put(AuthNetField.X_CPVERSION.getFieldName(), "1.0");
                this.requestMap.put(AuthNetField.X_RESPONSE_FORMAT.getFieldName(), "0");
                if (StringUtils.isNotEmpty(merchant.getUserRef())) {
                    this.requestMap.put(AuthNetField.X_USER_REF.getFieldName(), merchant.getUserRef());
                }
            }
        }
        if (transactionType == null) {
            transactionType = TransactionType.AUTH_CAPTURE;
        }
        this.transactionType = transactionType;
        this.requestMap.put(AuthNetField.X_TYPE.getFieldName(), transactionType.getValue());
        this.requestMap.put(AuthNetField.X_AMOUNT.getFieldName(), amount != null ? amount.setScale(2, 4).toPlainString() : "0.00");
        this.requestMap.put(AuthNetField.X_RELAY_RESPONSE.getFieldName(), "FALSE");
        this.requestMap.put(AuthNetField.X_DELIM_DATA.getFieldName(), "TRUE");
    }

    public static final Transaction createTransaction(Transaction transaction, Map<ResponseField, String> responseMap) {
        ECheck eCheck;
        CreditCard creditCard;
        Transaction _transaction = (Transaction)DeepCopy.copy(transaction);
        _transaction.responseMap = responseMap;
        if (responseMap.containsKey((Object)ResponseField.AUTHORIZATION_CODE)) {
            _transaction.setAuthorizationCode(responseMap.get((Object)ResponseField.AUTHORIZATION_CODE));
        }
        if (responseMap.containsKey((Object)ResponseField.TRANSACTION_ID)) {
            _transaction.setTransactionId(responseMap.get((Object)ResponseField.TRANSACTION_ID));
        }
        if ((creditCard = _transaction.getCreditCard()) != null) {
            if (responseMap.containsKey((Object)ResponseField.ACCOUNT_NUMBER)) {
                creditCard.setMaskedCreditCardNumber(responseMap.get((Object)ResponseField.ACCOUNT_NUMBER));
            }
            if (responseMap.containsKey((Object)ResponseField.CARD_TYPE)) {
                creditCard.setCardType(CardType.findByValue(responseMap.get((Object)ResponseField.CARD_TYPE)));
            }
            if (responseMap.containsKey((Object)ResponseField.AVS_CODE)) {
                creditCard.setAvsCode(AVSCode.findByValue(responseMap.get((Object)ResponseField.AVS_CODE)));
            }
            _transaction.setCreditCard(creditCard);
        }
        if ((eCheck = _transaction.getECheck()) != null) {
            // empty if block
        }
        return _transaction;
    }

    public static final Transaction createTransaction(Transaction transaction, BasicXmlDocument response) {
        Transaction _transaction = (Transaction)DeepCopy.copy(transaction);
        _transaction.cardPresent = true;
        _transaction.currentResponse = response;
        return _transaction;
    }

    public static Transaction createTransaction(Merchant merchant, TransactionType transactionType, BigDecimal amount) {
        return new Transaction(merchant, transactionType, amount);
    }

    public Map<String, String> getRequestMap() {
        return this.requestMap;
    }

    public Map<ResponseField, String> getResponseMap() {
        return this.responseMap;
    }

    public void setTransactionId(String transactionId) {
        if (this.requestMap.get(AuthNetField.X_SPLIT_TENDER_ID.getFieldName()) == null || this.requestMap.get(AuthNetField.X_SPLIT_TENDER_ID.getFieldName()).equals("")) {
            this.requestMap.put(AuthNetField.X_TRANS_ID.getFieldName(), transactionId != null ? transactionId : "");
            this.requestMap.remove(AuthNetField.X_SPLIT_TENDER_ID.getFieldName());
        }
    }

    public void setSplitTenderId(String splitTenderId) {
        if (this.requestMap.get(AuthNetField.X_TRANS_ID.getFieldName()) == null || this.requestMap.get(AuthNetField.X_TRANS_ID.getFieldName()).equals("")) {
            this.requestMap.put(AuthNetField.X_SPLIT_TENDER_ID.getFieldName(), splitTenderId != null ? splitTenderId : "");
            this.requestMap.remove(AuthNetField.X_TRANS_ID.getFieldName());
        }
    }

    public String getTransactionId() {
        return this.requestMap.containsKey(AuthNetField.X_TRANS_ID.getFieldName()) ? this.requestMap.get(AuthNetField.X_TRANS_ID.getFieldName()) : "";
    }

    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    public void setAuthorizationCode(String authCode) {
        this.requestMap.put(AuthNetField.X_AUTH_CODE.getFieldName(), authCode != null ? authCode : "");
    }

    public String getAuthorizationCode() {
        return this.requestMap.containsKey(AuthNetField.X_AUTH_CODE.getFieldName()) ? this.requestMap.get(AuthNetField.X_AUTH_CODE.getFieldName()) : "";
    }

    public void setCreditCard(CreditCard creditCard) {
        this.creditCard = creditCard;
        if (creditCard != null) {
            this.requestMap.put(AuthNetField.X_METHOD.getFieldName(), PaymentMethod.CREDIT_CARD.getMethod());
            this.requestMap.put(AuthNetField.X_CARD_NUM.getFieldName(), creditCard.getCreditCardNumber() != null ? creditCard.getCreditCardNumber() : "");
            this.requestMap.put(AuthNetField.X_EXP_DATE.getFieldName(), creditCard.getExpirationMonth() != null && creditCard.getExpirationYear() != null ? creditCard.getExpirationMonth() + creditCard.getExpirationYear() : "");
            if (creditCard.getCardCode() != null) {
                this.requestMap.put(AuthNetField.X_CARD_CODE.getFieldName(), creditCard.getCardCode());
            }
            if (creditCard.getCardholderAuthenticationIndicator() != null && creditCard.getCardholderAuthenticationValue() != null && (TransactionType.AUTH_ONLY.equals((Object)this.transactionType) || TransactionType.AUTH_CAPTURE.equals((Object)this.transactionType))) {
                this.requestMap.put(AuthNetField.X_AUTHENTICATION_INDICATOR.getFieldName(), creditCard.getCardholderAuthenticationIndicator());
                this.requestMap.put(AuthNetField.X_CARDHOLDER_AUTHENTICATION_VALUE.getFieldName(), creditCard.getCardholderAuthenticationValue());
            }
            if (StringUtils.isNotEmpty(creditCard.getTrack1()) || StringUtils.isNotEmpty(creditCard.getTrack2())) {
                if (creditCard.getCardType() != null) {
                    this.requestMap.put(AuthNetField.X_CARD_TYPE.getFieldName(), creditCard.getCardType().name().substring(0, 0));
                }
                this.requestMap.put(AuthNetField.X_TRACK1.getFieldName(), StringUtils.isNotEmpty(creditCard.getTrack1()) ? creditCard.getTrack1() : "");
                this.requestMap.put(AuthNetField.X_TRACK2.getFieldName(), StringUtils.isNotEmpty(creditCard.getTrack2()) ? creditCard.getTrack2() : "");
            }
        }
    }

    public CreditCard getCreditCard() {
        return this.creditCard;
    }

    public void setECheck(ECheck eCheck) {
        this.eCheck = eCheck;
        if (eCheck != null) {
            this.requestMap.put(AuthNetField.X_METHOD.getFieldName(), PaymentMethod.E_CHECK.getMethod());
            this.requestMap.put(AuthNetField.X_BANK_ABA_CODE.getFieldName(), eCheck.getRoutingNumber());
            this.requestMap.put(AuthNetField.X_BANK_ACCT_NUM.getFieldName(), eCheck.getBankAccountNumber());
            this.requestMap.put(AuthNetField.X_BANK_ACCT_TYPE.getFieldName(), eCheck.getBankAccountType().getValue());
            this.requestMap.put(AuthNetField.X_BANK_NAME.getFieldName(), eCheck.getBankName());
            this.requestMap.put(AuthNetField.X_BANK_ACCT_NAME.getFieldName(), eCheck.getBankAccountName());
            this.requestMap.put(AuthNetField.X_ECHECK_TYPE.getFieldName(), eCheck.getECheckType().getValue());
            if (ECheckType.ARC.equals(eCheck.getECheckType()) || ECheckType.BOC.equals(eCheck.getECheckType())) {
                this.requestMap.put(AuthNetField.X_BANK_CHECK_NUMBER.getFieldName(), eCheck.getBankCheckNumber());
            }
        }
    }

    public ECheck getECheck() {
        return this.eCheck;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
        if (customer != null) {
            this.requestMap.put(AuthNetField.X_FIRST_NAME.getFieldName(), customer.getFirstName() != null ? customer.getFirstName() : "");
            this.requestMap.put(AuthNetField.X_LAST_NAME.getFieldName(), customer.getLastName() != null ? customer.getLastName() : "");
            this.requestMap.put(AuthNetField.X_COMPANY.getFieldName(), customer.getCompany() != null ? customer.getCompany() : "");
            this.requestMap.put(AuthNetField.X_ADDRESS.getFieldName(), customer.getAddress() != null ? customer.getAddress() : "");
            this.requestMap.put(AuthNetField.X_CITY.getFieldName(), customer.getCity() != null ? customer.getCity() : "");
            this.requestMap.put(AuthNetField.X_STATE.getFieldName(), customer.getState() != null ? customer.getState() : "");
            this.requestMap.put(AuthNetField.X_ZIP.getFieldName(), customer.getZipPostalCode() != null ? customer.getZipPostalCode() : "");
            this.requestMap.put(AuthNetField.X_COUNTRY.getFieldName(), customer.getCountry() != null ? customer.getCountry() : "");
            this.requestMap.put(AuthNetField.X_PHONE.getFieldName(), customer.getPhone() != null ? customer.getPhone() : "");
            this.requestMap.put(AuthNetField.X_FAX.getFieldName(), customer.getFax() != null ? customer.getFax() : "");
            this.requestMap.put(AuthNetField.X_EMAIL.getFieldName(), customer.getEmail() != null ? customer.getEmail() : "");
            this.requestMap.put(AuthNetField.X_CUST_ID.getFieldName(), customer.getCustomerId() != null ? customer.getCustomerId() : "");
            this.requestMap.put(AuthNetField.X_CUSTOMER_IP.getFieldName(), customer.getCustomerIP() != null ? customer.getCustomerIP() : "");
        }
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public void setEmailReceipt(EmailReceipt emailReceipt) {
        this.emailReceipt = emailReceipt;
        if (emailReceipt != null) {
            this.requestMap.put(AuthNetField.X_EMAIL.getFieldName(), emailReceipt.getEmail() != null ? emailReceipt.getEmail() : "");
            this.requestMap.put(AuthNetField.X_EMAIL_CUSTOMER.getFieldName(), emailReceipt.isEmailCustomer() ? "TRUE" : "FALSE");
            this.requestMap.put(AuthNetField.X_HEADER_EMAIL_RECEIPT.getFieldName(), emailReceipt.getHeaderEmailReceipt() != null ? emailReceipt.getHeaderEmailReceipt() : "");
            this.requestMap.put(AuthNetField.X_FOOTER_EMAIL_RECEIPT.getFieldName(), emailReceipt.getFooterEmailReceipt() != null ? emailReceipt.getFooterEmailReceipt() : "");
            this.requestMap.put(AuthNetField.X_MERCHANT_EMAIL.getFieldName(), emailReceipt.getMerchantEmail() != null ? emailReceipt.getMerchantEmail() : "");
        }
    }

    public EmailReceipt getEmailReceipt() {
        return this.emailReceipt;
    }

    public void setOrder(Order order) {
        this.order = order;
        if (order != null) {
            this.requestMap.put(AuthNetField.X_INVOICE_NUM.getFieldName(), order.getInvoiceNumber() != null ? order.getInvoiceNumber() : "");
            this.requestMap.put(AuthNetField.X_DESCRIPTION.getFieldName(), order.getDescription() != null ? order.getDescription() : "");
            if (order.getOrderItems() != null) {
                StringBuilder orderItemBuffer = new StringBuilder();
                boolean firstOrderItem = true;
                for (OrderItem orderItem : order.getOrderItems()) {
                    if (firstOrderItem) {
                        firstOrderItem = false;
                    } else {
                        orderItemBuffer.append("&").append(AuthNetField.X_LINE_ITEM.getFieldName()).append("=");
                    }
                    try {
                        orderItemBuffer.append(orderItem.getItemId() != null ? URLEncoder.encode(orderItem.getItemId(), "UTF-8") : "").append("<|>");
                        orderItemBuffer.append(orderItem.getItemName() != null ? URLEncoder.encode(orderItem.getItemName(), "UTF-8") : "").append("<|>");
                        orderItemBuffer.append(orderItem.getItemDescription() != null ? URLEncoder.encode(orderItem.getItemDescription(), "UTF-8") : "").append("<|>");
                        orderItemBuffer.append(orderItem.getItemQuantity() != null ? URLEncoder.encode(orderItem.getItemQuantity().setScale(2, 4).toPlainString(), "UTF-8") : "0.00").append("<|>");
                        orderItemBuffer.append(orderItem.getItemPrice() != null ? URLEncoder.encode(orderItem.getItemPrice().setScale(2, 4).toPlainString(), "UTF-8") : "0.00").append("<|>");
                        orderItemBuffer.append(orderItem.isItemTaxable() ? "TRUE" : "FALSE");
                    }
                    catch (UnsupportedEncodingException uee) {
                        logger.warn((Object)"Failed encoding order items.", (Throwable)uee);
                    }
                }
                this.requestMap.put(AuthNetField.X_LINE_ITEM.getFieldName(), orderItemBuffer.toString());
            }
            this.setShippingCharges(order.getShippingCharges());
        }
    }

    public Order getOrder() {
        return this.order;
    }

    public void setShippingAddress(ShippingAddress shippingAddress) {
        this.shippingAddress = shippingAddress;
        if (shippingAddress != null) {
            this.requestMap.put(AuthNetField.X_SHIP_TO_FIRST_NAME.getFieldName(), shippingAddress.getFirstName() != null ? shippingAddress.getFirstName() : "");
            this.requestMap.put(AuthNetField.X_SHIP_TO_LAST_NAME.getFieldName(), shippingAddress.getLastName() != null ? shippingAddress.getLastName() : "");
            this.requestMap.put(AuthNetField.X_SHIP_TO_COMPANY.getFieldName(), shippingAddress.getCompany() != null ? shippingAddress.getCompany() : "");
            this.requestMap.put(AuthNetField.X_SHIP_TO_ADDRESS.getFieldName(), shippingAddress.getAddress() != null ? shippingAddress.getAddress() : "");
            this.requestMap.put(AuthNetField.X_SHIP_TO_CITY.getFieldName(), shippingAddress.getCity() != null ? shippingAddress.getCity() : "");
            this.requestMap.put(AuthNetField.X_SHIP_TO_STATE.getFieldName(), shippingAddress.getState() != null ? shippingAddress.getState() : "");
            this.requestMap.put(AuthNetField.X_SHIP_TO_ZIP.getFieldName(), shippingAddress.getZipPostalCode() != null ? shippingAddress.getZipPostalCode() : "");
            this.requestMap.put(AuthNetField.X_SHIP_TO_COUNTRY.getFieldName(), shippingAddress.getCountry() != null ? shippingAddress.getCountry() : "");
        }
    }

    public ShippingAddress getShippingAddress() {
        return this.shippingAddress;
    }

    public void setShippingCharges(ShippingCharges shippingCharges) {
        this.shippingCharges = shippingCharges;
        if (shippingCharges != null) {
            try {
                if (shippingCharges.getTaxAmount() != null && !ZERO_AMOUNT.equals(shippingCharges.getTaxAmount())) {
                    StringBuilder taxBuffer = new StringBuilder();
                    taxBuffer.append(URLEncoder.encode(shippingCharges.getTaxItemName() != null ? shippingCharges.getTaxItemName() : "", "UTF-8")).append("<|>");
                    taxBuffer.append(URLEncoder.encode(shippingCharges.getTaxDescription() != null ? shippingCharges.getTaxDescription() : "", "UTF-8")).append("<|>");
                    taxBuffer.append(URLEncoder.encode(shippingCharges.getTaxAmount().setScale(2, 4).toPlainString(), "UTF-8"));
                    this.requestMap.put(AuthNetField.X_TAX.getFieldName(), taxBuffer.toString());
                }
                if (shippingCharges.getFreightAmount() != null && !ZERO_AMOUNT.equals(shippingCharges.getFreightAmount())) {
                    StringBuilder freightBuffer = new StringBuilder();
                    freightBuffer.append(URLEncoder.encode(shippingCharges.getFreightItemName() != null ? shippingCharges.getFreightItemName() : "", "UTF-8")).append("<|>");
                    freightBuffer.append(URLEncoder.encode(shippingCharges.getFreightDescription() != null ? shippingCharges.getFreightDescription() : "", "UTF-8")).append("<|>");
                    freightBuffer.append(URLEncoder.encode(shippingCharges.getFreightAmount().setScale(2, 4).toPlainString(), "UTF-8"));
                    this.requestMap.put(AuthNetField.X_FREIGHT.getFieldName(), freightBuffer.toString());
                }
                if (shippingCharges.getDutyAmount() != null && !ZERO_AMOUNT.equals(shippingCharges.getDutyAmount())) {
                    StringBuilder dutyBuffer = new StringBuilder();
                    dutyBuffer.append(URLEncoder.encode(shippingCharges.getDutyItemName() != null ? shippingCharges.getDutyItemName() : "", "UTF-8"));
                    dutyBuffer.append(URLEncoder.encode(shippingCharges.getDutyItemDescription() != null ? shippingCharges.getDutyItemDescription() : "", "UTF-8"));
                    dutyBuffer.append(URLEncoder.encode(shippingCharges.getDutyAmount().setScale(2, 4).toPlainString(), "UTF-8"));
                    this.requestMap.put(AuthNetField.X_DUTY.getFieldName(), dutyBuffer.toString());
                }
            }
            catch (UnsupportedEncodingException uee) {
                logger.warn((Object)"Failed encoding shipping charges.", (Throwable)uee);
            }
            this.requestMap.put(AuthNetField.X_TAX_EXEMPT.getFieldName(), shippingCharges.isTaxExempt() ? "TRUE" : "FALSE");
            this.requestMap.put(AuthNetField.X_PO_NUM.getFieldName(), shippingCharges.getPurchaseOrderNumber() != null ? shippingCharges.getPurchaseOrderNumber() : "");
        }
    }

    public ShippingCharges getShippingCharges() {
        return this.shippingCharges;
    }

    public void setDuplicateWindow(int seconds) {
        this.requestMap.put(AuthNetField.X_DUPLICATE_WINDOW.getFieldName(), Integer.toString(seconds));
    }

    public void setCurrencyCode(String currencyCode) {
        this.requestMap.put(AuthNetField.X_CURRENCY_CODE.getFieldName(), currencyCode);
    }

    public String getCurrencyCode() {
        return this.requestMap.get(AuthNetField.X_CURRENCY_CODE.getFieldName());
    }

    public void setRecurringBilling(boolean recurringBillingStatus) {
        this.requestMap.put(AuthNetField.X_RECURRING_BILLING.getFieldName(), recurringBillingStatus ? "TRUE" : "FALSE");
    }

    public void setMerchantDefinedField(String field, String value) {
        if (this.requestMap.get(field) == null) {
            this.merchantDefinedMap.put(field, value);
        }
    }

    public String getMerchantDefinedField(String field) {
        return this.merchantDefinedMap.get(field);
    }

    public Map<String, String> getMerchantDefinedMap() {
        return this.merchantDefinedMap;
    }

    public String getResponseField(ResponseField responseField) {
        return this.responseMap.get((Object)responseField);
    }

    @Override
    public String toNVPString() {
        StringBuilder nvpBuffer = new StringBuilder();
        LinkedList<Map<String, String>> requestMappings = new LinkedList<Map<String, String>>();
        requestMappings.add(this.requestMap);
        requestMappings.add(this.merchantDefinedMap);
        for (Map map : requestMappings) {
            Set keys = map.keySet();
            for (String key : keys) {
                try {
                    String value = ((String)map.get(key)).toString();
                    key = URLEncoder.encode(key, "UTF-8");
                    if (!(AuthNetField.X_LINE_ITEM.getFieldName().equals(key) || AuthNetField.X_TAX.getFieldName().equals(key) || AuthNetField.X_FREIGHT.getFieldName().equals(key) || AuthNetField.X_DUTY.getFieldName().equals(key))) {
                        value = URLEncoder.encode(value, "UTF-8");
                    }
                    nvpBuffer.append(key).append("=").append(value).append("&");
                }
                catch (Exception e) {
                    LogHelper.warn(logger, "NVP encoding failed: " + e.getMessage(), new Object[0]);
                }
            }
        }
        nvpBuffer.deleteCharAt(nvpBuffer.length() - 1);
        return nvpBuffer.toString();
    }

    public boolean isCardPresent() {
        return this.cardPresent;
    }

    public BasicXmlDocument getCurrentResponse() {
        return this.currentResponse;
    }

    public String getMD5Value() {
        return this.MD5Value;
    }

    public void setSolutionField(Solution solution) {
        this.solution = solution;
        if (solution != null) {
            this.requestMap.put(AuthNetField.X_SOLUTION_ID.getFieldName(), solution.getId() != null ? solution.getId() : "");
        }
    }

    public Solution getSolutionField() {
        return this.solution;
    }
}

