/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.util;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import net.authorize.ResponseField;
import net.authorize.aim.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseParser {
    public static Map<ResponseField, String> parseResponseString(String responseString) {
        return ResponseParser.parseResponseString(responseString, Transaction.TRANSACTION_FIELD_DELIMITER);
    }

    public static Map<ResponseField, String> parseResponseString(String responseString, String delimiter) {
        HashMap<ResponseField, String> responseMap = new HashMap<ResponseField, String>();
        StringTokenizer st = new StringTokenizer(responseString, delimiter, true);
        int order = 0;
        while (st.hasMoreTokens()) {
            ResponseField responseField;
            String token = st.nextToken();
            if ((responseField = ResponseField.get(++order)) == null) continue;
            if (delimiter.equals(token)) {
                responseMap.put(responseField, "");
                continue;
            }
            responseMap.put(responseField, token.replaceAll(delimiter, ""));
            if (!st.hasMoreTokens()) continue;
            st.nextToken();
        }
        return responseMap;
    }
}

