/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.aim;

import java.util.Map;
import net.authorize.ResponseCode;
import net.authorize.ResponseField;
import net.authorize.ResponseReasonCode;
import net.authorize.aim.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Result<T>
extends net.authorize.Result<T> {
    private static final long serialVersionUID = 1L;
    private ResponseCode responseCode;
    private ResponseReasonCode reasonResponseCode;
    private String responseText;
    private String transactionId;

    private Result() {
    }

    public static <T> Result<T> createResult(T object, Map<ResponseField, String> responseMap) {
        Result<T> result = new Result<T>();
        if (object instanceof Transaction) {
            result.target = Transaction.createTransaction((Transaction)object, responseMap);
        }
        String responseCodeStr = responseMap.get((Object)ResponseField.RESPONSE_CODE);
        result.transactionId = responseMap.get((Object)ResponseField.TRANSACTION_ID);
        result.responseCode = responseCodeStr != null && !"".equals(responseCodeStr) ? ResponseCode.findByResponseCode(Double.valueOf(responseCodeStr).intValue()) : ResponseCode.ERROR;
        String responseReasonCodeStr = responseMap.get((Object)ResponseField.RESPONSE_REASON_CODE);
        result.reasonResponseCode = responseReasonCodeStr != null && !"".equals(responseReasonCodeStr) ? ResponseReasonCode.findByReasonCode(Integer.parseInt(responseReasonCodeStr)) : ResponseReasonCode.RRC_0_0;
        result.responseText = responseMap.get((Object)ResponseField.RESPONSE_REASON_TEXT);
        return result;
    }

    public ResponseCode getResponseCode() {
        return this.responseCode;
    }

    public ResponseReasonCode getReasonResponseCode() {
        return this.reasonResponseCode;
    }

    public String getResponseText() {
        return this.responseText;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public boolean isApproved() {
        return ResponseCode.APPROVED.equals((Object)this.responseCode);
    }

    public boolean isDeclined() {
        return ResponseCode.DECLINED.equals((Object)this.responseCode);
    }

    public boolean isError() {
        return ResponseCode.ERROR.equals((Object)this.responseCode);
    }

    public boolean isReview() {
        return ResponseCode.REVIEW.equals((Object)this.responseCode);
    }
}

