/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.data.creditcard;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum CardType implements Serializable
{
    VISA("Visa"),
    MASTER_CARD("MasterCard"),
    AMERICAN_EXPRESS("AmericanExpress"),
    DISCOVER("Discover"),
    DINERS_CLUB("DinersClub"),
    JCB("JCB"),
    ECHECK("eCheck"),
    UNKNOWN("");

    private final String value;

    private CardType(String value) {
        this.value = value;
    }

    public static CardType findByValue(String value) {
        if (value != null) {
            for (CardType cardType : CardType.values()) {
                if (!cardType.value.equals(value)) continue;
                return cardType;
            }
        }
        return UNKNOWN;
    }

    public String getValue() {
        return this.value;
    }
}

