/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.acceptsdk.parser;

import java.util.ArrayList;
import java.util.List;
import net.authorize.acceptsdk.datamodel.common.Message;
import net.authorize.acceptsdk.datamodel.common.ResponseMessages;
import net.authorize.acceptsdk.datamodel.error.SDKErrorCode;
import net.authorize.acceptsdk.datamodel.merchant.ClientKeyBasedMerchantAuthentication;
import net.authorize.acceptsdk.datamodel.merchant.FingerPrintBasedMerchantAuthentication;
import net.authorize.acceptsdk.datamodel.merchant.FingerPrintData;
import net.authorize.acceptsdk.datamodel.merchant.MerchantAuthenticationType;
import net.authorize.acceptsdk.datamodel.transaction.CardData;
import net.authorize.acceptsdk.datamodel.transaction.EncryptTransactionObject;
import net.authorize.acceptsdk.datamodel.transaction.response.EncryptTransactionResponse;
import net.authorize.acceptsdk.datamodel.transaction.response.ErrorTransactionResponse;
import net.authorize.acceptsdk.datamodel.transaction.response.TransactionResponse;
import net.authorize.acceptsdk.util.LogUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONStringer;
import org.json.JSONTokener;

public class AcceptSDKParser {
    public static String getOrderedJsonFromEncryptTransaction(EncryptTransactionObject transactionObject) throws JSONException {
        CardData cardData = transactionObject.getCardData();
        JSONStringer stringer = new JSONStringer().object();
        stringer.key("securePaymentContainerRequest").object();
        AcceptSDKParser.prepareJsonForAuthenticationSection(stringer, transactionObject);
        stringer.key("clientId").value((Object)"accept-sdk-android-1.0.2");
        stringer.key("data").object();
        stringer.key("type").value((Object)"TOKEN");
        stringer.key("id").value((Object)transactionObject.getGuid());
        AcceptSDKParser.prepareJsonForTokenSection(stringer, cardData);
        stringer.endObject();
        stringer.endObject();
        stringer.endObject();
        LogUtil.log(LogUtil.LOG_LEVEL.INFO, "getJsonFromEncryptTransaction : " + stringer.toString());
        return stringer.toString();
    }

    public static void prepareJsonForTokenSection(JSONStringer stringer, CardData cardData) throws JSONException {
        stringer.key("token").object();
        stringer.key("cardNumber").value((Object)cardData.getCardNumber());
        stringer.key("expirationDate").value((Object)cardData.getExpirationInFormatMMYYYY());
        if (cardData.getCvvCode() != null) {
            stringer.key("cardCode").value((Object)cardData.getCvvCode());
        }
        if (cardData.getZipCode() != null) {
            stringer.key("zip").value((Object)cardData.getZipCode());
        }
        if (cardData.getCardHolderName() != null) {
            stringer.key("fullName").value((Object)cardData.getCardHolderName());
        }
        stringer.endObject();
    }

    public static void prepareJsonForAuthenticationSection(JSONStringer stringer, EncryptTransactionObject transactionObject) throws JSONException {
        String clientKey = null;
        FingerPrintData fData = null;
        String apiLoginId = transactionObject.getMerchantAuthentication().getApiLoginID();
        MerchantAuthenticationType authenticationType = transactionObject.getMerchantAuthentication().getMerchantAuthenticationType();
        if (authenticationType == MerchantAuthenticationType.CLIENT_KEY) {
            ClientKeyBasedMerchantAuthentication clientKeyAuth = (ClientKeyBasedMerchantAuthentication)transactionObject.getMerchantAuthentication();
            clientKey = clientKeyAuth.getClientKey();
        } else if (authenticationType == MerchantAuthenticationType.FINGERPRINT) {
            FingerPrintBasedMerchantAuthentication fingerPrintAuth = (FingerPrintBasedMerchantAuthentication)transactionObject.getMerchantAuthentication();
            fData = fingerPrintAuth.getFingerPrintData();
        }
        stringer.key("merchantAuthentication").object();
        stringer.key("name").value((Object)apiLoginId);
        if (clientKey != null) {
            stringer.key("clientKey").value((Object)clientKey);
        } else if (fData != null) {
            AcceptSDKParser.prepareJsonForFingerPrintSection(stringer, fData);
        }
        stringer.endObject();
    }

    public static void prepareJsonForFingerPrintSection(JSONStringer stringer, FingerPrintData fData) throws JSONException {
        stringer.key("fingerPrint").object();
        stringer.key("hashValue").value((Object)fData.getHashValue());
        if (fData.getSequence() != null) {
            stringer.key("sequence").value((Object)fData.getSequence());
        }
        stringer.key("timestamp").value((Object)fData.getTimestampString());
        if (fData.getCurrencyCode() != null) {
            stringer.key("currencyCode").value((Object)fData.getCurrencyCode());
        }
        if (fData.getAmountString() != null) {
            stringer.key("amount").value((Object)fData.getAmountString());
        }
        stringer.endObject();
    }

    public static TransactionResponse createEncryptionTransactionResponse(String json) throws JSONException {
        JSONObject responseObject = (JSONObject)new JSONTokener(json).nextValue();
        if (responseObject.has("opaqueData")) {
            EncryptTransactionResponse encryptTransactionResponse = new EncryptTransactionResponse();
            AcceptSDKParser.parseOpaqueSection(encryptTransactionResponse, responseObject.getJSONObject("opaqueData"));
            encryptTransactionResponse.setResponseMessages(AcceptSDKParser.parseResponseMessagesSection(responseObject.getJSONObject("messages")));
            return encryptTransactionResponse;
        }
        ResponseMessages responseMessages = AcceptSDKParser.parseResponseMessagesSection(responseObject.getJSONObject("messages"));
        ErrorTransactionResponse response = new ErrorTransactionResponse(responseMessages);
        return response;
    }

    private static void parseOpaqueSection(EncryptTransactionResponse response, JSONObject json) throws JSONException {
        response.setDataDescriptor(json.getString("dataDescriptor"));
        response.setDataValue(json.getString("dataValue"));
    }

    private static ResponseMessages parseResponseMessagesSection(JSONObject json) throws JSONException {
        String resultCode = json.getString("resultCode");
        boolean isErrorResponse = false;
        if (resultCode.equals("Error")) {
            isErrorResponse = true;
        }
        ResponseMessages responseMessages = new ResponseMessages(json.getString("resultCode"));
        responseMessages.setMessageList(AcceptSDKParser.parseMessagesList(isErrorResponse, json.getJSONArray("message")));
        return responseMessages;
    }

    private static List<Message> parseMessagesList(boolean isErrorResponse, JSONArray jsonArray) throws JSONException {
        int arrayLength = jsonArray.length();
        ArrayList<Message> messageList = new ArrayList<Message>(arrayLength);
        for (int index = 0; index < arrayLength; ++index) {
            Message message = AcceptSDKParser.parseMessage(jsonArray.getJSONObject(index));
            if (isErrorResponse) {
                message.setMessageCode(SDKErrorCode.E_WC_14.getErrorCode());
            } else {
                message.setMessageCode("I_WC_01");
            }
            messageList.add(message);
        }
        return messageList;
    }

    private static Message parseMessage(JSONObject json) throws JSONException {
        Message message = new Message();
        message.setMessageCode(json.getString("code"));
        message.setMessageText(json.getString("text"));
        return message;
    }
}

