/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.acceptsdk.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import net.authorize.acceptsdk.AcceptSDKApiClient;
import net.authorize.acceptsdk.ValidationCallback;
import net.authorize.acceptsdk.datamodel.transaction.EncryptTransactionObject;
import net.authorize.acceptsdk.datamodel.transaction.callbacks.EncryptTransactionCallback;
import net.authorize.acceptsdk.datamodel.transaction.response.EncryptTransactionResponse;
import net.authorize.acceptsdk.datamodel.transaction.response.ErrorTransactionResponse;
import net.authorize.acceptsdk.network.AcceptService;
import net.authorize.acceptsdk.network.TransactionResultReceiver;

public class AcceptSDKCore
implements TransactionResultReceiver.Receiver {
    private static AcceptSDKCore sInstance = new AcceptSDKCore();
    private static boolean sTransactionInProgress = false;
    private TransactionResultReceiver mResultReceiver = null;
    EncryptTransactionCallback mEncryptTransactionCallback;

    private AcceptSDKCore() {
    }

    public static AcceptSDKCore getInstance() {
        return sInstance;
    }

    public boolean performEncryption(final EncryptTransactionObject transactionObject, EncryptTransactionCallback callback) {
        if (sTransactionInProgress) {
            return sTransactionInProgress;
        }
        this.mEncryptTransactionCallback = callback;
        transactionObject.validateTransactionObject(new ValidationCallback(){

            @Override
            public void OnValidationSuccessful() {
                AcceptSDKCore.this.registerResultReceiver();
                sTransactionInProgress = true;
                AcceptService.startActionEncrypt((Context)AcceptSDKApiClient.getContext().get(), transactionObject, AcceptSDKCore.this.mResultReceiver);
            }

            @Override
            public void OnValidationFailed(ErrorTransactionResponse errorTransactionResponse) {
                AcceptSDKCore.this.mEncryptTransactionCallback.onErrorReceived(errorTransactionResponse);
                sTransactionInProgress = false;
            }
        });
        return sTransactionInProgress;
    }

    private void registerResultReceiver() {
        if (this.mResultReceiver != null) {
            return;
        }
        this.mResultReceiver = new TransactionResultReceiver(new Handler());
        this.mResultReceiver.setReceiver(this);
    }

    @Override
    public void onReceiveResult(int resultCode, Bundle resultData) {
        sTransactionInProgress = false;
        switch (resultCode) {
            case 100: {
                EncryptTransactionResponse response = (EncryptTransactionResponse)resultData.getParcelable("SERVICE_RESULT_RESPONSE_KEY");
                this.mEncryptTransactionCallback.onEncryptionFinished(response);
                break;
            }
            case 200: {
                ErrorTransactionResponse error = (ErrorTransactionResponse)resultData.getParcelable("SERVICE_RESULT_ERROR_KEY");
                this.mEncryptTransactionCallback.onErrorReceived(error);
            }
        }
    }
}

