/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.acceptsdk.datamodel.transaction;

import java.io.Serializable;
import java.util.UUID;
import net.authorize.acceptsdk.ValidationCallback;
import net.authorize.acceptsdk.datamodel.merchant.AbstractMerchantAuthentication;
import net.authorize.acceptsdk.datamodel.transaction.CardData;
import net.authorize.acceptsdk.datamodel.transaction.EncryptTransactionObject;
import net.authorize.acceptsdk.datamodel.transaction.TransactionType;

public abstract class TransactionObject
implements Serializable {
    private static final long serialVersionUID = 2L;
    AbstractMerchantAuthentication mMerchantAuthentication;
    CardData mCardData;
    TransactionType mTransactionType;
    String mGuid = UUID.randomUUID().toString();

    public AbstractMerchantAuthentication getMerchantAuthentication() {
        return this.mMerchantAuthentication;
    }

    public void setGuid(String guid) {
        this.mGuid = guid;
    }

    public String getGuid() {
        return this.mGuid;
    }

    public void setMerchantAuthentication(AbstractMerchantAuthentication mMerchantAuthentication) {
        this.mMerchantAuthentication = mMerchantAuthentication;
    }

    public CardData getCardData() {
        return this.mCardData;
    }

    public void setCardData(CardData mCardData) {
        this.mCardData = mCardData;
    }

    public TransactionType getTransactionType() {
        return this.mTransactionType;
    }

    public void setTransactionType(TransactionType mTransactionType) {
        this.mTransactionType = mTransactionType;
    }

    public abstract boolean validateTransactionObject(ValidationCallback var1);

    public static Builder createTransactionObject(TransactionType type) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException("TransactionType must not be null");
        }
        switch (type) {
            case SDK_TRANSACTION_ENCRYPTION: {
                return new EncryptTransactionObject.Builder();
            }
        }
        return new EncryptTransactionObject.Builder();
    }

    public static abstract class Builder {
        CardData cardData;
        AbstractMerchantAuthentication merchantAuthentication;
        TransactionType transactionType;

        public Builder cardData(CardData cardData) {
            this.cardData = cardData;
            return this;
        }

        public Builder merchantAuthentication(AbstractMerchantAuthentication merchantAuthentication) {
            this.merchantAuthentication = merchantAuthentication;
            return this;
        }

        public abstract EncryptTransactionObject build();
    }
}

