/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.acceptsdk.datamodel.transaction;

import java.io.Serializable;
import net.authorize.acceptsdk.ValidationCallback;
import net.authorize.acceptsdk.ValidationManager;
import net.authorize.acceptsdk.datamodel.error.SDKErrorCode;
import net.authorize.acceptsdk.datamodel.transaction.response.ErrorTransactionResponse;

public class CardData
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final String MONTH_PREFIX = "0";
    private static final String YEAR_PREFIX = "20";
    private String cardNumber;
    private String expirationMonth;
    private String expirationYear;
    private String cvvCode;
    private String zipCode;
    private String cardHolderName;

    private CardData(Builder builder) {
        this.cardNumber = this.trimString(builder.cardNumber);
        this.expirationMonth = this.prefixMonth(builder.expirationMonth);
        this.expirationYear = this.prefixYear(builder.expirationYear);
        this.cvvCode = this.trimString(builder.cvvCode);
        this.zipCode = this.trimString(builder.zipCode);
        this.cardHolderName = this.trimString(builder.cardHolderName);
    }

    private String trimString(String data) {
        if (ValidationManager.isValidString(data)) {
            data = data.trim();
        }
        return data;
    }

    private String prefixMonth(String month) {
        if (ValidationManager.isValidString(month) && (month = month.trim()).length() == 1) {
            month = MONTH_PREFIX + month;
        }
        return month;
    }

    private String prefixYear(String year) {
        if (ValidationManager.isValidString(year) && (year = year.trim()).length() == 2) {
            year = YEAR_PREFIX + year;
        }
        return year;
    }

    public boolean validateCardData(ValidationCallback callback) {
        boolean result = false;
        if (!ValidationManager.isValidCardNumber(this.cardNumber)) {
            callback.OnValidationFailed(ErrorTransactionResponse.createErrorResponse(SDKErrorCode.E_WC_05));
            return result;
        }
        if (!ValidationManager.isValidExpirationMonth(this.expirationMonth)) {
            callback.OnValidationFailed(ErrorTransactionResponse.createErrorResponse(SDKErrorCode.E_WC_06));
            return result;
        }
        if (!ValidationManager.isValidExpirationYear(this.expirationYear)) {
            callback.OnValidationFailed(ErrorTransactionResponse.createErrorResponse(SDKErrorCode.E_WC_07));
            return result;
        }
        if (!ValidationManager.isValidExpirationDate(this.expirationMonth, this.expirationYear)) {
            callback.OnValidationFailed(ErrorTransactionResponse.createErrorResponse(SDKErrorCode.E_WC_08));
            return result;
        }
        if (this.cvvCode != null && !ValidationManager.isValidCVV(this.cvvCode)) {
            callback.OnValidationFailed(ErrorTransactionResponse.createErrorResponse(SDKErrorCode.E_WC_15));
            return result;
        }
        if (this.zipCode != null && !ValidationManager.isValidZipCode(this.zipCode)) {
            callback.OnValidationFailed(ErrorTransactionResponse.createErrorResponse(SDKErrorCode.E_WC_16));
            return result;
        }
        if (this.cardHolderName != null && !ValidationManager.isValidCardHolderName(this.cardHolderName)) {
            callback.OnValidationFailed(ErrorTransactionResponse.createErrorResponse(SDKErrorCode.E_WC_17));
            return result;
        }
        return true;
    }

    public String getCvvCode() {
        return this.cvvCode;
    }

    public void setCvvCode(String cvvCode) {
        this.cvvCode = cvvCode;
    }

    public String getZipCode() {
        return this.zipCode;
    }

    public void setZipCode(String zipCode) {
        this.zipCode = zipCode;
    }

    public String getCardHolderName() {
        return this.cardHolderName;
    }

    public void setCardHolderName(String cardHolderName) {
        this.cardHolderName = cardHolderName;
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    public String getExpirationMonth() {
        return this.expirationMonth;
    }

    public void setExpirationMonth(String expirationMonth) {
        this.expirationMonth = expirationMonth;
    }

    public String getExpirationYear() {
        return this.expirationYear;
    }

    public void setExpirationYear(String expirationYear) {
        this.expirationYear = expirationYear;
    }

    public String getExpirationInFormatMMYYYY() {
        return this.expirationMonth + this.expirationYear;
    }

    public static class Builder {
        private final String cardNumber;
        private final String expirationMonth;
        private final String expirationYear;
        private String cvvCode;
        private String zipCode;
        private String cardHolderName;

        public Builder(String cardNumber, String expirationMonth, String expirationYear) {
            this.cardNumber = cardNumber;
            this.expirationMonth = expirationMonth;
            this.expirationYear = expirationYear;
        }

        public Builder cvvCode(String cvvCode) {
            this.cvvCode = cvvCode;
            return this;
        }

        public Builder zipCode(String zipCode) {
            this.zipCode = zipCode;
            return this;
        }

        public Builder cardHolderName(String cardHolderName) {
            this.cardHolderName = cardHolderName;
            return this;
        }

        public CardData build() {
            return new CardData(this);
        }
    }
}

