/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.acceptsdk.datamodel.merchant;

import java.io.Serializable;
import net.authorize.acceptsdk.ValidationCallback;
import net.authorize.acceptsdk.ValidationManager;
import net.authorize.acceptsdk.datamodel.error.SDKErrorCode;
import net.authorize.acceptsdk.datamodel.transaction.response.ErrorTransactionResponse;

public class FingerPrintData
implements Serializable {
    private final double DEFAULT_AMOUNT = -99999.99;
    private String hashValue;
    private long timestamp;
    private String sequence;
    private String currencyCode;
    private double amount = -99999.99;

    public FingerPrintData(Builder builder) {
        this.hashValue = builder.hashValue;
        if (this.hashValue != null) {
            this.hashValue = this.hashValue.trim();
        }
        this.timestamp = builder.timestamp;
        this.sequence = builder.sequence;
        if (this.sequence != null) {
            this.sequence = this.sequence.trim();
        }
        this.currencyCode = builder.currencyCode;
        if (this.currencyCode != null) {
            this.currencyCode = this.currencyCode.trim();
        }
        this.amount = builder.amount;
    }

    public boolean validateFingerPrint(ValidationCallback callback) {
        if (!ValidationManager.isValidString(this.hashValue)) {
            callback.OnValidationFailed(ErrorTransactionResponse.createErrorResponse(SDKErrorCode.E_WC_09));
            return false;
        }
        if (!ValidationManager.isValidTimeStamp(this.timestamp)) {
            callback.OnValidationFailed(ErrorTransactionResponse.createErrorResponse(SDKErrorCode.E_WC_11));
            return false;
        }
        if (this.sequence != null && this.sequence.isEmpty()) {
            callback.OnValidationFailed(ErrorTransactionResponse.createErrorResponse(SDKErrorCode.E_WC_12));
            return false;
        }
        if (this.currencyCode != null && this.currencyCode.isEmpty()) {
            callback.OnValidationFailed(ErrorTransactionResponse.createErrorResponse(SDKErrorCode.E_WC_13));
            return false;
        }
        if (this.amount != -99999.99 && !ValidationManager.isValidAmount(this.amount)) {
            callback.OnValidationFailed(ErrorTransactionResponse.createErrorResponse(SDKErrorCode.E_WC_13));
            return false;
        }
        return true;
    }

    public String getHashValue() {
        return this.hashValue;
    }

    public void setHashValue(String hashValue) {
        this.hashValue = hashValue;
    }

    public double getAmount() {
        return this.amount;
    }

    public String getAmountString() {
        return String.valueOf(this.amount);
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getTimestampString() {
        return String.valueOf(this.timestamp);
    }

    public String getSequence() {
        return this.sequence;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public static class Builder {
        private String hashValue;
        private long timestamp;
        private String sequence;
        private String currencyCode;
        private double amount;

        public Builder(String hashValue, long timestamp) {
            this.timestamp = timestamp;
            this.hashValue = hashValue;
        }

        public Builder setSequence(String sequence) {
            this.sequence = sequence;
            return this;
        }

        public Builder setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public Builder setAmount(double amount) {
            this.amount = amount;
            return this;
        }

        public FingerPrintData build() {
            return new FingerPrintData(this);
        }
    }
}

