/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.acceptsdk.datamodel.merchant;

import net.authorize.acceptsdk.ValidationCallback;
import net.authorize.acceptsdk.ValidationManager;
import net.authorize.acceptsdk.datamodel.error.SDKErrorCode;
import net.authorize.acceptsdk.datamodel.merchant.AbstractMerchantAuthentication;
import net.authorize.acceptsdk.datamodel.merchant.FingerPrintData;
import net.authorize.acceptsdk.datamodel.merchant.MerchantAuthenticationType;
import net.authorize.acceptsdk.datamodel.transaction.response.ErrorTransactionResponse;

public class FingerPrintBasedMerchantAuthentication
extends AbstractMerchantAuthentication {
    private FingerPrintData mFingerPrintData;

    private FingerPrintBasedMerchantAuthentication() {
    }

    public static FingerPrintBasedMerchantAuthentication createMerchantAuthentication(String loginId, FingerPrintData fingerPrintData) {
        FingerPrintBasedMerchantAuthentication authenticator = new FingerPrintBasedMerchantAuthentication();
        if (loginId != null) {
            loginId = loginId.trim();
        }
        authenticator.mApiLoginID = loginId;
        authenticator.mFingerPrintData = fingerPrintData;
        authenticator.merchantAuthenticationType = MerchantAuthenticationType.FINGERPRINT;
        return authenticator;
    }

    public FingerPrintData getFingerPrintData() {
        return this.mFingerPrintData;
    }

    public void setFingerPrintData(FingerPrintData fingerPrintData) {
        this.mFingerPrintData = fingerPrintData;
    }

    @Override
    public boolean validateMerchantAuthentication(ValidationCallback callback) {
        if (!ValidationManager.isValidString(this.mApiLoginID)) {
            callback.OnValidationFailed(ErrorTransactionResponse.createErrorResponse(SDKErrorCode.E_WC_10));
            return false;
        }
        if (this.mFingerPrintData == null) {
            callback.OnValidationFailed(ErrorTransactionResponse.createErrorResponse(SDKErrorCode.E_WC_04));
            return false;
        }
        return this.mFingerPrintData.validateFingerPrint(callback);
    }
}

