/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.acceptsdk.datamodel.merchant;

import net.authorize.acceptsdk.ValidationCallback;
import net.authorize.acceptsdk.ValidationManager;
import net.authorize.acceptsdk.datamodel.error.SDKErrorCode;
import net.authorize.acceptsdk.datamodel.merchant.AbstractMerchantAuthentication;
import net.authorize.acceptsdk.datamodel.merchant.MerchantAuthenticationType;
import net.authorize.acceptsdk.datamodel.transaction.response.ErrorTransactionResponse;

public class ClientKeyBasedMerchantAuthentication
extends AbstractMerchantAuthentication {
    private String mClientKey;

    private ClientKeyBasedMerchantAuthentication() {
    }

    public static ClientKeyBasedMerchantAuthentication createMerchantAuthentication(String loginId, String clientKey) {
        ClientKeyBasedMerchantAuthentication authenticator = new ClientKeyBasedMerchantAuthentication();
        if (loginId != null) {
            loginId = loginId.trim();
        }
        if (clientKey != null) {
            clientKey = clientKey.trim();
        }
        authenticator.mApiLoginID = loginId;
        authenticator.mClientKey = clientKey;
        authenticator.merchantAuthenticationType = MerchantAuthenticationType.CLIENT_KEY;
        return authenticator;
    }

    public String getClientKey() {
        return this.mClientKey;
    }

    @Override
    public boolean validateMerchantAuthentication(ValidationCallback callback) {
        if (!ValidationManager.isValidString(this.mApiLoginID)) {
            callback.OnValidationFailed(ErrorTransactionResponse.createErrorResponse(SDKErrorCode.E_WC_10));
            return false;
        }
        if (!ValidationManager.isValidString(this.mClientKey)) {
            callback.OnValidationFailed(ErrorTransactionResponse.createErrorResponse(SDKErrorCode.E_WC_18));
            return false;
        }
        return true;
    }
}

