/*
 * Decompiled with CFR 0.152.
 */
package net.authorize.acceptsdk;

import android.content.Context;
import java.lang.ref.WeakReference;
import net.authorize.acceptsdk.datamodel.transaction.EncryptTransactionObject;
import net.authorize.acceptsdk.datamodel.transaction.callbacks.EncryptTransactionCallback;
import net.authorize.acceptsdk.internal.AcceptSDKCore;
import net.authorize.acceptsdk.network.ConnectionData;

public class AcceptSDKApiClient {
    private static WeakReference<Context> sContext;
    private final Environment mEnvironment;

    public AcceptSDKApiClient(Builder builder) {
        sContext = builder.context;
        this.mEnvironment = builder.environment;
        this.configureConnectionTimeout(builder.connectionTimeout);
        this.setActiveEndPointUrl();
    }

    public Environment getEnvironment() {
        return this.mEnvironment;
    }

    public static WeakReference<Context> getContext() {
        return sContext;
    }

    private void configureConnectionTimeout(int timeoutMillis) {
        ConnectionData.setConnectionTimeout(timeoutMillis);
    }

    private void setActiveEndPointUrl() {
        String url = this.mEnvironment == Environment.PRODUCTION ? "https://api.authorize.net/xml/v1/request.api " : "https://apitest.authorize.net/xml/v1/request.api ";
        ConnectionData.setActiveEndPointUrl(url);
    }

    public boolean getTokenWithRequest(EncryptTransactionObject transactionObject, EncryptTransactionCallback callback) {
        if (transactionObject == null) {
            throw new NullPointerException("Transaction Object must not be null");
        }
        if (callback == null) {
            throw new NullPointerException("Transaction Callback must not be null");
        }
        return AcceptSDKCore.getInstance().performEncryption(transactionObject, callback);
    }

    public static class Builder {
        private final WeakReference<Context> context;
        private final Environment environment;
        private int connectionTimeout;

        public Builder(Context context, Environment environment) {
            if (context == null) {
                throw new NullPointerException("Context must not be null");
            }
            this.context = new WeakReference<Context>(context);
            this.environment = environment == null ? Environment.SANDBOX : environment;
        }

        public Builder connectionTimeout(int timeout) {
            this.connectionTimeout = timeout;
            return this;
        }

        public AcceptSDKApiClient build() {
            return new AcceptSDKApiClient(this);
        }
    }

    public static enum Environment {
        SANDBOX,
        PRODUCTION;

    }
}

