/*
 * Decompiled with CFR 0.152.
 */
package net.augeas;

import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.util.ArrayList;
import java.util.List;
import net.augeas.LibAugeas;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Augeas {
    protected LibAugeas.Augeas_T augeas_t;
    private final Log log = LogFactory.getLog(this.getClass());

    public Augeas() {
        this("/", "/usr/local/share/augeas/lenses");
    }

    public Augeas(String rootPath, String loadPath) {
        NativeLibrary.addSearchPath((String)"augeas", (String)"/usr/local/lib");
        this.augeas_t = LibAugeas.INSTANCE.aug_init(rootPath, loadPath, LibAugeas.AugFlags.AUG_SAVE_BACKUP.getIndex());
    }

    public void outputTree(String path) {
        this.outputTree(path, 0);
    }

    public void outputTree(String path, int depth) {
        StringBuffer depthIndent = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            depthIndent.append("  ");
        }
        this.log.info((Object)(depthIndent + path + " = " + this.get(path)));
        for (String child : this.match(path + "/*")) {
            this.outputTree(child, depth + 1);
        }
    }

    public String get(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        PointerByReference ref = new PointerByReference();
        LibAugeas.INSTANCE.aug_get(this.augeas_t, path, ref);
        if (ref.getValue() != null) {
            return ref.getValue().getString(0L);
        }
        return null;
    }

    public void set(String path, String value) {
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        int result = LibAugeas.INSTANCE.aug_set(this.augeas_t, path, value);
        if (result != 0) {
            throw new RuntimeException("Failed to put value [" + value + "] at path [" + path + "]");
        }
    }

    public List<String> match(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        PointerByReference pref = new PointerByReference();
        int matches = LibAugeas.INSTANCE.aug_match(this.augeas_t, path, pref);
        Pointer[] refs = pref.getValue().getPointerArray(0L, matches);
        ArrayList<String> matchPaths = new ArrayList<String>();
        for (int i = 0; i < matches; ++i) {
            matchPaths.add(refs[i].getString(0L));
        }
        return matchPaths;
    }

    public void save() {
        int result = LibAugeas.INSTANCE.aug_save(this.augeas_t);
        if (result != 0) {
            throw new RuntimeException("Failed to save augeas changes");
        }
    }
}

