/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.util.Iterator;
import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.NullFormatter;
import net.arnx.jsonic.io.OutputSource;

final class IteratorFormatter
implements Formatter {
    public static final IteratorFormatter INSTANCE = new IteratorFormatter();

    IteratorFormatter() {
    }

    @Override
    public boolean accept(Object o) {
        return o instanceof Iterator;
    }

    @Override
    public boolean isStruct() {
        return true;
    }

    @Override
    public void format(JSON.Context context, Object src, Object o, OutputSource out) throws Exception {
        Iterator t = (Iterator)o;
        JSONHint hint = context.getHint();
        Class<?> lastClass = null;
        Formatter lastFormatter = null;
        out.append('[');
        int count = 0;
        while (t.hasNext()) {
            Object item = t.next();
            if (item == src) {
                item = null;
            }
            if (count != 0) {
                out.append(',');
            }
            if (context.isPrettyPrint()) {
                out.append('\n');
                context.appendIndent(out, context.getDepth() + 1);
            }
            context.enter(count, hint);
            item = context.preformatInternal(item != null ? item.getClass() : Object.class, item);
            if (item == null) {
                NullFormatter.INSTANCE.format(context, src, item, out);
            } else if (hint == null) {
                if (item.getClass() == lastClass) {
                    lastFormatter.format(context, src, item, out);
                } else {
                    lastFormatter = context.formatInternal(item, out);
                    lastClass = item.getClass();
                }
            } else {
                context.formatInternal(item, out);
            }
            context.exit();
            ++count;
        }
        if (context.isPrettyPrint() && count > 0) {
            out.append('\n');
            context.appendIndent(out, context.getDepth());
        }
        out.append(']');
    }
}

