/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.web.extension;

import com.google.inject.Injector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import net.arnx.jsonic.web.Container;

public class GuiceContainer
extends Container {
    Logger log;
    Injector injector;

    public void init(HttpServlet servlet) throws ServletException {
        super.init(servlet);
        this.log = Logger.getLogger(servlet.getClass().getName());
        this.injector = (Injector)this.context.getAttribute(Injector.class.getName());
    }

    public Object getComponent(String className) throws Exception {
        return this.injector.getInstance(this.findClass(className));
    }

    public boolean isDebugMode() {
        return this.debug != null ? this.debug.booleanValue() : this.log.isLoggable(Level.FINE);
    }

    public void debug(String message, Throwable e) {
        if (e != null) {
            this.log.log(Level.FINE, message, e);
        } else {
            this.log.log(Level.FINE, message);
        }
    }

    public void warn(String message, Throwable e) {
        if (e != null) {
            this.log.log(Level.WARNING, message, e);
        } else {
            this.log.log(Level.WARNING, message);
        }
    }

    public void error(String message, Throwable e) {
        if (e != null) {
            this.log.log(Level.SEVERE, message, e);
        } else {
            this.log.log(Level.SEVERE, message);
        }
    }
}

