/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.arnx.jsonic.util.ConstructorInfo;
import net.arnx.jsonic.util.MethodInfo;
import net.arnx.jsonic.util.PropertyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeanInfo {
    private static final Map<ClassLoader, Map<Class<?>, BeanInfo>> cache = new WeakHashMap();
    private Class<?> type;
    private ConstructorInfo ci;
    private Map<String, PropertyInfo> sprops;
    private Map<String, MethodInfo> smethods;
    private Map<String, PropertyInfo> props;
    private Map<String, MethodInfo> methods;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BeanInfo get(Class<?> cls) {
        Map<ClassLoader, Map<Class<?>, BeanInfo>> map = cache;
        synchronized (map) {
            BeanInfo info = null;
            LinkedHashMap map2 = cache.get(cls.getClassLoader());
            if (map2 == null) {
                map2 = new LinkedHashMap<Class<?>, BeanInfo>(16, 0.75f, true){

                    @Override
                    protected boolean removeEldestEntry(Map.Entry<Class<?>, BeanInfo> eldest) {
                        return this.size() > 1024;
                    }
                };
                cache.put(cls.getClassLoader(), map2);
            } else {
                info = map2.get(cls);
            }
            if (info == null) {
                info = new BeanInfo(cls);
                map2.put(cls, info);
            }
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        Map<ClassLoader, Map<Class<?>, BeanInfo>> map = cache;
        synchronized (map) {
            cache.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    private BeanInfo(Class<?> cls) {
        this.type = cls;
        for (Constructor<?> constructor : cls.getConstructors()) {
            if (constructor.isSynthetic()) continue;
            if (this.ci == null) {
                this.ci = new ConstructorInfo(cls, null);
            }
            constructor.setAccessible(true);
            this.ci.constructors.add(constructor);
        }
        for (AccessibleObject accessibleObject : cls.getFields()) {
            if (((Field)accessibleObject).isSynthetic() || ((Field)accessibleObject).getDeclaringClass() == Object.class || cls == Class.class) continue;
            boolean isStatic = Modifier.isStatic(((Field)accessibleObject).getModifiers());
            String name = ((Field)accessibleObject).getName();
            ((Field)accessibleObject).setAccessible(true);
            if (isStatic) {
                if (this.sprops == null) {
                    this.sprops = Collections.synchronizedMap(new LinkedHashMap());
                }
                this.sprops.put(name, new PropertyInfo(cls, name, (Field)accessibleObject, null, null, isStatic, -1));
                continue;
            }
            if (this.props == null) {
                this.props = Collections.synchronizedMap(new LinkedHashMap());
            }
            this.props.put(name, new PropertyInfo(cls, name, (Field)accessibleObject, null, null, isStatic, -1));
        }
        for (AccessibleObject accessibleObject : cls.getMethods()) {
            void var11_16;
            PropertyInfo prop;
            boolean isReadMethod;
            MethodInfo mi;
            if (((Method)accessibleObject).isSynthetic() || ((Method)accessibleObject).isBridge()) continue;
            String name = ((Method)accessibleObject).getName();
            Class<?>[] paramTypes = ((Method)accessibleObject).getParameterTypes();
            Class<?> returnType = ((Method)accessibleObject).getReturnType();
            boolean isStatic = Modifier.isStatic(((Method)accessibleObject).getModifiers());
            if (isStatic) {
                if (this.smethods == null) {
                    this.smethods = Collections.synchronizedMap(new LinkedHashMap());
                }
                if ((mi = this.smethods.get(name)) == null) {
                    mi = new MethodInfo(cls, name, null, isStatic);
                    this.smethods.put(name, mi);
                }
            } else {
                if (this.methods == null) {
                    this.methods = Collections.synchronizedMap(new LinkedHashMap());
                }
                if ((mi = this.methods.get(name)) == null) {
                    mi = new MethodInfo(cls, name, null, isStatic);
                    this.methods.put(name, mi);
                }
            }
            ((Method)accessibleObject).setAccessible(true);
            mi.methods.add((Method)accessibleObject);
            if (((Method)accessibleObject).getDeclaringClass() == Object.class || cls == Class.class) continue;
            int start = 0;
            if (name.startsWith("get") && paramTypes.length == 0 && !returnType.equals(Void.TYPE)) {
                isReadMethod = true;
                start = 3;
            } else if (name.startsWith("is") && paramTypes.length == 0 && !returnType.equals(Void.TYPE)) {
                isReadMethod = true;
                start = 2;
            } else {
                if (!name.startsWith("set") || paramTypes.length != 1 || paramTypes[0].equals(Void.TYPE)) continue;
                isReadMethod = false;
                start = 3;
            }
            if ((name.length() <= start || Character.isLowerCase(name.charAt(start))) && (name.length() <= start + 1 || Character.isLowerCase(name.charAt(start + 1)))) continue;
            if ((name = name.substring(start)).length() < 2 || !Character.isUpperCase(name.charAt(1))) {
                char[] chars = name.toCharArray();
                chars[0] = Character.toLowerCase(chars[0]);
                name = String.valueOf(chars);
            }
            if (isStatic) {
                if (this.sprops == null) {
                    this.sprops = Collections.synchronizedMap(new LinkedHashMap());
                }
                if ((prop = this.sprops.get(name)) == null) {
                    prop = new PropertyInfo(cls, name, null, null, null, isStatic, -1);
                    this.sprops.put(name, prop);
                }
            } else {
                if (this.props == null) {
                    this.props = Collections.synchronizedMap(new LinkedHashMap());
                }
                if ((prop = this.props.get(name)) == null) {
                    prop = new PropertyInfo(cls, name, null, null, null, isStatic, -1);
                    this.props.put(name, prop);
                }
            }
            if (var11_16 != false) {
                prop.readMethod = accessibleObject;
                continue;
            }
            prop.writeMethod = accessibleObject;
        }
        if (this.sprops == null) {
            this.sprops = Collections.emptyMap();
        }
        if (this.smethods == null) {
            this.smethods = Collections.emptyMap();
        }
        if (this.props == null) {
            this.props = Collections.emptyMap();
        }
        if (this.methods == null) {
            this.methods = Collections.emptyMap();
        }
    }

    public Object newInstance() {
        try {
            Constructor<?> target = this.type.getConstructor(new Class[0]);
            target.setAccessible(true);
            return target.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public Class<?> getType() {
        return this.type;
    }

    public ConstructorInfo getConstructor() {
        return this.ci;
    }

    public PropertyInfo getStaticProperty(String name) {
        return this.sprops.get(name);
    }

    public MethodInfo getStaticMethod(String name) {
        return this.smethods.get(name);
    }

    public Collection<PropertyInfo> getStaticProperties() {
        return this.sprops.values();
    }

    public Collection<MethodInfo> getStaticMethods() {
        return this.smethods.values();
    }

    public PropertyInfo getProperty(String name) {
        return this.props.get(name);
    }

    public MethodInfo getMethod(String name) {
        return this.methods.get(name);
    }

    public Collection<PropertyInfo> getProperties() {
        return this.props.values();
    }

    public Collection<MethodInfo> getMethods() {
        return this.methods.values();
    }

    public int hashCode() {
        return this.type == null ? 0 : this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BeanInfo other = (BeanInfo)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        return "BeanInfo [static properties = " + this.sprops + ", static methods = " + this.smethods + ", properties = " + this.props + ", methods = " + this.methods + "]";
    }

    static int calcurateDistance(Class<?>[] params, Object[] args) {
        int point = 0;
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) {
                if (params[i].isPrimitive()) continue;
                point += 5;
                continue;
            }
            if (params[i].equals(args[i].getClass())) {
                point += 10;
                continue;
            }
            if (params[i].isAssignableFrom(args[i].getClass())) {
                point += 8;
                continue;
            }
            if (Boolean.TYPE == args[i].getClass() || Boolean.class == args[i].getClass()) {
                if (Boolean.TYPE != params[i] && Boolean.class != params[i]) continue;
                point += 10;
                continue;
            }
            if (Byte.TYPE == args[i].getClass() || Byte.class == args[i].getClass()) {
                if (Byte.TYPE != params[i] && Short.TYPE != params[i] && Character.TYPE != params[i] && Integer.TYPE != params[i] && Long.TYPE != params[i] && Float.TYPE != params[i] && Double.TYPE != params[i] && Byte.class != params[i] && Short.class != params[i] && Character.class != params[i] && Integer.class != params[i] && Long.class != params[i] && Float.class != params[i] && Double.class != params[i]) continue;
                point += 10;
                continue;
            }
            if (Short.TYPE == args[i].getClass() || Short.class == args[i].getClass() || Character.TYPE == args[i].getClass() || Character.class == args[i].getClass()) {
                if (Short.TYPE != params[i] && Character.TYPE != params[i] && Integer.TYPE != params[i] && Long.TYPE != params[i] && Float.TYPE != params[i] && Double.TYPE != params[i] && Short.class != params[i] && Character.class != params[i] && Integer.class != params[i] && Long.class != params[i] && Float.class != params[i] && Double.class != params[i]) continue;
                point += 10;
                continue;
            }
            if (Integer.TYPE == args[i].getClass() || Integer.class == args[i].getClass()) {
                if (Integer.TYPE != params[i] && Long.TYPE != params[i] && Float.TYPE != params[i] && Double.TYPE != params[i] && Integer.class != params[i] && Long.class != params[i] && Float.class != params[i] && Double.class != params[i]) continue;
                point += 10;
                continue;
            }
            if (Long.TYPE == args[i].getClass() || Long.class == args[i].getClass()) {
                if (Long.TYPE != params[i] && Float.TYPE != params[i] && Double.TYPE != params[i] && Long.class != params[i] && Float.class != params[i] && Double.class != params[i]) continue;
                point += 10;
                continue;
            }
            if (Float.TYPE == args[i].getClass() || Float.class == args[i].getClass()) {
                if (Float.TYPE != params[i] && Double.TYPE != params[i] && Float.class != params[i] && Double.class != params[i]) continue;
                point += 10;
                continue;
            }
            if (Double.TYPE != args[i].getClass() && Double.class != args[i].getClass() || Double.TYPE != params[i] && Double.class != params[i]) continue;
            point += 10;
        }
        return point;
    }
}

