/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.text.NumberFormat;
import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.StringFormatter;
import net.arnx.jsonic.io.OutputSource;

final class FloatFormatter
implements Formatter {
    public static final FloatFormatter INSTANCE = new FloatFormatter();

    FloatFormatter() {
    }

    public boolean accept(Object o) {
        return o instanceof Float || o instanceof Double;
    }

    public boolean isStruct() {
        return false;
    }

    public void format(JSON.Context context, Object src, Object o, OutputSource out) throws Exception {
        NumberFormat f = context.getNumberFormat();
        if (f != null) {
            StringFormatter.serialize(context, f.format(o), out);
        } else {
            double d = ((Number)o).doubleValue();
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                if (context.getMode() != JSON.Mode.SCRIPT) {
                    out.append('\"');
                    out.append(o.toString());
                    out.append('\"');
                } else if (Double.isNaN(d)) {
                    out.append("Number.NaN");
                } else {
                    out.append("Number.");
                    out.append(d > 0.0 ? "POSITIVE" : "NEGATIVE");
                    out.append("_INFINITY");
                }
            } else {
                out.append(o.toString());
            }
        }
    }
}

